/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;
import org.jmol.util.Quaternion;
import org.jmol.viewer.JmolConstants;

public class Group {
    private int groupIndex;
    protected Chain chain;
    int seqcode;
    protected short groupID;
    protected boolean isAmino;
    int selectedIndex;
    protected int firstAtomIndex = -1;
    protected int lastAtomIndex;
    private static final int SEQUENCE_NUMBER_FLAG = 128;
    private static final int INSERTION_CODE_MASK = 127;
    private static final int SEQUENCE_NUMBER_SHIFT = 8;
    public int shapeVisibilityFlags = 0;
    private int minZ;
    protected float phi = Float.NaN;
    protected float psi = Float.NaN;
    protected float omega = Float.NaN;
    protected float straightness = Float.NaN;
    private static Hashtable htGroup = new Hashtable();
    static String[] group3Names = new String[128];
    static short group3NameCount = 0;

    public int getGroupIndex() {
        return this.groupIndex;
    }

    public void setGroupIndex(int groupIndex) {
        this.groupIndex = groupIndex;
    }

    public int getFirstAtomIndex() {
        return this.firstAtomIndex;
    }

    public int getLastAtomIndex() {
        return this.lastAtomIndex;
    }

    public void setMinZ(int z) {
        this.minZ = z;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public float getStraightness() {
        return this.straightness;
    }

    public void setStraightness(float straightness) {
        this.straightness = straightness;
    }

    public float getPhi() {
        return this.phi;
    }

    public void setPhi(float phi) {
        this.phi = phi;
    }

    public float getPsi() {
        return this.psi;
    }

    public void setPsi(float psi) {
        this.psi = psi;
    }

    public void setOmega(float omega) {
        this.omega = omega;
    }

    public float getOmega() {
        return this.omega;
    }

    public Group(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex) {
        this.chain = chain;
        this.seqcode = seqcode;
        if (group3 == null) {
            group3 = "";
        }
        this.groupID = Group.getGroupID(group3);
        this.isAmino = this.groupID >= 1 && this.groupID < 24;
        this.firstAtomIndex = firstAtomIndex;
        this.lastAtomIndex = lastAtomIndex;
    }

    public void setModelSet(ModelSet modelSet) {
        this.chain.modelSet = modelSet;
    }

    public final void setShapeVisibility(int visFlag, boolean isVisible) {
        this.shapeVisibilityFlags = isVisible ? (this.shapeVisibilityFlags |= visFlag) : (this.shapeVisibilityFlags &= ~visFlag);
    }

    final boolean isGroup3(String group3) {
        return group3Names[this.groupID].equalsIgnoreCase(group3);
    }

    final String getGroup3() {
        return group3Names[this.groupID];
    }

    public static String getGroup3(short groupID) {
        return group3Names[groupID];
    }

    public final char getGroup1() {
        if (this.groupID >= JmolConstants.predefinedGroup1Names.length) {
            return '?';
        }
        return JmolConstants.predefinedGroup1Names[this.groupID];
    }

    public final short getGroupID() {
        return this.groupID;
    }

    public final char getChainID() {
        return this.chain.chainID;
    }

    public int getBioPolymerLength() {
        return 0;
    }

    public int getBioPolymerIndex() {
        return -1;
    }

    public Object getStructure() {
        return null;
    }

    public int getProteinStructureID() {
        return 0;
    }

    public byte getProteinStructureType() {
        return 0;
    }

    public int setProteinStructureType(byte iType, int monomerIndexCurrent) {
        return -1;
    }

    public Hashtable getMyInfo() {
        return null;
    }

    public boolean isProtein() {
        return false;
    }

    public boolean isNucleic() {
        return false;
    }

    public boolean isDna() {
        return false;
    }

    public boolean isRna() {
        return false;
    }

    public boolean isPurine() {
        return false;
    }

    public boolean isPyrimidine() {
        return false;
    }

    public boolean isCarbohydrate() {
        return false;
    }

    static synchronized short addGroup3Name(String group3) {
        if (group3NameCount == group3Names.length) {
            group3Names = ArrayUtil.doubleLength(group3Names);
        }
        short s = group3NameCount;
        group3NameCount = (short)(s + 1);
        short groupID = s;
        Group.group3Names[groupID] = group3;
        htGroup.put(group3, new Short(groupID));
        return groupID;
    }

    public static short getGroupID(String group3) {
        if (group3 == null) {
            return -1;
        }
        short groupID = Group.lookupGroupID(group3);
        return groupID != -1 ? groupID : Group.addGroup3Name(group3);
    }

    public static short lookupGroupID(String group3) {
        Short boxedGroupID;
        if (group3 != null && (boxedGroupID = (Short)htGroup.get(group3)) != null) {
            return boxedGroupID;
        }
        return -1;
    }

    public final int getResno() {
        return this.seqcode == Integer.MIN_VALUE ? 0 : this.seqcode >> 8;
    }

    public final int getSeqcode() {
        return this.seqcode;
    }

    public final int getSeqNumber() {
        return this.seqcode >> 8;
    }

    public static final int getSequenceNumber(int seqcode) {
        return Group.haveSequenceNumber(seqcode) ? seqcode >> 8 : Integer.MAX_VALUE;
    }

    public static final int getInsertionCodeValue(int seqcode) {
        return seqcode & 0x7F;
    }

    public static final boolean haveSequenceNumber(int seqcode) {
        return (seqcode & 0x80) != 0;
    }

    public final String getSeqcodeString() {
        return Group.getSeqcodeString(this.seqcode);
    }

    public static int getSeqcode(int sequenceNumber, char insertionCode) {
        if (sequenceNumber == Integer.MIN_VALUE) {
            return sequenceNumber;
        }
        if (!(insertionCode >= 'A' && insertionCode <= 'Z' || insertionCode >= 'a' && insertionCode <= 'z' || insertionCode >= '0' && insertionCode <= '9' || insertionCode == '?' || insertionCode == '*')) {
            if (insertionCode != ' ' && insertionCode != '\u0000') {
                Logger.warn("unrecognized insertionCode:" + insertionCode);
            }
            insertionCode = '\u0000';
        }
        return (sequenceNumber == Integer.MAX_VALUE ? 0 : sequenceNumber << 8 | 0x80) + insertionCode;
    }

    public static String getSeqcodeString(int seqcode) {
        if (seqcode == Integer.MIN_VALUE) {
            return null;
        }
        return (seqcode & 0x7F) == 0 ? "" + (seqcode >> 8) : "" + (seqcode >> 8) + '^' + (char)(seqcode & 0x7F);
    }

    public char getInsertionCode() {
        if (this.seqcode == Integer.MIN_VALUE) {
            return '\u0000';
        }
        return (char)(this.seqcode & 0x7F);
    }

    public static char getInsertionCode(int seqcode) {
        if (seqcode == Integer.MIN_VALUE) {
            return '\u0000';
        }
        return (char)(seqcode & 0x7F);
    }

    public final void selectAtoms(BitSet bs) {
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            bs.set(i);
        }
    }

    public boolean isSelected(BitSet bs) {
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            if (!bs.get(i)) continue;
            return true;
        }
        return false;
    }

    boolean isHetero() {
        return this.chain.getAtom(this.firstAtomIndex).isHetero();
    }

    public String toString() {
        return "[" + this.getGroup3() + "-" + this.getSeqcodeString() + "]";
    }

    protected int scaleToScreen(int Z, int mar) {
        return this.chain.modelSet.viewer.scaleToScreen(Z, mar);
    }

    protected boolean isCursorOnTopOf(Atom atom, int x, int y, int radius, Atom champ) {
        return this.chain.modelSet.isCursorOnTopOf(atom, x, y, radius, champ);
    }

    protected boolean isAtomHidden(int atomIndex) {
        return this.chain.modelSet.isAtomHidden(atomIndex);
    }

    public Model getModel() {
        return this.chain.model;
    }

    public int getModelIndex() {
        return this.chain.model.getModelIndex();
    }

    public int getSelectedMonomerCount() {
        return 0;
    }

    public int getSelectedMonomerIndex() {
        return -1;
    }

    public int getSelectedGroupIndex() {
        return this.selectedIndex;
    }

    public Atom getLeadAtom(Atom atom) {
        Atom a = this.getLeadAtom();
        return a == null ? atom : a;
    }

    public Atom getLeadAtom() {
        return null;
    }

    public Quaternion getQuaternion(char qtype) {
        return null;
    }

    public void setProteinStructureId(int i) {
    }

    public Object getHelixData(int tokType, char qType) {
        switch (tokType) {
            case 135268356: {
                return new Point3f();
            }
            case 592445697: 
            case 0x40000003: {
                return new Vector3f();
            }
            case 0x8100801: {
                return new Float(Float.NaN);
            }
            case 0x8100001: {
                return new String[0];
            }
        }
        return "";
    }

    static {
        for (int i = 0; i < JmolConstants.predefinedGroup3Names.length; ++i) {
            Group.addGroup3Name(JmolConstants.predefinedGroup3Names[i]);
        }
    }
}

