/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.vecmath.Tuple3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Measurement;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

public class LabelToken {
    private String text;
    private String key;
    private float[] data;
    private int tok;
    private int pt = -1;
    private char ch1;
    private int width;
    private int precision = Integer.MAX_VALUE;
    private boolean alignLeft;
    private boolean zeroPad;
    private boolean intAsFloat;
    private static final String labelTokenParams = "AaBbCcDEefGgIiLlMmNnoPpQqRrSsTtUuVvWXxYyZz%%%gqW";
    private static final int[] labelTokenIds = new int[]{0xD00003, 13631746, 0xD00101, 38797585, 558891272, 0xD00004, 22020099, 0xD0000A, 13631749, 38797323, 22020106, 103, 38797321, 0x1500001, 22020110, 22020359, 22024203, 0xD00007, 22020109, 0xD00006, 0xF0000C, 38797578, 38797324, 81, 55574786, 22020111, 0xD00008, 0x1500010, 0xD00004, 38797327, 38797585, 0xD00009, 38797328, 38797589, 72352013, 87, 38797574, 38797571, 38797575, 38797572, 38797576, 38797573, 38797313, 0x2500002, 22020098, 22020100, 558895366, 22020105, 0x2500005, 156242439, 214958338, 752374019, 22020108, 642777357, 592445697, 39325966, 30412803, 22020114, 13631755, 38797330, 38797331, 38797332, 22020372, 38797590, 38797591, 38797592, 72351756, 72352011, 72352010};
    private static final String twoCharLabelTokenParams = "fuv";
    private static final int[] twoCharLabelTokenIds = new int[]{38797574, 38797575, 38797576, 38797330, 38797331, 38797332, 38797590, 38797591, 38797592};
    public static final String STANDARD_LABEL = "%[identify]";

    private static boolean isLabelPropertyTok(int tok) {
        int i = labelTokenIds.length;
        while (--i >= 0) {
            if (labelTokenIds[i] != tok) continue;
            return true;
        }
        return false;
    }

    private LabelToken(String text) {
        this.text = text;
    }

    private LabelToken(int pt) {
        this.pt = pt;
    }

    public static LabelToken[] compile(Viewer viewer, String strFormat, char chAtom, Hashtable htValues) {
        int ichPercent;
        if (strFormat.indexOf("%") < 0) {
            return new LabelToken[]{new LabelToken(strFormat)};
        }
        int n = 0;
        int ich = -1;
        int cch = strFormat.length();
        while (++ich < cch && (ich = strFormat.indexOf(37, ich)) >= 0) {
            ++n;
        }
        LabelToken[] tokens = new LabelToken[n * 2 + 1];
        int i = 0;
        ich = 0;
        while ((ichPercent = strFormat.indexOf(37, ich)) >= 0) {
            if (ich != ichPercent) {
                tokens[i++] = new LabelToken(strFormat.substring(ich, ichPercent));
            }
            int n2 = i++;
            LabelToken labelToken = new LabelToken(ichPercent);
            tokens[n2] = labelToken;
            LabelToken lt = labelToken;
            viewer.autoCalculate(lt.tok);
            ich = LabelToken.setToken(viewer, strFormat, lt, cch, chAtom, htValues);
        }
        if (ich < cch) {
            tokens[i++] = new LabelToken(strFormat.substring(ich));
        }
        return tokens;
    }

    private static int setToken(Viewer viewer, String strFormat, LabelToken lt, int cch, int chAtom, Hashtable htValues) {
        char ch;
        int ich = lt.pt + 1;
        if (strFormat.charAt(ich) == '-') {
            lt.alignLeft = true;
            ++ich;
        }
        if (strFormat.charAt(ich) == '0') {
            lt.zeroPad = true;
            ++ich;
        }
        while (Character.isDigit(ch = strFormat.charAt(ich))) {
            lt.width = 10 * lt.width + (ch - 48);
            ++ich;
        }
        lt.precision = Integer.MAX_VALUE;
        boolean isNegative = false;
        if (strFormat.charAt(ich) == '.') {
            lt.intAsFloat = true;
            if ((ch = strFormat.charAt(++ich)) == '-') {
                isNegative = true;
                ++ich;
            }
            if (Character.isDigit(ch = strFormat.charAt(ich))) {
                lt.precision = ch - 48;
                if (isNegative) {
                    lt.precision = -1 - lt.precision;
                }
                ++ich;
            }
        }
        if (htValues != null) {
            Enumeration keys = htValues.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (strFormat.indexOf(key) != ich) continue;
                lt.key = key;
                return ich + key.length();
            }
        }
        ch = strFormat.charAt(ich++);
        switch (ch) {
            case '%': {
                lt.text = "%";
                return ich;
            }
            case '[': {
                int ichClose = strFormat.indexOf(93, ich);
                if (ichClose < ich) {
                    ich = cch;
                    break;
                }
                String propertyName = strFormat.substring(ich, ichClose).toLowerCase();
                if (propertyName.startsWith("property_")) {
                    lt.text = propertyName;
                    lt.tok = 135272450;
                    lt.data = viewer.getDataFloat(lt.text);
                } else {
                    Token token = Token.getTokenFromName(propertyName);
                    if (token != null && LabelToken.isLabelPropertyTok(token.tok)) {
                        lt.tok = token.tok;
                    }
                }
                ich = ichClose + 1;
                break;
            }
            case '{': {
                int ichCloseBracket = strFormat.indexOf(125, ich);
                if (ichCloseBracket < ich) {
                    ich = cch;
                    break;
                }
                lt.text = strFormat.substring(ich, ichCloseBracket);
                lt.tok = 135272450;
                lt.data = viewer.getDataFloat(lt.text);
                ich = ichCloseBracket + 1;
                break;
            }
            default: {
                int i1;
                int i;
                if (ich < cch && (i = twoCharLabelTokenParams.indexOf(ch)) >= 0 && (i1 = "xyz".indexOf(strFormat.charAt(ich))) >= 0) {
                    lt.tok = twoCharLabelTokenIds[i * 3 + i1];
                    ++ich;
                    break;
                }
                i = labelTokenParams.indexOf(ch);
                if (i < 0) break;
                lt.tok = labelTokenIds[i];
            }
        }
        lt.text = strFormat.substring(lt.pt, ich);
        if (chAtom != 0 && ich < cch && Character.isDigit(ch = strFormat.charAt(ich))) {
            ++ich;
            lt.ch1 = ch;
            if (ch != chAtom && chAtom != 1) {
                lt.tok = 0;
            }
        }
        return ich;
    }

    public static String formatLabel(Atom atom, String strFormat) {
        return LabelToken.formatLabel(atom, strFormat, null, '\u0000', null);
    }

    public static String formatLabel(Atom atom, String strFormat, LabelToken[] tokens, char chAtom, int[] indices) {
        LabelToken t;
        StringBuffer strLabel;
        if (atom == null || tokens == null && (strFormat == null || strFormat.length() == 0)) {
            return null;
        }
        StringBuffer stringBuffer = strLabel = chAtom > '0' ? null : new StringBuffer();
        if (tokens == null) {
            tokens = LabelToken.compile(atom.group.chain.modelSet.viewer, strFormat, chAtom, null);
        }
        for (int i = 0; i < tokens.length && (t = tokens[i]) != null; ++i) {
            if (chAtom > '0' && t.ch1 != chAtom) continue;
            if (t.tok <= 0 || t.key != null) {
                if (strLabel == null) continue;
                strLabel.append(t.text);
                if (t.ch1 == '\u0000') continue;
                strLabel.append(t.ch1);
                continue;
            }
            LabelToken.appendAtomTokenValue(atom, t, strLabel, indices);
        }
        return strLabel == null ? null : strLabel.toString().intern();
    }

    private static void appendAtomTokenValue(Atom atom, LabelToken t, StringBuffer strLabel, int[] indices) {
        String strT = null;
        float floatT = Float.NaN;
        Tuple3f ptT = null;
        try {
            block1 : switch (t.tok) {
                case 22020099: {
                    strT = "" + (indices == null ? atom.atomIndex : indices[atom.atomIndex]);
                    break;
                }
                case 558895366: {
                    ptT = Atom.atomPropertyTuple(atom, t.tok);
                    break;
                }
                case 135272450: {
                    float f = floatT = t.data != null ? t.data[atom.atomIndex] : Float.NaN;
                    if (Float.isNaN(floatT)) {
                        strT = atom.getClientAtomStringProperty(t.text);
                    }
                    break;
                }
                case 558891272: {
                    int formalCharge = atom.getFormalCharge();
                    if (formalCharge > 0) {
                        strT = "" + formalCharge + "+";
                        break;
                    }
                    if (formalCharge < 0) {
                        strT = "" + -formalCharge + "-";
                        break;
                    }
                    strT = "0";
                    break;
                }
                case 103: {
                    strT = "" + atom.getSelectedGroupIndexWithinChain();
                    break;
                }
                case 22024203: {
                    strT = atom.getModelNumberForLabel();
                    break;
                }
                case 55574786: {
                    strT = "" + Atom.atomPropertyInt(atom, t.tok);
                    break;
                }
                case 81: {
                    floatT = (float)atom.getOccupancy100() / 100.0f;
                    break;
                }
                case 592445697: {
                    floatT = Atom.atomPropertyFloat(atom, t.tok);
                    break;
                }
                case 22020114: {
                    int id = atom.getProteinStructureID();
                    strT = id <= 0 ? "" : "" + id;
                    break;
                }
                case 38797327: {
                    floatT = atom.getStraightness();
                    if (Float.isNaN(floatT)) {
                        strT = "null";
                    }
                    break;
                }
                case 30412803: {
                    strT = Atom.atomPropertyString(atom, t.tok);
                    break;
                }
                case 87: {
                    strT = atom.getIdentityXYZ();
                    break;
                }
                default: {
                    switch (t.tok & 0x3D00000) {
                        case 0x1500000: {
                            if (t.intAsFloat) {
                                floatT = Atom.atomPropertyInt(atom, t.tok);
                                break block1;
                            }
                            strT = "" + Atom.atomPropertyInt(atom, t.tok);
                            break block1;
                        }
                        case 0x2500000: {
                            floatT = Atom.atomPropertyFloat(atom, t.tok);
                            break block1;
                        }
                        case 0xD00000: {
                            strT = Atom.atomPropertyString(atom, t.tok);
                            break block1;
                        }
                        case 0x500000: {
                            ptT = Atom.atomPropertyTuple(atom, t.tok);
                        }
                    }
                    break;
                }
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            floatT = Float.NaN;
            strT = null;
            ptT = null;
        }
        strT = t.format(floatT, strT, ptT);
        if (strLabel == null) {
            t.text = strT;
        } else {
            strLabel.append(strT);
        }
    }

    public static Hashtable getBondLabelValues() {
        Hashtable<String, Object> htValues = new Hashtable<String, Object>();
        htValues.put("#", "");
        htValues.put("ORDER", "");
        htValues.put("TYPE", "");
        htValues.put("LENGTH", new Float(0.0f));
        return htValues;
    }

    public static String formatLabel(Bond bond, LabelToken[] tokens, Hashtable values, int[] indices) {
        values.put("#", "" + (bond.index + 1));
        values.put("ORDER", "" + bond.getOrderNumberAsString());
        values.put("TYPE", bond.getOrderName());
        values.put("LENGTH", new Float(bond.atom1.distance(bond.atom2)));
        LabelToken.setValues(tokens, values);
        LabelToken.formatLabel(bond.atom1, null, tokens, '1', indices);
        LabelToken.formatLabel(bond.atom2, null, tokens, '2', indices);
        return LabelToken.getLabel(tokens);
    }

    public static String labelFormat(Measurement measurement, String label, float value, String units) {
        Hashtable<String, Object> htValues = new Hashtable<String, Object>();
        htValues.put("#", "" + (measurement.getIndex() + 1));
        htValues.put("VALUE", new Float(value));
        htValues.put("UNITS", units);
        LabelToken[] tokens = LabelToken.compile(measurement.viewer, label, '\u0001', htValues);
        LabelToken.setValues(tokens, htValues);
        Atom[] atoms = measurement.modelSet.atoms;
        int[] indices = measurement.getCountPlusIndices();
        for (int i = indices[0]; i >= 1; --i) {
            if (indices[i] < 0) continue;
            LabelToken.formatLabel(atoms[indices[i]], null, tokens, (char)(48 + i), null);
        }
        label = LabelToken.getLabel(tokens);
        return label == null ? "" : label;
    }

    public String format(float floatT, String strT, Tuple3f ptT) {
        if (!Float.isNaN(floatT)) {
            return TextFormat.format(floatT, this.width, this.precision, this.alignLeft, this.zeroPad);
        }
        if (strT != null) {
            return TextFormat.format(strT, this.width, this.precision, this.alignLeft, this.zeroPad);
        }
        if (ptT != null) {
            if (this.width == 0 && this.precision == Integer.MAX_VALUE) {
                this.width = 6;
                this.precision = 2;
            }
            return TextFormat.format(ptT.x, this.width, this.precision, false, false) + TextFormat.format(ptT.y, this.width, this.precision, false, false) + TextFormat.format(ptT.z, this.width, this.precision, false, false);
        }
        return this.text;
    }

    public static void setValues(LabelToken[] tokens, Hashtable values) {
        LabelToken lt;
        for (int i = 0; i < tokens.length && (lt = tokens[i]) != null; ++i) {
            if (lt.key == null) continue;
            Object value = values.get(lt.key);
            lt.text = value instanceof Float ? lt.format(((Float)value).floatValue(), null, null) : lt.format(Float.NaN, (String)value, null);
        }
    }

    public static String getLabel(LabelToken[] tokens) {
        LabelToken lt;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tokens.length && (lt = tokens[i]) != null; ++i) {
            sb.append(lt.text);
        }
        return sb.toString();
    }
}

