/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Escape;
import org.jmol.util.Measure;
import org.jmol.util.Point3fi;
import org.jmol.viewer.Viewer;

public class Measurement {
    Viewer viewer;
    public ModelSet modelSet;
    protected int count;
    protected int[] countPlusIndices = new int[5];
    protected Point3fi[] points;
    private String strMeasurement;
    private String strFormat;
    protected float value;
    private boolean isVisible = true;
    private boolean isHidden = false;
    private boolean isDynamic = false;
    private boolean isTrajectory = false;
    private short colix;
    private int index;
    private AxisAngle4f aa;
    private Point3f pointArc;

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = this.countPlusIndices[0] = count;
    }

    public int[] getCountPlusIndices() {
        return this.countPlusIndices;
    }

    public Point3fi[] getPoints() {
        return this.points;
    }

    public int getAtomIndex(int n) {
        return n > 0 && n <= this.count ? this.countPlusIndices[n] : -1;
    }

    public Point3fi getAtom(int i) {
        int pt = this.countPlusIndices[i];
        return pt < -1 ? this.points[-2 - pt] : this.modelSet.getAtomAt(pt);
    }

    public int getLastIndex() {
        return this.count > 0 ? this.countPlusIndices[this.count] : -1;
    }

    public String getString() {
        return this.strMeasurement;
    }

    public String getStringDetail() {
        return (this.count == 2 ? "Distance" : (this.count == 3 ? "Angle" : "Torsion")) + this.getMeasurementScript(" - ") + " : " + this.value;
    }

    public String getStrFormat() {
        return this.strFormat;
    }

    public float getValue() {
        return this.value;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public boolean isTrajectory() {
        return this.isTrajectory;
    }

    public void setVisible(boolean TF) {
        this.isVisible = TF;
    }

    public void setHidden(boolean TF) {
        this.isHidden = TF;
    }

    public void setDynamic(boolean TF) {
        this.isDynamic = TF;
    }

    public short getColix() {
        return this.colix;
    }

    public void setColix(short colix) {
        this.colix = colix;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public AxisAngle4f getAxisAngle() {
        return this.aa;
    }

    public Point3f getPointArc() {
        return this.pointArc;
    }

    public Measurement(ModelSet modelSet, int[] indices, Point3fi[] points, float value, short colix, String strFormat, int index) {
        this.index = index;
        this.modelSet = modelSet;
        this.viewer = modelSet.viewer;
        this.colix = colix;
        this.strFormat = strFormat;
        int n = this.count = indices == null ? 0 : indices[0];
        if (this.count > 0) {
            System.arraycopy(indices, 0, this.countPlusIndices, 0, this.count + 1);
            this.isTrajectory = modelSet.isTrajectory(this.countPlusIndices);
        }
        this.value = Float.isNaN(value) || this.isTrajectory ? this.getMeasurement() : value;
        this.points = points == null ? new Point3fi[4] : points;
        this.formatMeasurement();
    }

    public Measurement(ModelSet modelSet, int[] indices, Point3fi[] points) {
        this.countPlusIndices = indices;
        this.count = indices[0];
        this.points = points == null ? new Point3fi[4] : points;
        this.modelSet = modelSet;
    }

    public void refresh() {
        this.value = this.getMeasurement();
        this.isTrajectory = this.modelSet.isTrajectory(this.countPlusIndices);
        this.formatMeasurement();
    }

    public String getMeasurementScript(String sep) {
        String str = "";
        boolean asScript = sep.equals(" ");
        for (int i = 1; i <= this.count; ++i) {
            int atomIndex = this.countPlusIndices[i];
            str = str + (i > 1 ? sep : " ") + (atomIndex < 0 ? Escape.escape(this.getAtom(i)) : (asScript ? "{atomIndex=" + this.countPlusIndices[i] + "}" : this.viewer.getAtomInfo(atomIndex)));
        }
        return str;
    }

    public void formatMeasurement(String strFormat, boolean useDefault) {
        if (strFormat != null && strFormat.length() == 0) {
            strFormat = null;
        }
        if (!useDefault && strFormat != null && strFormat.indexOf(this.countPlusIndices[0] + ":") != 0) {
            return;
        }
        this.strFormat = strFormat;
        this.formatMeasurement();
    }

    protected void formatMeasurement() {
        this.strMeasurement = null;
        if (Float.isNaN(this.value) || this.count == 0) {
            return;
        }
        switch (this.count) {
            case 2: {
                this.strMeasurement = this.formatDistance(this.value);
                return;
            }
            case 3: {
                if (this.value == 180.0f) {
                    this.aa = null;
                    this.pointArc = null;
                } else {
                    Vector3f vectorBA = new Vector3f();
                    Vector3f vectorBC = new Vector3f();
                    float radians = Measure.computeAngle(this.getAtom(1), this.getAtom(2), this.getAtom(3), vectorBA, vectorBC, false);
                    Vector3f vectorAxis = new Vector3f();
                    vectorAxis.cross(vectorBA, vectorBC);
                    this.aa = new AxisAngle4f(vectorAxis.x, vectorAxis.y, vectorAxis.z, radians);
                    vectorBA.normalize();
                    vectorBA.scale(0.5f);
                    this.pointArc = new Point3f(vectorBA);
                }
            }
            case 4: {
                this.strMeasurement = this.formatAngle(this.value);
                return;
            }
        }
    }

    public void reformatDistanceIfSelected() {
        if (this.count != 2) {
            return;
        }
        if (this.viewer.isSelected(this.countPlusIndices[1]) && this.viewer.isSelected(this.countPlusIndices[2])) {
            this.formatMeasurement();
        }
    }

    private String formatDistance(float dist) {
        float value;
        int nDist = (int)(dist * 100.0f + 0.5f);
        String units = this.viewer.getMeasureDistanceUnits();
        if (units == "nanometers") {
            units = "nm";
            value = (float)nDist / 1000.0f;
        } else if (units == "picometers") {
            units = "pm";
            value = (float)((int)((double)(dist * 1000.0f) + 0.5)) / 10.0f;
        } else if (units == "au") {
            value = (float)((int)(dist / 0.5291772f * 1000.0f + 0.5f)) / 1000.0f;
        } else {
            units = "\u00c5";
            value = (float)nDist / 100.0f;
        }
        return this.formatString(value, units);
    }

    private String formatAngle(float angle) {
        angle = (int)(angle * 10.0f + (angle >= 0.0f ? 0.5f : -0.5f));
        return this.formatString(angle /= 10.0f, "\u00b0");
    }

    private String formatString(float value, String units) {
        String label;
        String s = this.countPlusIndices[0] + ":" + "";
        String string = label = this.strFormat != null && this.strFormat.indexOf(s) == 0 ? this.strFormat : this.viewer.getDefaultMeasurementLabel(this.countPlusIndices[0]);
        if (label.indexOf(s) == 0) {
            label = label.substring(2);
        }
        return LabelToken.labelFormat(this, label, value, units);
    }

    public boolean sameAs(int[] indices, Point3fi[] points) {
        int i;
        if (this.count != indices[0]) {
            return false;
        }
        boolean isSame = true;
        for (i = 1; i <= this.count && isSame; ++i) {
            isSame = this.countPlusIndices[i] == indices[i];
        }
        if (isSame) {
            for (i = 0; i < this.count && isSame; ++i) {
                if (points[i] == null) continue;
                isSame = (double)this.points[i].distance(points[i]) < 0.01;
            }
        }
        if (isSame) {
            return true;
        }
        switch (this.count) {
            default: {
                return true;
            }
            case 2: {
                return this.sameAs(indices, points, 1, 2) && this.sameAs(indices, points, 2, 1);
            }
            case 3: {
                return this.sameAs(indices, points, 1, 3) && this.sameAs(indices, points, 2, 2) && this.sameAs(indices, points, 3, 1);
            }
            case 4: 
        }
        return this.sameAs(indices, points, 1, 4) && this.sameAs(indices, points, 2, 3) && this.sameAs(indices, points, 3, 2) && this.sameAs(indices, points, 4, 1);
    }

    private boolean sameAs(int[] atoms, Point3fi[] points, int i, int j) {
        int ipt = this.countPlusIndices[i];
        int jpt = atoms[j];
        if (jpt < 0 && points[-2 - jpt] == null) {
            System.out.println("measurement -- ohoh");
        }
        return ipt >= 0 || jpt >= 0 ? ipt == jpt : (double)this.points[-2 - ipt].distance(points[-2 - jpt]) < 0.01;
    }

    public boolean sameAs(int i, int j) {
        return this.sameAs(this.countPlusIndices, this.points, i, j);
    }

    public Vector toVector() {
        Vector<String> V = new Vector<String>();
        for (int i = 1; i <= this.count; ++i) {
            V.addElement(this.getLabel(i, false));
        }
        V.addElement(this.strMeasurement);
        return V;
    }

    public float getMeasurement() {
        if (this.countPlusIndices == null) {
            return Float.NaN;
        }
        if (this.count < 2) {
            return Float.NaN;
        }
        int i = this.count;
        while (--i >= 0) {
            if (this.countPlusIndices[i + 1] != -1) continue;
            return Float.NaN;
        }
        Point3fi ptA = this.getAtom(1);
        Point3fi ptB = this.getAtom(2);
        switch (this.count) {
            case 2: {
                return ptA.distance(ptB);
            }
            case 3: {
                Point3fi ptC = this.getAtom(3);
                return Measure.computeAngle(ptA, ptB, ptC, true);
            }
            case 4: {
                Point3fi ptC = this.getAtom(3);
                Point3fi ptD = this.getAtom(4);
                return Measure.computeTorsion(ptA, ptB, ptC, ptD, true);
            }
        }
        return Float.NaN;
    }

    public String getLabel(int i, boolean asBitSet) {
        int atomIndex = this.countPlusIndices[i];
        return atomIndex < 0 ? Escape.escape(this.getAtom(i)) : (asBitSet ? "({" + atomIndex + "})" : this.viewer.getAtomInfo(atomIndex));
    }
}

