/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Polymer;
import org.jmol.util.BitSetUtil;
import org.jmol.viewer.StateManager;

public final class Model {
    ModelSet modelSet;
    int modelIndex;
    int fileIndex;
    boolean isPDB;
    boolean isTrajectory;
    int trajectoryBaseIndex;
    int selectedTrajectory = -1;
    boolean hasCalculatedHBonds;
    Hashtable dataFrames;
    int dataSourceFrame = -1;
    String jmolData;
    String jmolFrameType;
    int firstAtomIndex;
    int atomCount = -1;
    BitSet bsAtoms;
    int bondCount = -1;
    int firstMolecule;
    int moleculeCount;
    int nAltLocs;
    int nInsertions;
    int groupCount = -1;
    int chainCount = 0;
    Chain[] chains = new Chain[8];
    int bioPolymerCount = 0;
    Polymer[] bioPolymers = new Polymer[8];
    int biosymmetryCount;
    Hashtable auxiliaryInfo;
    Properties properties;
    float defaultRotationRadius;
    StateManager.Orientation orientation;
    boolean structureTainted;

    public ModelSet getModelSet() {
        return this.modelSet;
    }

    Model(ModelSet modelSet, int modelIndex, int trajectoryBaseIndex, String jmolData, Properties properties, Hashtable auxiliaryInfo) {
        this.modelSet = modelSet;
        this.dataSourceFrame = this.modelIndex = modelIndex;
        this.jmolData = jmolData;
        this.isTrajectory = trajectoryBaseIndex >= 0;
        int n = this.trajectoryBaseIndex = this.isTrajectory ? trajectoryBaseIndex : modelIndex;
        if (auxiliaryInfo == null) {
            auxiliaryInfo = new Hashtable<String, String>();
        }
        this.auxiliaryInfo = auxiliaryInfo;
        if (auxiliaryInfo.containsKey("biosymmetryCount")) {
            this.biosymmetryCount = (Integer)auxiliaryInfo.get("biosymmetryCount");
        }
        this.properties = properties;
        if (jmolData == null) {
            this.jmolFrameType = "modelSet";
        } else {
            auxiliaryInfo.put("jmolData", jmolData);
            auxiliaryInfo.put("title", jmolData);
            this.jmolFrameType = jmolData.indexOf("ramachandran") >= 0 ? "ramachandran" : (jmolData.indexOf("quaternion") >= 0 ? "quaternion" : "data");
        }
    }

    void setNAltLocs(int nAltLocs) {
        this.nAltLocs = nAltLocs;
    }

    void setNInsertions(int nInsertions) {
        this.nInsertions = nInsertions;
    }

    void addSecondaryStructure(byte type, char startChainID, int startSeqcode, char endChainID, int endSeqcode) {
        int i = this.bioPolymerCount;
        while (--i >= 0) {
            Polymer polymer = this.bioPolymers[i];
            polymer.addSecondaryStructure(type, startChainID, startSeqcode, endChainID, endSeqcode);
        }
    }

    void calculateStructures() {
        this.modelSet.proteinStructureTainted = true;
        this.structureTainted = true;
        int i = this.bioPolymerCount;
        while (--i >= 0) {
            this.bioPolymers[i].clearStructures();
            this.bioPolymers[i].calculateStructures();
        }
    }

    public boolean isStructureTainted() {
        return this.structureTainted;
    }

    void setConformation(BitSet bsConformation) {
        int i = this.bioPolymerCount;
        while (--i >= 0) {
            this.bioPolymers[i].setConformation(bsConformation, this.nAltLocs);
        }
    }

    public Chain[] getChains() {
        return this.chains;
    }

    public int getChainCount(boolean countWater) {
        if (this.chainCount > 1 && !countWater) {
            for (int i = 0; i < this.chainCount; ++i) {
                if (this.chains[i].chainID != '\u0000') continue;
                return this.chainCount - 1;
            }
        }
        return this.chainCount;
    }

    public int getGroupCount(boolean isHetero) {
        int n = 0;
        int i = this.chainCount;
        while (--i >= 0) {
            int j = this.chains[i].groupCount;
            while (--j >= 0) {
                if (this.chains[i].groups[j].isHetero() != isHetero) continue;
                ++n;
            }
        }
        return n;
    }

    public int getBioPolymerCount() {
        return this.bioPolymerCount;
    }

    void calcSelectedGroupsCount(BitSet bsSelected) {
        int i = this.chainCount;
        while (--i >= 0) {
            this.chains[i].calcSelectedGroupsCount(bsSelected);
        }
    }

    void calcSelectedMonomersCount(BitSet bsSelected) {
        int i = this.bioPolymerCount;
        while (--i >= 0) {
            this.bioPolymers[i].calcSelectedMonomersCount(bsSelected);
        }
    }

    void selectSeqcodeRange(int seqcodeA, int seqcodeB, char chainID, BitSet bs, boolean caseSensitive) {
        int i = this.chainCount;
        while (--i >= 0) {
            if (chainID != '\t' && chainID != this.chains[i].chainID && (caseSensitive || chainID != Character.toUpperCase(this.chains[i].chainID))) continue;
            int index = 0;
            while (index >= 0) {
                index = this.chains[i].selectSeqcodeRange(index, seqcodeA, seqcodeB, bs);
            }
        }
    }

    int getGroupCount() {
        if (this.groupCount < 0) {
            this.groupCount = 0;
            int i = this.chainCount;
            while (--i >= 0) {
                this.groupCount += this.chains[i].getGroupCount();
            }
        }
        return this.groupCount;
    }

    Chain getChain(char chainID) {
        int i = this.chainCount;
        while (--i >= 0) {
            Chain chain = this.chains[i];
            if (chain.getChainID() != chainID) continue;
            return chain;
        }
        return null;
    }

    Chain getChain(int i) {
        return i < this.chainCount ? this.chains[i] : null;
    }

    public Polymer getBioPolymer(int polymerIndex) {
        return this.bioPolymers[polymerIndex];
    }

    void calcHydrogenBonds(BitSet bsA, BitSet bsB) {
        int i = this.bioPolymerCount;
        while (--i >= 0) {
            int type = this.bioPolymers[i].getType();
            if (type != 1 && type != 2) continue;
            if (type == 1) {
                this.bioPolymers[i].calcHydrogenBonds(null, bsA, bsB);
            }
            int j = this.bioPolymerCount;
            while (--j >= 0) {
                if (i == j || this.bioPolymers[i] == null || type != this.bioPolymers[j].getType()) continue;
                this.bioPolymers[j].calcHydrogenBonds(this.bioPolymers[i], bsA, bsB);
            }
        }
    }

    public boolean isAtomHidden(int index) {
        return this.modelSet.isAtomHidden(index);
    }

    public void addHydrogenBond(Atom atom1, Atom atom2, short order, BitSet bsA, BitSet bsB, float energy) {
        this.hasCalculatedHBonds = true;
        this.modelSet.addHydrogenBond(atom1, atom2, order, bsA, bsB, energy);
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    void fixIndices(int modelIndex, int nAtomsDeleted, BitSet bsDeleted) {
        int i;
        if (this.dataSourceFrame > modelIndex) {
            --this.dataSourceFrame;
        }
        if (this.trajectoryBaseIndex > modelIndex) {
            --this.trajectoryBaseIndex;
        }
        this.firstAtomIndex -= nAtomsDeleted;
        for (i = 0; i < this.chainCount; ++i) {
            this.chains[i].fixIndices(nAtomsDeleted);
        }
        for (i = 0; i < this.bioPolymerCount; ++i) {
            this.bioPolymers[i].recalculateLeadMidpointsAndWingVectors();
        }
        BitSetUtil.deleteBits(this.bsAtoms, bsDeleted);
    }
}

