/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolBioResolver;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Logger;
import org.jmol.util.Quaternion;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public final class ModelLoader
extends ModelSet {
    private ModelLoader mergeModelSet;
    private boolean merging;
    private String jmolData;
    private final int[] specialAtomIndexes = new int[JmolConstants.ATOMID_MAX];
    private String[] group3Lists;
    private int[][] group3Counts;
    private boolean someModelsHaveUnitcells;
    private boolean isTrajectory;
    private String fileHeader;
    private static final int ATOM_GROWTH_INCREMENT = 2000;
    private final Hashtable htAtomMap = new Hashtable();
    private static final int defaultGroupCount = 32;
    private Chain[] chainOf;
    private String[] group3Of;
    private int[] seqcodes;
    private int[] firstAtomIndexes;
    private int currentModelIndex;
    private Model currentModel;
    private char currentChainID;
    private Chain currentChain;
    private int currentGroupSequenceNumber;
    private char currentGroupInsertionCode;
    private String currentGroup3;
    Group nullGroup;
    private int baseModelIndex = 0;
    private int baseModelCount = 0;
    private int baseAtomIndex = 0;
    private int baseTrajectoryCount = 0;
    private boolean appendNew;
    private int adapterModelCount = 0;
    private int adapterTrajectoryCount = 0;
    private static Hashtable htAtom = new Hashtable();

    public ModelLoader(Viewer viewer, String name) {
        if (this.shapes == null && !viewer.isDataOnly()) {
            this.shapes = new Shape[32];
        }
        this.viewer = viewer;
        this.initializeInfo(name, 1, null, null);
        this.createModelSet(null, null);
        this.modelSetName = "zapped";
        viewer.setStringProperty("_fileType", "");
    }

    public ModelLoader(Viewer viewer, Object atomSetCollection, ModelLoader mergeModelSet, String modelSetName) {
        if (this.shapes == null && !viewer.isDataOnly()) {
            this.shapes = new Shape[32];
        }
        JmolAdapter adapter = viewer.getModelAdapter();
        this.modelSetName = modelSetName;
        this.mergeModelSet = mergeModelSet;
        this.merging = mergeModelSet != null && mergeModelSet.atomCount > 0;
        this.viewer = viewer;
        this.initializeInfo(adapter.getFileTypeName(atomSetCollection).toLowerCase().intern(), adapter.getEstimatedAtomCount(atomSetCollection), adapter.getAtomSetCollectionProperties(atomSetCollection), adapter.getAtomSetCollectionAuxiliaryInfo(atomSetCollection));
        this.createModelSet(adapter, atomSetCollection);
    }

    private void initializeInfo(String name, int nAtoms, Properties properties, Hashtable info) {
        this.g3d = this.viewer.getGraphics3D();
        this.modelSetTypeName = name;
        this.isXYZ = this.modelSetTypeName == "xyz";
        this.setModelSetProperties(properties);
        this.setModelSetAuxiliaryInfo(info);
        this.isPDB = this.getModelSetAuxiliaryInfoBoolean("isPDB");
        this.jmolData = (String)this.getModelSetAuxiliaryInfo("jmolData");
        this.fileHeader = (String)this.getModelSetAuxiliaryInfo("fileHeader");
        this.trajectorySteps = (Vector)this.getModelSetAuxiliaryInfo("trajectorySteps");
        this.isTrajectory = this.trajectorySteps != null;
        this.adapterTrajectoryCount = this.trajectorySteps == null ? 0 : this.trajectorySteps.size();
        this.someModelsHaveSymmetry = this.getModelSetAuxiliaryInfoBoolean("someModelsHaveSymmetry");
        this.someModelsHaveUnitcells = this.getModelSetAuxiliaryInfoBoolean("someModelsHaveUnitcells");
        this.someModelsHaveFractionalCoordinates = this.getModelSetAuxiliaryInfoBoolean("someModelsHaveFractionalCoordinates");
        if (this.merging) {
            this.someModelsHaveSymmetry |= this.mergeModelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveSymmetry");
            this.someModelsHaveUnitcells |= this.mergeModelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveUnitcells");
            this.someModelsHaveFractionalCoordinates |= this.mergeModelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveFractionalCoordinates");
            this.someModelsHaveAromaticBonds |= this.mergeModelSet.someModelsHaveAromaticBonds;
        }
        this.initializeBuild(nAtoms);
    }

    private void initializeBuild(int atomCountEstimate) {
        if (atomCountEstimate <= 0) {
            atomCountEstimate = 2000;
        }
        if (this.merging) {
            this.atoms = this.mergeModelSet.atoms;
            this.bonds = this.mergeModelSet.bonds;
        } else {
            this.atoms = new Atom[atomCountEstimate];
            this.bonds = new Bond[250 + atomCountEstimate];
        }
        this.htAtomMap.clear();
        this.initializeGroupBuild();
    }

    private void initializeGroupBuild() {
        this.chainOf = new Chain[32];
        this.group3Of = new String[32];
        this.seqcodes = new int[32];
        this.firstAtomIndexes = new int[32];
        this.currentChainID = (char)65535;
        this.currentChain = null;
        this.currentGroupInsertionCode = (char)65535;
        this.currentGroup3 = "xxxxx";
        this.currentModelIndex = -1;
        this.currentModel = null;
    }

    private void createModelSet(JmolAdapter adapter, Object atomSetCollection) {
        this.adapterModelCount = adapter == null ? 1 : adapter.getAtomSetCount(atomSetCollection);
        boolean bl = this.appendNew = !this.merging || adapter == null || this.adapterModelCount > 1 || this.isTrajectory || this.viewer.getAppendNew();
        if (this.merging) {
            this.mergeModelArrays();
        }
        this.initializeAtomBondModelCounts();
        if (adapter == null) {
            this.setModelNameNumberProperties(0, -1, "", 1, null, null, false, null);
        } else {
            Quaternion q;
            if (this.adapterModelCount > 0) {
                Logger.info("ModelSet: haveSymmetry:" + this.someModelsHaveSymmetry + " haveUnitcells:" + this.someModelsHaveUnitcells + " haveFractionalCoord:" + this.someModelsHaveFractionalCoordinates);
                Logger.info(this.adapterModelCount + " model" + (this.modelCount == 1 ? "" : "s") + " in this collection. Use getProperty \"modelInfo\" or" + " getProperty \"auxiliaryInfo\" to inspect them.");
            }
            if ((q = (Quaternion)this.getModelSetAuxiliaryInfo("defaultOrientationQuaternion")) != null) {
                Logger.info("defaultOrientationQuaternion = " + q);
                Logger.info("Use \"set autoLoadOrientation TRUE\" before loading or \"restore orientation DEFAULT\" after loading to view this orientation.");
            }
            this.iterateOverAllNewModels(adapter, atomSetCollection);
            this.iterateOverAllNewAtoms(adapter, atomSetCollection);
            this.iterateOverAllNewBonds(adapter, atomSetCollection);
            this.iterateOverAllNewStructures(adapter, atomSetCollection);
            if (adapter != null) {
                adapter.finish(atomSetCollection);
            }
            this.initializeUnitCellAndSymmetry();
            this.initializeBonding();
        }
        this.finalizeGroupBuild();
        this.calculatePolymers(null);
        this.freeze();
        this.calcBoundBoxDimensions(null);
        this.finalizeShapes();
        if (this.mergeModelSet != null) {
            this.mergeModelSet.releaseModelSet();
        }
        this.mergeModelSet = null;
    }

    protected void releaseModelSet() {
        this.group3Lists = null;
        this.group3Counts = null;
        this.groups = null;
        super.releaseModelSet();
    }

    private void mergeModelArrays() {
        this.baseModelCount = this.mergeModelSet.modelCount;
        this.baseTrajectoryCount = this.mergeModelSet.getTrajectoryCount();
        if (this.baseTrajectoryCount > 0) {
            if (this.isTrajectory) {
                for (int i = 0; i < this.trajectorySteps.size(); ++i) {
                    this.mergeModelSet.trajectorySteps.addElement(this.trajectorySteps.elementAt(i));
                }
            }
            this.trajectorySteps = this.mergeModelSet.trajectorySteps;
        }
        this.modelFileNumbers = this.mergeModelSet.modelFileNumbers;
        this.modelNumbersForAtomLabel = this.mergeModelSet.modelNumbersForAtomLabel;
        this.modelNames = this.mergeModelSet.modelNames;
        this.modelNumbers = this.mergeModelSet.modelNumbers;
        this.frameTitles = this.mergeModelSet.frameTitles;
    }

    private void initializeAtomBondModelCounts() {
        this.atomCount = 0;
        this.bondCount = 0;
        int trajectoryCount = this.adapterTrajectoryCount;
        if (this.merging) {
            if (this.appendNew) {
                this.baseModelIndex = this.baseModelCount;
                this.modelCount = this.baseModelCount + this.adapterModelCount;
            } else {
                this.baseModelIndex = this.viewer.getCurrentModelIndex();
                if (this.baseModelIndex < 0) {
                    this.baseModelIndex = this.baseModelCount - 1;
                }
                this.modelCount = this.baseModelCount;
            }
            this.atomCount = this.baseAtomIndex = this.mergeModelSet.atomCount;
            this.bondCount = this.mergeModelSet.bondCount;
            this.groupCount = this.baseGroupIndex = this.mergeModelSet.groupCount;
        } else {
            this.modelCount = this.adapterModelCount;
        }
        if (trajectoryCount > 1) {
            this.modelCount += trajectoryCount - 1;
        }
        this.models = (Model[])ArrayUtil.setLength(this.models, this.modelCount);
        this.modelFileNumbers = ArrayUtil.setLength(this.modelFileNumbers, this.modelCount);
        this.modelNumbers = ArrayUtil.setLength(this.modelNumbers, this.modelCount);
        this.modelNumbersForAtomLabel = ArrayUtil.setLength(this.modelNumbersForAtomLabel, this.modelCount);
        this.modelNames = ArrayUtil.setLength(this.modelNames, this.modelCount);
        this.frameTitles = ArrayUtil.setLength(this.frameTitles, this.modelCount);
    }

    private void initializeMerge() {
        this.merge(this.mergeModelSet);
        this.bsSymmetry = this.mergeModelSet.bsSymmetry;
        Hashtable info = this.mergeModelSet.getAuxiliaryInfo(null);
        String[] mergeGroup3Lists = (String[])info.get("group3Lists");
        int[][] mergeGroup3Counts = (int[][])info.get("group3Counts");
        if (mergeGroup3Lists != null) {
            for (int i = 0; i < this.baseModelCount; ++i) {
                this.group3Lists[i + 1] = mergeGroup3Lists[i + 1];
                this.group3Counts[i + 1] = mergeGroup3Counts[i + 1];
                this.structuresDefinedInFile.set(i);
            }
            this.group3Lists[0] = mergeGroup3Lists[0];
            this.group3Counts[0] = mergeGroup3Counts[0];
        }
        if (!this.appendNew && this.isPDB) {
            this.structuresDefinedInFile.clear(this.baseModelIndex);
        }
        this.surfaceDistance100s = null;
    }

    private void iterateOverAllNewModels(JmolAdapter adapter, Object atomSetCollection) {
        if (this.modelCount > 0) {
            this.nullGroup = new Group(new Chain(this, this.getModel(this.baseModelIndex), ' '), "", 0, -1, -1);
        }
        this.group3Lists = new String[this.modelCount + 1];
        this.group3Counts = new int[this.modelCount + 1][];
        this.structuresDefinedInFile = new BitSet();
        if (this.merging) {
            this.initializeMerge();
        }
        int iTrajectory = this.isTrajectory ? this.baseTrajectoryCount : -1;
        int ipt = this.baseModelIndex;
        int i = 0;
        while (i < this.adapterModelCount) {
            boolean isPDBModel;
            int modelNumber = this.appendNew ? adapter.getAtomSetNumber(atomSetCollection, i) : Integer.MAX_VALUE;
            String modelName = adapter.getAtomSetName(atomSetCollection, i);
            Properties modelProperties = adapter.getAtomSetProperties(atomSetCollection, i);
            Hashtable modelAuxiliaryInfo = adapter.getAtomSetAuxiliaryInfo(atomSetCollection, i);
            this.viewer.setStringProperty("_fileType", (String)modelAuxiliaryInfo.get("fileType"));
            if (modelName == null) {
                String string = this.jmolData != null ? this.jmolData.substring(this.jmolData.indexOf(":") + 2, this.jmolData.indexOf(";")) : (modelName = modelNumber == Integer.MAX_VALUE ? "" : "" + modelNumber % 1000000);
            }
            if (isPDBModel = this.setModelNameNumberProperties(ipt, iTrajectory, modelName, modelNumber, modelProperties, modelAuxiliaryInfo, this.isPDB, this.jmolData)) {
                this.group3Lists[ipt + 1] = JmolConstants.group3List;
                this.group3Counts[ipt + 1] = new int[JmolConstants.group3Count + 10];
                if (this.group3Lists[0] == null) {
                    this.group3Lists[0] = JmolConstants.group3List;
                    this.group3Counts[0] = new int[JmolConstants.group3Count + 10];
                }
            }
            if (this.getModelAuxiliaryInfo(ipt, "periodicOriginXyz") != null) {
                this.someModelsHaveSymmetry = true;
            }
            ++i;
            ++ipt;
        }
        if (this.isTrajectory) {
            Logger.info(this.modelCount - ipt + 1 + " trajectory steps read");
            int ia = this.adapterModelCount;
            for (int i2 = ipt; i2 < this.modelCount; ++i2) {
                this.models[i2] = this.models[this.baseModelCount];
                this.modelNumbers[i2] = adapter.getAtomSetNumber(atomSetCollection, ia++);
                this.structuresDefinedInFile.set(i2);
            }
        }
        this.finalizeModels(this.baseModelCount);
    }

    private boolean setModelNameNumberProperties(int modelIndex, int trajectoryBaseIndex, String modelName, int modelNumber, Properties modelProperties, Hashtable modelAuxiliaryInfo, boolean isPDB, String jmolData) {
        if (modelNumber != Integer.MAX_VALUE) {
            this.models[modelIndex] = new Model(this, modelIndex, trajectoryBaseIndex, jmolData, modelProperties, modelAuxiliaryInfo);
            this.modelNumbers[modelIndex] = modelNumber;
            this.modelNames[modelIndex] = modelName;
        }
        String codes = (String)this.getModelAuxiliaryInfo(modelIndex, "altLocs");
        this.models[modelIndex].setNAltLocs(codes == null ? 0 : codes.length());
        codes = (String)this.getModelAuxiliaryInfo(modelIndex, "insertionCodes");
        this.models[modelIndex].setNInsertions(codes == null ? 0 : codes.length());
        this.models[modelIndex].isPDB = this.getModelAuxiliaryInfoBoolean(modelIndex, "isPDB");
        return this.models[modelIndex].isPDB;
    }

    private void finalizeModels(int baseModelCount) {
        int i;
        if (this.modelCount == baseModelCount) {
            return;
        }
        int modelnumber = 0;
        int lastfilenumber = -1;
        if (this.isTrajectory) {
            i = baseModelCount;
            while (++i < this.modelCount) {
                this.modelNumbers[i] = this.modelNumbers[i - 1] + 1;
            }
        }
        if (baseModelCount > 0) {
            if (this.modelNumbers[0] < 1000000) {
                for (i = 0; i < baseModelCount; ++i) {
                    if (this.modelNames[i].length() == 0) {
                        this.modelNames[i] = "" + this.modelNumbers[i];
                    }
                    int n = i;
                    this.modelNumbers[n] = this.modelNumbers[n] + 1000000;
                    this.modelNumbersForAtomLabel[i] = "1." + (i + 1);
                }
            }
            int filenumber = this.modelNumbers[baseModelCount - 1];
            filenumber -= filenumber % 1000000;
            if (this.modelNumbers[baseModelCount] < 1000000) {
                filenumber += 1000000;
            }
            int i2 = baseModelCount;
            while (i2 < this.modelCount) {
                int n = i2++;
                this.modelNumbers[n] = this.modelNumbers[n] + filenumber;
            }
        }
        for (i = baseModelCount; i < this.modelCount; ++i) {
            String sNum;
            int filenumber;
            if (this.fileHeader != null) {
                this.setModelAuxiliaryInfo(i, "fileHeader", this.fileHeader);
            }
            if ((filenumber = this.modelNumbers[i] / 1000000) != lastfilenumber) {
                modelnumber = 0;
                lastfilenumber = filenumber;
            }
            ++modelnumber;
            if (filenumber == 0) {
                sNum = "" + this.getModelNumber(i);
                filenumber = 1;
            } else {
                sNum = filenumber + "." + modelnumber;
            }
            this.modelNumbersForAtomLabel[i] = sNum;
            this.models[i].fileIndex = filenumber - 1;
            this.modelFileNumbers[i] = filenumber * 1000000 + modelnumber;
            if (this.modelNames[i] != null && this.modelNames[i].length() != 0) continue;
            this.modelNames[i] = sNum;
        }
        if (this.merging) {
            for (i = 0; i < baseModelCount; ++i) {
                this.models[i].modelSet = this;
            }
        }
        for (i = 0; i < this.modelCount; ++i) {
            this.setModelAuxiliaryInfo(i, "modelName", this.modelNames[i]);
            this.setModelAuxiliaryInfo(i, "modelNumber", new Integer(this.modelNumbers[i] % 1000000));
            this.setModelAuxiliaryInfo(i, "modelFileNumber", new Integer(this.modelFileNumbers[i]));
            this.setModelAuxiliaryInfo(i, "modelNumberDotted", this.getModelNumberDotted(i));
        }
    }

    private void iterateOverAllNewAtoms(JmolAdapter adapter, Object atomSetCollection) {
        short size = this.viewer.getDefaultMadAtom();
        JmolAdapter.AtomIterator iterAtom = adapter.getAtomIterator(atomSetCollection);
        while (iterAtom.hasNext()) {
            short elementNumber = (short)iterAtom.getElementNumber();
            if (elementNumber <= 0) {
                elementNumber = JmolConstants.elementNumberFromSymbol(iterAtom.getElementSymbol());
            }
            char alternateLocation = iterAtom.getAlternateLocationID();
            this.addAtom(iterAtom.getAtomSetIndex() + this.baseModelIndex, iterAtom.getAtomSymmetry(), iterAtom.getAtomSite(), iterAtom.getUniqueID(), elementNumber, iterAtom.getAtomName(), size, iterAtom.getFormalCharge(), iterAtom.getPartialCharge(), iterAtom.getEllipsoid(), iterAtom.getOccupancy(), iterAtom.getBfactor(), iterAtom.getX(), iterAtom.getY(), iterAtom.getZ(), iterAtom.getIsHetero(), iterAtom.getAtomSerial(), iterAtom.getChainID(), iterAtom.getGroup3(), iterAtom.getSequenceNumber(), iterAtom.getInsertionCode(), iterAtom.getVectorX(), iterAtom.getVectorY(), iterAtom.getVectorZ(), alternateLocation, iterAtom.getClientAtomReference(), iterAtom.getRadius());
        }
        short iLast = -1;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.atoms[i].modelIndex == iLast) continue;
            iLast = this.atoms[i].modelIndex;
            this.models[iLast].firstAtomIndex = i;
            this.models[iLast].bsAtoms = null;
        }
    }

    private void addAtom(int modelIndex, BitSet atomSymmetry, int atomSite, Object atomUid, short atomicAndIsotopeNumber, String atomName, int size, int formalCharge, float partialCharge, Object[] ellipsoid, int occupancy, float bfactor, float x, float y, float z, boolean isHetero, int atomSerial, char chainID, String group3, int groupSequenceNumber, char groupInsertionCode, float vectorX, float vectorY, float vectorZ, char alternateLocationID, Object clientAtomReference, float radius) {
        Atom atom;
        this.checkNewGroup(this.atomCount, modelIndex, chainID, group3, groupSequenceNumber, groupInsertionCode);
        if (this.atomCount == this.atoms.length) {
            this.growAtomArrays(2000);
        }
        this.atoms[this.atomCount] = atom = new Atom(this.viewer, this.currentModelIndex, this.atomCount, atomSymmetry, atomSite, atomicAndIsotopeNumber, size, formalCharge, x, y, z, isHetero, chainID, alternateLocationID, radius);
        this.setBFactor(this.atomCount, bfactor);
        this.setOccupancy(this.atomCount, occupancy);
        this.setPartialCharge(this.atomCount, partialCharge);
        if (ellipsoid != null) {
            this.setEllipsoid(this.atomCount, ellipsoid);
        }
        atom.group = this.nullGroup;
        atom.colixAtom = this.viewer.getColixAtomPalette(atom, (byte)1);
        if (atomName != null) {
            int i;
            if (this.atomNames == null) {
                this.atomNames = new String[this.atoms.length];
            }
            if ((i = atomName.indexOf(0)) >= 0) {
                if (this.atomTypes == null) {
                    this.atomTypes = new String[this.atoms.length];
                }
                this.atomTypes[this.atomCount] = atomName.substring(i + 1);
                atomName = atomName.substring(0, i);
            }
            this.atomNames[this.atomCount] = atomName.intern();
            byte specialAtomID = ModelLoader.lookupSpecialAtomID(atomName);
            if (specialAtomID == 2 && group3 != null && group3.equalsIgnoreCase("CA")) {
                specialAtomID = 0;
            }
            if (specialAtomID != 0) {
                if (this.specialAtomIDs == null) {
                    this.specialAtomIDs = new byte[this.atoms.length];
                }
                this.specialAtomIDs[this.atomCount] = specialAtomID;
            }
        }
        if (atomSerial != Integer.MIN_VALUE) {
            if (this.atomSerials == null) {
                this.atomSerials = new int[this.atoms.length];
            }
            this.atomSerials[this.atomCount] = atomSerial;
        }
        if (clientAtomReference != null) {
            if (this.clientAtomReferences == null) {
                this.clientAtomReferences = new Object[this.atoms.length];
            }
            this.clientAtomReferences[this.atomCount] = clientAtomReference;
        }
        if (!Float.isNaN(vectorX)) {
            this.setVibrationVector(this.atomCount, vectorX, vectorY, vectorZ);
        }
        this.htAtomMap.put(atomUid, atom);
        ++this.atomCount;
    }

    private static byte lookupSpecialAtomID(String atomName) {
        if (atomName != null) {
            Integer boxedAtomID;
            if (atomName.indexOf(42) >= 0) {
                atomName = atomName.replace('*', '\'');
            }
            if ((boxedAtomID = (Integer)htAtom.get(atomName)) != null) {
                return (byte)boxedAtomID.intValue();
            }
        }
        return 0;
    }

    private void checkNewGroup(int atomIndex, int modelIndex, char chainID, String group3, int groupSequenceNumber, char groupInsertionCode) {
        String group3i;
        String string = group3i = group3 == null ? null : group3.intern();
        if (modelIndex != this.currentModelIndex) {
            this.currentModel = this.getModel(modelIndex);
            this.currentModelIndex = modelIndex;
            this.currentChainID = (char)65535;
        }
        if (chainID != this.currentChainID) {
            this.currentChainID = chainID;
            this.currentChain = this.getOrAllocateChain(this.currentModel, chainID);
            this.currentGroupInsertionCode = (char)65535;
            this.currentGroupSequenceNumber = -1;
            this.currentGroup3 = "xxxx";
        }
        if (groupSequenceNumber != this.currentGroupSequenceNumber || groupInsertionCode != this.currentGroupInsertionCode || group3i != this.currentGroup3) {
            this.currentGroupSequenceNumber = groupSequenceNumber;
            this.currentGroupInsertionCode = groupInsertionCode;
            this.currentGroup3 = group3i;
            while (this.groupCount >= this.group3Of.length) {
                this.chainOf = (Chain[])ArrayUtil.doubleLength(this.chainOf);
                this.group3Of = ArrayUtil.doubleLength(this.group3Of);
                this.seqcodes = ArrayUtil.doubleLength(this.seqcodes);
                this.firstAtomIndexes = ArrayUtil.doubleLength(this.firstAtomIndexes);
            }
            this.firstAtomIndexes[this.groupCount] = atomIndex;
            this.chainOf[this.groupCount] = this.currentChain;
            this.group3Of[this.groupCount] = group3;
            this.seqcodes[this.groupCount] = Group.getSeqcode(groupSequenceNumber, groupInsertionCode);
            ++this.groupCount;
        }
    }

    private Chain getOrAllocateChain(Model model, char chainID) {
        Chain chain = model.getChain(chainID);
        if (chain != null) {
            return chain;
        }
        if (model.chainCount == model.chains.length) {
            model.chains = (Chain[])ArrayUtil.doubleLength(model.chains);
        }
        Chain chain2 = new Chain(this, model, chainID);
        model.chains[model.chainCount++] = chain2;
        return chain2;
    }

    private void growAtomArrays(int byHowMuch) {
        int newLength = this.atomCount + byHowMuch;
        this.atoms = (Atom[])ArrayUtil.setLength(this.atoms, newLength);
        if (this.clientAtomReferences != null) {
            this.clientAtomReferences = (Object[])ArrayUtil.setLength(this.clientAtomReferences, newLength);
        }
        if (this.vibrationVectors != null) {
            this.vibrationVectors = (Vector3f[])ArrayUtil.setLength(this.vibrationVectors, newLength);
        }
        if (this.occupancies != null) {
            this.occupancies = ArrayUtil.setLength(this.occupancies, newLength);
        }
        if (this.bfactor100s != null) {
            this.bfactor100s = ArrayUtil.setLength(this.bfactor100s, newLength);
        }
        if (this.partialCharges != null) {
            this.partialCharges = ArrayUtil.setLength(this.partialCharges, newLength);
        }
        if (this.ellipsoids != null) {
            Object[][] ellipsoids2 = new Object[newLength][];
            for (int i = 0; i < this.ellipsoids.length; ++i) {
                ellipsoids2[i] = this.ellipsoids[i];
            }
            this.ellipsoids = ellipsoids2;
        }
        if (this.atomNames != null) {
            this.atomNames = ArrayUtil.setLength(this.atomNames, newLength);
        }
        if (this.atomTypes != null) {
            this.atomTypes = ArrayUtil.setLength(this.atomTypes, newLength);
        }
        if (this.atomSerials != null) {
            this.atomSerials = ArrayUtil.setLength(this.atomSerials, newLength);
        }
        if (this.specialAtomIDs != null) {
            this.specialAtomIDs = ArrayUtil.setLength(this.specialAtomIDs, newLength);
        }
    }

    private void iterateOverAllNewBonds(JmolAdapter adapter, Object atomSetCollection) {
        JmolAdapter.BondIterator iterBond = adapter.getBondIterator(atomSetCollection);
        if (iterBond == null) {
            return;
        }
        short mad = this.viewer.getMadBond();
        this.defaultCovalentMad = this.jmolData == null ? mad : (short)0;
        boolean haveMultipleBonds = false;
        while (iterBond.hasNext()) {
            short order = (short)iterBond.getEncodedOrder();
            this.bondAtoms(iterBond.getAtomUniqueID1(), iterBond.getAtomUniqueID2(), order);
            if (order <= 1) continue;
            haveMultipleBonds = true;
        }
        if (haveMultipleBonds && this.someModelsHaveSymmetry && !this.viewer.getApplySymmetryToBonds()) {
            Logger.info("ModelSet: use \"set appletSymmetryToBonds TRUE \" to apply the file-based multiple bonds to symmetry-generated atoms.");
        }
        this.defaultCovalentMad = mad;
    }

    private void bondAtoms(Object atomUid1, Object atomUid2, short order) {
        Atom atom1 = (Atom)this.htAtomMap.get(atomUid1);
        if (atom1 == null) {
            Logger.error("bondAtoms cannot find atomUid1?:" + atomUid1);
            return;
        }
        Atom atom2 = (Atom)this.htAtomMap.get(atomUid2);
        if (atom2 == null) {
            Logger.error("bondAtoms cannot find atomUid2?:" + atomUid2);
            return;
        }
        if (atom1.isBonded(atom2)) {
            return;
        }
        Bond bond = this.bondMutually(atom1, atom2, order, this.getDefaultMadFromOrder(order));
        if (bond.isAromatic()) {
            this.someModelsHaveAromaticBonds = true;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount + 4000);
        }
        this.setBond(this.bondCount++, bond);
    }

    private void iterateOverAllNewStructures(JmolAdapter adapter, Object atomSetCollection) {
        JmolAdapter.StructureIterator iterStructure = adapter.getStructureIterator(atomSetCollection);
        if (iterStructure != null) {
            while (iterStructure.hasNext()) {
                if (iterStructure.getStructureType().equals("turn")) continue;
                this.defineStructure(iterStructure.getModelIndex(), iterStructure.getStructureType(), iterStructure.getStartChainID(), iterStructure.getStartSequenceNumber(), iterStructure.getStartInsertionCode(), iterStructure.getEndChainID(), iterStructure.getEndSequenceNumber(), iterStructure.getEndInsertionCode());
            }
        }
        if ((iterStructure = adapter.getStructureIterator(atomSetCollection)) != null) {
            while (iterStructure.hasNext()) {
                if (!iterStructure.getStructureType().equals("turn")) continue;
                this.defineStructure(iterStructure.getModelIndex(), iterStructure.getStructureType(), iterStructure.getStartChainID(), iterStructure.getStartSequenceNumber(), iterStructure.getStartInsertionCode(), iterStructure.getEndChainID(), iterStructure.getEndSequenceNumber(), iterStructure.getEndInsertionCode());
            }
        }
    }

    protected void defineStructure(int modelIndex, String structureType, char startChainID, int startSequenceNumber, char startInsertionCode, char endChainID, int endSequenceNumber, char endInsertionCode) {
        if (modelIndex >= 0 || this.isTrajectory) {
            if (this.isTrajectory) {
                modelIndex = 0;
            }
            this.structuresDefinedInFile.set(modelIndex += this.baseModelIndex);
            super.defineStructure(modelIndex, structureType, startChainID, startSequenceNumber, startInsertionCode, endChainID, endSequenceNumber, endInsertionCode);
            return;
        }
        for (int i = this.baseModelIndex; i < this.modelCount; ++i) {
            this.structuresDefinedInFile.set(i);
            super.defineStructure(i, structureType, startChainID, startSequenceNumber, startInsertionCode, endChainID, endSequenceNumber, endInsertionCode);
        }
    }

    private void initializeUnitCellAndSymmetry() {
        if (this.someModelsHaveUnitcells) {
            this.unitCells = new SymmetryInterface[this.modelCount];
            boolean haveMergeCells = this.mergeModelSet != null && this.mergeModelSet.unitCells != null;
            for (int i = 0; i < this.modelCount; ++i) {
                if (haveMergeCells && i < this.baseModelCount) {
                    this.unitCells[i] = this.mergeModelSet.unitCells[i];
                    continue;
                }
                this.unitCells[i] = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
                this.unitCells[i].setSymmetryInfo(i, this.getModelAuxiliaryInfo(i));
            }
        }
        if (this.someModelsHaveSymmetry) {
            this.getAtomBits(0xF0000C, null);
            short iModel = -1;
            int i0 = 0;
            for (int iAtom = this.baseAtomIndex; iAtom < this.atomCount; ++iAtom) {
                if (this.atoms[iAtom].modelIndex != iModel) {
                    iModel = this.atoms[iAtom].modelIndex;
                    i0 = this.baseAtomIndex + this.getModelAuxiliaryInfoInt(iModel, "presymmetryAtomIndex") + this.getModelAuxiliaryInfoInt(iModel, "presymmetryAtomCount");
                }
                if (iAtom < i0) continue;
                this.bsSymmetry.set(iAtom);
            }
        }
        if (this.someModelsHaveFractionalCoordinates) {
            for (int i = this.baseAtomIndex; i < this.atomCount; ++i) {
                short modelIndex = this.atoms[i].modelIndex;
                if (!this.unitCells[modelIndex].getCoordinatesAreFractional()) continue;
                this.unitCells[modelIndex].toCartesian(this.atoms[i]);
                if (!Logger.debugging) continue;
                Logger.debug("atom " + i + ": " + this.atoms[i]);
            }
        }
    }

    private void initializeBonding() {
        BitSet bsExclude;
        BitSet bitSet = bsExclude = this.getModelSetAuxiliaryInfo("someModelsHaveCONECT") == null ? null : new BitSet();
        if (bsExclude != null) {
            this.setPdbConectBonding(this.baseAtomIndex, this.baseModelIndex, bsExclude);
        }
        int atomIndex = this.baseAtomIndex;
        int modelAtomCount = 0;
        boolean symmetryAlreadyAppliedToBonds = this.viewer.getApplySymmetryToBonds();
        boolean doAutoBond = this.viewer.getAutoBond();
        boolean forceAutoBond = this.viewer.getForceAutoBond();
        BitSet bs = null;
        boolean autoBonding = false;
        for (int i = this.baseModelIndex; i < this.modelCount; ++i) {
            modelAtomCount = this.getModelAuxiliaryInfoInt(i, "initialAtomCount");
            if (modelAtomCount < 0) {
                modelAtomCount = this.atomCount;
            }
            if (!this.getModelAuxiliaryInfoBoolean(i, "noautobond")) {
                boolean doBond;
                int modelBondCount = this.getModelAuxiliaryInfoInt(i, "initialBondCount");
                if (modelBondCount < 0) {
                    modelBondCount = this.bondCount;
                }
                boolean modelIsPDB = this.models[i].isPDB;
                boolean modelHasSymmetry = this.getModelAuxiliaryInfoBoolean(i, "hasSymmetry");
                boolean bl = doBond = forceAutoBond || doAutoBond && (modelBondCount == 0 || modelIsPDB && this.jmolData == null && modelBondCount < modelAtomCount / 2 || modelHasSymmetry && !symmetryAlreadyAppliedToBonds);
                if (doBond) {
                    autoBonding = true;
                    if (this.merging || this.modelCount > 1) {
                        if (bs == null) {
                            bs = new BitSet(this.atomCount);
                        }
                        int j = atomIndex + modelAtomCount;
                        while (--j >= atomIndex) {
                            bs.set(j);
                        }
                    }
                }
            }
            atomIndex += modelAtomCount;
        }
        if (autoBonding) {
            this.autoBond(bs, bs, bsExclude, null);
            Logger.info("ModelSet: autobonding; use  autobond=false  to not generate bonds automatically");
        } else {
            Logger.info("ModelSet: not autobonding; use  forceAutobond=true  to force automatic bond creation");
        }
    }

    private void finalizeGroupBuild() {
        Hashtable info;
        int i;
        this.groups = new Group[this.groupCount];
        if (this.merging) {
            for (i = 0; i < this.baseGroupIndex; ++i) {
                this.groups[i] = this.mergeModelSet.groups[i];
                this.groups[i].setModelSet(this);
            }
        }
        for (i = this.baseGroupIndex; i < this.groupCount; ++i) {
            this.distinguishAndPropagateGroup(i, this.chainOf[i], this.group3Of[i], this.seqcodes[i], this.firstAtomIndexes[i], i == this.groupCount - 1 ? this.atomCount : this.firstAtomIndexes[i + 1]);
            this.chainOf[i] = null;
            this.group3Of[i] = null;
        }
        this.chainOf = null;
        this.group3Of = null;
        if (this.group3Lists != null && (info = this.getModelSetAuxiliaryInfo()) != null) {
            info.put("group3Lists", this.group3Lists);
            info.put("group3Counts", this.group3Counts);
        }
        this.group3Counts = null;
        this.group3Lists = null;
    }

    private void distinguishAndPropagateGroup(int groupIndex, Chain chain, String group3, int seqcode, int firstAtomIndex, int maxAtomIndex) {
        String key;
        int lastAtomIndex = maxAtomIndex - 1;
        if (lastAtomIndex < firstAtomIndex) {
            throw new NullPointerException();
        }
        short modelIndex = this.atoms[firstAtomIndex].modelIndex;
        Group group = null;
        if (group3 != null && this.specialAtomIDs != null && this.haveBioClasses) {
            if (this.jbr == null && this.haveBioClasses) {
                try {
                    Class<?> shapeClass = Class.forName("org.jmol.modelsetbio.Resolver");
                    this.jbr = (JmolBioResolver)shapeClass.newInstance();
                    this.haveBioClasses = true;
                }
                catch (Exception e) {
                    Logger.error("developer error: org.jmol.modelsetbio.Resolver could not be found");
                    this.haveBioClasses = false;
                }
            }
            if (this.haveBioClasses) {
                group = this.jbr.distinguishAndPropagateGroup(chain, group3, seqcode, firstAtomIndex, maxAtomIndex, modelIndex, this.specialAtomIndexes, this.specialAtomIDs, this.atoms);
            }
        }
        if (group == null) {
            group = new Group(chain, group3, seqcode, firstAtomIndex, lastAtomIndex);
            key = "o>";
        } else {
            String string = group.isProtein() ? "p>" : (group.isNucleic() ? "n>" : (key = group.isCarbohydrate() ? "c>" : "o>"));
        }
        if (group3 != null) {
            this.countGroup(modelIndex, key, group3);
        }
        this.addGroup(chain, group);
        this.groups[groupIndex] = group;
        group.setGroupIndex(groupIndex);
        int i = maxAtomIndex;
        while (--i >= firstAtomIndex) {
            this.atoms[i].setGroup(group);
        }
    }

    private void addGroup(Chain chain, Group group) {
        if (chain.groupCount == chain.groups.length) {
            chain.groups = (Group[])ArrayUtil.doubleLength(chain.groups);
        }
        chain.groups[chain.groupCount++] = group;
    }

    private void countGroup(int modelIndex, String code, String group3) {
        int ptm = modelIndex + 1;
        if (this.group3Lists == null || this.group3Lists[ptm] == null) {
            return;
        }
        String g3code = (group3 + "   ").substring(0, 3);
        int pt = this.group3Lists[ptm].indexOf(g3code);
        if (pt < 0) {
            int n = ptm;
            this.group3Lists[n] = this.group3Lists[n] + ",[" + g3code + "]";
            pt = this.group3Lists[ptm].indexOf(g3code);
            this.group3Counts[ptm] = ArrayUtil.setLength(this.group3Counts[ptm], this.group3Counts[ptm].length + 10);
        }
        int[] nArray = this.group3Counts[ptm];
        int n = pt / 6;
        nArray[n] = nArray[n] + 1;
        pt = this.group3Lists[ptm].indexOf(",[" + g3code);
        if (pt >= 0) {
            this.group3Lists[ptm] = this.group3Lists[ptm].substring(0, pt) + code + this.group3Lists[ptm].substring(pt + 2);
        }
        if (modelIndex >= 0) {
            this.countGroup(-1, code, group3);
        }
    }

    private void freeze() {
        this.htAtomMap.clear();
        if (this.atomCount < this.atoms.length) {
            this.growAtomArrays(0);
        }
        if (this.bondCount < this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount);
        }
        int i = 5;
        while (--i > 0) {
            this.numCached[i] = 0;
            Bond[][] bondsCache = this.freeBonds[i];
            int j = bondsCache.length;
            while (--j >= 0) {
                bondsCache[j] = null;
            }
        }
        this.setAtomNamesAndNumbers();
        this.findElementsPresent();
        if (this.isPDB) {
            this.calculateStructuresAllExcept(this.structuresDefinedInFile, true);
        }
        this.molecules = null;
        this.moleculeCount = 0;
        this.currentModel = null;
        this.currentChain = null;
        this.setStructureIds();
    }

    private void setAtomNamesAndNumbers() {
        Atom atom;
        int i;
        if (this.atomSerials == null) {
            this.atomSerials = new int[this.atomCount];
        }
        boolean isZeroBased = this.isXYZ && this.viewer.getZeroBasedXyzRasmol();
        int n = Integer.MAX_VALUE;
        int atomNo = 1;
        for (i = 0; i < this.atomCount; ++i) {
            short s;
            atom = this.atoms[i];
            if (atom.modelIndex != s) {
                s = atom.modelIndex;
                int n2 = atomNo = isZeroBased ? 0 : 1;
            }
            if (this.atomSerials[i] != 0) continue;
            this.atomSerials[i] = i < this.baseAtomIndex ? this.mergeModelSet.atomSerials[i] : atomNo++;
        }
        if (this.atomNames == null) {
            this.atomNames = new String[this.atomCount];
        }
        for (i = 0; i < this.atomCount; ++i) {
            if (this.atomNames[i] != null) continue;
            atom = this.atoms[i];
            this.atomNames[i] = atom.getElementSymbol() + atom.getAtomNumber();
        }
    }

    private void findElementsPresent() {
        int i;
        this.elementsPresent = new BitSet[this.modelCount];
        for (i = 0; i < this.modelCount; ++i) {
            this.elementsPresent[i] = new BitSet();
        }
        i = this.atomCount;
        while (--i >= 0) {
            int n = this.atoms[i].getAtomicAndIsotopeNumber();
            if (n >= JmolConstants.elementNumberMax) {
                n = JmolConstants.elementNumberMax + JmolConstants.altElementIndexFromNumber(n);
            }
            this.elementsPresent[this.atoms[i].modelIndex].set(n);
        }
    }

    private void finalizeShapes() {
        if (this.someModelsHaveAromaticBonds && this.viewer.getSmartAromatic()) {
            this.assignAromaticBonds(false);
        }
        if (this.shapes == null) {
            return;
        }
        if (this.merging) {
            for (int i = 0; i < 32; ++i) {
                this.shapes[i] = this.mergeModelSet.shapes[i];
                if (this.shapes[i] == null) continue;
                this.shapes[i].setModelSet(this);
            }
            this.viewer.clearShapes();
            this.merging = false;
            return;
        }
        this.loadShape(0);
        this.loadShape(1);
        this.loadShape(5);
        this.loadShape(28);
        this.loadShape(29);
    }

    public void createAtomDataSet(int tokType, Object atomSetCollection, BitSet bsSelected) {
        if (atomSetCollection == null) {
            return;
        }
        JmolAdapter adapter = this.viewer.getModelAdapter();
        Point3f pt = new Point3f();
        Point3f v = new Point3f();
        float tolerance = ((Float)this.viewer.getParameter("loadAtomDataTolerance")).floatValue();
        int i = -1;
        int n = 0;
        int imax = tokType == 72352010 ? BitSetUtil.length(bsSelected) : 0;
        JmolAdapter.AtomIterator iterAtom = adapter.getAtomIterator(atomSetCollection);
        while (iterAtom.hasNext()) {
            float z;
            float y;
            float x = iterAtom.getX();
            if (Float.isNaN(x + (y = iterAtom.getY()) + (z = iterAtom.getZ()))) continue;
            if (tokType == 72352010) {
                while (++i < imax && !bsSelected.get(i)) {
                }
                if (i == imax) break;
                ++n;
                if (Logger.debugging) {
                    Logger.debug("atomIndex = " + i + ": " + this.atoms[i] + " --> (" + x + "," + y + "," + z);
                }
                this.setAtomCoord(i, x, y, z);
                continue;
            }
            pt.set(x, y, z);
            BitSet bs = new BitSet();
            this.getAtomsWithin(-tolerance, pt, bs, -1);
            this.getAtomsWithin(tolerance, pt, bs, -1);
            bs.and(bsSelected);
            if (BitSetUtil.cardinalityOf(bsSelected) == this.viewer.getAtomCount()) {
                n = BitSetUtil.cardinalityOf(bs);
                if (n == 0) {
                    Logger.warn("createAtomDataSet: no atom found at position " + pt);
                    continue;
                }
                if (n > 1 && Logger.debugging) {
                    Logger.debug("createAtomDataSet: " + n + " atoms found at position " + pt);
                }
            }
            switch (tokType) {
                case 72352013: {
                    float vx = iterAtom.getVectorX();
                    float vy = iterAtom.getVectorY();
                    float vz = iterAtom.getVectorZ();
                    if (Float.isNaN(vx + vy + vz)) break;
                    v.set(vx, vy, vz);
                    if (Logger.debugging) {
                        Logger.info("xyz: " + pt + " vib: " + v);
                    }
                    this.setAtomCoord(bs, 72352013, v);
                    break;
                }
                case 55574786: {
                    this.setAtomProperty(bs, tokType, iterAtom.getOccupancy(), 0.0f, null, null, null);
                    break;
                }
                case 38797578: {
                    this.setAtomProperty(bs, tokType, 0, iterAtom.getPartialCharge(), null, null, null);
                    break;
                }
                case 38797585: {
                    this.setAtomProperty(bs, tokType, 0, iterAtom.getBfactor(), null, null, null);
                }
            }
        }
        switch (tokType) {
            case 72352013: {
                String vibName = adapter.getAtomSetName(atomSetCollection, 0);
                Logger.info("_vibrationName = " + vibName);
                this.viewer.setStringProperty("_vibrationName", vibName);
                break;
            }
            case 72352010: {
                Logger.info(n + " atom positions read");
                this.recalculateLeadMidpointsAndWingVectors(-1);
            }
        }
    }

    static {
        int i = JmolConstants.specialAtomNames.length;
        while (--i >= 0) {
            String specialAtomName = JmolConstants.specialAtomNames[i];
            if (specialAtomName == null) continue;
            Integer boxedI = new Integer(i);
            htAtom.put(specialAtomName, boxedI);
        }
    }
}

