/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javax.vecmath.Point3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.Helix;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Sheet;
import org.jmol.modelsetbio.Turn;

public class AlphaMonomer
extends Monomer {
    static final byte[] alphaOffsets = new byte[]{0};
    private ProteinStructure proteinStructure;
    protected Point3f nitrogenHydrogenPoint;

    static Monomer validateAndAllocate(Chain chain, String group3, int seqcode, int firstIndex, int lastIndex, int[] specialAtomIndexes, Atom[] atoms) {
        if (firstIndex != lastIndex || specialAtomIndexes[2] != firstIndex) {
            return null;
        }
        return new AlphaMonomer(chain, group3, seqcode, firstIndex, lastIndex, alphaOffsets);
    }

    AlphaMonomer(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, byte[] offsets) {
        super(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, offsets);
    }

    boolean isAlphaMonomer() {
        return true;
    }

    public ProteinStructure getProteinStructure() {
        return this.proteinStructure;
    }

    public Object getStructure() {
        return this.getProteinStructure();
    }

    void setStructure(ProteinStructure proteinStructure) {
        this.proteinStructure = proteinStructure;
        if (proteinStructure == null) {
            this.nitrogenHydrogenPoint = null;
        }
    }

    public void setProteinStructureId(int id) {
        if (this.proteinStructure != null) {
            this.proteinStructure.uniqueID = id;
        }
    }

    public byte getProteinStructureType() {
        return this.proteinStructure == null ? (byte)0 : this.proteinStructure.type;
    }

    public int getProteinStructureID() {
        return this.proteinStructure != null ? this.proteinStructure.uniqueID : 0;
    }

    public boolean isHelix() {
        return this.proteinStructure != null && this.proteinStructure.type == 3;
    }

    public boolean isSheet() {
        return this.proteinStructure != null && this.proteinStructure.type == 2;
    }

    public int setProteinStructureType(byte iType, int monomerIndexCurrent) {
        if (monomerIndexCurrent < 0 || monomerIndexCurrent > 0 && this.monomerIndex == 0) {
            int nAbandoned;
            if (this.proteinStructure != null && (nAbandoned = this.proteinStructure.removeMonomer(this.monomerIndex)) > 0) {
                this.getBioPolymer().removeProteinStructure(this.monomerIndex + 1, nAbandoned);
            }
            switch (iType) {
                case 3: {
                    this.setStructure(new Helix((AlphaPolymer)this.bioPolymer, this.monomerIndex, 1, 0));
                    break;
                }
                case 2: {
                    this.setStructure(new Sheet((AlphaPolymer)this.bioPolymer, this.monomerIndex, 1, 0));
                    break;
                }
                case 1: {
                    this.setStructure(new Turn((AlphaPolymer)this.bioPolymer, this.monomerIndex, 1, 0));
                    break;
                }
                case 0: {
                    this.setStructure(null);
                }
            }
        } else {
            this.setStructure(this.getBioPolymer().getProteinStructure(monomerIndexCurrent));
            if (this.proteinStructure != null) {
                this.proteinStructure.addMonomer(this.monomerIndex);
            }
        }
        return this.monomerIndex;
    }

    public final Atom getAtom(byte specialAtomID) {
        return specialAtomID == 2 ? this.getLeadAtom() : null;
    }

    public final Point3f getAtomPoint(byte specialAtomID) {
        return specialAtomID == 2 ? this.getLeadAtomPoint() : null;
    }

    boolean isConnectedAfter(Monomer possiblyPreviousMonomer) {
        Atom atom2;
        if (possiblyPreviousMonomer == null) {
            return true;
        }
        if (!(possiblyPreviousMonomer instanceof AlphaMonomer)) {
            return false;
        }
        Atom atom1 = this.getLeadAtom();
        return atom1.isBonded(atom2 = possiblyPreviousMonomer.getLeadAtom()) || atom1.distance(atom2) <= 4.2f;
    }
}

