/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Quaternion;

public class AminoMonomer
extends AlphaMonomer {
    private static final byte CA = 0;
    private static final byte O = 1;
    private static final byte N = 2;
    private static final byte C = 3;
    private static final byte OT = 4;
    static final byte[] interestingAminoAtomIDs = new byte[]{2, -5, 1, 3, -65, -6};
    boolean nhChecked = false;
    private final Point3f ptTemp = new Point3f();
    private static final float beta = 0.29670596f;

    static Monomer validateAndAllocate(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, int[] specialAtomIndexes, Atom[] atoms) {
        byte[] offsets = AminoMonomer.scanForOffsets(firstAtomIndex, specialAtomIndexes, interestingAminoAtomIDs);
        if (offsets == null) {
            return null;
        }
        AminoMonomer.checkOptional(offsets, (byte)1, firstAtomIndex, specialAtomIndexes[5]);
        if (atoms[firstAtomIndex].isHetero() && !AminoMonomer.isBondedCorrectly(firstAtomIndex, offsets, atoms)) {
            return null;
        }
        AminoMonomer aminoMonomer = new AminoMonomer(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, offsets);
        return aminoMonomer;
    }

    private static boolean isBondedCorrectly(int offset1, int offset2, int firstAtomIndex, byte[] offsets, Atom[] atoms) {
        int atomIndex1 = firstAtomIndex + (offsets[offset1] & 0xFF);
        int atomIndex2 = firstAtomIndex + (offsets[offset2] & 0xFF);
        if (atomIndex1 >= atomIndex2) {
            return false;
        }
        return atoms[atomIndex1].isBonded(atoms[atomIndex2]);
    }

    private static boolean isBondedCorrectly(int firstAtomIndex, byte[] offsets, Atom[] atoms) {
        return AminoMonomer.isBondedCorrectly(2, 0, firstAtomIndex, offsets, atoms) && AminoMonomer.isBondedCorrectly(0, 3, firstAtomIndex, offsets, atoms) && (offsets[1] == -1 || AminoMonomer.isBondedCorrectly(3, 1, firstAtomIndex, offsets, atoms));
    }

    private AminoMonomer(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, byte[] offsets) {
        super(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, offsets);
    }

    boolean isAminoMonomer() {
        return true;
    }

    Atom getNitrogenAtom() {
        return this.getAtomFromOffsetIndex(2);
    }

    Point3f getNitrogenAtomPoint() {
        return this.getAtomFromOffsetIndex(2);
    }

    Atom getCarbonylCarbonAtom() {
        return this.getAtomFromOffsetIndex(3);
    }

    Point3f getCarbonylCarbonAtomPoint() {
        return this.getAtomFromOffsetIndex(3);
    }

    Atom getCarbonylOxygenAtom() {
        return this.getWingAtom();
    }

    Point3f getCarbonylOxygenAtomPoint() {
        return this.getWingAtomPoint();
    }

    Atom getInitiatorAtom() {
        return this.getNitrogenAtom();
    }

    Atom getTerminatorAtom() {
        return this.getAtomFromOffsetIndex(this.offsets[4] != -1 ? 4 : 3);
    }

    boolean hasOAtom() {
        return this.offsets[1] != -1;
    }

    boolean isConnectedAfter(Monomer possiblyPreviousMonomer) {
        if (possiblyPreviousMonomer == null) {
            return true;
        }
        if (!(possiblyPreviousMonomer instanceof AminoMonomer)) {
            return false;
        }
        AminoMonomer other = (AminoMonomer)possiblyPreviousMonomer;
        return other.getCarbonylCarbonAtom().isBonded(this.getNitrogenAtom());
    }

    void findNearestAtomIndex(int x, int y, Atom[] closest, short madBegin, short madEnd) {
        Atom alpha;
        int radiusEnd;
        Atom competitor = closest[0];
        Atom nitrogen = this.getNitrogenAtom();
        int marBegin = madBegin / 2;
        if (marBegin < 1200) {
            marBegin = 1200;
        }
        if (nitrogen.screenZ == 0) {
            return;
        }
        int radiusBegin = this.scaleToScreen(nitrogen.screenZ, marBegin);
        if (radiusBegin < 4) {
            radiusBegin = 4;
        }
        Atom ccarbon = this.getCarbonylCarbonAtom();
        int marEnd = madEnd / 2;
        if (marEnd < 1200) {
            marEnd = 1200;
        }
        if ((radiusEnd = this.scaleToScreen(nitrogen.screenZ, marEnd)) < 4) {
            radiusEnd = 4;
        }
        if (this.isCursorOnTopOf(alpha = this.getLeadAtom(), x, y, (radiusBegin + radiusEnd) / 2, competitor) || this.isCursorOnTopOf(nitrogen, x, y, radiusBegin, competitor) || this.isCursorOnTopOf(ccarbon, x, y, radiusEnd, competitor)) {
            closest[0] = alpha;
        }
    }

    public void resetHydrogenPoint() {
        this.nhChecked = false;
        this.nitrogenHydrogenPoint = null;
    }

    Point3f getNitrogenHydrogenPoint() {
        if (this.nitrogenHydrogenPoint == null && !this.nhChecked) {
            this.nhChecked = true;
            Atom nitrogen = this.getNitrogenAtom();
            Atom h = null;
            Bond[] bonds = nitrogen.getBonds();
            for (int i = 0; i < bonds.length; ++i) {
                h = bonds[i].getOtherAtom(nitrogen);
                if (h.getElementNumber() != 1) continue;
                this.nitrogenHydrogenPoint = h;
                return this.nitrogenHydrogenPoint;
            }
        }
        return this.nitrogenHydrogenPoint;
    }

    public boolean getNHPoint(Point3f aminoHydrogenPoint, Vector3f vNH) {
        if (this.monomerIndex == 0 || this.getGroupID() == 15) {
            return false;
        }
        Point3f nitrogenPoint = this.getNitrogenAtomPoint();
        Point3f nhPoint = this.getNitrogenHydrogenPoint();
        if (nhPoint != null) {
            vNH.sub(nhPoint, nitrogenPoint);
            aminoHydrogenPoint.set(nhPoint);
            return true;
        }
        vNH.sub(nitrogenPoint, this.getLeadAtomPoint());
        vNH.add(nitrogenPoint);
        vNH.sub(((AminoMonomer)this.bioPolymer.monomers[this.monomerIndex - 1]).getCarbonylCarbonAtomPoint());
        vNH.normalize();
        aminoHydrogenPoint.add(nitrogenPoint, vNH);
        this.nitrogenHydrogenPoint = new Point3f(aminoHydrogenPoint);
        if (Logger.debugging) {
            Logger.info("draw pta" + this.monomerIndex + " {" + aminoHydrogenPoint.x + " " + aminoHydrogenPoint.y + " " + aminoHydrogenPoint.z + "} color red#aminoPolymer.calchbonds");
        }
        return true;
    }

    Point3f getQuaternionFrameCenter(char qType) {
        switch (qType) {
            default: {
                return this.getLeadAtomPoint();
            }
            case 'p': {
                return this.getCarbonylCarbonAtomPoint();
            }
            case 'n': 
        }
        return this.getNitrogenAtomPoint();
    }

    public Object getHelixData(int tokType, char qType) {
        Quaternion q2;
        int iNext = this.monomerIndex + 1;
        AminoMonomer next = (AminoMonomer)(iNext >= this.bioPolymer.monomers.length ? null : this.bioPolymer.monomers[iNext]);
        Quaternion q1 = this.getQuaternion(qType);
        Quaternion quaternion = q2 = next == null ? null : next.getQuaternion(qType);
        if (q1 == null || q2 == null) {
            return super.getHelixData(tokType, qType);
        }
        Quaternion dq = q2.div(q1);
        float theta = dq.getTheta();
        if (tokType == 0x8100801) {
            return new Float(theta);
        }
        Vector3f n = dq.getNormal();
        Point3f a = this.getQuaternionFrameCenter(qType);
        Point3f b = next.getQuaternionFrameCenter(qType);
        Vector3f vab = new Vector3f();
        vab.sub(b, a);
        float v_dot_n = vab.dot(n);
        if (tokType == 0x40000003) {
            n.scale(v_dot_n);
            return n;
        }
        Vector3f vcb = new Vector3f(n);
        vcb.scale(v_dot_n);
        Vector3f va_prime_d = new Vector3f();
        va_prime_d.cross(vab, n);
        va_prime_d.scale(1.0f / vab.length());
        Vector3f vda = new Vector3f();
        vda.sub(vcb, vab);
        vda.scale(0.5f);
        va_prime_d.scale((float)((double)vda.length() / Math.tan((double)(theta / 2.0f / 180.0f) * Math.PI)));
        Vector3f r = new Vector3f(va_prime_d);
        r.add(vda);
        if (tokType == 592445697) {
            return r;
        }
        Point3f pt_a_prime = new Point3f(a);
        pt_a_prime.sub(r);
        if (tokType == 135268356) {
            return pt_a_prime;
        }
        n.scale(v_dot_n);
        if (tokType == 4112) {
            String id = this.getUniqueID();
            return "draw ID helixaxis" + id + " VECTOR " + Escape.escape(pt_a_prime) + " " + Escape.escape(n);
        }
        return new String[]{Escape.escape(pt_a_prime), Escape.escape(n), Escape.escape(r)};
    }

    public Quaternion getQuaternion(char qType) {
        Point3f ptC = this.getCarbonylCarbonAtomPoint();
        Point3f ptCa = this.getLeadAtomPoint();
        Vector3f vA = new Vector3f();
        Vector3f vB = new Vector3f();
        Vector3f vC = null;
        switch (qType) {
            default: {
                vA.sub(ptC, ptCa);
                vB.sub(this.getNitrogenAtomPoint(), ptCa);
                break;
            }
            case 'p': {
                vA.sub(ptCa, ptC);
                if (this.monomerIndex == this.bioPolymer.monomerCount - 1) {
                    return null;
                }
                vB.sub(((AminoMonomer)this.bioPolymer.getMonomers()[this.monomerIndex + 1]).getNitrogenAtomPoint(), ptC);
                break;
            }
            case 'n': {
                if (this.monomerIndex == 0 || this.getGroupID() == 15) {
                    return null;
                }
                vC = new Vector3f();
                this.getNHPoint(this.ptTemp, vC);
                vB.sub(ptCa, this.getNitrogenAtomPoint());
                vB.cross(vC, vB);
                Matrix3f mat = new Matrix3f();
                mat.set(new AxisAngle4f(vB, -0.29670596f));
                mat.transform(vC);
                vA.cross(vB, vC);
            }
        }
        return Quaternion.getQuaternionFrame(vA, vB, vC);
    }
}

