/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.Logger;

public abstract class Monomer
extends Group {
    BioPolymer bioPolymer;
    protected final byte[] offsets;
    protected int monomerIndex;

    protected Monomer(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, byte[] interestingAtomOffsets) {
        super(chain, group3, seqcode, firstAtomIndex, lastAtomIndex);
        this.offsets = interestingAtomOffsets;
    }

    void setBioPolymer(BioPolymer polymer, int index) {
        this.bioPolymer = polymer;
        this.monomerIndex = index;
    }

    public int getSelectedMonomerCount() {
        return this.bioPolymer.getSelectedMonomerCount();
    }

    public int getSelectedMonomerIndex() {
        return this.monomerIndex >= 0 && this.bioPolymer.isMonomerSelected(this.monomerIndex) ? this.monomerIndex : -1;
    }

    public BioPolymer getBioPolymer() {
        return this.bioPolymer;
    }

    public int getBioPolymerLength() {
        return this.bioPolymer == null ? 0 : this.bioPolymer.monomerCount;
    }

    public int getBioPolymerIndex() {
        return this.monomerIndex;
    }

    protected static byte[] scanForOffsets(int firstAtomIndex, int[] specialAtomIndexes, byte[] interestingAtomIDs) {
        int interestingCount = interestingAtomIDs.length;
        byte[] offsets = new byte[interestingCount];
        int i = interestingCount;
        while (--i >= 0) {
            int offset;
            int atomIndex;
            byte atomID = interestingAtomIDs[i];
            if (atomID < 0) {
                atomIndex = specialAtomIndexes[~atomID];
            } else {
                atomIndex = specialAtomIndexes[atomID];
                if (atomIndex < 0) {
                    return null;
                }
            }
            if (atomIndex < 0) {
                offset = 255;
            } else {
                offset = atomIndex - firstAtomIndex;
                if (offset < 0 || offset > 254) {
                    Logger.warn("Monomer.scanForOffsets i=" + i + " atomID=" + atomID + " atomIndex:" + atomIndex + " firstAtomIndex:" + firstAtomIndex + " offset out of 0-254 range. Groups aren't organized correctly. Is this really a protein?: " + offset);
                    if (atomID < 0) {
                        offset = 255;
                    }
                }
            }
            offsets[i] = (byte)offset;
        }
        return offsets;
    }

    public boolean isDna() {
        return false;
    }

    public boolean isRna() {
        return false;
    }

    public final boolean isProtein() {
        return this.isAmino || this instanceof AlphaMonomer;
    }

    public final boolean isNucleic() {
        return this instanceof PhosphorusMonomer;
    }

    void setStructure(ProteinStructure proteinstructure) {
    }

    public ProteinStructure getProteinStructure() {
        return null;
    }

    public byte getProteinStructureType() {
        return 0;
    }

    public boolean isHelix() {
        return false;
    }

    public boolean isSheet() {
        return false;
    }

    public void setProteinStructureId(int id) {
    }

    protected final Atom getAtomFromOffsetIndex(int offsetIndex) {
        if (offsetIndex > this.offsets.length) {
            return null;
        }
        int offset = this.offsets[offsetIndex] & 0xFF;
        if (offset == 255) {
            return null;
        }
        return this.chain.getAtom(this.firstAtomIndex + offset);
    }

    protected final Atom getSpecialAtom(byte[] interestingIDs, byte specialAtomID) {
        int i = interestingIDs.length;
        while (--i >= 0) {
            byte interestingID = interestingIDs[i];
            if (interestingID < 0) {
                interestingID = -interestingID;
            }
            if (specialAtomID != interestingID) continue;
            int offset = this.offsets[i] & 0xFF;
            if (offset == 255) {
                return null;
            }
            return this.chain.getAtom(this.firstAtomIndex + offset);
        }
        return null;
    }

    protected final Point3f getSpecialAtomPoint(byte[] interestingIDs, byte specialAtomID) {
        int i = interestingIDs.length;
        while (--i >= 0) {
            byte interestingID = interestingIDs[i];
            if (interestingID < 0) {
                interestingID = -interestingID;
            }
            if (specialAtomID != interestingID) continue;
            int offset = this.offsets[i] & 0xFF;
            if (offset == 255) {
                return null;
            }
            return this.chain.getAtom(this.firstAtomIndex + offset);
        }
        return null;
    }

    final int getLeadAtomIndex() {
        return this.firstAtomIndex + (this.offsets[0] & 0xFF);
    }

    public final Atom getLeadAtom() {
        return this.getAtomFromOffsetIndex(0);
    }

    final Point3f getLeadAtomPoint() {
        return this.getAtomFromOffsetIndex(0);
    }

    public final Atom getWingAtom() {
        return this.getAtomFromOffsetIndex(1);
    }

    public final Point3f getWingAtomPoint() {
        return this.getAtomFromOffsetIndex(1);
    }

    final Point3f getPointAtomPoint() {
        return this.getAtomFromOffsetIndex(3);
    }

    Atom getInitiatorAtom() {
        return this.getLeadAtom();
    }

    Atom getTerminatorAtom() {
        return this.getLeadAtom();
    }

    abstract boolean isConnectedAfter(Monomer var1);

    void findNearestAtomIndex(int x, int y, Atom[] closest, short madBegin, short madEnd) {
    }

    public Hashtable getMyInfo() {
        ProteinStructure structure;
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        char chainID = this.chain.getChainID();
        info.put("chain", chainID == '\u0000' ? "" : "" + chainID);
        int seqNum = this.getSeqNumber();
        char insCode = this.getInsertionCode();
        if (seqNum > 0) {
            info.put("sequenceNumber", new Integer(seqNum));
        }
        if (insCode != '\u0000') {
            info.put("insertionCode", "" + insCode);
        }
        info.put("atomInfo1", this.chain.getAtom(this.firstAtomIndex).getInfo());
        info.put("atomInfo2", this.chain.getAtom(this.lastAtomIndex).getInfo());
        info.put("_apt1", new Integer(this.firstAtomIndex));
        info.put("_apt2", new Integer(this.lastAtomIndex));
        info.put("atomIndex1", new Integer(this.firstAtomIndex));
        info.put("atomIndex2", new Integer(this.lastAtomIndex));
        if (!Float.isNaN(this.phi)) {
            info.put("phi", new Float(this.phi));
        }
        if (!Float.isNaN(this.psi)) {
            info.put("psi", new Float(this.psi));
        }
        if ((structure = this.getProteinStructure()) != null) {
            info.put("structureId", new Integer(structure.uniqueID));
            info.put("structureType", Monomer.getStructureTypeName(structure.type));
        }
        info.put("shapeVisibilityFlags", new Integer(this.shapeVisibilityFlags));
        return info;
    }

    static String getStructureTypeName(byte type) {
        switch (type) {
            case 3: {
                return "helix";
            }
            case 2: {
                return "sheet";
            }
            case 1: {
                return "turn";
            }
            case 4: {
                return "DNA";
            }
            case 5: {
                return "RNA";
            }
        }
        return type + "?";
    }

    final void updateOffsetsForAlternativeLocations(BitSet bsSelected, int nAltLocInModel) {
        this.chain.updateOffsetsForAlternativeLocations(bsSelected, nAltLocInModel, this.offsets, this.firstAtomIndex, this.lastAtomIndex);
    }

    final void getMonomerSequenceAtoms(BitSet bsInclude, BitSet bsResult) {
        for (int j = this.firstAtomIndex; j <= this.lastAtomIndex; ++j) {
            if (!bsInclude.get(j)) continue;
            bsResult.set(j);
        }
    }

    protected static final boolean checkOptional(byte[] offsets, byte atom, int firstAtomIndex, int index) {
        if (offsets[atom] >= 0) {
            return true;
        }
        if (index < 0) {
            return false;
        }
        offsets[atom] = (byte)(index - firstAtomIndex);
        return true;
    }

    Point3f getQuaternionFrameCenter(char qtype) {
        return null;
    }

    public void resetHydrogenPoint() {
    }

    public String getUniqueID() {
        char cid = this.getChainID();
        Atom a = this.getLeadAtom();
        String id = (a == null ? "" : "_" + a.getModelIndex()) + "_" + this.getResno() + (cid == '\u0000' ? "" : "" + cid);
        char c = cid = a == null ? (char)'\u0000' : this.getLeadAtom().getAlternateLocationID();
        if (cid != '\u0000') {
            id = id + cid;
        }
        return id;
    }
}

