/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.BitSet;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Polymer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;

public class NucleicPolymer
extends BioPolymer {
    private static final short HBOND_MASK = 18432;

    NucleicPolymer(Monomer[] monomers) {
        super(monomers);
        this.type = 2;
    }

    Atom getNucleicPhosphorusAtom(int monomerIndex) {
        return this.monomers[monomerIndex].getLeadAtom();
    }

    boolean hasWingPoints() {
        return true;
    }

    public void calcHydrogenBonds(Polymer polymer, BitSet bsA, BitSet bsB) {
        this.lookForHbonds((NucleicPolymer)polymer, bsA, bsB);
    }

    void lookForHbonds(NucleicPolymer other, BitSet bsA, BitSet bsB) {
        int i = this.monomerCount;
        while (--i >= 0) {
            NucleicMonomer myNucleotide = (NucleicMonomer)this.monomers[i];
            if (!myNucleotide.isPurine()) continue;
            Atom myN1 = myNucleotide.getN1();
            Atom bestN3 = null;
            float minDist2 = 25.0f;
            NucleicMonomer bestNucleotide = null;
            int j = other.monomerCount;
            while (--j >= 0) {
                Atom otherN3;
                float dist2;
                NucleicMonomer otherNucleotide = (NucleicMonomer)other.monomers[j];
                if (!otherNucleotide.isPyrimidine() || !((dist2 = myN1.distanceSquared(otherN3 = otherNucleotide.getN3())) < minDist2)) continue;
                bestNucleotide = otherNucleotide;
                bestN3 = otherN3;
                minDist2 = dist2;
            }
            if (bestN3 == null) continue;
            this.model.addHydrogenBond(myN1, bestN3, (short)18432, bsA, bsB, 0.0f);
            if (myNucleotide.isGuanine()) {
                this.model.addHydrogenBond(myNucleotide.getN2(), bestNucleotide.getO2(), (short)18432, bsA, bsB, 0.0f);
                this.model.addHydrogenBond(myNucleotide.getO6(), bestNucleotide.getN4(), (short)18432, bsA, bsB, 0.0f);
                continue;
            }
            this.model.addHydrogenBond(myNucleotide.getN6(), bestNucleotide.getO4(), (short)18432, bsA, bsB, 0.0f);
        }
    }

    public void getPdbData(char ctype, char qtype, int derivType, boolean isDraw, BitSet bsAtoms, StringBuffer pdbATOM, StringBuffer pdbCONECT, BitSet bsSelected, boolean addHeader, BitSet bsWritten) {
        NucleicPolymer.getPdbData(this, ctype, qtype, derivType, isDraw, bsAtoms, pdbATOM, pdbCONECT, bsSelected, addHeader, bsWritten);
    }
}

