/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.ProteinStructure;

public class Sheet
extends ProteinStructure {
    AlphaPolymer alphaPolymer;
    Vector3f widthUnitVector;
    Vector3f heightUnitVector;

    Sheet(AlphaPolymer alphaPolymer, int monomerIndex, int monomerCount, int id) {
        super(alphaPolymer, (byte)2, monomerIndex, monomerCount, id);
        this.alphaPolymer = alphaPolymer;
    }

    public void calcAxis() {
        if (this.axisA != null) {
            return;
        }
        if (this.monomerCount == 2) {
            this.axisA = this.alphaPolymer.getLeadPoint(this.monomerIndexFirst);
            this.axisB = this.alphaPolymer.getLeadPoint(this.monomerIndexFirst + 1);
        } else {
            this.axisA = new Point3f();
            this.alphaPolymer.getLeadMidPoint(this.monomerIndexFirst + 1, this.axisA);
            this.axisB = new Point3f();
            this.alphaPolymer.getLeadMidPoint(this.monomerIndexFirst + this.monomerCount - 1, this.axisB);
        }
        this.axisUnitVector = new Vector3f();
        this.axisUnitVector.sub(this.axisB, this.axisA);
        this.axisUnitVector.normalize();
        Point3f tempA = new Point3f();
        this.alphaPolymer.getLeadMidPoint(this.monomerIndexFirst, tempA);
        if (!this.lowerNeighborIsHelixOrSheet()) {
            Graphics3D.projectOntoAxis(tempA, this.axisA, this.axisUnitVector, this.vectorProjection);
        }
        Point3f tempB = new Point3f();
        this.alphaPolymer.getLeadMidPoint(this.monomerIndexFirst + this.monomerCount, tempB);
        if (!this.upperNeighborIsHelixOrSheet()) {
            Graphics3D.projectOntoAxis(tempB, this.axisA, this.axisUnitVector, this.vectorProjection);
        }
        this.axisA = tempA;
        this.axisB = tempB;
    }

    void calcSheetUnitVectors() {
        if (!(this.alphaPolymer instanceof AminoPolymer)) {
            return;
        }
        if (this.widthUnitVector == null) {
            Vector3f vectorCO = new Vector3f();
            Vector3f vectorCOSum = new Vector3f();
            AminoMonomer amino = (AminoMonomer)this.alphaPolymer.monomers[this.monomerIndexFirst];
            vectorCOSum.sub(amino.getCarbonylOxygenAtomPoint(), amino.getCarbonylCarbonAtomPoint());
            int i = this.monomerCount;
            while (--i > 0) {
                amino = (AminoMonomer)this.alphaPolymer.monomers[i];
                vectorCO.sub(amino.getCarbonylOxygenAtomPoint(), amino.getCarbonylCarbonAtomPoint());
                if (vectorCOSum.angle(vectorCO) < 1.5707964f) {
                    vectorCOSum.add(vectorCO);
                    continue;
                }
                vectorCOSum.sub(vectorCO);
            }
            this.heightUnitVector = vectorCO;
            this.heightUnitVector.cross(this.axisUnitVector, vectorCOSum);
            this.heightUnitVector.normalize();
            this.widthUnitVector = vectorCOSum;
            this.widthUnitVector.cross(this.axisUnitVector, this.heightUnitVector);
        }
    }

    public Vector3f getWidthUnitVector() {
        if (this.widthUnitVector == null) {
            this.calcSheetUnitVectors();
        }
        return this.widthUnitVector;
    }

    public Vector3f getHeightUnitVector() {
        if (this.heightUnitVector == null) {
            this.calcSheetUnitVectors();
        }
        return this.heightUnitVector;
    }
}

