/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.popup;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.popup.JmolPopupAwt;
import org.jmol.popup.JmolPopupSwing;
import org.jmol.popup.PopupResourceBundle;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;

public abstract class JmolPopup {
    private static final boolean forceAwt = false;
    private static final boolean dumpList = false;
    JmolViewer viewer;
    Component display;
    MenuItemListener mil;
    CheckboxMenuItemListener cmil;
    boolean asPopup = true;
    Hashtable htMenus = new Hashtable();
    Properties menuText = new Properties();
    Object frankPopup;
    int aboutComputedMenuBaseCount;
    String nullModelSetName;
    String modelSetName;
    String modelSetFileName;
    String modelSetRoot;
    Hashtable modelSetInfo;
    Hashtable modelInfo;
    Vector PDBOnly = new Vector();
    Vector UnitcellOnly = new Vector();
    Vector FramesOnly = new Vector();
    Vector VibrationOnly = new Vector();
    Vector SymmetryOnly = new Vector();
    Vector SignedOnly = new Vector();
    Vector AppletOnly = new Vector();
    Vector ChargesOnly = new Vector();
    Vector TemperatureOnly = new Vector();
    boolean isPDB;
    boolean isSymmetry;
    boolean isUnitCell;
    boolean isMultiFrame;
    boolean isMultiConfiguration;
    boolean isVibration;
    boolean isApplet;
    boolean isSigned;
    boolean isZapped;
    boolean haveCharges;
    boolean haveBFactors;
    String altlocs;
    int modelIndex;
    int modelCount;
    int atomCount;
    static final int MAX_ITEMS = 25;
    static final int TITLE_MAX_WIDTH = 20;
    static String menuStructure;
    static final int UPDATE_ALL = 0;
    static final int UPDATE_CONFIG = 1;
    static final int UPDATE_SHOW = 2;
    int updateMode;
    String group3List;
    int[] group3Counts;
    String configurationSelected = "";
    Hashtable htCheckbox = new Hashtable();
    String currentMenuItemId = null;
    int thisx;
    int thisy;
    Object[][] frankList = new Object[10][];
    int nFrankList = 0;
    String currentFrankId = null;

    JmolPopup(JmolViewer viewer, boolean asPopup) {
        this.viewer = viewer;
        this.asPopup = asPopup;
        this.display = viewer.getDisplay();
        this.mil = new MenuItemListener();
        this.cmil = new CheckboxMenuItemListener();
    }

    public static JmolPopup newJmolPopup(JmolViewer viewer, boolean doTranslate, String menu, boolean asPopup) {
        JmolPopup popup;
        menuStructure = menu;
        GT.setDoTranslate(true);
        try {
            popup = !viewer.isJvm12orGreater() ? new JmolPopupAwt(viewer, asPopup) : new JmolPopupSwing(viewer, asPopup);
        }
        catch (Exception e) {
            Logger.error("JmolPopup not loaded");
            GT.setDoTranslate(doTranslate);
            return null;
        }
        try {
            popup.updateComputedMenus();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        GT.setDoTranslate(doTranslate);
        return popup;
    }

    public abstract void installMainMenu(Object var1);

    void build(Object popupMenu) {
        this.htMenus.put("popupMenu", popupMenu);
        boolean allowSignedFeatures = !this.viewer.isApplet() || this.viewer.getBooleanProperty("_signedApplet");
        this.addMenuItems("", "popupMenu", popupMenu, new PopupResourceBundle(menuStructure, this.menuText), this.viewer.isJvm12orGreater(), allowSignedFeatures);
    }

    public String getMenu(String title) {
        int pt = title.indexOf("|");
        if (pt >= 0) {
            String type = title.substring(pt);
            title = title.substring(0, pt);
            if (type.indexOf("current") >= 0) {
                return this.getMenuCurrent();
            }
        }
        return new PopupResourceBundle(menuStructure, null).getMenu(title);
    }

    abstract String getMenuCurrent();

    protected static void addCurrentItem(StringBuffer sb, char type, int level, String name, String label, String script, String flags) {
        sb.append(type).append(level).append('\t').append(name);
        if (label == null) {
            sb.append(".\n");
            return;
        }
        sb.append("\t").append(label).append("\t").append(script == null || script.length() == 0 ? "-" : script).append("\t").append(flags).append("\n");
    }

    private String getMenuText(String key) {
        String str = this.menuText.getProperty(key);
        return str == null ? key : str;
    }

    public void updateComputedMenus() {
        this.updateMode = 0;
        this.getViewerData();
        this.updateSelectMenu();
        this.updateWriteMenu();
        this.updateElementsComputedMenu(this.viewer.getElementsPresentBitSet(this.modelIndex));
        this.updateHeteroComputedMenu(this.viewer.getHeteroList(this.modelIndex));
        this.updateSurfMoComputedMenu((Hashtable)this.modelInfo.get("moData"));
        this.updateFileTypeDependentMenus();
        this.updatePDBComputedMenus();
        this.updateMode = 1;
        this.updateConfigurationComputedMenu();
        this.updateSYMMETRYComputedMenu();
        this.updateFRAMESbyModelComputedMenu();
        this.updateModelSetComputedMenu();
        this.updateLanguageSubmenu();
        this.updateAboutSubmenu();
    }

    private void updateWriteMenu() {
        Object menu = this.htMenus.get("SIGNEDwriteMenu");
        if (menu == null) {
            return;
        }
        String text = this.getMenuText("writeFileTextVARIABLE");
        menu = this.htMenus.get("writeFileTextVARIABLE");
        this.setLabel(menu, GT._(text, this.modelSetFileName, true));
        this.enableMenuItem(menu, !this.modelSetFileName.equals("zapped"));
    }

    private void getViewerData() {
        this.isApplet = this.viewer.isApplet();
        this.isSigned = this.viewer.getBooleanProperty("_signedApplet");
        this.modelSetName = this.viewer.getModelSetName();
        this.modelSetRoot = this.modelSetName == null || this.modelSetName.indexOf("<") >= 0 || this.modelSetName.indexOf("[") >= 0 || this.modelSetName.indexOf(" ") >= 0 ? "Jmol" : this.modelSetName;
        this.modelSetFileName = this.viewer.getModelSetFileName();
        if ("string".equals(this.modelSetFileName)) {
            this.modelSetFileName = "";
        }
        this.isZapped = "zapped".equals(this.modelSetName);
        this.modelIndex = this.viewer.getDisplayModelIndex();
        this.modelCount = this.viewer.getModelCount();
        this.atomCount = this.viewer.getAtomCountInModel(this.modelIndex);
        this.modelSetInfo = this.viewer.getModelSetAuxiliaryInfo();
        this.modelInfo = this.viewer.getModelAuxiliaryInfo(this.modelIndex);
        if (this.modelInfo == null) {
            this.modelInfo = new Hashtable();
        }
        this.isPDB = this.checkBoolean(this.modelSetInfo, "isPDB");
        this.isSymmetry = this.checkBoolean(this.modelSetInfo, "someModelsHaveSymmetry");
        this.isUnitCell = this.checkBoolean(this.modelSetInfo, "someModelsHaveUnitcells");
        this.isMultiFrame = this.modelCount > 1;
        this.altlocs = this.viewer.getAltLocListInModel(this.modelIndex);
        this.isMultiConfiguration = this.altlocs.length() > 0;
        this.isVibration = this.viewer.modelHasVibrationVectors(this.modelIndex);
        this.haveCharges = this.viewer.havePartialCharges();
        this.haveBFactors = this.viewer.getBooleanProperty("haveBFactors");
    }

    private void updateForShow() {
        this.updateMode = 2;
        this.updateSelectMenu();
        this.updateFRAMESbyModelComputedMenu();
        this.updateModelSetComputedMenu();
        this.updateAboutSubmenu();
    }

    boolean checkBoolean(Hashtable info, String key) {
        if (info == null || !info.containsKey(key)) {
            return false;
        }
        return (Boolean)info.get(key);
    }

    void updateSelectMenu() {
        Object menu = this.htMenus.get("selectMenuText");
        if (menu == null) {
            return;
        }
        this.enableMenu(menu, this.atomCount != 0);
        this.setLabel(menu, GT._(this.getMenuText("selectMenuText"), this.viewer.getSelectionCount(), true));
    }

    void updateElementsComputedMenu(BitSet elementsPresentBitSet) {
        int i;
        Object menu = this.htMenus.get("elementsComputedMenu");
        if (menu == null) {
            return;
        }
        this.removeAll(menu);
        this.enableMenu(menu, false);
        if (elementsPresentBitSet == null) {
            return;
        }
        for (i = 0; i < JmolConstants.elementNumberMax; ++i) {
            if (!elementsPresentBitSet.get(i)) continue;
            String elementName = JmolConstants.elementNameFromNumber(i);
            String elementSymbol = JmolConstants.elementSymbolFromNumber(i);
            String entryName = elementSymbol + " - " + elementName;
            this.addMenuItem(menu, entryName, "SELECT " + elementName, null);
        }
        for (i = 4; i < JmolConstants.altElementMax; ++i) {
            int n = JmolConstants.elementNumberMax + i;
            if (!elementsPresentBitSet.get(n)) continue;
            n = JmolConstants.altElementNumberFromIndex(i);
            String elementName = JmolConstants.elementNameFromNumber(n);
            String elementSymbol = JmolConstants.elementSymbolFromNumber(n);
            String entryName = elementSymbol + " - " + elementName;
            this.addMenuItem(menu, entryName, "SELECT " + elementName, null);
        }
        this.enableMenu(menu, true);
    }

    void updateHeteroComputedMenu(Hashtable htHetero) {
        Object menu = this.htMenus.get("PDBheteroComputedMenu");
        if (menu == null) {
            return;
        }
        this.removeAll(menu);
        this.enableMenu(menu, false);
        if (htHetero == null) {
            return;
        }
        Enumeration e = htHetero.keys();
        int n = 0;
        while (e.hasMoreElements()) {
            String heteroCode = (String)e.nextElement();
            String heteroName = (String)htHetero.get(heteroCode);
            if (heteroName.length() > 20) {
                heteroName = heteroName.substring(0, 20) + "...";
            }
            String entryName = heteroCode + " - " + heteroName;
            this.addMenuItem(menu, entryName, "SELECT [" + heteroCode + "]", null);
            ++n;
        }
        this.enableMenu(menu, n > 0);
    }

    void updateSurfMoComputedMenu(Hashtable moData) {
        int nOrb;
        Object menu = this.htMenus.get("surfMoComputedMenu");
        if (menu == null) {
            return;
        }
        this.enableMenu(menu, false);
        this.removeAll(menu);
        if (moData == null) {
            return;
        }
        Vector mos = (Vector)moData.get("mos");
        int n = nOrb = mos == null ? 0 : mos.size();
        if (nOrb == 0) {
            return;
        }
        this.enableMenu(menu, true);
        Object subMenu = menu;
        int nmod = nOrb % 25;
        if (nmod == 0) {
            nmod = 25;
        }
        int pt = nOrb > 25 ? 0 : Integer.MIN_VALUE;
        int i = nOrb;
        while (--i >= 0) {
            if (pt >= 0 && pt++ % nmod == 0) {
                if (pt == nmod + 1) {
                    nmod = 25;
                }
                String id = "mo" + pt + "Menu";
                subMenu = this.newMenu(Math.max(i + 2 - nmod, 1) + "..." + (i + 1), this.getId(menu) + "." + id);
                this.addMenuSubMenu(menu, subMenu);
                this.htMenus.put(id, subMenu);
                pt = 1;
            }
            Hashtable mo = (Hashtable)mos.get(i);
            String entryName = "#" + (i + 1) + " " + (mo.containsKey("energy") ? mo.get("energy") : "") + " " + (mo.containsKey("type") ? (String)mo.get("type") : "");
            String script = "mo " + (i + 1);
            this.addMenuItem(subMenu, entryName, script, null);
        }
    }

    void updatePDBComputedMenus() {
        Object menu = this.htMenus.get("PDBaaResiduesComputedMenu");
        if (menu == null) {
            return;
        }
        this.removeAll(menu);
        this.enableMenu(menu, false);
        Object menu1 = this.htMenus.get("PDBnucleicResiduesComputedMenu");
        if (menu1 == null) {
            return;
        }
        this.removeAll(menu1);
        this.enableMenu(menu1, false);
        Object menu2 = this.htMenus.get("PDBcarboResiduesComputedMenu");
        if (menu2 == null) {
            return;
        }
        this.removeAll(menu2);
        this.enableMenu(menu2, false);
        if (this.modelSetInfo == null) {
            return;
        }
        int n = this.modelIndex < 0 ? 0 : this.modelIndex + 1;
        String[] lists = (String[])this.modelSetInfo.get("group3Lists");
        this.group3List = lists == null ? null : lists[n];
        int[] nArray = this.group3Counts = lists == null ? null : ((int[][])this.modelSetInfo.get("group3Counts"))[n];
        if (this.group3List == null) {
            return;
        }
        int nItems = 0;
        for (int i = 1; i < 24; ++i) {
            nItems += this.updateGroup3List(menu, JmolConstants.predefinedGroup3Names[i]);
        }
        this.enableMenu(menu, (nItems += this.augmentGroup3List(menu, "p>", true)) > 0);
        this.enableMenu(this.htMenus.get("PDBproteinMenu"), nItems > 0);
        nItems = this.augmentGroup3List(menu1, "n>", false);
        this.enableMenu(menu1, nItems > 0);
        this.enableMenu(this.htMenus.get("PDBnucleicMenu"), nItems > 0);
        nItems = this.augmentGroup3List(menu2, "c>", false);
        this.enableMenu(menu2, nItems > 0);
        this.enableMenu(this.htMenus.get("PDBcarboMenu"), nItems > 0);
    }

    int updateGroup3List(Object menu, String name) {
        int nItems = 0;
        int n = this.group3Counts[this.group3List.indexOf(name) / 6];
        String script = null;
        if (n > 0) {
            script = "SELECT " + name;
            name = name + "  (" + n + ")";
            ++nItems;
        } else {
            script = null;
        }
        Object item = this.addMenuItem(menu, name, script, this.getId(menu) + "." + name);
        if (n == 0) {
            this.enableMenuItem(item, false);
        }
        return nItems;
    }

    int augmentGroup3List(Object menu, String type, boolean addSeparator) {
        int pt = 138;
        int nItems = 0;
        while ((pt = this.group3List.indexOf(type, pt)) >= 0) {
            if (nItems++ == 0 && addSeparator) {
                this.addMenuSeparator(menu);
            }
            int n = this.group3Counts[pt / 6];
            String heteroCode = this.group3List.substring(pt + 2, pt + 5);
            String name = heteroCode + "  (" + n + ")";
            this.addMenuItem(menu, name, "SELECT [" + heteroCode + "]", this.getId(menu) + "." + name);
            ++pt;
        }
        return nItems;
    }

    void updateSYMMETRYComputedMenu() {
        Object menu = this.htMenus.get("SYMMETRYComputedMenu");
        if (menu == null) {
            return;
        }
        this.removeAll(menu);
        this.enableMenu(menu, false);
        if (!this.isSymmetry || this.modelIndex < 0) {
            return;
        }
        String[] list = (String[])this.modelInfo.get("symmetryOperations");
        if (list == null) {
            return;
        }
        int[] cellRange = (int[])this.modelInfo.get("unitCellRange");
        boolean haveUnitCellRange = cellRange != null;
        Object subMenu = menu;
        int nmod = 25;
        int pt = list.length > 25 ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < list.length; ++i) {
            if (pt >= 0 && pt++ % nmod == 0) {
                String id = "symop" + pt + "Menu";
                subMenu = this.newMenu(i + 1 + "..." + Math.min(i + 25, list.length), this.getId(menu) + "." + id);
                this.addMenuSubMenu(menu, subMenu);
                this.htMenus.put(id, subMenu);
                pt = 1;
            }
            String entryName = "symop=" + (i + 1) + " # " + list[i];
            this.enableMenuItem(this.addMenuItem(subMenu, entryName, "SELECT symop=" + (i + 1), null), haveUnitCellRange);
        }
        this.enableMenu(menu, true);
    }

    void updateFRAMESbyModelComputedMenu() {
        Object menu = this.htMenus.get("FRAMESbyModelComputedMenu");
        if (menu == null) {
            return;
        }
        this.enableMenu(menu, this.modelCount > 1);
        this.setLabel(menu, this.modelIndex < 0 ? GT._(this.getMenuText("allModelsText"), this.modelCount, true) : this.getModelLabel());
        this.removeAll(menu);
        if (this.modelCount < 2) {
            return;
        }
        this.addCheckboxMenuItem(menu, GT._("All", true), "frame 0 ##", null, this.modelIndex < 0);
        Object subMenu = menu;
        int nmod = 25;
        int pt = this.modelCount > 25 ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < this.modelCount; ++i) {
            if (pt >= 0 && pt++ % nmod == 0) {
                String id = "model" + pt + "Menu";
                subMenu = this.newMenu(i + 1 + "..." + Math.min(i + 25, this.modelCount), this.getId(menu) + "." + id);
                this.addMenuSubMenu(menu, subMenu);
                this.htMenus.put(id, subMenu);
                pt = 1;
            }
            String script = "" + this.viewer.getModelNumberDotted(i);
            String entryName = this.viewer.getModelName(i);
            if (!entryName.equals(script)) {
                entryName = script + ": " + entryName;
            }
            if (entryName.length() > 50) {
                entryName = entryName.substring(0, 45) + "...";
            }
            this.addCheckboxMenuItem(subMenu, entryName, "model " + script + " ##", null, this.modelIndex == i);
        }
    }

    void updateConfigurationComputedMenu() {
        Object menu = this.htMenus.get("configurationComputedMenu");
        if (menu == null) {
            return;
        }
        this.enableMenu(menu, this.isMultiConfiguration);
        if (!this.isMultiConfiguration) {
            return;
        }
        int nAltLocs = this.altlocs.length();
        this.setLabel(menu, GT._(this.getMenuText("configurationMenuText"), nAltLocs, true));
        this.removeAll(menu);
        String script = "hide none ##CONFIG";
        this.addCheckboxMenuItem(menu, GT._("All", true), script, null, this.updateMode == 1 && this.configurationSelected.equals(script));
        for (int i = 0; i < nAltLocs; ++i) {
            script = "configuration " + (i + 1) + "; hide thisModel and not selected ##CONFIG";
            String entryName = "" + (i + 1) + " -- \"" + this.altlocs.charAt(i) + "\"";
            this.addCheckboxMenuItem(menu, entryName, script, null, this.updateMode == 1 && this.configurationSelected.equals(script));
        }
    }

    void updateModelSetComputedMenu() {
        Object menu = this.htMenus.get("modelSetMenu");
        if (menu == null) {
            return;
        }
        this.removeAll(menu);
        this.renameMenu(menu, this.nullModelSetName);
        this.enableMenu(menu, false);
        this.enableMenu(this.htMenus.get("surfaceMenu"), !this.isZapped);
        this.enableMenu(this.htMenus.get("measureMenu"), !this.isZapped);
        this.enableMenu(this.htMenus.get("pickingMenu"), !this.isZapped);
        if (this.modelSetName == null || this.isZapped) {
            return;
        }
        if (this.isMultiFrame) {
            this.modelSetName = GT._(this.getMenuText("modelSetCollectionText"), this.modelCount);
            if (this.modelSetName.length() > 20) {
                this.modelSetName = this.modelSetName.substring(0, 20) + "...";
            }
        } else if (this.viewer.getBooleanProperty("hideNameInPopup")) {
            this.modelSetName = this.getMenuText("hiddenModelSetText");
        } else if (this.modelSetName.length() > 20) {
            this.modelSetName = this.modelSetName.substring(0, 20) + "...";
        }
        this.renameMenu(menu, this.modelSetName);
        this.enableMenu(menu, true);
        this.enableMenuItem(this.addMenuItem(menu, GT._("Minimize"), "minimize", null), this.atomCount <= 100);
        this.addMenuSeparator(menu);
        this.addMenuItem(menu, GT._(this.getMenuText("atomsText"), this.atomCount, true));
        this.addMenuItem(menu, GT._(this.getMenuText("bondsText"), this.viewer.getBondCountInModel(this.modelIndex), true));
        if (this.isPDB) {
            Vector biomolecules;
            this.addMenuSeparator(menu);
            this.addMenuItem(menu, GT._(this.getMenuText("groupsText"), this.viewer.getGroupCountInModel(this.modelIndex), true));
            this.addMenuItem(menu, GT._(this.getMenuText("chainsText"), this.viewer.getChainCountInModel(this.modelIndex), true));
            this.addMenuItem(menu, GT._(this.getMenuText("polymersText"), this.viewer.getPolymerCountInModel(this.modelIndex), true));
            Object submenu = this.htMenus.get("BiomoleculesMenu");
            if (submenu == null) {
                submenu = this.newMenu(GT._(this.getMenuText("biomoleculesMenuText")), this.getId(menu) + ".biomolecules");
                this.addMenuSubMenu(menu, submenu);
            }
            this.removeAll(submenu);
            this.enableMenu(submenu, false);
            if (this.modelIndex >= 0 && (biomolecules = (Vector)this.viewer.getModelAuxiliaryInfo(this.modelIndex, "biomolecules")) != null) {
                this.enableMenu(submenu, true);
                int nBiomolecules = biomolecules.size();
                for (int i = 0; i < nBiomolecules; ++i) {
                    String script = this.isMultiFrame ? "" : "save orientation;load \"\" FILTER \"biomolecule " + (i + 1) + "\";restore orientation;";
                    int nAtoms = (Integer)((Hashtable)biomolecules.elementAt(i)).get("atomCount");
                    String entryName = GT._(this.getMenuText(this.isMultiFrame ? "biomoleculeText" : "loadBiomoleculeText"), new Object[]{new Integer(i + 1), new Integer(nAtoms)});
                    this.addMenuItem(submenu, entryName, script, null);
                }
            }
        }
        if (this.isApplet && this.viewer.showModelSetDownload() && !this.viewer.getBooleanProperty("hideNameInPopup")) {
            this.addMenuSeparator(menu);
            this.addMenuItem(menu, GT._(this.getMenuText("viewMenuText"), this.modelSetFileName, true), "show url", null);
        }
    }

    void updateFileTypeDependentMenus() {
        int i;
        for (i = 0; i < this.PDBOnly.size(); ++i) {
            this.enableMenu(this.PDBOnly.get(i), this.isPDB);
        }
        for (i = 0; i < this.UnitcellOnly.size(); ++i) {
            this.enableMenu(this.UnitcellOnly.get(i), this.isUnitCell);
        }
        for (i = 0; i < this.FramesOnly.size(); ++i) {
            this.enableMenu(this.FramesOnly.get(i), this.isMultiFrame);
        }
        for (i = 0; i < this.VibrationOnly.size(); ++i) {
            this.enableMenu(this.VibrationOnly.get(i), this.isVibration);
        }
        for (i = 0; i < this.SymmetryOnly.size(); ++i) {
            this.enableMenu(this.SymmetryOnly.get(i), this.isSymmetry && this.isUnitCell);
        }
        for (i = 0; i < this.SignedOnly.size(); ++i) {
            this.enableMenu(this.SignedOnly.get(i), this.isSigned || !this.isApplet);
        }
        for (i = 0; i < this.AppletOnly.size(); ++i) {
            this.enableMenu(this.AppletOnly.get(i), this.isApplet);
        }
        for (i = 0; i < this.ChargesOnly.size(); ++i) {
            this.enableMenu(this.ChargesOnly.get(i), this.haveCharges);
        }
        for (i = 0; i < this.TemperatureOnly.size(); ++i) {
            this.enableMenu(this.TemperatureOnly.get(i), this.haveBFactors);
        }
    }

    String getModelLabel() {
        return GT._(this.getMenuText("modelMenuText"), this.modelIndex + 1 + "/" + this.modelCount, true);
    }

    private void updateAboutSubmenu() {
        Object menu = this.htMenus.get("aboutComputedMenu");
        if (menu == null) {
            return;
        }
        int i = this.getMenuItemCount(menu);
        while (--i >= this.aboutComputedMenuBaseCount) {
            this.removeMenuItem(menu, i);
        }
        this.addMenuSeparator(menu);
        this.addMenuItem(menu, "Jmol " + JmolConstants.version + (this.isSigned ? " (signed)" : ""));
        this.addMenuItem(menu, JmolConstants.date);
        this.addMenuItem(menu, this.viewer.getOperatingSystemName());
        this.addMenuItem(menu, this.viewer.getJavaVendor());
        this.addMenuItem(menu, this.viewer.getJavaVersion());
        this.addMenuSeparator(menu);
        this.addMenuItem(menu, GT._("Java memory usage", true));
        Runtime runtime = Runtime.getRuntime();
        long mbTotal = this.convertToMegabytes(runtime.totalMemory());
        long mbFree = this.convertToMegabytes(runtime.freeMemory());
        long mbMax = this.convertToMegabytes(this.maxMemoryForNewerJvm());
        this.addMenuItem(menu, GT._("{0} MB total", new Object[]{new Long(mbTotal)}, true));
        this.addMenuItem(menu, GT._("{0} MB free", new Object[]{new Long(mbFree)}, true));
        if (mbMax > 0L) {
            this.addMenuItem(menu, GT._("{0} MB maximum", new Object[]{new Long(mbMax)}, true));
        } else {
            this.addMenuItem(menu, GT._("unknown maximum", true));
        }
        int availableProcessors = this.availableProcessorsForNewerJvm();
        if (availableProcessors > 0) {
            this.addMenuItem(menu, availableProcessors == 1 ? GT._("1 processor", true) : GT._("{0} processors", availableProcessors, true));
        } else {
            this.addMenuItem(menu, GT._("unknown processor count", true));
        }
    }

    private void updateLanguageSubmenu() {
        Object menu = this.htMenus.get("languageComputedMenu");
        if (menu == null) {
            return;
        }
        int i = this.getMenuItemCount(menu);
        while (--i >= 0) {
            this.removeMenuItem(menu, i);
        }
        String language = GT.getLanguage();
        String id = this.getId(menu);
        GT.Language[] languages = GT.getLanguageList();
        for (int i2 = 0; i2 < languages.length; ++i2) {
            if (!languages[i2].display) continue;
            String code = languages[i2].code;
            String name = languages[i2].language;
            this.addCheckboxMenuItem(menu, GT._(name, true) + " (" + code + ")", "language = \"" + code + "\" ##" + name, id + "." + code, language.equals(code));
        }
    }

    private long convertToMegabytes(long num) {
        if (num <= 0x7FFFFFFFFFF7FFFFL) {
            num += 524288L;
        }
        return num / 0x100000L;
    }

    private void addMenuItems(String parentId, String key, Object menu, PopupResourceBundle popupResourceBundle, boolean isJVM12orGreater, boolean allowSignedFeatures) {
        String item;
        String id = parentId + "." + key;
        String value = popupResourceBundle.getStructure(key);
        if (value == null) {
            this.addMenuItem(menu, "#" + key, "", "");
            return;
        }
        StringTokenizer st = new StringTokenizer(value);
        while (value.indexOf("@") >= 0) {
            String s = "";
            while (st.hasMoreTokens()) {
                s = s + " " + ((item = st.nextToken()).startsWith("@") ? popupResourceBundle.getStructure(item) : item);
            }
            value = s.substring(1);
            st = new StringTokenizer(value);
        }
        while (st.hasMoreTokens()) {
            Object newMenu = null;
            String script = "";
            item = st.nextToken();
            boolean isDisabled = !isJVM12orGreater && item.indexOf("JVM12") >= 0;
            String word = popupResourceBundle.getWord(item);
            if (item.indexOf("Menu") >= 0) {
                if (!allowSignedFeatures && item.startsWith("SIGNED")) continue;
                Object subMenu = this.newMenu(word, id + "." + item);
                this.addMenuSubMenu(menu, subMenu);
                this.htMenus.put(item, subMenu);
                if (item.indexOf("Computed") < 0) {
                    this.addMenuItems(id, item, subMenu, popupResourceBundle, isJVM12orGreater, allowSignedFeatures);
                }
                if ("aboutComputedMenu".equals(item)) {
                    this.aboutComputedMenuBaseCount = this.getMenuItemCount(subMenu);
                } else if ("modelSetMenu".equals(item)) {
                    this.nullModelSetName = word;
                    this.enableMenu(subMenu, false);
                }
                newMenu = subMenu;
                if (isDisabled) {
                    this.enableMenu(newMenu, false);
                }
            } else if ("-".equals(item)) {
                this.addMenuSeparator(menu);
            } else if (item.endsWith("Checkbox")) {
                script = popupResourceBundle.getStructure(item);
                String basename = item.substring(0, item.length() - 8);
                if (script == null || script.length() == 0) {
                    script = "set " + basename + " T/F";
                }
                newMenu = this.addCheckboxMenuItem(menu, word, basename + ":" + script, id + "." + item);
            } else {
                script = popupResourceBundle.getStructure(item);
                if (script == null) {
                    script = item;
                }
                newMenu = this.addMenuItem(menu, word, script, id + "." + item);
                if (isDisabled) {
                    this.enableMenuItem(newMenu, false);
                }
            }
            if (item.indexOf("VARIABLE") >= 0) {
                this.htMenus.put(item, newMenu);
            }
            if (item.indexOf("PDB") >= 0) {
                this.PDBOnly.add(newMenu);
            } else if (item.indexOf("URL") >= 0) {
                this.AppletOnly.add(newMenu);
            } else if (item.indexOf("CHARGE") >= 0) {
                this.ChargesOnly.add(newMenu);
            } else if (item.indexOf("BFACTORS") >= 0) {
                this.TemperatureOnly.add(newMenu);
            } else if (item.indexOf("UNITCELL") >= 0) {
                this.UnitcellOnly.add(newMenu);
            } else if (item.indexOf("FRAMES") >= 0) {
                this.FramesOnly.add(newMenu);
            } else if (item.indexOf("VIBRATION") >= 0) {
                this.VibrationOnly.add(newMenu);
            } else if (item.indexOf("SYMMETRY") >= 0) {
                this.SymmetryOnly.add(newMenu);
            }
            if (!item.startsWith("SIGNED")) continue;
            this.SignedOnly.add(newMenu);
        }
    }

    void rememberCheckbox(String key, Object checkboxMenuItem) {
        this.htCheckbox.put(key, checkboxMenuItem);
    }

    void setCheckBoxValue(String what, boolean TF) {
        if (what.indexOf("##") < 0) {
            int pt = what.indexOf(":");
            String basename = what.substring(0, pt);
            if (this.viewer.getBooleanProperty(basename) == TF) {
                return;
            }
            if ((pt = (what = what.substring(pt + 1)).indexOf("|")) >= 0) {
                what = (TF ? what.substring(0, pt) : what.substring(pt + 1)).trim();
            }
            what = TextFormat.simpleReplace(what, "T/F", TF ? " TRUE" : " FALSE");
        }
        this.viewer.evalStringQuiet(what);
        if (what.indexOf("#CONFIG") >= 0) {
            this.configurationSelected = what;
            this.updateConfigurationComputedMenu();
            this.updateModelSetComputedMenu();
        }
    }

    String fixScript(String id, String script) {
        if (script == "" || id.endsWith("Checkbox")) {
            return script;
        }
        if (script.indexOf("SELECT") == 0) {
            return "select thisModel and (" + script.substring(6) + ")";
        }
        int pt = id.lastIndexOf("[");
        if (pt >= 0) {
            if ((pt = (id = id.substring(pt + 1)).indexOf("]")) >= 0) {
                id = id.substring(0, pt);
            }
            id = id.replace('_', ' ');
            if (script.indexOf("[]") < 0) {
                script = "[] " + script;
            }
            return TextFormat.simpleReplace(script, "[]", id);
        }
        if (script.indexOf("?FILEROOT?") >= 0) {
            script = TextFormat.simpleReplace(script, "FILEROOT?", this.modelSetRoot);
        } else if (script.indexOf("?FILE?") >= 0) {
            script = TextFormat.simpleReplace(script, "FILE?", this.modelSetFileName);
        } else if (script.indexOf("?PdbId?") >= 0) {
            script = TextFormat.simpleReplace(script, "PdbId?", "=" + (this.modelSetRoot.length() == 4 && this.modelSetRoot.indexOf(".") < 0 ? this.modelSetRoot : "1crn"));
        }
        return script;
    }

    Object addMenuItem(Object menuItem, String entry) {
        return this.addMenuItem(menuItem, entry, "", null);
    }

    Object addCheckboxMenuItem(Object menu, String entry, String basename, String id) {
        Object item = this.addCheckboxMenuItem(menu, entry, basename, id, false);
        this.rememberCheckbox(basename, item);
        return item;
    }

    public void show(int x, int y) {
        this.thisx = x;
        this.thisy = y;
        String id = this.currentMenuItemId;
        this.updateForShow();
        Enumeration keys = this.htCheckbox.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object item = this.htCheckbox.get(key);
            String basename = key.substring(0, key.indexOf(":"));
            boolean b = this.viewer.getBooleanProperty(basename);
            this.setCheckBoxState(item, b);
        }
        if (x < 0) {
            this.setFrankMenu(id);
            this.thisx = -x - 50;
            if (this.nFrankList > 1) {
                this.thisy = y - this.nFrankList * this.getMenuItemHeight();
                this.showFrankMenu(this.thisx, this.thisy);
                return;
            }
        }
        this.restorePopupMenu();
        if (this.asPopup) {
            this.showPopupMenu(this.thisx, this.thisy);
        }
    }

    void setFrankMenu(String id) {
        int iNew;
        if (this.currentFrankId != null && this.currentFrankId == id && this.nFrankList > 0) {
            return;
        }
        if (this.frankPopup == null) {
            this.createFrankPopup();
        }
        this.resetFrankMenu();
        if (id == null) {
            return;
        }
        this.currentFrankId = id;
        this.nFrankList = 0;
        this.frankList[this.nFrankList++] = new Object[]{null, null, null};
        this.addMenuItem(this.frankPopup, GT._(this.getMenuText("mainMenuText")), "MAIN", "");
        int i = id.indexOf(".", 2) + 1;
        while ((iNew = id.indexOf(".", i)) >= 0) {
            String strMenu = id.substring(i, iNew);
            Object menu = this.htMenus.get(strMenu);
            this.frankList[this.nFrankList++] = new Object[]{this.getParent(menu), menu, new Integer(this.getPosition(menu))};
            this.addMenuSubMenu(this.frankPopup, menu);
            i = iNew + 1;
        }
    }

    void restorePopupMenu() {
        if (this.nFrankList < 2) {
            return;
        }
        int i = this.nFrankList;
        while (--i > 0) {
            this.insertMenuSubMenu(this.frankList[i][0], this.frankList[i][1], (Integer)this.frankList[i][2]);
        }
        this.nFrankList = 1;
    }

    abstract void resetFrankMenu();

    abstract Object getParent(Object var1);

    abstract void insertMenuSubMenu(Object var1, Object var2, int var3);

    abstract int getPosition(Object var1);

    abstract void showPopupMenu(int var1, int var2);

    abstract void showFrankMenu(int var1, int var2);

    abstract void setCheckBoxState(Object var1, boolean var2);

    abstract void addMenuSeparator(Object var1);

    abstract Object addMenuItem(Object var1, String var2, String var3, String var4);

    abstract void setLabel(Object var1, String var2);

    abstract void updateMenuItem(Object var1, String var2, String var3);

    abstract Object addCheckboxMenuItem(Object var1, String var2, String var3, String var4, boolean var5);

    abstract void addMenuSubMenu(Object var1, Object var2);

    abstract Object newMenu(String var1, String var2);

    abstract void enableMenu(Object var1, boolean var2);

    abstract void enableMenuItem(Object var1, boolean var2);

    abstract void renameMenu(Object var1, String var2);

    abstract void removeAll(Object var1);

    abstract int getMenuItemCount(Object var1);

    abstract void removeMenuItem(Object var1, int var2);

    abstract String getId(Object var1);

    abstract void setCheckBoxValue(Object var1);

    abstract void createFrankPopup();

    abstract int getMenuItemHeight();

    long maxMemoryForNewerJvm() {
        return 0L;
    }

    int availableProcessorsForNewerJvm() {
        return 0;
    }

    class CheckboxMenuItemListener
    implements ItemListener {
        CheckboxMenuItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            JmolPopup.this.restorePopupMenu();
            JmolPopup.this.setCheckBoxValue(e.getSource());
            String id = JmolPopup.this.getId(e.getSource());
            if (id != null) {
                JmolPopup.this.currentMenuItemId = id;
            }
        }
    }

    class MenuItemListener
    implements ActionListener {
        MenuItemListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JmolPopup.this.restorePopupMenu();
            String script = e.getActionCommand();
            if (script == null || script.length() == 0) {
                return;
            }
            if (script.equals("MAIN")) {
                JmolPopup.this.show(JmolPopup.this.thisx, JmolPopup.this.thisy);
                return;
            }
            String id = JmolPopup.this.getId(e.getSource());
            if (id != null) {
                script = JmolPopup.this.fixScript(id, script);
                JmolPopup.this.currentMenuItemId = id;
            }
            JmolPopup.this.viewer.evalStringQuiet(script);
        }
    }
}

