/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.api.MOCalculationInterface;
import org.jmol.api.VolumeDataInterface;
import org.jmol.quantum.QuantumCalculation;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

public class MOCalculation
extends QuantumCalculation
implements MOCalculationInterface {
    private static int MAX_GRID = 80;
    final float[] CX = new float[MAX_GRID];
    final float[] CY = new float[MAX_GRID];
    final float[] CZ = new float[MAX_GRID];
    final float[] DXY = new float[MAX_GRID];
    final float[] DXZ = new float[MAX_GRID];
    final float[] DYZ = new float[MAX_GRID];
    final float[] EX = new float[MAX_GRID];
    final float[] EY = new float[MAX_GRID];
    final float[] EZ = new float[MAX_GRID];
    private String calculationType;
    private Vector shells;
    private float[][] gaussians;
    private int[][] slaterInfo;
    private float[][] slaterData;
    private float[] moCoefficients;
    private int moCoeff;
    private int gaussianPtr;
    private int firstAtomOffset;
    private boolean isElectronDensity;
    private float occupancy = 2.0f;
    protected float[][][] voxelDataTemp;
    boolean as5D = false;
    private static final float ROOT3 = 1.7320508f;

    public void calculate(VolumeDataInterface volumeData, BitSet bsSelected, String calculationType, Point3f[] atomCoordAngstroms, int firstAtomOffset, Vector shells, float[][] gaussians, Hashtable aoOrdersDF, int[][] slaterInfo, float[][] slaterData, float[] moCoefficients, float[] nuclearCharges) {
        this.calculationType = calculationType;
        this.firstAtomOffset = firstAtomOffset;
        this.shells = shells;
        this.gaussians = gaussians;
        this.slaterInfo = slaterInfo;
        this.slaterData = slaterData;
        this.moCoefficients = moCoefficients;
        this.isElectronDensity = nuclearCharges != null;
        int[] countsXYZ = volumeData.getVoxelCounts();
        this.initialize(countsXYZ[0], countsXYZ[1], countsXYZ[2]);
        this.voxelData = volumeData.getVoxelData();
        this.voxelDataTemp = this.isElectronDensity ? new float[this.nX][this.nY][this.nZ] : this.voxelData;
        this.setupCoordinates(volumeData.getOriginFloat(), volumeData.getVolumetricVectorLengths(), bsSelected, atomCoordAngstroms);
        this.atomIndex = firstAtomOffset - 1;
        this.doDebug = Logger.debugging;
        if (slaterInfo != null) {
            this.createSlaterCube();
        } else {
            this.createGaussianCube();
        }
    }

    public void calculateElectronDensity(float[] nuclearCharges) {
        float t = 0.0f;
        int ix = this.nX;
        while (--ix >= 0) {
            int iy = this.nY;
            while (--iy >= 0) {
                int iz = this.nZ;
                while (--iz >= 0) {
                    t += this.voxelData[ix][iy][iz];
                }
            }
        }
        float volume = this.stepBohr[0] * this.stepBohr[1] * this.stepBohr[2] / 1.8897161f / 1.8897161f / 1.8897161f;
        System.out.println("MOCalculation " + (t *= volume));
    }

    private void createSlaterCube() {
        this.moCoeff = 0;
        int nSlaters = this.slaterInfo.length;
        for (int i = 0; i < nSlaters; ++i) {
            this.processSlater(i);
        }
    }

    private void createGaussianCube() {
        if (!this.checkCalculationType()) {
            return;
        }
        this.check5D();
        int nShells = this.shells.size();
        this.moCoeff = 0;
        for (int i = 0; i < nShells; ++i) {
            this.processShell(i);
            if (!this.doDebug) continue;
            Logger.debug("createGaussianCube shell=" + i + " moCoeff=" + this.moCoeff + "/" + this.moCoefficients.length);
        }
    }

    private void check5D() {
        int nShells = this.shells.size();
        this.moCoeff = 0;
        this.thisAtom = null;
        for (int i = 0; i < nShells; ++i) {
            int[] shell = (int[])this.shells.get(i);
            int basisType = shell[1];
            this.gaussianPtr = shell[2];
            int nGaussians = shell[3];
            this.addData(basisType, nGaussians);
        }
        boolean bl = this.as5D = this.moCoeff > this.moCoefficients.length;
        if (this.as5D) {
            Logger.info("MO calculation is assuming spherical (5D,7F) orbitals");
        }
    }

    private boolean checkCalculationType() {
        if (this.calculationType == null) {
            Logger.warn("calculation type not identified -- continuing");
            return true;
        }
        if (this.calculationType.indexOf("+") >= 0 || this.calculationType.indexOf("*") >= 0) {
            Logger.warn("polarization/diffuse wavefunctions have not been tested fully: " + this.calculationType + " -- continuing");
        }
        if (this.calculationType.indexOf("?") >= 0) {
            Logger.warn("unknown calculation type may not render correctly -- continuing");
        } else {
            Logger.info("calculation type: " + this.calculationType + " OK.");
        }
        return true;
    }

    private void processShell(int iShell) {
        int lastAtom = this.atomIndex;
        int[] shell = (int[])this.shells.get(iShell);
        this.atomIndex = shell[0] + this.firstAtomOffset;
        int basisType = shell[1];
        this.gaussianPtr = shell[2];
        int nGaussians = shell[3];
        if (this.doDebug) {
            Logger.debug("processShell: " + iShell + " type=" + JmolConstants.getQuantumShellTag(basisType) + " nGaussians=" + nGaussians + " atom=" + this.atomIndex);
        }
        if (this.atomIndex != lastAtom && (this.thisAtom = this.qmAtoms[this.atomIndex]) != null) {
            this.thisAtom.setXYZ(true);
        }
        this.addData(basisType, nGaussians);
    }

    private void addData(int basisType, int nGaussians) {
        switch (basisType) {
            case 0: {
                this.addDataS(nGaussians);
                break;
            }
            case 1: {
                this.addDataP(nGaussians);
                break;
            }
            case 2: {
                this.addDataSP(nGaussians);
                break;
            }
            case 3: {
                if (this.as5D) {
                    this.addData5D(nGaussians);
                    break;
                }
                this.addData6D(nGaussians);
                break;
            }
            case 4: {
                this.addData5D(nGaussians);
                break;
            }
            case 5: {
                if (this.as5D) {
                    this.addData7F(nGaussians);
                    break;
                }
                this.addData10F(nGaussians);
                break;
            }
            case 6: {
                this.addData7F(nGaussians);
                break;
            }
            default: {
                Logger.warn(" Unsupported basis type for atomno=" + (this.atomIndex + 1) + " -- use \"set loglevel 5\" to debug.");
            }
        }
    }

    private void setTemp() {
        int ix = this.xMax;
        while (--ix >= this.xMin) {
            int iy = this.yMax;
            while (--iy >= this.yMin) {
                int iz = this.zMax;
                while (--iz >= this.zMin) {
                    float value = this.voxelDataTemp[ix][iy][iz];
                    float[] fArray = this.voxelData[ix][iy];
                    int n = iz;
                    fArray[n] = fArray[n] + value * value * this.occupancy;
                    this.voxelDataTemp[ix][iy][iz] = 0.0f;
                }
            }
        }
    }

    private void addDataS(int nGaussians) {
        if (this.thisAtom == null) {
            ++this.moCoeff;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(nGaussians, "S ");
        }
        float m1 = this.moCoefficients[this.moCoeff++];
        for (int ig = 0; ig < nGaussians; ++ig) {
            float alpha = this.gaussians[this.gaussianPtr + ig][0];
            float c1 = this.gaussians[this.gaussianPtr + ig][1];
            float a = m1 * c1 * (float)Math.pow(alpha, 0.75) * 0.7127055f;
            int i = this.xMax;
            while (--i >= this.xMin) {
                this.EX[i] = a * (float)Math.exp(-this.X2[i] * alpha);
            }
            i = this.yMax;
            while (--i >= this.yMin) {
                this.EY[i] = (float)Math.exp(-this.Y2[i] * alpha);
            }
            i = this.zMax;
            while (--i >= this.zMin) {
                this.EZ[i] = (float)Math.exp(-this.Z2[i] * alpha);
            }
            int ix = this.xMax;
            while (--ix >= this.xMin) {
                float eX = this.EX[ix];
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    float eXY = eX * this.EY[iy];
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        float[] fArray = this.voxelDataTemp[ix][iy];
                        int n = iz;
                        fArray[n] = fArray[n] + eXY * this.EZ[iz];
                    }
                }
            }
        }
        if (this.isElectronDensity) {
            this.setTemp();
        }
    }

    private void addDataP(int nGaussians) {
        if (this.thisAtom == null) {
            this.moCoeff += 3;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(nGaussians, "X Y Z ");
        }
        float mx = this.moCoefficients[this.moCoeff++];
        float my = this.moCoefficients[this.moCoeff++];
        float mz = this.moCoefficients[this.moCoeff++];
        if (this.isElectronDensity) {
            float a;
            float c1;
            float alpha;
            int ig;
            for (ig = 0; ig < nGaussians; ++ig) {
                alpha = this.gaussians[this.gaussianPtr + ig][0];
                c1 = this.gaussians[this.gaussianPtr + ig][1];
                a = c1 * (float)Math.pow(alpha, 1.25) * 1.425411f;
                this.calcSP(alpha, 0.0f, a * mx, 0.0f, 0.0f);
            }
            this.setTemp();
            for (ig = 0; ig < nGaussians; ++ig) {
                alpha = this.gaussians[this.gaussianPtr + ig][0];
                c1 = this.gaussians[this.gaussianPtr + ig][1];
                a = c1 * (float)Math.pow(alpha, 1.25) * 1.425411f;
                this.calcSP(alpha, 0.0f, 0.0f, a * my, 0.0f);
            }
            this.setTemp();
            for (ig = 0; ig < nGaussians; ++ig) {
                alpha = this.gaussians[this.gaussianPtr + ig][0];
                c1 = this.gaussians[this.gaussianPtr + ig][1];
                a = c1 * (float)Math.pow(alpha, 1.25) * 1.425411f;
                this.calcSP(alpha, 0.0f, 0.0f, 0.0f, a * mz);
            }
            this.setTemp();
        } else {
            for (int ig = 0; ig < nGaussians; ++ig) {
                float alpha = this.gaussians[this.gaussianPtr + ig][0];
                float c1 = this.gaussians[this.gaussianPtr + ig][1];
                float a = c1 * (float)Math.pow(alpha, 1.25) * 1.425411f;
                this.calcSP(alpha, 0.0f, a * mx, a * my, a * mz);
            }
        }
    }

    private void addDataSP(int nGaussians) {
        float c1 = this.gaussians[this.gaussianPtr][1];
        if (this.thisAtom == null) {
            this.moCoeff += c1 == 0.0f ? 3 : 4;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(nGaussians, c1 == 0.0f ? "X Y Z " : "S X Y Z ");
        }
        float ms = c1 == 0.0f ? 0.0f : this.moCoefficients[this.moCoeff++];
        float mx = this.moCoefficients[this.moCoeff++];
        float my = this.moCoefficients[this.moCoeff++];
        float mz = this.moCoefficients[this.moCoeff++];
        if (this.isElectronDensity) {
            float a2;
            float c2;
            float alpha;
            int ig;
            for (ig = 0; ig < nGaussians; ++ig) {
                alpha = this.gaussians[this.gaussianPtr + ig][0];
                c1 = this.gaussians[this.gaussianPtr + ig][1];
                float a1 = c1 * (float)Math.pow(alpha, 0.75) * 0.7127055f;
                this.calcSP(alpha, a1 * ms, 0.0f, 0.0f, 0.0f);
            }
            this.setTemp();
            for (ig = 0; ig < nGaussians; ++ig) {
                alpha = this.gaussians[this.gaussianPtr + ig][0];
                c2 = this.gaussians[this.gaussianPtr + ig][2];
                a2 = c2 * (float)Math.pow(alpha, 1.25) * 1.425411f;
                this.calcSP(alpha, 0.0f, a2 * mx, 0.0f, 0.0f);
            }
            this.setTemp();
            for (ig = 0; ig < nGaussians; ++ig) {
                alpha = this.gaussians[this.gaussianPtr + ig][0];
                c2 = this.gaussians[this.gaussianPtr + ig][2];
                a2 = c2 * (float)Math.pow(alpha, 1.25) * 1.425411f;
                this.calcSP(alpha, 0.0f, 0.0f, a2 * my, 0.0f);
            }
            this.setTemp();
            for (ig = 0; ig < nGaussians; ++ig) {
                alpha = this.gaussians[this.gaussianPtr + ig][0];
                c2 = this.gaussians[this.gaussianPtr + ig][2];
                a2 = c2 * (float)Math.pow(alpha, 1.25) * 1.425411f;
                this.calcSP(alpha, 0.0f, 0.0f, 0.0f, a2 * mz);
            }
            this.setTemp();
        } else {
            for (int ig = 0; ig < nGaussians; ++ig) {
                float alpha = this.gaussians[this.gaussianPtr + ig][0];
                c1 = this.gaussians[this.gaussianPtr + ig][1];
                float c2 = this.gaussians[this.gaussianPtr + ig][2];
                float a1 = c1 * (float)Math.pow(alpha, 0.75) * 0.7127055f;
                float a2 = c2 * (float)Math.pow(alpha, 1.25) * 1.425411f;
                this.calcSP(alpha, a1 * ms, a2 * mx, a2 * my, a2 * mz);
            }
        }
    }

    private void setCE(float[] CX, float[] EX, float alpha, float as, float ax, float ay, float az) {
        int i = this.xMax;
        while (--i >= this.xMin) {
            CX[i] = as + ax * this.X[i];
            EX[i] = (float)Math.exp(-this.X2[i] * alpha);
        }
        i = this.yMax;
        while (--i >= this.yMin) {
            this.CY[i] = ay * this.Y[i];
            this.EY[i] = (float)Math.exp(-this.Y2[i] * alpha);
        }
        i = this.zMax;
        while (--i >= this.zMin) {
            this.CZ[i] = az * this.Z[i];
            this.EZ[i] = (float)Math.exp(-this.Z2[i] * alpha);
        }
    }

    private void setE(float[] EX, float alpha) {
        int i = this.xMax;
        while (--i >= this.xMin) {
            EX[i] = (float)Math.exp(-this.X2[i] * alpha);
        }
        i = this.yMax;
        while (--i >= this.yMin) {
            this.EY[i] = (float)Math.exp(-this.Y2[i] * alpha);
        }
        i = this.zMax;
        while (--i >= this.zMin) {
            this.EZ[i] = (float)Math.exp(-this.Z2[i] * alpha);
        }
    }

    private void calcSP(float alpha, float as, float ax, float ay, float az) {
        this.setCE(this.CX, this.EX, alpha, as, ax, ay, az);
        int ix = this.xMax;
        while (--ix >= this.xMin) {
            float eX = this.EX[ix];
            float cX = this.CX[ix];
            int iy = this.yMax;
            while (--iy >= this.yMin) {
                float eXY = eX * this.EY[iy];
                float cXY = cX + this.CY[iy];
                int iz = this.zMax;
                while (--iz >= this.zMin) {
                    float[] fArray = this.voxelDataTemp[ix][iy];
                    int n = iz;
                    fArray[n] = fArray[n] + (cXY + this.CZ[iz]) * eXY * this.EZ[iz];
                }
            }
        }
    }

    private void addData6D(int nGaussians) {
        if (this.thisAtom == null || this.isElectronDensity) {
            this.moCoeff += 6;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(nGaussians, "XXYYZZXYXZYZ");
        }
        float mxx = this.moCoefficients[this.moCoeff++];
        float myy = this.moCoefficients[this.moCoeff++];
        float mzz = this.moCoefficients[this.moCoeff++];
        float mxy = this.moCoefficients[this.moCoeff++];
        float mxz = this.moCoefficients[this.moCoeff++];
        float myz = this.moCoefficients[this.moCoeff++];
        for (int ig = 0; ig < nGaussians; ++ig) {
            float alpha = this.gaussians[this.gaussianPtr + ig][0];
            float c1 = this.gaussians[this.gaussianPtr + ig][1];
            float a = c1 * (float)Math.pow(alpha, 1.75) * 2.850822f;
            float axx = a / 1.7320508f * mxx;
            float ayy = a / 1.7320508f * myy;
            float azz = a / 1.7320508f * mzz;
            float axy = a * mxy;
            float axz = a * mxz;
            float ayz = a * myz;
            this.setCE(this.CX, this.EX, alpha, 0.0f, axx, ayy, azz);
            int i = this.xMax;
            while (--i >= this.xMin) {
                this.DXY[i] = axy * this.X[i];
                this.DXZ[i] = axz * this.X[i];
            }
            i = this.yMax;
            while (--i >= this.yMin) {
                this.DYZ[i] = ayz * this.Y[i];
            }
            int ix = this.xMax;
            while (--ix >= this.xMin) {
                float axx_x2 = this.CX[ix] * this.X[ix];
                float axy_x = this.DXY[ix];
                float axz_x = this.DXZ[ix];
                float eX = this.EX[ix];
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    float axx_x2__ayy_y2__axy_xy = axx_x2 + (this.CY[iy] + axy_x) * this.Y[iy];
                    float axz_x__ayz_y = axz_x + this.DYZ[iy];
                    float eXY = eX * this.EY[iy];
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        float[] fArray = this.voxelDataTemp[ix][iy];
                        int n = iz;
                        fArray[n] = fArray[n] + (axx_x2__ayy_y2__axy_xy + (this.CZ[iz] + axz_x__ayz_y) * this.Z[iz]) * eXY * this.EZ[iz];
                    }
                }
            }
        }
    }

    private void addData5D(int nGaussians) {
        if (this.thisAtom == null || this.isElectronDensity) {
            this.moCoeff += 5;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(nGaussians, 4);
        }
        float norm1 = (float)Math.pow(66.05114251919257, 0.25);
        float norm2 = (float)((double)norm1 / Math.sqrt(3.0));
        float root34 = (float)Math.sqrt(0.75);
        float m0 = this.moCoefficients[this.moCoeff++];
        float m1p = this.moCoefficients[this.moCoeff++];
        float m1n = this.moCoefficients[this.moCoeff++];
        float m2p = this.moCoefficients[this.moCoeff++];
        float m2n = this.moCoefficients[this.moCoeff++];
        for (int ig = 0; ig < nGaussians; ++ig) {
            float alpha = this.gaussians[this.gaussianPtr + ig][0];
            float c1 = this.gaussians[this.gaussianPtr + ig][1];
            float a = c1 * (float)Math.pow(alpha, 1.75);
            float ad0 = a * m0;
            float ad1p = a * m1p;
            float ad1n = a * m1n;
            float ad2p = a * m2p;
            float ad2n = a * m2n;
            this.setE(this.EX, alpha);
            int ix = this.xMax;
            while (--ix >= this.xMin) {
                float x = this.X[ix];
                float eX = this.EX[ix];
                float cxx = norm2 * x * x;
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    float y = this.Y[iy];
                    float eXY = eX * this.EY[iy];
                    float cyy = norm2 * y * y;
                    float cxy = norm1 * x * y;
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        float z = this.Z[iz];
                        float czz = norm2 * z * z;
                        float cxz = norm1 * x * z;
                        float cyz = norm1 * y * z;
                        float[] fArray = this.voxelDataTemp[ix][iy];
                        int n = iz;
                        fArray[n] = fArray[n] + (ad0 * (czz - 0.5f * (cxx + cyy)) + ad1p * cxz + ad1n * cyz + ad2p * root34 * (cxx - cyy) + ad2n * cxy) * eXY * this.EZ[iz];
                    }
                }
            }
        }
    }

    private void addData10F(int nGaussians) {
        if (this.thisAtom == null || this.isElectronDensity) {
            this.moCoeff += 10;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(nGaussians, 5);
        }
        float norm1 = (float)Math.pow(1056.818280307081, 0.25);
        float norm2 = (float)((double)norm1 / Math.sqrt(3.0));
        float norm3 = (float)((double)norm1 / Math.sqrt(15.0));
        float mxxx = this.moCoefficients[this.moCoeff++];
        float myyy = this.moCoefficients[this.moCoeff++];
        float mzzz = this.moCoefficients[this.moCoeff++];
        float mxyy = this.moCoefficients[this.moCoeff++];
        float mxxy = this.moCoefficients[this.moCoeff++];
        float mxxz = this.moCoefficients[this.moCoeff++];
        float mxzz = this.moCoefficients[this.moCoeff++];
        float myzz = this.moCoefficients[this.moCoeff++];
        float myyz = this.moCoefficients[this.moCoeff++];
        float mxyz = this.moCoefficients[this.moCoeff++];
        for (int ig = 0; ig < nGaussians; ++ig) {
            float alpha = this.gaussians[this.gaussianPtr + ig][0];
            float c1 = this.gaussians[this.gaussianPtr + ig][1];
            this.setE(this.EX, alpha);
            float a = c1 * (float)Math.pow(alpha, 2.25);
            float axxx = a * norm3 * mxxx;
            float ayyy = a * norm3 * myyy;
            float azzz = a * norm3 * mzzz;
            float axyy = a * norm2 * mxyy;
            float axxy = a * norm2 * mxxy;
            float axxz = a * norm2 * mxxz;
            float axzz = a * norm2 * mxzz;
            float ayzz = a * norm2 * myzz;
            float ayyz = a * norm2 * myyz;
            float axyz = a * norm1 * mxyz;
            int ix = this.xMax;
            while (--ix >= this.xMin) {
                float x = this.X[ix];
                float xx = x * x;
                float Ex = this.EX[ix];
                float cxxx = axxx * xx * x;
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    float y = this.Y[iy];
                    float yy = y * y;
                    float Exy = Ex * this.EY[iy];
                    float cyyy = ayyy * yy * y;
                    float cxxy = axxy * xx * y;
                    float cxyy = axyy * x * yy;
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        float z = this.Z[iz];
                        float zz = z * z;
                        float czzz = azzz * zz * z;
                        float cxxz = axxz * xx * z;
                        float cxzz = axzz * x * zz;
                        float cyyz = ayyz * yy * z;
                        float cyzz = ayzz * y * zz;
                        float cxyz = axyz * x * y * z;
                        float[] fArray = this.voxelDataTemp[ix][iy];
                        int n = iz;
                        fArray[n] = fArray[n] + (cxxx + cyyy + czzz + cxyy + cxxy + cxxz + cxzz + cyzz + cyyz + cxyz) * Exy * this.EZ[iz];
                    }
                }
            }
        }
    }

    private void addData7F(int nGaussians) {
        if (this.thisAtom == null || this.isElectronDensity) {
            this.moCoeff += 7;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(nGaussians, 6);
        }
        float norm1 = (float)Math.pow(1056.818280307081, 0.25);
        float norm2 = (float)((double)norm1 / Math.sqrt(3.0));
        float norm3 = (float)((double)norm1 / Math.sqrt(15.0));
        float c0_xxz_yyz = (float)(3.0 / (2.0 * Math.sqrt(5.0)));
        float c1p_xzz = (float)Math.sqrt(1.2);
        float c1p_xxx = (float)Math.sqrt(0.375);
        float c1p_xyy = (float)Math.sqrt(0.075);
        float c1n_yzz = c1p_xzz;
        float c1n_yyy = c1p_xxx;
        float c1n_xxy = c1p_xyy;
        float c2p_xxz_yyz = (float)Math.sqrt(0.75);
        float c3p_xxx = (float)Math.sqrt(0.625);
        float c3p_xyy = 0.75f * (float)Math.sqrt(2.0);
        float c3n_yyy = c3p_xxx;
        float c3n_xxy = c3p_xyy;
        float m0 = this.moCoefficients[this.moCoeff++];
        float m1p = this.moCoefficients[this.moCoeff++];
        float m1n = this.moCoefficients[this.moCoeff++];
        float m2p = this.moCoefficients[this.moCoeff++];
        float m2n = this.moCoefficients[this.moCoeff++];
        float m3p = this.moCoefficients[this.moCoeff++];
        float m3n = this.moCoefficients[this.moCoeff++];
        for (int ig = 0; ig < nGaussians; ++ig) {
            float alpha = this.gaussians[this.gaussianPtr + ig][0];
            float c1 = this.gaussians[this.gaussianPtr + ig][1];
            float a = c1 * (float)Math.pow(alpha, 2.25);
            float af0 = a * m0;
            float af1p = a * m1p;
            float af1n = a * m1n;
            float af2p = a * m2p;
            float af2n = a * m2n;
            float af3p = a * m3p;
            float af3n = a * m3n;
            this.setE(this.EX, alpha);
            int ix = this.xMax;
            while (--ix >= this.xMin) {
                float x = this.X[ix];
                float xx = x * x;
                float eX = this.EX[ix];
                float cxxx = norm3 * x * xx;
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    float y = this.Y[iy];
                    float yy = y * y;
                    float eXY = eX * this.EY[iy];
                    float cyyy = norm3 * y * yy;
                    float cxyy = norm2 * x * yy;
                    float cxxy = norm2 * xx * y;
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        float z = this.Z[iz];
                        float zz = z * z;
                        float czzz = norm3 * z * zz;
                        float cxxz = norm2 * xx * z;
                        float cxzz = norm2 * x * zz;
                        float cyyz = norm2 * yy * z;
                        float cyzz = norm2 * y * zz;
                        float cxyz = norm1 * x * y * z;
                        float f0 = af0 * (czzz - c0_xxz_yyz * (cxxz + cyyz));
                        float f1p = af1p * (c1p_xzz * cxzz - c1p_xxx * cxxx - c1p_xyy * cxyy);
                        float f1n = af1n * (c1n_yzz * cyzz - c1n_yyy * cyyy - c1n_xxy * cxxy);
                        float f2p = af2p * (c2p_xxz_yyz * (cxxz - cyyz));
                        float f2n = af2n * cxyz;
                        float f3p = af3p * (c3p_xxx * cxxx - c3p_xyy * cxyy);
                        float f3n = af3n * (-c3n_yyy * cyyy + c3n_xxy * cxxy);
                        float[] fArray = this.voxelDataTemp[ix][iy];
                        int n = iz;
                        fArray[n] = fArray[n] + (f0 + f1p + f1n + f2p + f2n + f3p + f3n) * eXY * this.EZ[iz];
                    }
                }
            }
        }
    }

    private void processSlater(int slaterIndex) {
        float coef;
        int lastAtom = this.atomIndex;
        this.atomIndex = this.slaterInfo[slaterIndex][0];
        float minuszeta = -this.slaterData[slaterIndex][0];
        this.thisAtom = this.qmAtoms[this.atomIndex];
        if (this.thisAtom == null) {
            if (minuszeta <= 0.0f) {
                ++this.moCoeff;
            }
            return;
        }
        if (this.atomIndex != lastAtom) {
            this.thisAtom.setXYZ(true);
        }
        int a = this.slaterInfo[slaterIndex][1];
        int b = this.slaterInfo[slaterIndex][2];
        int c = this.slaterInfo[slaterIndex][3];
        int d = this.slaterInfo[slaterIndex][4];
        if (minuszeta > 0.0f) {
            minuszeta = -minuszeta;
            --this.moCoeff;
        }
        if ((coef = this.slaterData[slaterIndex][1] * this.moCoefficients[this.moCoeff++]) == 0.0f) {
            return;
        }
        if (a == -2 || b == -2) {
            int ix = this.xMax;
            while (--ix >= this.xMin) {
                float dx2 = this.X2[ix];
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    float dy2 = this.Y2[iy];
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        float dz2 = this.Z2[iz];
                        float r = (float)Math.sqrt(dx2 + dy2 + dz2);
                        float value = coef * (float)Math.exp(minuszeta * r) * ((a == -2 ? 2.0f * dz2 - dx2 : dx2) - dy2);
                        int i = d;
                        while (--i >= 0) {
                            value *= r;
                        }
                        float[] fArray = this.voxelDataTemp[ix][iy];
                        int n = iz;
                        fArray[n] = fArray[n] + value;
                    }
                }
            }
        } else {
            int ix = this.xMax;
            while (--ix >= this.xMin) {
                float dx = this.X[ix];
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    float dy = this.Y[iy];
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        float dz = this.Z[iz];
                        float r = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
                        float value = coef * (float)Math.exp(minuszeta * r);
                        int i = a;
                        while (--i >= 0) {
                            value *= dx;
                        }
                        i = b;
                        while (--i >= 0) {
                            value *= dy;
                        }
                        i = c;
                        while (--i >= 0) {
                            value *= dz;
                        }
                        i = d;
                        while (--i >= 0) {
                            value *= r;
                        }
                        float[] fArray = this.voxelDataTemp[ix][iy];
                        int n = iz;
                        fArray[n] = fArray[n] + value;
                    }
                }
            }
        }
        if (this.isElectronDensity) {
            this.setTemp();
        }
    }

    private void dumpInfo(int nGaussians, String info) {
        for (int ig = 0; ig < nGaussians; ++ig) {
            float alpha = this.gaussians[this.gaussianPtr + ig][0];
            float c1 = this.gaussians[this.gaussianPtr + ig][1];
            if (!Logger.debugging) continue;
            Logger.debug("Gaussian " + (ig + 1) + " alpha=" + alpha + " c=" + c1);
        }
        int n = info.length() / 2;
        if (Logger.debugging) {
            for (int i = 0; i < n; ++i) {
                Logger.debug("MO coeff " + info.substring(2 * i, 2 * i + 2) + " " + (this.moCoeff + i + 1) + " " + this.moCoefficients[this.moCoeff + i]);
            }
        }
    }

    private void dumpInfo(int nGaussians, int shell) {
        for (int ig = 0; ig < nGaussians; ++ig) {
            float alpha = this.gaussians[this.gaussianPtr + ig][0];
            float c1 = this.gaussians[this.gaussianPtr + ig][1];
            Logger.debug("Gaussian " + (ig + 1) + " alpha=" + alpha + " c=" + c1);
        }
        if (shell >= 0 && Logger.debugging) {
            String[] so = JmolConstants.getShellOrder(shell);
            for (int i = 0; i < so.length; ++i) {
                Logger.debug("MO coeff " + so[i] + " " + (this.moCoeff + i + 1) + " " + this.moCoefficients[this.moCoeff + i]);
            }
        }
    }
}

