/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.util.Logger;

abstract class QuantumCalculation {
    protected boolean doDebug = false;
    protected static final float bohr_per_angstrom = 1.8897161f;
    protected float[][][] voxelData;
    protected int xMin;
    protected int xMax;
    protected int yMin;
    protected int yMax;
    protected int zMin;
    protected int zMax;
    protected QMAtom[] qmAtoms;
    protected int atomIndex;
    protected QMAtom thisAtom;
    protected float[] xBohr;
    protected float[] yBohr;
    protected float[] zBohr;
    protected float[] originBohr = new float[3];
    protected float[] stepBohr = new float[3];
    protected int nX;
    protected int nY;
    protected int nZ;
    protected float[] X;
    protected float[] Y;
    protected float[] Z;
    protected float[] X2;
    protected float[] Y2;
    protected float[] Z2;
    protected float rangeBohr = 10.0f;

    QuantumCalculation() {
    }

    protected void initialize(int nX, int nY, int nZ) {
        this.nX = nX;
        this.nY = nY;
        this.nZ = nZ;
        this.xBohr = new float[nX];
        this.yBohr = new float[nY];
        this.zBohr = new float[nZ];
        this.X = new float[nX];
        this.Y = new float[nY];
        this.Z = new float[nZ];
        this.X2 = new float[nX];
        this.Y2 = new float[nY];
        this.Z2 = new float[nZ];
    }

    protected void setupCoordinates(float[] originXYZ, float[] stepsXYZ, BitSet bsSelected, Point3f[] atomCoordAngstroms) {
        int i = 3;
        while (--i >= 0) {
            this.originBohr[i] = originXYZ[i] * 1.8897161f;
            this.stepBohr[i] = stepsXYZ[i] * 1.8897161f;
        }
        this.setXYZBohr(this.xBohr, 0, this.nX);
        this.setXYZBohr(this.yBohr, 1, this.nY);
        this.setXYZBohr(this.zBohr, 2, this.nZ);
        this.qmAtoms = new QMAtom[atomCoordAngstroms.length];
        i = atomCoordAngstroms.length;
        while (--i >= 0) {
            if (bsSelected != null && !bsSelected.get(i)) continue;
            this.qmAtoms[i] = new QMAtom(atomCoordAngstroms[i], this.X, this.Y, this.Z, this.X2, this.Y2, this.Z2);
        }
        if (this.doDebug) {
            Logger.debug("QuantumCalculation:\n origin(Bohr)= " + this.originBohr[0] + " " + this.originBohr[1] + " " + this.originBohr[2] + "\n steps(Bohr)= " + this.stepBohr[0] + " " + this.stepBohr[1] + " " + this.stepBohr[2] + "\n counts= " + this.nX + " " + this.nY + " " + this.nZ);
        }
    }

    private void setXYZBohr(float[] bohr, int i, int n) {
        bohr[0] = this.originBohr[i];
        float inc = this.stepBohr[i];
        int j = 0;
        while (++j < n) {
            bohr[j] = bohr[j - 1] + inc;
        }
    }

    class QMAtom
    extends Point3f {
        private float[] myX;
        private float[] myY;
        private float[] myZ;
        private float[] myX2;
        private float[] myY2;
        private float[] myZ2;

        QMAtom(Point3f coordAngstroms, float[] X, float[] Y, float[] Z, float[] X2, float[] Y2, float[] Z2) {
            this.myX = X;
            this.myY = Y;
            this.myZ = Z;
            this.myX2 = X2;
            this.myY2 = Y2;
            this.myZ2 = Z2;
            this.set(coordAngstroms);
            this.scale(1.8897161f);
        }

        protected void setXYZ(boolean setMinMax) {
            try {
                int i;
                if (setMinMax) {
                    i = (int)Math.floor((this.x - QuantumCalculation.this.xBohr[0] - QuantumCalculation.this.rangeBohr) / QuantumCalculation.this.stepBohr[0]);
                    QuantumCalculation.this.xMin = i < 0 ? 0 : i;
                    i = (int)Math.floor(1.0f + (this.x - QuantumCalculation.this.xBohr[0] + QuantumCalculation.this.rangeBohr) / QuantumCalculation.this.stepBohr[0]);
                    QuantumCalculation.this.xMax = i >= QuantumCalculation.this.nX ? QuantumCalculation.this.nX : i + 1;
                    i = (int)Math.floor((this.y - QuantumCalculation.this.yBohr[0] - QuantumCalculation.this.rangeBohr) / QuantumCalculation.this.stepBohr[1]);
                    QuantumCalculation.this.yMin = i < 0 ? 0 : i;
                    i = (int)Math.floor(1.0f + (this.y - QuantumCalculation.this.yBohr[0] + QuantumCalculation.this.rangeBohr) / QuantumCalculation.this.stepBohr[1]);
                    QuantumCalculation.this.yMax = i >= QuantumCalculation.this.nY ? QuantumCalculation.this.nY : i + 1;
                    i = (int)Math.floor((this.z - QuantumCalculation.this.zBohr[0] - QuantumCalculation.this.rangeBohr) / QuantumCalculation.this.stepBohr[2]);
                    QuantumCalculation.this.zMin = i < 0 ? 0 : i;
                    i = (int)Math.floor(1.0f + (this.z - QuantumCalculation.this.zBohr[0] + QuantumCalculation.this.rangeBohr) / QuantumCalculation.this.stepBohr[2]);
                    QuantumCalculation.this.zMax = i >= QuantumCalculation.this.nZ ? QuantumCalculation.this.nZ : i + 1;
                }
                i = QuantumCalculation.this.xMax;
                while (--i >= QuantumCalculation.this.xMin) {
                    this.myX2[i] = this.myX[i] = QuantumCalculation.this.xBohr[i] - this.x;
                    int n = i;
                    this.myX2[n] = this.myX2[n] * this.myX[i];
                }
                i = QuantumCalculation.this.yMax;
                while (--i >= QuantumCalculation.this.yMin) {
                    this.myY2[i] = this.myY[i] = QuantumCalculation.this.yBohr[i] - this.y;
                    int n = i;
                    this.myY2[n] = this.myY2[n] * this.myY[i];
                }
                i = QuantumCalculation.this.zMax;
                while (--i >= QuantumCalculation.this.zMin) {
                    this.myZ2[i] = this.myZ[i] = QuantumCalculation.this.zBohr[i] - this.z;
                    int n = i;
                    this.myZ2[n] = this.myZ2[n] * this.myZ[i];
                }
            }
            catch (Exception e) {
                System.out.println("Error in QuantumCalculation setting bounds");
            }
        }
    }
}

