/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.Shape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.viewer.JmolConstants;

public abstract class AtomShape
extends Shape {
    public short[] mads;
    public short[] colixes;
    public byte[] paletteIDs;
    protected BitSet bsSizeSet;
    protected BitSet bsColixSet;
    public int atomCount;
    public Atom[] atoms;
    public boolean isActive;

    protected void initModelSet() {
        this.atoms = this.modelSet.atoms;
        this.atomCount = this.modelSet.getAtomCount();
        if (this.mads != null) {
            this.mads = ArrayUtil.setLength(this.mads, this.atomCount);
        }
        if (this.colixes != null) {
            this.colixes = ArrayUtil.setLength(this.colixes, this.atomCount);
        }
        if (this.paletteIDs != null) {
            this.paletteIDs = ArrayUtil.setLength(this.paletteIDs, this.atomCount);
        }
    }

    public void setSize(int size, BitSet bsSelected) {
        this.setSize(size, Float.NaN, bsSelected);
    }

    public void setSize(int size, float fsize, BitSet bsSelected) {
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        boolean isVisible = size != 0;
        int i = this.atomCount;
        while (--i >= 0) {
            if (bsSelected != null && !bsSelected.get(i)) continue;
            if (this.mads == null) {
                this.mads = new short[this.atomCount];
            }
            Atom atom = this.atoms[i];
            this.mads[i] = atom.convertEncodedMad(this.viewer, size, fsize);
            this.bsSizeSet.set(i, isVisible);
            atom.setShapeVisibility(this.myVisibilityFlag, isVisible);
        }
    }

    public void setProperty(String propertyName, Object value, BitSet bs) {
        if ("color" == propertyName) {
            this.isActive = true;
            short colix = Graphics3D.getColix(value);
            byte pid = JmolConstants.pidOf(value);
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                this.setColixAndPalette(colix, pid, i);
            }
            return;
        }
        if ("translucency" == propertyName) {
            this.isActive = true;
            boolean isTranslucent = value.equals("translucent");
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                if (this.colixes == null) {
                    this.colixes = new short[this.atomCount];
                    this.paletteIDs = new byte[this.atomCount];
                }
                this.colixes[i] = Graphics3D.getColixTranslucent(this.colixes[i], isTranslucent, this.translucentLevel);
                if (!isTranslucent) continue;
                this.bsColixSet.set(i);
            }
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            this.atoms = (Atom[])((Object[])value)[1];
            this.atomCount = this.modelSet.getAtomCount();
            int firstAtomDeleted = ((int[])((Object[])value)[2])[1];
            int nAtomsDeleted = ((int[])((Object[])value)[2])[2];
            this.mads = (short[])ArrayUtil.deleteElements(this.mads, firstAtomDeleted, nAtomsDeleted);
            this.colixes = (short[])ArrayUtil.deleteElements(this.colixes, firstAtomDeleted, nAtomsDeleted);
            this.paletteIDs = (byte[])ArrayUtil.deleteElements(this.paletteIDs, firstAtomDeleted, nAtomsDeleted);
            BitSetUtil.deleteBits(this.bsSizeSet, bs);
            BitSetUtil.deleteBits(this.bsColixSet, bs);
            return;
        }
        super.setProperty(propertyName, value, bs);
    }

    void setColixAndPalette(short colix, byte paletteID, int atomIndex) {
        if (this.colixes == null || atomIndex >= this.colixes.length) {
            if (colix == 0) {
                return;
            }
            this.colixes = ArrayUtil.ensureLength(this.colixes, atomIndex + 1);
            this.paletteIDs = ArrayUtil.ensureLength(this.paletteIDs, atomIndex + 1);
        }
        if (this.bsColixSet == null) {
            this.bsColixSet = new BitSet();
        }
        this.colixes[atomIndex] = colix = this.setColix(colix, paletteID, atomIndex);
        this.bsColixSet.set(atomIndex, colix != 0);
        this.paletteIDs[atomIndex] = paletteID;
    }

    public void setModelClickability() {
        if (!this.isActive) {
            return;
        }
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            if ((atom.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden(i)) continue;
            atom.setClickable(this.myVisibilityFlag);
        }
    }

    public String getShapeState() {
        if (!this.isActive) {
            return "";
        }
        Hashtable temp = new Hashtable();
        Hashtable temp2 = new Hashtable();
        String type = JmolConstants.shapeClassBases[this.shapeID];
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.bsSizeSet != null && this.bsSizeSet.get(i)) {
                AtomShape.setStateInfo(temp, i, type + " " + (float)this.mads[i] / 2000.0f);
            }
            if (this.bsColixSet == null || !this.bsColixSet.get(i)) continue;
            AtomShape.setStateInfo(temp2, i, this.getColorCommand(type, this.paletteIDs[i], this.colixes[i]));
        }
        return AtomShape.getShapeCommands(temp, temp2, this.atomCount);
    }
}

