/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.awt.FontMetrics;
import javax.vecmath.Point3f;
import org.jmol.api.SymmetryInterface;
import org.jmol.g3d.Font3D;
import org.jmol.shape.Axes;
import org.jmol.shape.FontLineShapeRenderer;

public class AxesRenderer
extends FontLineShapeRenderer {
    private static final String[] axisLabels = new String[]{"+X", "+Y", "+Z", null, null, null, "a", "b", "c", "X", "Y", "Z", null, null, null, "X", null, "Z", null, "(Y)", null};
    private final Point3f[] axisScreens = new Point3f[6];
    private final Point3f originScreen;
    private short[] colixes;

    public AxesRenderer() {
        int i = 6;
        while (--i >= 0) {
            this.axisScreens[i] = new Point3f();
        }
        this.originScreen = new Point3f();
        this.colixes = new short[3];
    }

    protected void render() {
        int widthPixels;
        Axes axes = (Axes)this.shape;
        int mad = this.viewer.getObjectMad(1);
        if (mad == 0 || !this.g3d.checkTranslucent(false)) {
            return;
        }
        int axesMode = this.viewer.getAxesMode();
        this.imageFontScaling = this.viewer.getImageFontScaling();
        if (this.viewer.areAxesTainted()) {
            axes.initShape();
        }
        int nPoints = 6;
        int labelPtr = 0;
        SymmetryInterface[] cellInfos = this.modelSet.getCellInfos();
        boolean isXY = axes.axisXY.z != 0.0f;
        int modelIndex = this.viewer.getDisplayModelIndex();
        if (this.viewer.isJmolDataFrame(modelIndex)) {
            return;
        }
        if (axesMode == 2 && cellInfos != null) {
            if (modelIndex < 0 || !cellInfos[modelIndex].haveUnitCell()) {
                return;
            }
            nPoints = 3;
            labelPtr = 6;
        } else if (isXY) {
            nPoints = 3;
            labelPtr = 9;
        } else if (axesMode == 0) {
            nPoints = 6;
            labelPtr = this.viewer.getAxesOrientationRasmol() ? 15 : 9;
        }
        boolean isDataFrame = this.viewer.isJmolDataFrame();
        int aFactor = this.g3d.isAntialiased() ? 2 : 1;
        int slab = this.g3d.getSlab();
        int n = widthPixels = mad < 20 ? mad * aFactor : Integer.MIN_VALUE;
        if (isXY) {
            if (widthPixels < 0) {
                widthPixels = (int)(mad > 500 ? 5.0f : (float)mad / 100.0f);
            }
            this.g3d.setSlab(0);
            this.pt0.set(this.viewer.transformPoint(axes.axisXY));
            this.originScreen.set(this.pt0.x, this.pt0.y, this.pt0.z);
            float zoomDimension = this.viewer.getScreenDim();
            float scaleFactor = zoomDimension / 10.0f * axes.scale;
            for (int i = 0; i < 3; ++i) {
                this.viewer.rotatePoint(axes.getAxisPoint(i, false), this.axisScreens[i]);
                this.axisScreens[i].z *= -1.0f;
                this.axisScreens[i].scaleAdd(scaleFactor, this.axisScreens[i], this.originScreen);
            }
        } else {
            this.viewer.transformPointNoClip(axes.getOriginPoint(isDataFrame), this.originScreen);
            if (widthPixels == Integer.MIN_VALUE) {
                widthPixels = this.viewer.scaleToScreen((int)this.originScreen.z, mad);
            }
            int i = nPoints;
            while (--i >= 0) {
                this.viewer.transformPointNoClip(axes.getAxisPoint(i, isDataFrame), this.axisScreens[i]);
            }
        }
        float xCenter = this.originScreen.x;
        float yCenter = this.originScreen.y;
        this.colixes[0] = this.viewer.getObjectColix(1);
        this.colixes[1] = this.viewer.getObjectColix(2);
        this.colixes[2] = this.viewer.getObjectColix(3);
        Font3D font = this.g3d.getFont3DScaled(axes.font3d, this.imageFontScaling);
        int i = nPoints;
        while (--i >= 0) {
            this.colix = this.colixes[i % 3];
            this.g3d.setColix(this.colix);
            String label = axisLabels[i + labelPtr];
            if (label != null) {
                this.renderLabel(label, font, this.axisScreens[i].x, this.axisScreens[i].y, this.axisScreens[i].z, xCenter, yCenter);
            }
            this.renderLine(this.originScreen, this.axisScreens[i], widthPixels, (byte)2, this.pt0, this.pt1);
        }
        if (nPoints == 3 && !isXY) {
            this.colix = this.viewer.getColixBackgroundContrast();
            this.g3d.setColix(this.colix);
            this.renderLabel("0", font, this.originScreen.x, this.originScreen.y, this.originScreen.z, xCenter, yCenter);
        }
        if (isXY) {
            this.g3d.setSlab(slab);
        }
    }

    private void renderLabel(String str, Font3D font3d, float x, float y, float z, float xCenter, float yCenter) {
        FontMetrics fontMetrics = font3d.fontMetrics;
        int strAscent = fontMetrics.getAscent();
        int strWidth = fontMetrics.stringWidth(str);
        float dx = x - xCenter;
        float dy = y - yCenter;
        if (dx != 0.0f || dy != 0.0f) {
            float dist = (float)Math.sqrt(dx * dx + dy * dy);
            dx = (float)strWidth * 0.75f * dx / dist;
            dy = (float)strAscent * 0.75f * dy / dist;
            x += dx;
            y += dy;
        }
        float xStrBaseline = x - (float)(strWidth / 2);
        float yStrBaseline = y + (float)(strAscent / 2);
        this.g3d.drawString(str, font3d, (int)xStrBaseline, (int)yStrBaseline, (int)z, (int)z);
    }
}

