/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.AtomShape;
import org.jmol.viewer.JmolConstants;

public class Balls
extends AtomShape {
    public void setSize(int size, float fsize, BitSet bsSelected) {
        int bsLength;
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        int i = bsLength = Math.min(this.atoms.length, bsSelected.length());
        while (--i >= 0) {
            if (!bsSelected.get(i)) continue;
            Atom atom = this.atoms[i];
            atom.setMadAtom(this.viewer, size, fsize);
            this.bsSizeSet.set(i);
        }
    }

    public void setProperty(String propertyName, Object value, BitSet bs) {
        if ("color" == propertyName) {
            short colix = Graphics3D.getColix(value);
            if (colix == 0) {
                colix = 2;
            }
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            byte pid = JmolConstants.pidOf(value);
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                Atom atom = this.atoms[i];
                atom.setColixAtom(this.setColix(colix, pid, atom));
                this.bsColixSet.set(i, colix != 2 || pid != 0);
                atom.setPaletteID(pid);
            }
            return;
        }
        if ("colorValues" == propertyName) {
            int[] values = (int[])value;
            if (values.length == 0) {
                return;
            }
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            int n = 0;
            Integer color = null;
            for (int i = 0; i < this.atomCount; ++i) {
                short colix;
                if (!bs.get(i)) continue;
                if (n >= values.length) {
                    return;
                }
                if ((colix = Graphics3D.getColix(color = new Integer(values[n++]))) == 0) {
                    colix = 2;
                }
                byte pid = JmolConstants.pidOf(color);
                Atom atom = this.atoms[i];
                atom.setColixAtom(this.setColix(colix, pid, atom));
                this.bsColixSet.set(i, colix != 2 || pid != 0);
                atom.setPaletteID(pid);
            }
            return;
        }
        if ("translucency" == propertyName) {
            boolean isTranslucent = ((String)value).equals("translucent");
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                this.atoms[i].setTranslucent(isTranslucent, this.translucentLevel);
                if (!isTranslucent) continue;
                this.bsColixSet.set(i);
            }
            return;
        }
        super.setProperty(propertyName, value, bs);
    }

    public void setModelClickability() {
        BitSet bs = this.viewer.getDeletedAtoms();
        if (bs == null) {
            bs = new BitSet();
        }
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            atom.setClickable(0);
            if (bs.get(i) || (atom.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden(i)) continue;
            atom.setClickable(this.myVisibilityFlag);
        }
    }

    public void setVisibilityFlags(BitSet bs) {
        int displayModelIndex = this.viewer.getDisplayModelIndex();
        boolean isOneFrame = displayModelIndex >= 0;
        boolean showHydrogens = this.viewer.getShowHydrogens();
        BitSet bsDeleted = this.viewer.getDeletedAtoms();
        if (bsDeleted == null) {
            bsDeleted = new BitSet();
        }
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            int flag = atom.getShapeVisibilityFlags();
            atom.setShapeVisibilityFlags(flag &= 0xFFFFFFFE & ~this.myVisibilityFlag);
            if (bsDeleted.get(i) || !showHydrogens && atom.getElementNumber() == 1) continue;
            int modelIndex = atom.getModelIndex();
            if ((isOneFrame || !bs.get(modelIndex)) && modelIndex != displayModelIndex) continue;
            atom.setShapeVisibility(1, true);
            if (atom.getMadAtom() == 0 || this.modelSet.isAtomHidden(i)) continue;
            atom.setShapeVisibility(this.myVisibilityFlag, true);
        }
    }

    public String getShapeState() {
        Hashtable temp = new Hashtable();
        float r = 0.0f;
        for (int i = 0; i < this.atomCount; ++i) {
            byte pid;
            if (this.bsSizeSet != null && this.bsSizeSet.get(i)) {
                float f;
                r = this.atoms[i].getMadAtom();
                if (f < 0.0f) {
                    Balls.setStateInfo(temp, i, "Spacefill on");
                } else {
                    Balls.setStateInfo(temp, i, "Spacefill " + r / 2000.0f);
                }
            }
            if (this.bsColixSet == null || !this.bsColixSet.get(i) || (pid = this.atoms[i].getPaletteID()) == 1 && !this.atoms[i].isTranslucent()) continue;
            Balls.setStateInfo(temp, i, this.getColorCommand("atoms", pid, this.atoms[i].getColix()));
        }
        return Balls.getShapeCommands(temp, null, this.atomCount);
    }
}

