/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.geodesic.EnvelopeCalculation;
import org.jmol.modelset.Atom;
import org.jmol.shape.AtomShape;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class Dots
extends AtomShape {
    public EnvelopeCalculation ec;
    public boolean isSurface = false;
    static final float SURFACE_DISTANCE_FOR_CALCULATION = 10.0f;
    BitSet bsOn = new BitSet();
    private BitSet bsSelected;
    private BitSet bsIgnore;
    static int MAX_LEVEL = 3;
    int thisAtom;
    float thisRadius;
    int thisArgb;
    int lastSize = 0;
    float lastSolventRadius = 0.0f;

    public void initShape() {
        super.initShape();
        this.translucentAllowed = false;
        this.ec = new EnvelopeCalculation(this.viewer, this.atomCount, this.mads);
    }

    public void setProperty(String propertyName, Object value, BitSet bs) {
        if (Logger.debugging) {
            Logger.debug("Dots.setProperty: " + propertyName + " " + value);
        }
        if ("init" == propertyName) {
            this.initialize();
            return;
        }
        if ("translucency" == propertyName && !this.translucentAllowed) {
            return;
        }
        if ("ignore" == propertyName) {
            this.bsIgnore = (BitSet)value;
            return;
        }
        if ("select" == propertyName) {
            this.bsSelected = (BitSet)value;
            return;
        }
        if ("radius" == propertyName) {
            this.thisRadius = ((Float)value).floatValue();
            if (this.thisRadius > 16.0f) {
                this.thisRadius = 16.0f;
            }
            return;
        }
        if ("colorRGB" == propertyName) {
            this.thisArgb = (Integer)value;
            return;
        }
        if ("atom" == propertyName) {
            this.thisAtom = (Integer)value;
            this.atoms[this.thisAtom].setShapeVisibility(this.myVisibilityFlag, true);
            this.ec.allocDotsConvexMaps(this.atomCount);
            return;
        }
        if ("dots" == propertyName) {
            this.isActive = true;
            this.ec.setFromBits(this.thisAtom, (BitSet)value);
            this.atoms[this.thisAtom].setShapeVisibility(this.myVisibilityFlag, true);
            if (this.mads == null) {
                this.ec.setMads(null);
                this.mads = new short[this.atomCount];
                for (int i = 0; i < this.atomCount; ++i) {
                    if (!this.atoms[i].isShapeVisible(this.myVisibilityFlag)) continue;
                    this.mads[i] = (short)(this.ec.getAppropriateRadius(i) * 1000.0f);
                }
                this.ec.setMads(this.mads);
            }
            this.mads[this.thisAtom] = (short)(this.thisRadius * 1000.0f);
            if (this.colixes == null) {
                this.colixes = new short[this.atomCount];
                this.paletteIDs = new byte[this.atomCount];
            }
            this.colixes[this.thisAtom] = Graphics3D.getColix(this.thisArgb);
            this.bsOn.set(this.thisAtom);
            return;
        }
        if ("refreshTrajectories" == propertyName) {
            this.bsSelected = null;
            this.setSize(0, bs);
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            int firstAtomDeleted = ((int[])((Object[])value)[2])[1];
            int nAtomsDeleted = ((int[])((Object[])value)[2])[2];
            BitSetUtil.deleteBits(this.bsOn, bs);
            this.ec.deleteAtoms(firstAtomDeleted, nAtomsDeleted, bs);
        }
        super.setProperty(propertyName, value, bs);
    }

    void initialize() {
        this.bsSelected = null;
        this.bsIgnore = null;
        this.isActive = false;
        if (this.ec == null) {
            this.ec = new EnvelopeCalculation(this.viewer, this.atomCount, this.mads);
        }
    }

    public void setSize(int size, float fsize, BitSet bsSelected) {
        int i;
        boolean newSet;
        if (this.bsSelected != null) {
            bsSelected = this.bsSelected;
        }
        if (Logger.debugging) {
            Logger.debug("Dots.setSize " + size);
        }
        boolean isVisible = true;
        float addRadius = Float.MAX_VALUE;
        float setRadius = Float.MAX_VALUE;
        boolean useVanderwaalsRadius = true;
        float scale = 1.0f;
        this.isActive = true;
        if (Float.isNaN(fsize)) {
            switch (size) {
                case 0: {
                    isVisible = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    if (size <= Short.MIN_VALUE) {
                        setRadius = -32768.0f;
                        if (size < Short.MIN_VALUE) {
                            scale = (float)(Short.MIN_VALUE - size) / 100.0f;
                            break;
                        }
                    } else {
                        if (size < 0) {
                            useVanderwaalsRadius = false;
                            break;
                        }
                        if (size <= 1001) {
                            scale = (float)(size - 1) / 100.0f;
                            break;
                        }
                        if (size <= 11002) {
                            useVanderwaalsRadius = false;
                            setRadius = (float)(size - 1002) / 1000.0f;
                            break;
                        }
                        if (size <= 13002) {
                            addRadius = (float)(size - 11002) / 1000.0f;
                            scale = 1.0f;
                            break;
                        }
                        if (size >= Short.MAX_VALUE) {
                            setRadius = 32767.0f;
                            if (size > Short.MAX_VALUE) {
                                scale = (float)(size - Short.MAX_VALUE) / 100.0f;
                                break;
                            } else {
                                break;
                            }
                        } else {
                            break;
                        }
                    }
                }
            }
        } else if (size == 1) {
            addRadius = fsize;
        } else {
            useVanderwaalsRadius = false;
            setRadius = fsize;
        }
        float maxRadius = !useVanderwaalsRadius ? setRadius : this.modelSet.getMaxVanderwaalsRadius();
        float solventRadius = this.viewer.getCurrentSolventProbeRadius();
        if (addRadius == Float.MAX_VALUE) {
            float f = addRadius = solventRadius != 0.0f ? solventRadius : 0.0f;
        }
        if (Logger.debugging) {
            Logger.startTimer();
        }
        boolean bl = newSet = this.lastSolventRadius != addRadius || size != 0 && size != this.lastSize || this.ec.getDotsConvexMax() == 0;
        if (isVisible) {
            i = this.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i) || this.bsOn.get(i)) continue;
                this.bsOn.set(i);
                newSet = true;
            }
        } else {
            i = this.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.bsOn.set(i, false);
            }
        }
        i = this.atomCount;
        while (--i >= 0) {
            this.atoms[i].setShapeVisibility(this.myVisibilityFlag, this.bsOn.get(i));
        }
        if (newSet) {
            this.mads = null;
            this.ec.newSet();
            this.lastSolventRadius = addRadius;
        }
        int[][] dotsConvexMaps = this.ec.getDotsConvexMaps();
        if (isVisible && dotsConvexMaps != null) {
            int i2 = this.atomCount;
            while (--i2 >= 0) {
                if (!this.bsOn.get(i2)) continue;
                dotsConvexMaps[i2] = null;
            }
        }
        if (isVisible) {
            this.lastSize = size;
            if (dotsConvexMaps == null) {
                this.colixes = new short[this.atomCount];
                this.paletteIDs = new byte[this.atomCount];
            }
            boolean disregardNeighbors = !this.viewer.getDotSurfaceFlag();
            boolean onlySelectedDots = this.viewer.getDotsSelectedOnlyFlag();
            this.ec.calculate(addRadius, setRadius, scale, maxRadius, this.bsOn, this.bsIgnore, useVanderwaalsRadius, disregardNeighbors, onlySelectedDots, this.isSurface, true);
        }
        if (Logger.debugging) {
            Logger.checkTimer("dots generation time");
        }
    }

    public void setModelClickability() {
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            if ((atom.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden(i)) continue;
            atom.setClickable(this.myVisibilityFlag);
        }
    }

    public String getShapeState() {
        int[][] dotsConvexMaps = this.ec.getDotsConvexMaps();
        if (dotsConvexMaps == null || this.ec.getDotsConvexMax() == 0) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        Hashtable temp = new Hashtable();
        int atomCount = this.viewer.getAtomCount();
        String type = this.isSurface ? "geoSurface " : "dots ";
        for (int i = 0; i < atomCount; ++i) {
            if (dotsConvexMaps[i] == null || !this.bsOn.get(i)) continue;
            if (this.bsColixSet != null && this.bsColixSet.get(i)) {
                Dots.setStateInfo(temp, i, this.getColorCommand(type, this.paletteIDs[i], this.colixes[i]));
            }
            BitSet bs = new BitSet();
            int[] map = dotsConvexMaps[i];
            int iDot = map.length << 5;
            int n = 0;
            while (--iDot >= 0) {
                if (!EnvelopeCalculation.getBit(map, iDot)) continue;
                ++n;
                bs.set(iDot);
            }
            if (n <= 0) continue;
            float r = this.ec.getAppropriateRadius(i);
            Dots.appendCmd(s, type + i + " radius " + r + " " + Escape.escape(bs));
        }
        s.append(Dots.getShapeCommands(temp, null, atomCount));
        return s.toString();
    }
}

