/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.geodesic.EnvelopeCalculation;
import org.jmol.geodesic.Geodesic;
import org.jmol.modelset.Atom;
import org.jmol.shape.Dots;
import org.jmol.shape.ShapeRenderer;

public class DotsRenderer
extends ShapeRenderer {
    public boolean iShowSolid;
    Vector3f[] verticesTransformed;
    public int screenLevel;
    public int screenDotCount;
    public int[] screenCoordinates;
    public int[] faceMap = null;

    protected void initRenderer() {
        this.screenLevel = Dots.MAX_LEVEL;
        this.screenDotCount = Geodesic.getVertexCount(Dots.MAX_LEVEL);
        this.verticesTransformed = new Vector3f[this.screenDotCount];
        int i = this.screenDotCount;
        while (--i >= 0) {
            this.verticesTransformed[i] = new Vector3f();
        }
        this.screenCoordinates = new int[3 * this.screenDotCount];
    }

    protected void render() {
        Dots dots = (Dots)this.shape;
        this.render1(dots);
    }

    protected void render1(Dots dots) {
        if (!this.iShowSolid && !this.g3d.setColix((short)4)) {
            return;
        }
        int sppa = (int)this.viewer.getScalePixelsPerAngstrom(true);
        int n = this.iShowSolid || sppa > 20 ? 3 : (sppa > 10 ? 2 : (this.screenLevel = sppa > 5 ? 1 : 0));
        if (!this.iShowSolid) {
            this.screenLevel += this.viewer.getDotDensity() - 3;
            this.screenLevel = Math.max(Math.min(this.screenLevel, 3), 0);
        }
        int i = this.screenDotCount = Geodesic.getVertexCount(this.screenLevel);
        while (--i >= 0) {
            this.viewer.transformVector(Geodesic.getVertexVector(i), this.verticesTransformed[i]);
        }
        int[][] maps = dots.ec.getDotsConvexMaps();
        int i2 = dots.ec.getDotsConvexMax();
        while (--i2 >= 0) {
            int nPoints;
            Atom atom = this.modelSet.atoms[i2];
            int[] map = maps[i2];
            if (map == null || !atom.isShapeVisible(this.myVisibilityFlag) || this.modelSet.isAtomHidden(i2) || !this.g3d.isInDisplayRange(atom.screenX, atom.screenY) || (nPoints = this.calcScreenPoints(map, dots.ec.getAppropriateRadius(i2), atom.screenX, atom.screenY, atom.screenZ)) == 0) continue;
            this.renderConvex(Graphics3D.getColixInherited(dots.colixes[i2], atom.getColix()), map, nPoints);
        }
    }

    private int calcScreenPoints(int[] visibilityMap, float radius, int x, int y, int z) {
        int nPoints = 0;
        int i = 0;
        float scaledRadius = this.viewer.scaleToPerspective(z, radius);
        int iDot = Math.min(visibilityMap.length << 5, this.screenDotCount);
        while (--iDot >= 0) {
            if (!EnvelopeCalculation.getBit(visibilityMap, iDot)) continue;
            Vector3f vertex = this.verticesTransformed[iDot];
            if (this.faceMap != null) {
                this.faceMap[iDot] = i;
            }
            this.screenCoordinates[i++] = x + (int)((double)(scaledRadius * vertex.x) + (vertex.x < 0.0f ? -0.5 : 0.5));
            this.screenCoordinates[i++] = y + (int)((double)(scaledRadius * vertex.y) + (vertex.y < 0.0f ? -0.5 : 0.5));
            this.screenCoordinates[i++] = z + (int)((double)(scaledRadius * vertex.z) + (vertex.z < 0.0f ? -0.5 : 0.5));
            ++nPoints;
        }
        return nPoints;
    }

    protected void renderConvex(short colix, int[] map, int nPoints) {
        this.colix = Graphics3D.getColixTranslucent(colix, false, 0.0f);
        this.renderDots(nPoints);
    }

    protected void renderDots(int nPoints) {
        this.g3d.setColix(this.colix);
        this.g3d.drawPoints(nPoints, this.screenCoordinates);
    }
}

