/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.awt.Image;
import java.util.BitSet;
import java.util.Enumeration;
import org.jmol.shape.Object2d;
import org.jmol.shape.Text;
import org.jmol.shape.TextShape;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

public class Echo
extends TextShape {
    private static final String FONTFACE = "Serif";
    private static final int FONTSIZE = 20;
    private static final short COLOR = 10;

    public void initShape() {
        super.initShape();
        this.setProperty("target", "top", null);
    }

    public void setProperty(String propertyName, Object value, BitSet bsSelected) {
        if (Logger.debugging) {
            Logger.debug("Echo.setProperty(" + propertyName + "," + value + ")");
        }
        if ("scalereference" == propertyName) {
            if (this.currentObject != null) {
                float val = ((Float)value).floatValue();
                this.currentObject.setScalePixelsPerMicron(val == 0.0f ? 0.0f : 10000.0f / val);
            }
            return;
        }
        if ("xyz" == propertyName && this.currentObject != null && this.viewer.getFontScaling()) {
            this.currentObject.setScalePixelsPerMicron(this.viewer.getScalePixelsPerAngstrom(false) * 10000.0f);
        }
        if ("image" == propertyName) {
            Image image = (Image)value;
            if (this.currentObject == null) {
                if (this.isAll) {
                    Enumeration e = this.objects.elements();
                    while (e.hasMoreElements()) {
                        ((Text)e.nextElement()).setImage(image);
                    }
                }
                return;
            }
            ((Text)this.currentObject).setImage(image);
            return;
        }
        if ("thisID" == propertyName) {
            String target = (String)value;
            this.currentObject = (Text)this.objects.get(target);
            if (this.currentObject == null && TextFormat.isWild(target)) {
                this.thisID = target.toUpperCase();
            }
            return;
        }
        if ("hidden" == propertyName) {
            boolean isHidden = (Boolean)value;
            if (this.currentObject == null) {
                if (this.isAll || this.thisID != null) {
                    Enumeration e = this.objects.elements();
                    while (e.hasMoreElements()) {
                        Text text = (Text)e.nextElement();
                        if (!this.isAll && !TextFormat.isMatch(text.target.toUpperCase(), this.thisID, true, true)) continue;
                        text.hidden = isHidden;
                    }
                }
                return;
            }
            ((Text)this.currentObject).hidden = isHidden;
            return;
        }
        if (Object2d.setProperty(propertyName, value, this.currentObject)) {
            return;
        }
        if ("target" == propertyName) {
            this.thisID = null;
            String target = ((String)value).intern().toLowerCase();
            if (target != "none" && target != "all") {
                Text text = (Text)this.objects.get(target);
                if (text == null) {
                    int valign = 0;
                    int halign = 1;
                    if ("top" == target) {
                        valign = 1;
                        halign = 2;
                    } else if ("middle" == target) {
                        valign = 3;
                        halign = 2;
                    } else if ("bottom" == target) {
                        valign = 2;
                    }
                    text = new Text(this.viewer, this.g3d, this.g3d.getFont3D(FONTFACE, 20.0f), target, 10, valign, halign, 0.0f);
                    text.setAdjustForWindow(true);
                    this.objects.put(target, text);
                    if (this.currentFont != null) {
                        text.setFont(this.currentFont);
                    }
                    if (this.currentColor != null) {
                        text.setColix(this.currentColor);
                    }
                    if (this.currentBgColor != null) {
                        text.setBgColix(this.currentBgColor);
                    }
                    if (this.currentTranslucentLevel != 0.0f) {
                        text.setTranslucent(this.currentTranslucentLevel, false);
                    }
                    if (this.currentBgTranslucentLevel != 0.0f) {
                        text.setTranslucent(this.currentBgTranslucentLevel, true);
                    }
                }
                this.currentObject = text;
                return;
            }
        }
        super.setProperty(propertyName, value, null);
    }

    public Object getProperty(String property, int index) {
        if (property.startsWith("checkID:")) {
            String key = property.substring(8).toUpperCase();
            boolean isWild = TextFormat.isWild(key);
            Enumeration e = this.objects.elements();
            while (e.hasMoreElements()) {
                String id = ((Text)e.nextElement()).target.toUpperCase();
                if (!id.equals(key) && (!isWild || !TextFormat.isMatch(id, key, true, true))) continue;
                return id;
            }
        }
        return null;
    }

    public String getShapeState() {
        StringBuffer s = new StringBuffer("\n  set echo off;\n");
        Enumeration e = this.objects.elements();
        while (e.hasMoreElements()) {
            Text t = (Text)e.nextElement();
            s.append(t.getState());
            if (!t.hidden) continue;
            s.append("  set echo " + t.target + " hidden;\n");
        }
        return s.toString();
    }
}

