/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.Enumeration;
import javax.vecmath.Point3i;
import org.jmol.modelset.Atom;
import org.jmol.shape.Echo;
import org.jmol.shape.ShapeRenderer;
import org.jmol.shape.Text;

public class EchoRenderer
extends ShapeRenderer {
    float imageFontScaling;
    Atom ptAtom;
    Point3i pt = new Point3i();

    protected void render() {
        Echo echo = (Echo)this.shape;
        Enumeration e = echo.objects.elements();
        float scalePixelsPerMicron = this.viewer.getFontScaling() ? this.viewer.getScalePixelsPerAngstrom(true) * 10000.0f : 0.0f;
        this.imageFontScaling = this.viewer.getImageFontScaling();
        while (e.hasMoreElements()) {
            Text t = (Text)e.nextElement();
            if (!t.visible || t.hidden) continue;
            if (t.valign == 4) {
                this.viewer.transformPoint(t.xyz, this.pt);
                t.setXYZs(this.pt.x, this.pt.y, this.pt.z, this.pt.z);
            } else if (t.movableZPercent != Integer.MAX_VALUE) {
                int z = this.viewer.zValueFromPercent(t.movableZPercent);
                t.setZs(z, z);
            }
            t.render(this.g3d, scalePixelsPerMicron, this.imageFontScaling);
        }
        String frameTitle = this.viewer.getFrameTitle();
        if (frameTitle != null && frameTitle.length() > 0) {
            this.renderFrameTitle(frameTitle);
        }
    }

    private void renderFrameTitle(String frameTitle) {
        if (this.isGenerator || !this.g3d.setColix(this.viewer.getColixBackgroundContrast())) {
            return;
        }
        byte fid = this.g3d.getFontFid("Monospaced", 14.0f * this.imageFontScaling);
        this.g3d.setFont(fid);
        int y = (int)((float)(this.viewer.getScreenHeight() * (this.g3d.isAntialiased() ? 2 : 1)) - 10.0f * this.imageFontScaling);
        int x = (int)(5.0f * this.imageFontScaling);
        this.g3d.drawStringNoSlab(frameTitle, null, x, y, 0);
    }
}

