/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import org.jmol.modelset.Atom;
import org.jmol.modelset.LabelToken;
import org.jmol.shape.Hover;
import org.jmol.shape.ShapeRenderer;
import org.jmol.shape.Text;

public class HoverRenderer
extends ShapeRenderer {
    protected void render() {
        if (this.viewer.getNavigating()) {
            return;
        }
        Hover hover = (Hover)this.shape;
        boolean antialias = this.g3d.isAntialiased();
        if (hover.atomIndex >= 0) {
            String label;
            Atom atom = this.modelSet.getAtomAt(hover.atomIndex);
            String string = hover.atomFormats != null && hover.atomFormats[hover.atomIndex] != null ? LabelToken.formatLabel(atom, hover.atomFormats[hover.atomIndex]) : (label = hover.labelFormat != null ? LabelToken.formatLabel(atom, this.fixLabel(atom, hover.labelFormat)) : null);
            if (label == null) {
                return;
            }
            Text text = hover.hoverText;
            text.setText(label);
            text.setXY(atom.screenX, atom.screenY);
            text.render(this.g3d, 0.0f, antialias ? 2.0f : 1.0f);
        } else if (hover.text != null) {
            Text text = hover.hoverText;
            text.setText(hover.text);
            text.setXY(hover.xy.x, hover.xy.y);
            text.render(this.g3d, 0.0f, antialias ? 2.0f : 1.0f);
        }
    }

    String fixLabel(Atom atom, String label) {
        if (label == null) {
            return null;
        }
        return this.viewer.isJmolDataFrame(atom.getModelIndex()) && label.equals("%U") ? "%W" : label;
    }
}

