/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.LabelToken;
import org.jmol.shape.AtomShape;
import org.jmol.shape.Object2d;
import org.jmol.shape.Text;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.viewer.JmolConstants;

public class Labels
extends AtomShape {
    String[] strings;
    String[] formats;
    short[] bgcolixes;
    byte[] fids;
    int[] offsets;
    private Hashtable atomLabels = new Hashtable();
    private Text text;
    private BitSet bsFontSet;
    private BitSet bsBgColixSet;
    private int defaultOffset;
    private int defaultAlignment;
    private int defaultZPos;
    private byte defaultFontId;
    private short defaultColix;
    private short defaultBgcolix;
    private byte defaultPaletteID;
    private int defaultPointer;
    private int zeroOffset;
    byte zeroFontId;
    private boolean defaultsOnlyForNone = true;
    private boolean setDefaults = false;
    static final int POINTER_FLAGS = 3;
    static final int ALIGN_FLAGS = 12;
    static final int ZPOS_FLAGS = 48;
    static final int GROUP_FLAG = 16;
    static final int FRONT_FLAG = 32;
    static final int SCALE_FLAG = 64;
    static final int FLAGS = 255;
    static final int FLAG_OFFSET = 8;

    public void initShape() {
        super.initShape();
        this.defaultFontId = this.zeroFontId = this.g3d.getFont3D((String)"SansSerif", (String)"Plain", (float)13.0f).fid;
        this.defaultColix = 0;
        this.defaultBgcolix = 0;
        this.zeroOffset = 1028;
        this.defaultOffset = 1028;
        this.defaultZPos = 0;
        this.translucentAllowed = false;
    }

    public void setProperty(String propertyName, Object value, BitSet bsSelected) {
        this.isActive = true;
        if ("setDefaults" == propertyName) {
            this.setDefaults = (Boolean)value;
            return;
        }
        if ("color" == propertyName) {
            this.isActive = true;
            byte pid = JmolConstants.pidOf(value);
            short colix = Graphics3D.getColix(value);
            if (!this.setDefaults) {
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!bsSelected.get(i)) continue;
                    this.setColix(i, colix, pid);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultColix = colix;
                this.defaultPaletteID = pid;
            }
            return;
        }
        if ("scalereference" == propertyName) {
            if (this.strings == null) {
                return;
            }
            float val = ((Float)value).floatValue();
            float scalePixelsPerMicron = val == 0.0f ? 0.0f : 10000.0f / val;
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i) || this.strings.length <= i) continue;
                this.text = this.getLabel(i);
                if (this.text == null) {
                    this.text = new Text(this.g3d, null, this.strings[i], 0, 0, 0, 0, 0, 0, 0, scalePixelsPerMicron);
                    this.putLabel(i, this.text);
                    continue;
                }
                this.text.setScalePixelsPerMicron(scalePixelsPerMicron);
            }
            return;
        }
        if ("label" == propertyName) {
            this.setLabel((String)value, bsSelected);
            return;
        }
        if ("translucency" == propertyName || "bgtranslucency" == propertyName) {
            return;
        }
        if ("bgcolor" == propertyName) {
            this.isActive = true;
            if (this.bsBgColixSet == null) {
                this.bsBgColixSet = new BitSet();
            }
            short bgcolix = Graphics3D.getColix(value);
            if (!this.setDefaults) {
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!bsSelected.get(i)) continue;
                    this.setBgcolix(i, bgcolix);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultBgcolix = bgcolix;
            }
            return;
        }
        if (this.bsFontSet == null) {
            this.bsFontSet = new BitSet();
        }
        if ("fontsize" == propertyName) {
            int fontsize = (Integer)value;
            if (fontsize < 0) {
                this.fids = null;
                return;
            }
            byte fid = this.g3d.getFontFid(fontsize);
            if (!this.setDefaults) {
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!bsSelected.get(i)) continue;
                    this.setFont(i, fid);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultFontId = fid;
            }
            return;
        }
        if ("font" == propertyName) {
            byte fid = ((Font3D)value).fid;
            if (!this.setDefaults) {
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!bsSelected.get(i)) continue;
                    this.setFont(i, fid);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultFontId = fid;
            }
            return;
        }
        if ("offset" == propertyName) {
            int offset = (Integer)value;
            if (offset == 0) {
                offset = Short.MAX_VALUE;
            } else if (offset == this.zeroOffset) {
                offset = 0;
            }
            if (!this.setDefaults) {
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!bsSelected.get(i)) continue;
                    this.setOffsets(i, offset);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultOffset = offset;
            }
            return;
        }
        if ("align" == propertyName) {
            String type = (String)value;
            int alignment = 1;
            if (type.equalsIgnoreCase("right")) {
                alignment = 3;
            } else if (type.equalsIgnoreCase("center")) {
                alignment = 2;
            }
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.setAlignment(i, alignment);
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultAlignment = alignment;
            }
            return;
        }
        if ("pointer" == propertyName) {
            int pointer = (Integer)value;
            if (!this.setDefaults) {
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!bsSelected.get(i)) continue;
                    this.setPointer(i, pointer);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultPointer = pointer;
            }
            return;
        }
        if ("front" == propertyName) {
            boolean TF = (Boolean)value;
            if (!this.setDefaults) {
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!bsSelected.get(i)) continue;
                    this.setFront(i, TF);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultZPos = TF ? 32 : 0;
            }
            return;
        }
        if ("group" == propertyName) {
            boolean TF = (Boolean)value;
            if (!this.setDefaults) {
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!bsSelected.get(i)) continue;
                    this.setGroup(i, TF);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultZPos = TF ? 16 : 0;
            }
            return;
        }
        if ("toggleLabel" == propertyName) {
            int atomIndex = this.atomCount;
            while (--atomIndex >= 0) {
                if (!bsSelected.get(atomIndex)) continue;
                Atom atom = this.atoms[atomIndex];
                if (this.formats == null || atomIndex >= this.formats.length) {
                    this.formats = ArrayUtil.ensureLength(this.formats, atomIndex + 1);
                }
                if (this.strings != null && this.strings.length > atomIndex && this.strings[atomIndex] != null) {
                    this.strings[atomIndex] = null;
                    this.formats[atomIndex] = null;
                    this.bsSizeSet.clear(atomIndex);
                } else {
                    String strLabel = this.viewer.getStandardLabelFormat();
                    this.strings = ArrayUtil.ensureLength(this.strings, atomIndex + 1);
                    this.strings[atomIndex] = LabelToken.formatLabel(atom, strLabel);
                    this.formats[atomIndex] = strLabel;
                    this.bsSizeSet.set(atomIndex);
                    if (!(this.bsBgColixSet != null && this.bsBgColixSet.get(atomIndex) || this.defaultBgcolix == 0)) {
                        this.setBgcolix(atomIndex, this.defaultBgcolix);
                    }
                }
                atom.setShapeVisibility(this.myVisibilityFlag, this.strings != null && atomIndex < this.strings.length && this.strings[atomIndex] != null);
            }
            return;
        }
        if (propertyName.startsWith("label:")) {
            this.setLabel(propertyName.substring(6), (Integer)value);
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            int firstAtomDeleted = ((int[])((Object[])value)[2])[1];
            int nAtomsDeleted = ((int[])((Object[])value)[2])[2];
            this.fids = (byte[])ArrayUtil.deleteElements(this.fids, firstAtomDeleted, nAtomsDeleted);
            this.bgcolixes = (short[])ArrayUtil.deleteElements(this.bgcolixes, firstAtomDeleted, nAtomsDeleted);
            this.offsets = (int[])ArrayUtil.deleteElements(this.offsets, firstAtomDeleted, nAtomsDeleted);
            this.formats = (String[])ArrayUtil.deleteElements(this.formats, firstAtomDeleted, nAtomsDeleted);
            this.strings = (String[])ArrayUtil.deleteElements(this.strings, firstAtomDeleted, nAtomsDeleted);
            BitSetUtil.deleteBits(this.bsFontSet, bsSelected);
            BitSetUtil.deleteBits(this.bsBgColixSet, bsSelected);
        }
        super.setProperty(propertyName, value, bsSelected);
    }

    private void setLabel(String value, BitSet bsSelected) {
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        String strLabel = value;
        boolean isScaled = this.viewer.getFontScaling();
        float scalePixelsPerMicron = isScaled ? this.viewer.getScalePixelsPerAngstrom(false) * 10000.0f : 0.0f;
        int i = this.atomCount;
        while (--i >= 0) {
            if (!bsSelected.get(i)) continue;
            this.setLabel(strLabel, i, isScaled, scalePixelsPerMicron);
        }
    }

    private void setLabel(String value, int i) {
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        String strLabel = value;
        boolean isScaled = this.viewer.getFontScaling();
        float scalePixelsPerMicron = isScaled ? this.viewer.getScalePixelsPerAngstrom(false) * 10000.0f : 0.0f;
        this.setLabel(strLabel, i, isScaled, scalePixelsPerMicron);
    }

    private void setLabel(String strLabel, int i, boolean isScaled, float scalePixelsPerMicron) {
        Atom atom;
        String label = LabelToken.formatLabel(atom = this.atoms[i], strLabel);
        atom.setShapeVisibility(this.myVisibilityFlag, label != null);
        if (this.strings == null || i >= this.strings.length) {
            this.strings = ArrayUtil.ensureLength(this.strings, i + 1);
        }
        if (this.formats == null || i >= this.formats.length) {
            this.formats = ArrayUtil.ensureLength(this.formats, i + 1);
        }
        this.strings[i] = label;
        this.formats[i] = strLabel;
        this.bsSizeSet.set(i, strLabel != null);
        this.text = this.getLabel(i);
        if (isScaled) {
            this.text = new Text(this.g3d, null, label, 0, 0, 0, 0, 0, 0, 0, scalePixelsPerMicron);
            this.putLabel(i, this.text);
        } else if (this.text != null) {
            this.text.setText(label);
        }
        if (this.defaultOffset != this.zeroOffset) {
            this.setOffsets(i, this.defaultOffset);
        }
        if (this.defaultAlignment != 1) {
            this.setAlignment(i, this.defaultAlignment);
        }
        if ((this.defaultZPos & 0x20) != 0) {
            this.setFront(i, true);
        } else if ((this.defaultZPos & 0x10) != 0) {
            this.setGroup(i, true);
        }
        if (this.defaultPointer != 0) {
            this.setPointer(i, this.defaultPointer);
        }
        if (this.defaultColix != 0 || this.defaultPaletteID != 0) {
            this.setColix(i, this.defaultColix, this.defaultPaletteID);
        }
        if (this.defaultBgcolix != 0) {
            this.setBgcolix(i, this.defaultBgcolix);
        }
        if (this.defaultFontId != this.zeroFontId) {
            this.setFont(i, this.defaultFontId);
        }
    }

    public Object getProperty(String property, int index) {
        if (property.equals("defaultState")) {
            return this.getDefaultState();
        }
        if (property.equals("label")) {
            return this.strings != null && index < this.strings.length && this.strings[index] != null ? this.strings[index] : "";
        }
        return null;
    }

    void putLabel(int i, Text text) {
        if (text == null) {
            this.atomLabels.remove(this.atoms[i]);
        } else {
            this.atomLabels.put(this.atoms[i], text);
        }
    }

    Text getLabel(int i) {
        return (Text)this.atomLabels.get(this.atoms[i]);
    }

    private void setColix(int i, short colix, byte pid) {
        this.setColixAndPalette(colix, pid, i);
        this.text = this.getLabel(i);
        if (this.text != null) {
            this.text.setColix(this.colixes[i]);
        }
    }

    private void setBgcolix(int i, short bgcolix) {
        if (this.bgcolixes == null || i >= this.bgcolixes.length) {
            if (bgcolix == 0) {
                return;
            }
            this.bgcolixes = ArrayUtil.ensureLength(this.bgcolixes, i + 1);
        }
        this.bgcolixes[i] = bgcolix;
        this.bsBgColixSet.set(i, bgcolix != 0);
        this.text = this.getLabel(i);
        if (this.text != null) {
            this.text.setBgColix(bgcolix);
        }
    }

    private void setOffsets(int i, int offset) {
        if (this.offsets == null || i >= this.offsets.length) {
            if (offset == 0) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength(this.offsets, i + 1);
        }
        this.offsets[i] = this.offsets[i] & 0xFF | offset << 8;
        this.text = this.getLabel(i);
        if (this.text != null) {
            this.text.setOffset(offset);
        }
    }

    private void setAlignment(int i, int alignment) {
        if (this.offsets == null || i >= this.offsets.length) {
            if (alignment == 1) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength(this.offsets, i + 1);
        }
        this.offsets[i] = this.offsets[i] & 0xFFFFFFF3 | alignment << 2;
        this.text = this.getLabel(i);
        if (this.text != null) {
            this.text.setAlignment(alignment);
        }
    }

    static int getAlignment(int offsetFull) {
        return (offsetFull & 0xC) >> 2;
    }

    private void setPointer(int i, int pointer) {
        if (this.offsets == null || i >= this.offsets.length) {
            if (pointer == 0) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength(this.offsets, i + 1);
        }
        this.offsets[i] = (this.offsets[i] & 0xFFFFFFFC) + pointer;
        this.text = this.getLabel(i);
        if (this.text != null) {
            this.text.setPointer(pointer);
        }
    }

    private void setFront(int i, boolean TF) {
        if (this.offsets == null || i >= this.offsets.length) {
            if (!TF) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength(this.offsets, i + 1);
        }
        this.offsets[i] = (this.offsets[i] & 0xFFFFFFCF) + (TF ? 32 : 0);
    }

    private void setGroup(int i, boolean TF) {
        if (this.offsets == null || i >= this.offsets.length) {
            if (!TF) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength(this.offsets, i + 1);
        }
        this.offsets[i] = (this.offsets[i] & 0xFFFFFFCF) + (TF ? 16 : 0);
    }

    private void setFont(int i, byte fid) {
        if (this.fids == null || i >= this.fids.length) {
            if (fid == this.zeroFontId) {
                return;
            }
            this.fids = ArrayUtil.ensureLength(this.fids, i + 1);
        }
        this.fids[i] = fid;
        this.bsFontSet.set(i);
        this.text = this.getLabel(i);
        if (this.text != null) {
            this.text.setFid(fid);
        }
    }

    public void setModelClickability() {
        if (this.strings == null) {
            return;
        }
        int i = this.strings.length;
        while (--i >= 0) {
            String label = this.strings[i];
            if (label == null || this.modelSet.atoms.length <= i || this.modelSet.isAtomHidden(i)) continue;
            this.modelSet.atoms[i].setClickable(this.myVisibilityFlag);
        }
    }

    private String getDefaultState() {
        StringBuffer s = new StringBuffer("\n# label defaults;\n");
        Labels.appendCmd(s, "select none");
        Labels.appendCmd(s, this.getColorCommand("label", this.defaultPaletteID, this.defaultColix));
        Labels.appendCmd(s, "background label " + this.encodeColor(this.defaultBgcolix));
        Labels.appendCmd(s, "set labelOffset " + Object2d.getXOffset(this.defaultOffset) + " " + -Object2d.getYOffset(this.defaultOffset));
        String align = Object2d.getAlignment(this.defaultAlignment);
        Labels.appendCmd(s, "set labelAlignment " + (align.length() < 5 ? "left" : align));
        String pointer = Object2d.getPointer(this.defaultPointer);
        Labels.appendCmd(s, "set labelPointer " + (pointer.length() == 0 ? "off" : pointer));
        if ((this.defaultZPos & 0x20) != 0) {
            Labels.appendCmd(s, "set labelFront");
        } else if ((this.defaultZPos & 0x10) != 0) {
            Labels.appendCmd(s, "set labelGroup");
        }
        Labels.appendCmd(s, Labels.getFontCommand("label", Font3D.getFont3D(this.defaultFontId)));
        return s.toString();
    }

    public String getShapeState() {
        if (!this.isActive) {
            return "";
        }
        Hashtable temp = new Hashtable();
        Hashtable temp2 = new Hashtable();
        Hashtable temp3 = new Hashtable();
        int i = this.atomCount;
        while (--i >= 0) {
            Text text;
            float sppm;
            if (this.bsSizeSet == null || !this.bsSizeSet.get(i)) continue;
            Labels.setStateInfo(temp, i, "label " + Escape.escape(this.formats[i]));
            if (this.bsColixSet != null && this.bsColixSet.get(i)) {
                Labels.setStateInfo(temp2, i, this.getColorCommand("label", this.paletteIDs[i], this.colixes[i]));
            }
            if (this.bsBgColixSet != null && this.bsBgColixSet.get(i)) {
                Labels.setStateInfo(temp2, i, "background label " + this.encodeColor(this.bgcolixes[i]));
            }
            float f = sppm = (text = this.getLabel(i)) != null ? text.getScalePixelsPerMicron() : 0.0f;
            if (sppm > 0.0f) {
                Labels.setStateInfo(temp2, i, "set labelScaleReference " + 10000.0f / sppm);
            }
            if (this.offsets != null && this.offsets.length > i) {
                int offsetFull = this.offsets[i];
                Labels.setStateInfo(temp2, i, "set labelOffset " + Object2d.getXOffset(offsetFull >> 8) + " " + -Object2d.getYOffset(offsetFull >> 8));
                String align = Object2d.getAlignment(offsetFull >> 2);
                String pointer = Object2d.getPointer(offsetFull);
                if (pointer.length() > 0) {
                    Labels.setStateInfo(temp2, i, "set labelPointer " + pointer);
                }
                if ((offsetFull & 0x20) != 0) {
                    Labels.setStateInfo(temp2, i, "set labelFront");
                } else if ((offsetFull & 0x10) != 0) {
                    Labels.setStateInfo(temp2, i, "set labelGroup");
                }
                if (align.length() > 0) {
                    Labels.setStateInfo(temp3, i, "set labelAlignment " + align);
                }
            }
            if (this.bsFontSet == null || !this.bsFontSet.get(i)) continue;
            Labels.setStateInfo(temp2, i, Labels.getFontCommand("label", Font3D.getFont3D(this.fids[i])));
        }
        return Labels.getShapeCommands(temp, temp2, this.atomCount) + Labels.getShapeCommands(null, temp3, this.atomCount);
    }
}

