/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.MeasurementPending;
import org.jmol.shape.Shape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Point3fi;

public class Measures
extends Shape {
    private static final int measurementGrowthIncrement = 16;
    private BitSet bsColixSet;
    private BitSet bsSelected;
    private String strFormat;
    private boolean isAllConnected = false;
    private float[] rangeMinMax = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
    private Atom[] atoms;
    private int atomCount;
    int measurementCount = 0;
    Measurement[] measurements = new Measurement[16];
    MeasurementPending measurementPending;
    short mad = (short)-1;
    short colix;
    Font3D font3d;

    protected void initModelSet() {
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            this.measurements[i].modelSet = this.modelSet;
        }
        this.atoms = this.modelSet.atoms;
        this.atomCount = this.modelSet.getAtomCount();
    }

    public void initShape() {
        super.initShape();
        this.font3d = this.g3d.getFont3D(15.0f);
    }

    public void setSize(int size, BitSet bsSelected) {
        this.mad = (short)size;
    }

    public void setProperty(String propertyName, Object value, BitSet bsIgnored) {
        if ("select".equals(propertyName)) {
            BitSet bs = (BitSet)value;
            if (bs == null || BitSetUtil.cardinalityOf(bs) == 0) {
                this.bsSelected = null;
            } else {
                this.bsSelected = new BitSet();
                this.bsSelected.or(bs);
            }
            return;
        }
        if ("color".equals(propertyName)) {
            short colix;
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            short s = colix = value == null ? (short)0 : Graphics3D.getColix(value);
            if (this.bsSelected == null) {
                this.colix = colix;
            }
            for (int i = 0; i < this.measurements.length; ++i) {
                if (this.measurements[i] == null || (this.bsSelected == null || !this.bsSelected.get(i)) && (this.bsSelected != null || colix != 0 && this.measurements[i].getColix() != 0)) continue;
                this.measurements[i].setColix(colix);
                this.bsColixSet.set(i);
            }
            return;
        }
        if ("refresh".equals(propertyName)) {
            for (int i = 0; i < this.measurements.length; ++i) {
                if (this.measurements[i] == null) continue;
                this.measurements[i].refresh();
            }
            return;
        }
        if ("refreshTrajectories".equals(propertyName)) {
            for (int i = 0; i < this.measurements.length; ++i) {
                if (this.measurements[i] == null || !this.measurements[i].isTrajectory()) continue;
                this.measurements[i].refresh();
            }
            return;
        }
        if ("hideAll".equals(propertyName)) {
            this.showHide((Boolean)value);
            return;
        }
        if ("setFormats".equals(propertyName)) {
            this.setFormats((String)value);
            return;
        }
        if ("delete".equals(propertyName)) {
            this.delete(value);
            this.setIndices();
            return;
        }
        this.bsSelected = null;
        if ("pending".equals(propertyName)) {
            this.pending((MeasurementPending)value);
        } else if ("font".equals(propertyName)) {
            this.font3d = (Font3D)value;
        } else if ("clear".equals(propertyName)) {
            this.clear();
        } else if ("reformatDistances".equals(propertyName)) {
            this.reformatDistances();
        } else if ("setRange".equals(propertyName)) {
            this.setRange((float[])value);
        } else if ("setFormat".equals(propertyName)) {
            this.strFormat = (String)value;
        } else if ("setConnected".equals(propertyName)) {
            this.setConnected((Boolean)value);
        } else if ("hide".equals(propertyName)) {
            this.showHide(new Measurement(this.modelSet, (int[])value, null), true);
        } else if ("show".equals(propertyName)) {
            this.showHide(new Measurement(this.modelSet, (int[])value, null), false);
        } else if ("toggle".equals(propertyName)) {
            this.toggle(new Measurement(this.modelSet, (int[])value, null));
        } else if ("toggleOn".equals(propertyName)) {
            this.toggleOn((int[])value);
        } else if ("hideVector".equals(propertyName)) {
            this.showHide(this.setSingleItem((Vector)value), true);
        } else if ("showVector".equals(propertyName)) {
            this.showHide(this.setSingleItem((Vector)value), false);
        } else if ("defineVector".equals(propertyName)) {
            this.toggle(this.setSingleItem((Vector)value));
        } else if ("deleteVector".equals(propertyName)) {
            this.define(this.setSingleItem((Vector)value), true, false, false);
            this.setIndices();
        } else if ("defineVector_All".equals(propertyName)) {
            this.define((Vector)value, false, false, false);
        } else if ("deleteVector_All".equals(propertyName)) {
            this.define((Vector)value, true, false, false);
            this.setIndices();
        } else if ("hideVector_All".equals(propertyName)) {
            this.define((Vector)value, false, false, true);
        } else if ("showVector_All".equals(propertyName)) {
            this.define((Vector)value, false, true, false);
        } else if ("deleteModelAtoms".equals(propertyName)) {
            this.atoms = (Atom[])((Object[])value)[1];
            this.atomCount = this.modelSet.getAtomCount();
            int firstAtomDeleted = ((int[])((Object[])value)[2])[1];
            int nAtomsDeleted = ((int[])((Object[])value)[2])[2];
            int atomMax = firstAtomDeleted + nAtomsDeleted;
            int i = this.measurementCount;
            block3: while (--i >= 0) {
                Measurement m = this.measurements[i];
                int[] indices = m.getCountPlusIndices();
                for (int j = 1; j <= indices[0]; ++j) {
                    int iAtom = indices[j];
                    if (iAtom < firstAtomDeleted) continue;
                    if (iAtom < atomMax) {
                        this.deleteMeasurement(i);
                        continue block3;
                    }
                    int n = j;
                    indices[n] = indices[n] - nAtomsDeleted;
                }
            }
        }
    }

    private Measurement setSingleItem(Vector vector) {
        Point3fi[] points = new Point3fi[4];
        int[] indices = new int[5];
        indices[0] = vector.size();
        int i = vector.size();
        while (--i >= 0) {
            Object value = vector.get(i);
            if (value instanceof BitSet) {
                int atomIndex = BitSetUtil.firstSetBit((BitSet)value);
                if (atomIndex < 0) {
                    return null;
                }
                indices[i + 1] = atomIndex;
                continue;
            }
            points[i] = new Point3fi();
            points[i].set((Point3f)value);
            indices[i + 1] = -2 - i;
        }
        return new Measurement(this.modelSet, indices, points);
    }

    public Object getProperty(String property, int index) {
        if ("pending".equals(property)) {
            return this.measurementPending;
        }
        if ("count".equals(property)) {
            return new Integer(this.measurementCount);
        }
        if ("countPlusIndices".equals(property)) {
            return index < this.measurementCount ? this.measurements[index].getCountPlusIndices() : null;
        }
        if ("stringValue".equals(property)) {
            return index < this.measurementCount ? this.measurements[index].getString() : null;
        }
        if ("pointInfo".equals(property)) {
            return this.measurements[index / 10].getLabel(index % 10, false);
        }
        if ("info".equals(property)) {
            return this.getAllInfo();
        }
        if ("infostring".equals(property)) {
            return this.getAllInfoAsString();
        }
        return null;
    }

    private void clear() {
        if (this.measurementCount == 0) {
            return;
        }
        int countT = this.measurementCount;
        this.measurementCount = 0;
        int i = countT;
        while (--i >= 0) {
            this.measurements[i] = null;
        }
        this.viewer.setStatusMeasuring("measureDeleted", -1, "all");
    }

    private int findMeasurement(int[] indices, Point3fi[] points) {
        int i = this.measurementCount;
        while (--i >= 0) {
            if (!this.measurements[i].sameAs(indices, points)) continue;
            return i;
        }
        return -1;
    }

    private int findMeasurement(Measurement m) {
        return this.findMeasurement(m.getCountPlusIndices(), m.getPoints());
    }

    private void showHide(Measurement m, boolean isHide) {
        int i = this.findMeasurement(m);
        if (i < 0) {
            return;
        }
        this.measurements[i].setHidden(isHide);
    }

    private void showHide(boolean isHide) {
        int i = this.measurementCount;
        while (--i >= 0) {
            if (this.bsSelected != null && !this.bsSelected.get(i)) continue;
            this.measurements[i].setHidden(isHide);
        }
    }

    private void toggle(Measurement m) {
        this.rangeMinMax[0] = Float.MAX_VALUE;
        int i = this.findMeasurement(m);
        if (i >= 0 && !this.measurements[i].isHidden()) {
            this.define(this.measurements[i], true, false, false);
        } else {
            this.define(m, false, true, false);
        }
        this.setIndices();
    }

    private void toggleOn(int[] indices) {
        this.rangeMinMax[0] = Float.MAX_VALUE;
        this.bsSelected = new BitSet();
        this.define(new Measurement(this.modelSet, indices, null), false, true, true);
        this.setIndices();
        this.reformatDistances();
    }

    private void delete(Object value) {
        if (value instanceof int[]) {
            this.define(new Measurement(this.modelSet, (int[])value, null), true, false, false);
            return;
        }
        if (value instanceof Integer) {
            this.deleteMeasurement((Integer)value);
        }
    }

    private void define(Vector monitorExpressions, boolean isDelete, boolean isShow, boolean isHide) {
        int nPoints = monitorExpressions.size();
        if (nPoints < 2) {
            return;
        }
        int modelIndex = -1;
        Point3fi[] points = new Point3fi[4];
        int[] indices = new int[5];
        Measurement m = new Measurement(this.modelSet, indices, points);
        m.setCount(nPoints);
        int ptLastAtom = -1;
        for (int i = 0; i < nPoints; ++i) {
            Object obj = monitorExpressions.get(i);
            if (obj instanceof Point3f) {
                if (points == null) {
                    points = new Point3fi[4];
                }
                points[i] = new Point3fi();
                points[i].set((Point3f)obj);
                indices[i + 1] = -2 - i;
                continue;
            }
            BitSet bs = (BitSet)obj;
            if (BitSetUtil.cardinalityOf(bs) > 1) {
                modelIndex = 0;
            }
            ptLastAtom = i;
            indices[i + 1] = BitSetUtil.firstSetBit(bs);
        }
        this.nextMeasure(0, ptLastAtom, monitorExpressions, m, modelIndex, isDelete, isShow, isHide);
    }

    private void setIndices() {
        for (int i = 0; i < this.measurementCount; ++i) {
            this.measurements[i].setIndex(i);
        }
    }

    private void define(Measurement m, boolean isDelete, boolean isShow, boolean doSelect) {
        if (this.viewer.getMeasureAllModelsFlag()) {
            if (isShow) {
                this.define(m, true, false, false);
                if (isDelete) {
                    return;
                }
            }
            Vector<Point3fi> measureList = new Vector<Point3fi>();
            int nPoints = m.getCount();
            for (int i = 1; i <= nPoints; ++i) {
                int atomIndex = m.getAtomIndex(i);
                measureList.addElement((Point3fi)(atomIndex >= 0 ? this.viewer.getAtomBits(0x1500001, new Integer(this.atoms[atomIndex].getAtomNumber())) : m.getAtom(i)));
            }
            this.define(measureList, isDelete, false, false);
            return;
        }
        this.define(m, isDelete, doSelect);
    }

    private void define(Measurement m, boolean isDelete, boolean doSelect) {
        float value;
        int i = this.findMeasurement(m);
        int count = m.getCount();
        if (i < 0 && isDelete || m.sameAs(1, 2) || count > 2 && m.sameAs(1, 3) || count == 4 && m.sameAs(2, 4)) {
            return;
        }
        float f = value = isDelete ? this.rangeMinMax[0] : m.getMeasurement();
        if (this.rangeMinMax[0] != Float.MAX_VALUE && (value < this.rangeMinMax[0] || value > this.rangeMinMax[1])) {
            return;
        }
        if (i >= 0) {
            if (isDelete) {
                this.deleteMeasurement(i);
            } else {
                this.measurements[i].setHidden(false);
                if (doSelect) {
                    this.bsSelected.set(i);
                }
            }
            return;
        }
        Measurement measureNew = new Measurement(this.modelSet, m.getCountPlusIndices(), m.getPoints(), value, this.colix, this.strFormat, this.measurementCount);
        if (this.measurementCount == this.measurements.length) {
            this.measurements = (Measurement[])ArrayUtil.setLength(this.measurements, this.measurementCount + 16);
        }
        int n = this.measurementCount;
        this.measurements[this.measurementCount++] = measureNew;
        this.viewer.setStatusMeasuring("measureCompleted", n, measureNew.toVector().toString());
    }

    private void deleteMeasurement(int i) {
        String msg = this.measurements[i].toVector().toString();
        System.arraycopy(this.measurements, i + 1, this.measurements, i, this.measurementCount - i - 1);
        this.measurements[--this.measurementCount] = null;
        this.viewer.setStatusMeasuring("measureDeleted", i, msg);
    }

    private void nextMeasure(int thispt, int ptLastAtom, Vector monitorExpressions, Measurement m, int thisModel, boolean isDelete, boolean isShow, boolean isHide) {
        if (thispt > ptLastAtom) {
            if (this.isAllConnected && !this.isConnected(m, thispt)) {
                return;
            }
            int iThis = this.findMeasurement(m);
            if (iThis >= 0) {
                if (isDelete) {
                    this.define(m, true, false);
                } else if (this.strFormat != null) {
                    this.measurements[iThis].formatMeasurement(this.strFormat, true);
                } else {
                    this.measurements[iThis].setHidden(isHide);
                }
            } else if (!(isDelete || isHide || isShow)) {
                this.define(m, false, true);
            }
            return;
        }
        BitSet bs = (BitSet)monitorExpressions.get(thispt);
        int[] indices = m.getCountPlusIndices();
        int thisAtomIndex = indices[thispt];
        if (thisAtomIndex < 0) {
            this.nextMeasure(thispt + 1, ptLastAtom, monitorExpressions, m, thisModel, isDelete, isShow, isHide);
            return;
        }
        boolean haveNext = false;
        for (int i = 0; i < this.atomCount; ++i) {
            if (!bs.get(i) || i == thisAtomIndex) continue;
            int modelIndex = this.atoms[i].getModelIndex();
            if (thisModel >= 0) {
                if (thispt == 0) {
                    thisModel = modelIndex;
                } else if (thisModel != modelIndex) continue;
            }
            indices[thispt + 1] = i;
            haveNext = true;
            this.nextMeasure(thispt + 1, ptLastAtom, monitorExpressions, m, thisModel, isDelete, isShow, isHide);
        }
        if (!haveNext) {
            this.nextMeasure(thispt + 1, ptLastAtom, monitorExpressions, m, thisModel, isDelete, isShow, isHide);
        }
    }

    private boolean isConnected(Measurement m, int ptLastAtom) {
        int atomIndexLast = -1;
        for (int i = 1; i <= ptLastAtom; ++i) {
            int atomIndex = m.getAtomIndex(i);
            if (atomIndex < 0) continue;
            if (atomIndexLast >= 0 && !this.atoms[atomIndex].isBonded(this.atoms[atomIndexLast])) {
                return false;
            }
            atomIndexLast = atomIndex;
        }
        return true;
    }

    private void setRange(float[] rangeMinMax) {
        this.rangeMinMax[0] = rangeMinMax[0];
        this.rangeMinMax[1] = rangeMinMax[1];
    }

    private void setConnected(boolean isAllConnected) {
        this.isAllConnected = isAllConnected;
    }

    private void pending(MeasurementPending measurementPending) {
        this.measurementPending = measurementPending;
        if (measurementPending == null) {
            return;
        }
        if (measurementPending.getCount() > 1) {
            this.viewer.setStatusMeasuring("measurePending", measurementPending.getCount(), measurementPending.toVector().toString());
        }
    }

    private void reformatDistances() {
        int i = this.measurementCount;
        while (--i >= 0) {
            this.measurements[i].reformatDistanceIfSelected();
        }
    }

    private void setFormats(String format) {
        if (format != null && format.length() == 0) {
            format = null;
        }
        int i = this.measurementCount;
        while (--i >= 0) {
            if (this.bsSelected != null && !this.bsSelected.get(i)) continue;
            this.measurements[i].formatMeasurement(format, false);
        }
    }

    private Vector getAllInfo() {
        Vector<Hashtable> info = new Vector<Hashtable>();
        for (int i = 0; i < this.measurementCount; ++i) {
            info.addElement(this.getInfo(i));
        }
        return info;
    }

    private String getAllInfoAsString() {
        String info = "Measurement Information";
        for (int i = 0; i < this.measurementCount; ++i) {
            info = info + "\n" + this.getInfoAsString(i);
        }
        return info;
    }

    private Hashtable getInfo(int index) {
        Measurement m = this.measurements[index];
        int count = m.getCount();
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("index", new Integer(index));
        info.put("type", count == 2 ? "distance" : (count == 3 ? "angle" : "dihedral"));
        info.put("strMeasurement", m.getString());
        info.put("count", new Integer(count));
        info.put("value", new Float(m.getValue()));
        Vector atomsInfo = new Vector();
        for (int i = 1; i <= count; ++i) {
            Hashtable<String, Object> atomInfo = new Hashtable<String, Object>();
            int atomIndex = m.getAtomIndex(i);
            atomInfo.put("_ipt", new Integer(atomIndex));
            atomInfo.put("coord", Escape.escape(m.getAtom(i)));
            atomInfo.put("atomno", new Integer(atomIndex < 0 ? -1 : this.atoms[atomIndex].getAtomNumber()));
            atomInfo.put("info", atomIndex < 0 ? "<point>" : this.atoms[atomIndex].getInfo());
            atomsInfo.addElement(atomInfo);
        }
        info.put("atoms", atomsInfo);
        return info;
    }

    private String getInfoAsString(int index) {
        Measurement m = this.measurements[index];
        int count = m.getCount();
        StringBuffer sb = new StringBuffer();
        sb.append(count == 2 ? "distance" : (count == 3 ? "angle" : "dihedral"));
        sb.append(" \t").append(m.getValue()).append(" \t").append(m.getString());
        for (int i = 1; i <= count; ++i) {
            sb.append(" \t").append(m.getLabel(i, false));
        }
        return sb.toString();
    }

    void setVisibilityInfo() {
        int i = this.measurementCount;
        block0: while (--i >= 0) {
            this.measurements[i].setVisible(false);
            if (this.mad == 0 || this.measurements[i].isHidden()) continue;
            for (int iAtom = this.measurements[i].getCount(); iAtom > 0; --iAtom) {
                int atomIndex = this.measurements[i].getAtomIndex(iAtom);
                if (atomIndex >= 0 && !this.modelSet.getAtomAt(atomIndex).isClickable()) continue block0;
            }
            this.measurements[i].setVisible(true);
        }
    }

    public String getShapeState() {
        String s;
        int i;
        StringBuffer commands = new StringBuffer("");
        Measures.appendCmd(commands, "measures delete");
        for (int i2 = 0; i2 < this.measurementCount; ++i2) {
            Measures.appendCmd(commands, this.getState(i2));
        }
        Measures.appendCmd(commands, "select *; set measures " + this.viewer.getMeasureDistanceUnits());
        Measures.appendCmd(commands, Measures.getFontCommand("measures", this.font3d));
        int n = 0;
        Hashtable temp = new Hashtable();
        BitSet bs = new BitSet(this.measurementCount);
        for (i = 0; i < this.measurementCount; ++i) {
            if (this.measurements[i].isHidden()) {
                ++n;
                bs.set(i);
            }
            if (this.bsColixSet != null && this.bsColixSet.get(i)) {
                Measures.setStateInfo(temp, i, this.getColorCommand("measure", this.measurements[i].getColix()));
            }
            if (this.measurements[i].getStrFormat() == null) continue;
            Measures.setStateInfo(temp, i, "measure " + Escape.escape(this.measurements[i].getStrFormat()));
        }
        if (n > 0) {
            if (n == this.measurementCount) {
                Measures.appendCmd(commands, "measures off; # lines and numbers off");
            } else {
                for (i = 0; i < this.measurementCount; ++i) {
                    if (!this.measurements[i].isHidden()) continue;
                    Measures.setStateInfo(temp, i, "measure off");
                }
            }
        }
        if ((s = Measures.getShapeCommands(temp, null, -1, "select measures")) != null) {
            commands.append(s);
            Measures.appendCmd(commands, "select measures ({null})");
        }
        return commands.toString();
    }

    private String getState(int index) {
        Measurement m = this.measurements[index];
        int count = m.getCount();
        StringBuffer sb = new StringBuffer("measure");
        for (int i = 1; i <= count; ++i) {
            sb.append(" ").append(m.getLabel(i, true));
        }
        sb.append("; # " + this.getInfoAsString(index));
        return sb.toString();
    }
}

