/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Mesh;
import org.jmol.shape.Shape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Token;

public abstract class MeshCollection
extends Shape {
    public int meshCount;
    public Mesh[] meshes = new Mesh[4];
    public Mesh currentMesh;
    public int modelCount;
    public boolean isFixed;
    public String script;
    public int nUnnamed;
    public short colix;
    public String myType;
    public boolean explicitID;
    protected String previousMeshID;
    protected Mesh linkedMesh;
    protected boolean iHaveModelIndex;
    protected int modelIndex;
    protected boolean allowContourLines;
    protected boolean haveContours = false;
    public String[] title;
    protected boolean allowMesh = true;

    private Mesh setMesh(String thisID) {
        this.linkedMesh = null;
        if (thisID == null || TextFormat.isWild(thisID)) {
            this.currentMesh = null;
            return null;
        }
        int meshIndex = this.getIndexFromName(thisID);
        if (meshIndex >= 0) {
            this.currentMesh = this.meshes[meshIndex];
            if (thisID.equals("+PREVIOUS_MESH+")) {
                this.linkedMesh = this.currentMesh.linkedMesh;
            }
        } else {
            this.allocMesh(thisID);
        }
        if (this.currentMesh.thisID == null) {
            this.currentMesh.thisID = this.myType + ++this.nUnnamed;
        }
        this.previousMeshID = this.currentMesh.thisID;
        return this.currentMesh;
    }

    public void allocMesh(String thisID) {
        this.meshes = (Mesh[])ArrayUtil.ensureLength(this.meshes, this.meshCount + 1);
        Mesh mesh = new Mesh(thisID, this.g3d, this.colix);
        this.meshes[this.meshCount++] = mesh;
        this.currentMesh = mesh;
        this.previousMeshID = null;
    }

    public void initShape() {
        super.initShape();
        this.colix = (short)5;
        this.modelCount = this.viewer.getModelCount();
    }

    public void setProperty(String propertyName, Object value, BitSet bs) {
        if (Logger.debugging) {
            Logger.debug("MeshCollection.setProperty(" + propertyName + "," + (value == null ? "null" : (propertyName == "token" ? Token.nameOf((Integer)value) : value.toString())) + ")");
        }
        if ("init" == propertyName) {
            this.title = null;
            return;
        }
        if ("link" == propertyName) {
            if (this.meshCount >= 2 && this.currentMesh != null) {
                this.currentMesh.linkedMesh = this.meshes[this.meshCount - 2];
            }
            return;
        }
        if ("commandOption" == propertyName) {
            String s = "# " + (String)value;
            if (this.script.indexOf(s) < 0) {
                this.script = this.script + " " + s;
            }
            return;
        }
        if ("thisID" == propertyName) {
            String id = (String)value;
            this.setMesh(id);
            boolean bl = this.explicitID = id != null && !id.equals("+PREVIOUS_MESH+");
            if (this.explicitID) {
                this.previousMeshID = id;
            }
            return;
        }
        if ("title" == propertyName) {
            if (value == null) {
                this.title = null;
            } else if (value instanceof String[]) {
                this.title = (String[])value;
            } else {
                int nLine = 1;
                String lines = (String)value;
                int i = lines.length();
                while (--i >= 0) {
                    if (lines.charAt(i) != '|') continue;
                    ++nLine;
                }
                this.title = new String[nLine];
                nLine = 0;
                int i0 = -1;
                for (int i2 = 0; i2 < lines.length(); ++i2) {
                    if (lines.charAt(i2) != '|') continue;
                    this.title[nLine++] = lines.substring(i0 + 1, i2);
                    i0 = i2;
                }
                this.title[nLine] = lines.substring(i0 + 1);
            }
            return;
        }
        if ("delete" == propertyName) {
            this.deleteMesh();
            return;
        }
        if ("reset" == propertyName) {
            String thisID = (String)value;
            if (this.setMesh(thisID) == null) {
                return;
            }
            this.setMesh(thisID);
            return;
        }
        if ("color" == propertyName) {
            if (value == null) {
                return;
            }
            this.colix = Graphics3D.getColix(value);
            this.setProperty(558895366, false);
            return;
        }
        if ("translucency" == propertyName) {
            this.setProperty(1073741887, ((String)value).equals("translucent"));
            return;
        }
        if ("hidden" == propertyName) {
            value = new Integer((Boolean)value != false ? 0x10000C : 0x10000D);
            propertyName = "token";
        }
        if ("token" == propertyName) {
            int tok = (Integer)value;
            int tok2 = 0;
            boolean test = true;
            switch (tok) {
                case 528399: 
                case 0x10000D: 
                case 0x40000006: 
                case 0x40000010: 
                case 1073741843: 
                case 0x40000014: 
                case 1073741845: 
                case 0x40000040: {
                    break;
                }
                case 0x10000C: {
                    test = false;
                    tok = 0x10000D;
                    break;
                }
                case 0x40000070: {
                    tok2 = 1073741851;
                    break;
                }
                case 1073741954: {
                    test = false;
                    tok = 0x40000070;
                    tok2 = 1073741851;
                    break;
                }
                case 1073741851: {
                    tok2 = 0x40000070;
                    break;
                }
                case 1073741857: {
                    test = false;
                    tok = 1073741851;
                    tok2 = 0x40000070;
                    break;
                }
                case 1073741855: {
                    test = false;
                    tok = 528399;
                    break;
                }
                case 0x40000020: {
                    test = false;
                    tok = 0x40000010;
                    break;
                }
                case 0x40000024: {
                    test = false;
                    tok = 0x40000040;
                    break;
                }
                case 1073741859: {
                    test = false;
                    tok = 0x40000014;
                    break;
                }
                default: {
                    System.out.println("PROBLEM IN MESHCOLLECTION: token? " + Token.nameOf(tok));
                }
            }
            this.setProperty(tok, test);
            if (tok2 != 0 && this.currentMesh.havePlanarContours && this.currentMesh.drawTriangles != this.currentMesh.showContourLines) {
                this.setProperty(tok2, test);
            }
            return;
        }
        super.setProperty(propertyName, value, bs);
    }

    private void setProperty(int tokProp, boolean bProp) {
        String key;
        if (this.currentMesh != null) {
            switch (tokProp) {
                case 0x10000D: {
                    this.currentMesh.visible = bProp;
                    return;
                }
                case 558895366: {
                    this.currentMesh.colix = this.colix;
                    if (this.linkedMesh != null) {
                        this.linkedMesh.colix = this.colix;
                    }
                    return;
                }
                case 1073741887: {
                    this.currentMesh.setTranslucent(bProp, this.translucentLevel);
                    if (this.linkedMesh != null) {
                        this.linkedMesh.setTranslucent(bProp, this.translucentLevel);
                    }
                    return;
                }
                case 0x40000006: 
                case 1073741843: 
                case 1073741845: {
                    this.currentMesh.setLighting(tokProp);
                    if (this.linkedMesh != null) {
                        this.linkedMesh.setLighting(tokProp);
                    }
                    return;
                }
                case 0x40000070: {
                    this.currentMesh.showContourLines = bProp;
                    if (this.linkedMesh != null) {
                        this.linkedMesh.showContourLines = bProp;
                    }
                    return;
                }
                case 1073741851: {
                    this.currentMesh.drawTriangles = bProp;
                    if (this.linkedMesh != null) {
                        this.linkedMesh.drawTriangles = bProp;
                    }
                    return;
                }
                case 528399: {
                    this.currentMesh.showPoints = bProp;
                    if (this.linkedMesh != null) {
                        this.linkedMesh.showPoints = bProp;
                    }
                    return;
                }
                case 0x40000010: {
                    this.currentMesh.fillTriangles = bProp;
                    if (this.linkedMesh != null) {
                        this.linkedMesh.fillTriangles = bProp;
                    }
                    return;
                }
                case 0x40000040: {
                    this.currentMesh.showTriangles = bProp;
                    if (this.linkedMesh != null) {
                        this.linkedMesh.showTriangles = bProp;
                    }
                    return;
                }
                case 0x40000014: {
                    this.currentMesh.frontOnly = bProp;
                    if (this.linkedMesh != null) {
                        this.linkedMesh.frontOnly = bProp;
                    }
                    return;
                }
            }
            return;
        }
        String string = key = this.explicitID && this.previousMeshID != null && TextFormat.isWild(this.previousMeshID) ? this.previousMeshID.toUpperCase() : null;
        if (key != null && key.length() == 0) {
            key = null;
        }
        block22: for (int i = 0; i < this.meshCount; ++i) {
            Mesh m = this.meshes[i];
            if (key != null && !TextFormat.isMatch(m.thisID.toUpperCase(), key, true, true)) continue;
            switch (tokProp) {
                case 0x10000D: {
                    m.visible = bProp;
                    continue block22;
                }
                case 558895366: {
                    m.colix = this.colix;
                    continue block22;
                }
                case 1073741887: {
                    m.setTranslucent(bProp, this.translucentLevel);
                    continue block22;
                }
                case 0x40000006: 
                case 1073741843: 
                case 1073741845: {
                    m.setLighting(tokProp);
                    continue block22;
                }
                case 528399: {
                    m.showPoints = bProp;
                    continue block22;
                }
                case 1073741851: {
                    m.drawTriangles = bProp;
                    continue block22;
                }
                case 0x40000010: {
                    m.fillTriangles = bProp;
                    continue block22;
                }
                case 0x40000040: {
                    m.showTriangles = bProp;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getProperty(String property, int index) {
        if (property == "count") {
            int n = 0;
            int i = 0;
            while (i < this.meshCount) {
                if (this.meshes[i] != null && this.meshes[i].vertexCount > 0) {
                    ++n;
                }
                ++i;
            }
            return new Integer(n);
        }
        if (property == "ID") {
            return this.currentMesh == null ? (String)null : this.currentMesh.thisID;
        }
        if (property == "list") {
            StringBuffer sb = new StringBuffer();
            int k = 0;
            int i = 0;
            while (i < this.meshCount) {
                if (this.meshes[i] != null && this.meshes[i].vertexCount != 0) {
                    Mesh m = this.meshes[i];
                    sb.append(++k).append(" id:" + m.thisID).append("; model:" + this.viewer.getModelNumberDotted(m.modelIndex)).append("; vertices:" + m.vertexCount).append("; polygons:" + m.polygonCount).append("; visible:" + m.visible);
                    if (m.title != null) {
                        String s = "";
                        for (int j = 0; j < m.title.length; ++j) {
                            s = s + (j == 0 ? "; title:" : " | ") + m.title[j];
                        }
                        if (s.length() > 100) {
                            s = s.substring(0, 100) + "...";
                        }
                        sb.append(s);
                    }
                    sb.append('\n');
                }
                ++i;
            }
            return sb.toString();
        }
        if (property == "command") {
            String key = this.previousMeshID.toUpperCase();
            boolean isWild = TextFormat.isWild(key);
            StringBuffer sb = new StringBuffer();
            int i = this.meshCount;
            while (--i >= 0) {
                String id = this.meshes[i].thisID.toUpperCase();
                if (!id.equals(key) && (!isWild || !TextFormat.isMatch(id, key, true, true))) continue;
                this.getMeshCommand(sb, i);
            }
            return sb.toString();
        }
        if (property.startsWith("checkID:")) {
            String key = property.substring(8).toUpperCase();
            boolean isWild = TextFormat.isWild(key);
            int i = this.meshCount;
            while (--i >= 0) {
                String id = this.meshes[i].thisID.toUpperCase();
                if (id.equals(key)) return id;
                if (!isWild || !TextFormat.isMatch(id, key, true, true)) continue;
                return id;
            }
        }
        if (property == "vertices") {
            return this.getVertices(this.currentMesh);
        }
        if (!property.startsWith("getCenter:")) return null;
        int meshIndex = this.getIndexFromName(property.substring(10));
        if (meshIndex < 0) return null;
        Mesh m = this.meshes[meshIndex];
        if (m.vertices == null) return null;
        if (m.vertexCount <= index) {
            return null;
        }
        if (index < 0) return null;
        Point3f point3f = m.vertices[index];
        return point3f;
    }

    private Object getVertices(Mesh mesh) {
        if (mesh == null) {
            return null;
        }
        return mesh.vertices;
    }

    private void deleteMesh() {
        int i = 0;
        if (this.explicitID && this.currentMesh != null) {
            i = this.meshCount;
            while (this.meshes[--i] != this.currentMesh) {
            }
            this.deleteMesh(i);
        } else {
            String key;
            String string = key = this.explicitID && this.previousMeshID != null && TextFormat.isWild(this.previousMeshID) ? this.previousMeshID.toUpperCase() : null;
            if (key == null || key.length() == 0) {
                i = this.meshCount;
                while (--i >= 0) {
                    this.meshes[i] = null;
                }
                this.meshCount = 0;
                this.nUnnamed = 0;
            } else {
                i = this.meshCount;
                while (--i >= 0) {
                    if (!TextFormat.isMatch(this.meshes[i].thisID.toUpperCase(), key, true, true)) continue;
                    this.deleteMesh(i);
                }
            }
        }
        this.currentMesh = null;
    }

    public void deleteMesh(int i) {
        for (int j = i + 1; j < this.meshCount; ++j) {
            this.meshes[j - 1] = this.meshes[j];
        }
        this.meshes[--this.meshCount] = null;
    }

    public int getIndexFromName(String thisID) {
        if ("+PREVIOUS_MESH+".equals(thisID)) {
            return this.previousMeshID == null ? this.meshCount - 1 : this.getIndexFromName(this.previousMeshID);
        }
        if (TextFormat.isWild(thisID)) {
            thisID = thisID.toLowerCase();
            int i = this.meshCount;
            while (--i >= 0) {
                if (this.meshes[i] == null || !TextFormat.isMatch(this.meshes[i].thisID, thisID, true, true)) continue;
                return i;
            }
        } else {
            int i = this.meshCount;
            while (--i >= 0) {
                if (this.meshes[i] == null || !thisID.equalsIgnoreCase(this.meshes[i].thisID)) continue;
                return i;
            }
        }
        return -1;
    }

    public void setModelIndex(int atomIndex, int modelIndex) {
        if (this.currentMesh == null) {
            return;
        }
        this.currentMesh.visible = true;
        this.currentMesh.atomIndex = atomIndex;
        this.currentMesh.modelIndex = this.currentMesh.atomIndex >= 0 ? this.viewer.getAtomModelIndex(atomIndex) : (this.isFixed ? -1 : (modelIndex >= 0 ? modelIndex : this.viewer.getCurrentModelIndex()));
        this.currentMesh.scriptCommand = this.script;
    }

    public String getShapeState() {
        StringBuffer sb = new StringBuffer("\n");
        for (int i = 0; i < this.meshCount; ++i) {
            this.getMeshCommand(sb, i);
        }
        return sb.toString();
    }

    private void getMeshCommand(StringBuffer sb, int i) {
        String name;
        Mesh mesh = this.meshes[i];
        String cmd = mesh.scriptCommand;
        if (cmd == null) {
            return;
        }
        int pt = (cmd = cmd.replace('\t', ' ')).indexOf(";#");
        if (pt >= 0) {
            cmd = cmd.substring(0, pt + 1);
        }
        cmd = TextFormat.trim(cmd, ";") + ";";
        if (mesh.bitsets != null) {
            cmd = cmd + "# " + (mesh.bitsets[0] == null ? "({null})" : Escape.escape(mesh.bitsets[0])) + " " + (mesh.bitsets[1] == null ? "({null})" : Escape.escape(mesh.bitsets[1])) + (mesh.bitsets[2] == null ? "" : "/" + Escape.escape(mesh.bitsets[2]));
        }
        if (cmd.toLowerCase().indexOf(" id ") < 0 && !this.myType.equals("mo")) {
            cmd = cmd + "# ID=\"" + mesh.thisID + "\"";
        }
        if (mesh.modelIndex >= 0) {
            cmd = cmd + "# MODEL({" + mesh.modelIndex + "})";
        }
        if (mesh.linkedMesh != null) {
            cmd = cmd + " LINK";
        }
        if (mesh.data1 != null) {
            name = ((String)mesh.data1.elementAt(0)).toLowerCase();
            if (name.indexOf("data2d_") != 0) {
                name = "data2d_" + name;
            }
            name = TextFormat.simpleReplace(name, "_xyz", "_");
            cmd = Escape.encapsulateData(name, mesh.data1.elementAt(5)) + "  " + cmd + "# DATA=\"" + name + "\"";
        }
        if (mesh.data2 != null) {
            name = ((String)mesh.data2.elementAt(0)).toLowerCase();
            if (name.indexOf("data2d_") != 0) {
                name = "data2d_" + name;
            }
            name = TextFormat.simpleReplace(name, "_xyz", "_");
            cmd = Escape.encapsulateData(name, mesh.data2.elementAt(5)) + "  " + cmd + "# DATA2=\"" + name + "\"";
        }
        if (mesh.modelIndex >= 0 && this.modelCount > 1) {
            MeshCollection.appendCmd(sb, "frame " + this.viewer.getModelNumberDotted(mesh.modelIndex));
        }
        MeshCollection.appendCmd(sb, cmd);
        if (cmd.charAt(0) != '#') {
            if (this.allowMesh) {
                MeshCollection.appendCmd(sb, mesh.getState(this.myType));
            }
            if (mesh.colorCommand != null) {
                if (!mesh.isColorSolid && Graphics3D.isColixTranslucent(mesh.colix)) {
                    MeshCollection.appendCmd(sb, this.getColorCommand(this.myType, mesh.colix));
                }
                MeshCollection.appendCmd(sb, mesh.colorCommand);
            }
            this.getColorState(sb, mesh);
        }
    }

    protected void getColorState(StringBuffer sb, Mesh mesh) {
        this.getColorState(sb, mesh);
        if (mesh.isColorSolid) {
            MeshCollection.appendCmd(sb, this.getColorCommand(this.myType, mesh.colix));
        }
    }

    public void setVisibilityFlags(BitSet bs) {
        int i = this.meshCount;
        while (--i >= 0) {
            Mesh mesh = this.meshes[i];
            mesh.visibilityFlags = mesh.visible && mesh.isValid && (mesh.modelIndex < 0 || bs.get(mesh.modelIndex) && (mesh.atomIndex < 0 || !this.modelSet.isAtomHidden(mesh.atomIndex))) ? this.myVisibilityFlag : 0;
        }
    }

    protected void getModelIndex(String script) {
        int i;
        this.iHaveModelIndex = false;
        this.modelIndex = -1;
        if (script == null || (i = script.indexOf("MODEL({")) < 0) {
            return;
        }
        int j = script.indexOf("})", i);
        if (j < 0) {
            return;
        }
        BitSet bs = Escape.unescapeBitset(script.substring(i + 3, j + 1));
        this.modelIndex = bs == null ? -1 : BitSetUtil.firstSetBit(bs);
        this.iHaveModelIndex = this.modelIndex >= 0;
    }
}

