/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Viewer;

public abstract class Object2d {
    public static final int POINTER_NONE = 0;
    public static final int POINTER_ON = 1;
    public static final int POINTER_BACKGROUND = 2;
    protected static final String[] hAlignNames = new String[]{"", "left", "center", "right", ""};
    protected static final int ALIGN_NONE = 0;
    public static final int ALIGN_LEFT = 1;
    protected static final int ALIGN_CENTER = 2;
    protected static final int ALIGN_RIGHT = 3;
    protected static final String[] vAlignNames = new String[]{"xy", "top", "bottom", "middle"};
    public static final int VALIGN_XY = 0;
    protected static final int VALIGN_TOP = 1;
    protected static final int VALIGN_BOTTOM = 2;
    protected static final int VALIGN_MIDDLE = 3;
    public static final int VALIGN_XYZ = 4;
    protected boolean isLabelOrHover;
    protected Viewer viewer;
    protected JmolRendererInterface g3d;
    public Point3f xyz;
    String target;
    protected String script;
    protected short colix;
    protected short bgcolix;
    protected int pointer;
    protected int align;
    public int valign;
    protected int movableX;
    protected int movableY;
    protected int movableZ;
    protected int movableXPercent = Integer.MAX_VALUE;
    protected int movableYPercent = Integer.MAX_VALUE;
    protected int movableZPercent = Integer.MAX_VALUE;
    protected int offsetX;
    protected int offsetY;
    protected int z;
    protected int zSlab;
    protected int windowWidth;
    protected int windowHeight;
    protected boolean adjustForWindow;
    protected float boxWidth;
    protected float boxHeight;
    protected float boxX;
    protected float boxY;
    int modelIndex = -1;
    boolean visible = true;
    boolean hidden = false;
    protected final float[] boxXY = new float[2];
    protected float scalePixelsPerMicron;

    float getScalePixelsPerMicron() {
        return this.scalePixelsPerMicron;
    }

    public void setScalePixelsPerMicron(float scalePixelsPerMicron) {
        this.scalePixelsPerMicron = scalePixelsPerMicron;
    }

    protected abstract void recalc();

    protected Object2d() {
    }

    protected Object2d(Viewer viewer, Graphics3D g3d, String target, short colix, int valign, int align, float scalePixelsPerMicron) {
        this.viewer = viewer;
        this.g3d = g3d;
        this.isLabelOrHover = false;
        this.target = target;
        if (target.equals("error")) {
            valign = 1;
        }
        this.colix = colix;
        this.align = align;
        this.valign = valign;
        this.z = 2;
        this.zSlab = Integer.MIN_VALUE;
        this.scalePixelsPerMicron = scalePixelsPerMicron;
    }

    void setModel(int modelIndex) {
        this.modelIndex = modelIndex;
    }

    public void setVisibility(boolean TF) {
        this.visible = TF;
    }

    public void setXYZ(Point3f xyz) {
        this.valign = 4;
        this.xyz = xyz;
        this.setAdjustForWindow(false);
    }

    public void setAdjustForWindow(boolean TF) {
        this.adjustForWindow = TF;
    }

    void setColix(short colix) {
        this.colix = colix;
    }

    void setColix(Object value) {
        this.colix = Graphics3D.getColix(value);
    }

    void setTranslucent(float level, boolean isBackground) {
        if (isBackground) {
            if (this.bgcolix != 0) {
                this.bgcolix = Graphics3D.getColixTranslucent(this.bgcolix, !Float.isNaN(level), level);
            }
        } else {
            this.colix = Graphics3D.getColixTranslucent(this.colix, !Float.isNaN(level), level);
        }
    }

    void setBgColix(short colix) {
        this.bgcolix = colix;
    }

    void setBgColix(Object value) {
        this.bgcolix = value == null ? (short)0 : Graphics3D.getColix(value);
    }

    public void setMovableX(int x) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableX = x;
        this.movableXPercent = Integer.MAX_VALUE;
    }

    public void setMovableY(int y) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableY = y;
        this.movableYPercent = Integer.MAX_VALUE;
    }

    public void setMovableZ(int z) {
        if (this.valign != 4) {
            this.valign = 0;
        }
        this.movableZ = z;
        this.movableZPercent = Integer.MAX_VALUE;
    }

    public void setMovableXPercent(int x) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableX = Integer.MAX_VALUE;
        this.movableXPercent = x;
    }

    public void setMovableYPercent(int y) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableY = Integer.MAX_VALUE;
        this.movableYPercent = y;
    }

    public void setMovableZPercent(int z) {
        if (this.valign != 4) {
            this.valign = 0;
        }
        this.movableZ = Integer.MAX_VALUE;
        this.movableZPercent = z;
    }

    void setXY(int x, int y) {
        this.setMovableX(x);
        this.setMovableY(y);
    }

    void setZs(int z, int zSlab) {
        this.z = z;
        this.zSlab = zSlab;
    }

    public void setXYZs(int x, int y, int z, int zSlab) {
        this.setMovableX(x);
        this.setMovableY(y);
        this.setZs(z, zSlab);
    }

    public void setScript(String script) {
        this.script = script == null || script.length() == 0 ? null : script;
    }

    public String getScript() {
        return this.script;
    }

    void setOffset(int offset) {
        this.offsetX = Object2d.getXOffset(offset);
        this.offsetY = Object2d.getYOffset(offset);
        this.valign = 0;
    }

    static int getXOffset(int offset) {
        switch (offset) {
            case 0: {
                return 4;
            }
            case 32767: {
                return 0;
            }
        }
        return (byte)(offset >> 8 & 0xFF);
    }

    static int getYOffset(int offset) {
        switch (offset) {
            case 0: {
                return -4;
            }
            case 32767: {
                return 0;
            }
        }
        return -((byte)(offset & 0xFF));
    }

    boolean setAlignment(String align) {
        if ("left".equals(align)) {
            return this.setAlignment(1);
        }
        if ("center".equals(align)) {
            return this.setAlignment(2);
        }
        if ("right".equals(align)) {
            return this.setAlignment(3);
        }
        return false;
    }

    static String getAlignment(int align) {
        return hAlignNames[align & 3];
    }

    boolean setAlignment(int align) {
        if (this.align != align) {
            this.align = align;
            this.recalc();
        }
        return true;
    }

    void setPointer(int pointer) {
        this.pointer = pointer;
    }

    static String getPointer(int pointer) {
        return (pointer & 1) == 0 ? "" : ((pointer & 2) > 0 ? "background" : "on");
    }

    protected void drawPointer(JmolRendererInterface g3d) {
        if ((this.pointer & 1) != 0) {
            if (!g3d.setColix((this.pointer & 2) != 0 && this.bgcolix != 0 ? this.bgcolix : this.colix)) {
                return;
            }
            if (this.boxX > (float)this.movableX) {
                g3d.drawLine(this.movableX, this.movableY, this.zSlab, (int)this.boxX, (int)(this.boxY + this.boxHeight / 2.0f), this.zSlab);
            } else if (this.boxX + this.boxWidth < (float)this.movableX) {
                g3d.drawLine(this.movableX, this.movableY, this.zSlab, (int)(this.boxX + this.boxWidth), (int)(this.boxY + this.boxHeight / 2.0f), this.zSlab);
            }
        }
    }

    protected void setBoxOffsetsInWindow(float margin, float vMargin, float vTop) {
        float x = this.boxX;
        float bw = this.boxWidth + margin;
        if (x + bw > (float)this.windowWidth) {
            x = (float)this.windowWidth - bw;
        }
        if (x < margin) {
            x = margin;
        }
        this.boxX = x;
        float y = vTop;
        float bh = this.boxHeight;
        if (y + bh > (float)this.windowHeight) {
            y = (float)this.windowHeight - bh;
        }
        if (y < vMargin) {
            y = vMargin;
        }
        this.boxY = y;
    }

    protected void setWindow(JmolRendererInterface g3d, float scalePixelsPerMicron) {
        this.windowWidth = g3d.getRenderWidth();
        this.windowHeight = g3d.getRenderHeight();
        if (this.scalePixelsPerMicron < 0.0f && scalePixelsPerMicron != 0.0f) {
            this.scalePixelsPerMicron = scalePixelsPerMicron;
        }
    }

    public boolean checkObjectClicked(int x, int y, BitSet bsVisible) {
        if (this.modelIndex >= 0 && !bsVisible.get(this.modelIndex) || this.hidden) {
            return false;
        }
        if (this.g3d.isAntialiased()) {
            x <<= 1;
            y <<= 1;
        }
        return this.script != null && (float)x >= this.boxX && (float)x <= this.boxX + this.boxWidth && (float)y >= this.boxY && (float)y <= this.boxY + this.boxHeight;
    }

    public static boolean setProperty(String propertyName, Object value, Object2d currentObject) {
        if ("script" == propertyName) {
            if (currentObject != null) {
                currentObject.setScript((String)value);
            }
            return true;
        }
        if ("xpos" == propertyName) {
            if (currentObject != null) {
                currentObject.setMovableX((Integer)value);
            }
            return true;
        }
        if ("ypos" == propertyName) {
            if (currentObject != null) {
                currentObject.setMovableY((Integer)value);
            }
            return true;
        }
        if ("%xpos" == propertyName) {
            if (currentObject != null) {
                currentObject.setMovableXPercent((Integer)value);
            }
            return true;
        }
        if ("%ypos" == propertyName) {
            if (currentObject != null) {
                currentObject.setMovableYPercent((Integer)value);
            }
            return true;
        }
        if ("%zpos" == propertyName) {
            if (currentObject != null) {
                currentObject.setMovableZPercent((Integer)value);
            }
            return true;
        }
        if ("xypos" == propertyName) {
            if (currentObject == null) {
                return true;
            }
            Point3f pt = (Point3f)value;
            if (pt.z == Float.MAX_VALUE) {
                currentObject.setMovableX((int)pt.x);
                currentObject.setMovableY((int)pt.y);
            } else {
                currentObject.setMovableXPercent((int)pt.x);
                currentObject.setMovableYPercent((int)pt.y);
            }
            return true;
        }
        if ("xyz" == propertyName) {
            if (currentObject != null) {
                currentObject.setXYZ((Point3f)value);
            }
            return true;
        }
        return false;
    }
}

