/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import org.jmol.g3d.Font3D;
import org.jmol.shape.Object2d;
import org.jmol.shape.Shape;
import org.jmol.shape.Text;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

public class Object2dShape
extends Shape {
    Hashtable objects = new Hashtable();
    Object2d currentObject;
    Font3D currentFont;
    Object currentColor;
    Object currentBgColor;
    float currentTranslucentLevel;
    float currentBgTranslucentLevel;
    protected String thisID;
    boolean isHover;
    boolean isAll;

    public void setProperty(String propertyName, Object value, BitSet bsSelected) {
        if (Logger.debugging) {
            Logger.debug("TextShape.setProperty(" + propertyName + "," + value + ")");
        }
        if ("allOff" == propertyName) {
            this.currentObject = null;
            this.isAll = true;
            this.objects = new Hashtable();
            return;
        }
        if ("delete" == propertyName) {
            if (this.currentObject == null) {
                if (this.isAll || this.thisID != null) {
                    Enumeration e = this.objects.elements();
                    while (e.hasMoreElements()) {
                        Text text = (Text)e.nextElement();
                        if (!this.isAll && !TextFormat.isMatch(text.target.toUpperCase(), this.thisID, true, true)) continue;
                        this.objects.remove(text.target);
                    }
                }
                return;
            }
            this.objects.remove(this.currentObject.target);
            this.currentObject = null;
            return;
        }
        if ("off" == propertyName) {
            if (this.isAll) {
                this.objects = new Hashtable();
                this.isAll = false;
                this.currentObject = null;
            }
            if (this.currentObject == null) {
                return;
            }
            this.objects.remove(this.currentObject.target);
            this.currentObject = null;
            return;
        }
        if ("model" == propertyName) {
            int modelIndex = (Integer)value;
            if (this.currentObject == null) {
                if (this.isAll) {
                    Enumeration e = this.objects.elements();
                    while (e.hasMoreElements()) {
                        ((Text)e.nextElement()).setModel(modelIndex);
                    }
                }
                return;
            }
            this.currentObject.setModel(modelIndex);
            return;
        }
        if ("align" == propertyName) {
            String align = (String)value;
            if (this.currentObject == null) {
                if (this.isAll) {
                    Enumeration e = this.objects.elements();
                    while (e.hasMoreElements()) {
                        ((Text)e.nextElement()).setAlignment(align);
                    }
                }
                return;
            }
            if (!this.currentObject.setAlignment(align)) {
                Logger.error("unrecognized align:" + align);
            }
            return;
        }
        if ("bgcolor" == propertyName) {
            this.currentBgColor = value;
            if (this.currentObject == null) {
                if (this.isAll) {
                    Enumeration e = this.objects.elements();
                    while (e.hasMoreElements()) {
                        ((Text)e.nextElement()).setBgColix(value);
                    }
                }
                return;
            }
            this.currentObject.setBgColix(value);
            return;
        }
        if ("color" == propertyName) {
            this.currentColor = value;
            if (this.currentObject == null) {
                if (this.isAll || this.thisID != null) {
                    Enumeration e = this.objects.elements();
                    while (e.hasMoreElements()) {
                        Text text = (Text)e.nextElement();
                        if (!this.isAll && !TextFormat.isMatch(text.target.toUpperCase(), this.thisID, true, true)) continue;
                        text.setColix(value);
                    }
                }
                return;
            }
            this.currentObject.setColix(value);
            return;
        }
        if ("target" == propertyName) {
            String target = (String)value;
            this.isAll = target.equals("all");
            if (this.isAll || target.equals("none")) {
                this.currentObject = null;
            }
            return;
        }
        boolean isBackground = "bgtranslucency" == propertyName;
        if (isBackground || "translucency" == propertyName) {
            boolean isTranslucent;
            boolean bl = isTranslucent = "translucent" == value;
            if (isBackground) {
                this.currentBgTranslucentLevel = isTranslucent ? this.translucentLevel : 0.0f;
            } else {
                float f = this.currentTranslucentLevel = isTranslucent ? this.translucentLevel : 0.0f;
            }
            if (this.currentObject == null) {
                if (this.isAll) {
                    Enumeration e = this.objects.elements();
                    while (e.hasMoreElements()) {
                        ((Text)e.nextElement()).setTranslucent(this.translucentLevel, isBackground);
                    }
                }
                return;
            }
            this.currentObject.setTranslucent(this.translucentLevel, isBackground);
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            int modelIndex = ((int[])((Object[])value)[2])[0];
            Enumeration e = this.objects.elements();
            while (e.hasMoreElements()) {
                Text text = (Text)e.nextElement();
                if (text.modelIndex == modelIndex) {
                    this.objects.remove(text.target);
                    continue;
                }
                if (text.modelIndex <= modelIndex) continue;
                --text.modelIndex;
            }
            return;
        }
        super.setProperty(propertyName, value, bsSelected);
    }

    protected void initModelSet() {
        this.currentObject = null;
        this.isAll = false;
    }

    public void setVisibilityFlags(BitSet bs) {
        if (this.isHover) {
            return;
        }
        Enumeration e = this.objects.elements();
        while (e.hasMoreElements()) {
            Text t = (Text)e.nextElement();
            t.setVisibility(t.modelIndex < 0 || bs.get(t.modelIndex));
        }
    }

    public Point3f checkObjectClicked(int x, int y, int modifiers, BitSet bsVisible) {
        if (this.isHover) {
            return null;
        }
        Enumeration e = this.objects.elements();
        while (e.hasMoreElements()) {
            Object2d obj = (Object2d)e.nextElement();
            if (!obj.checkObjectClicked(x, y, bsVisible)) continue;
            String s = obj.getScript();
            if (s != null) {
                this.viewer.evalStringQuiet(s);
            }
            return obj.xyz == null ? new Point3f() : obj.xyz;
        }
        return null;
    }

    public boolean checkObjectHovered(int x, int y, BitSet bsVisible) {
        if (this.isHover) {
            return false;
        }
        Enumeration e = this.objects.elements();
        boolean haveScripts = false;
        while (e.hasMoreElements()) {
            Object2d obj = (Object2d)e.nextElement();
            String s = obj.getScript();
            if (s == null) continue;
            haveScripts = true;
            if (!obj.checkObjectClicked(x, y, bsVisible)) continue;
            this.viewer.setCursor(1);
            return true;
        }
        if (haveScripts) {
            this.viewer.setCursor(0);
        }
        return false;
    }
}

