/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

public abstract class Shape {
    public Viewer viewer;
    public ModelSet modelSet;
    public Graphics3D g3d;
    public int shapeID;
    public int myVisibilityFlag;
    protected float translucentLevel;
    protected boolean translucentAllowed = true;
    public boolean isBioShape;

    public Viewer getViewer() {
        return this.viewer;
    }

    public final void initializeShape(Viewer viewer, Graphics3D g3d, ModelSet modelSet, int shapeID) {
        this.viewer = viewer;
        this.g3d = g3d;
        this.shapeID = shapeID;
        this.myVisibilityFlag = JmolConstants.getShapeVisibilityFlag(shapeID);
        this.setModelSet(modelSet);
        this.initShape();
    }

    public void setModelSet(ModelSet modelSet) {
        this.modelSet = modelSet;
        this.initModelSet();
    }

    protected void initModelSet() {
    }

    public void initShape() {
    }

    public void setSize(int size, BitSet bsSelected) {
    }

    public void setSize(int flags, float size, BitSet bsSelected) {
    }

    public void setProperty(String propertyName, Object value, BitSet bsSelected) {
        if (propertyName == "translucentLevel") {
            this.translucentLevel = ((Float)value).floatValue();
            return;
        }
        if (propertyName == "refreshTrajectories") {
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            // empty if block
        }
        Logger.warn("unassigned " + JmolConstants.shapeClassBases[this.shapeID] + " + shape setProperty:" + propertyName + ":" + value);
    }

    public Object getProperty(String property, int index) {
        return null;
    }

    public int getIndexFromName(String thisID) {
        return -1;
    }

    public boolean wasClicked(int x, int y) {
        return false;
    }

    public void findNearestAtomIndex(int xMouse, int yMouse, Atom[] closest) {
    }

    public void checkBoundsMinMax(Point3f pointMin, Point3f pointMax) {
    }

    public void setModelClickability() {
    }

    public Point3f checkObjectClicked(int x, int y, int modifiers, BitSet bsVisible) {
        return null;
    }

    public boolean checkObjectHovered(int x, int y, BitSet bsVisible) {
        return false;
    }

    public boolean checkObjectDragged(int prevX, int prevY, int x, int y, int modifiers, BitSet bsVisible) {
        return false;
    }

    public short setColix(short colix, byte paletteID, int atomIndex) {
        return this.setColix(colix, paletteID, this.modelSet.getAtomAt(atomIndex));
    }

    protected short setColix(short colix, byte paletteID, Atom atom) {
        return colix == 2 ? this.viewer.getColixAtomPalette(atom, paletteID) : colix;
    }

    protected short setColix(short colix, byte paletteID, Bond bond) {
        return colix == 2 ? this.viewer.getColixBondPalette(bond, paletteID) : colix;
    }

    protected void remapColors() {
    }

    public Vector getShapeDetail() {
        return null;
    }

    public String getShapeState() {
        return null;
    }

    public void setVisibilityFlags(BitSet bs) {
    }

    public static void setStateInfo(Hashtable ht, int i, String key) {
        Shape.setStateInfo(ht, i, i, key);
    }

    public static void setStateInfo(Hashtable ht, int i1, int i2, String key) {
        StateManager.setStateInfo(ht, i1, i2, key);
    }

    public static String getShapeCommands(Hashtable htDefine, Hashtable htMore, int atomCount) {
        return StateManager.getCommands(htDefine, htMore, atomCount);
    }

    public static String getShapeCommands(Hashtable htDefine, Hashtable htMore, int count, String selectCmd) {
        return StateManager.getCommands(htDefine, htMore, count, selectCmd);
    }

    public static void appendCmd(StringBuffer s, String cmd) {
        StateManager.appendCmd(s, cmd);
    }

    public static String getFontCommand(String type, Font3D font) {
        if (font == null) {
            return "";
        }
        return "font " + type + " " + font.fontSizeNominal + " " + font.fontFace + " " + font.fontStyle;
    }

    public String getColorCommand(String type, short colix) {
        return this.getColorCommand(type, (byte)-1, colix);
    }

    public String getColorCommand(String type, byte pid, short colix) {
        if (pid == -1 && colix == 0) {
            return "";
        }
        return "color " + type + " " + this.encodeTransColor(pid, colix, this.translucentAllowed);
    }

    private String encodeTransColor(byte pid, short colix, boolean translucentAllowed) {
        if (pid == -1 && colix == 0) {
            return "";
        }
        return (translucentAllowed ? Shape.getTranslucentLabel(colix) + " " : "") + (pid != -1 && !JmolConstants.isPaletteVariable(pid) ? JmolConstants.getPaletteName(pid) : this.encodeColor(colix));
    }

    String encodeColor(short colix) {
        return Graphics3D.isColixColorInherited(colix) ? "none" : Escape.escapeColor(this.g3d.getColixArgb(colix));
    }

    private static String getTranslucentLabel(short colix) {
        return Graphics3D.isColixTranslucent(colix) ? "translucent " + Graphics3D.getColixTranslucencyLevel(colix) : "opaque";
    }

    public static short getColix(short[] colixes, int i, Atom atom) {
        return Graphics3D.getColixInherited(colixes == null || i >= colixes.length ? (short)0 : colixes[i], atom.getColix());
    }
}

