/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.shape.ShapeRenderer;
import org.jmol.viewer.JmolConstants;

public class SticksRenderer
extends ShapeRenderer {
    protected boolean showMultipleBonds;
    protected byte modeMultipleBond;
    protected byte endcaps;
    protected boolean ssbondsBackbone;
    protected boolean hbondsBackbone;
    protected boolean bondsBackbone;
    protected boolean hbondsSolid;
    protected Atom atomA;
    protected Atom atomB;
    protected Bond bond;
    int xA;
    int yA;
    int zA;
    int xB;
    int yB;
    int zB;
    int dx;
    int dy;
    int mag2d;
    protected short colixA;
    protected short colixB;
    protected int width;
    protected int bondOrder;
    private boolean renderWireframe;
    private boolean isAntialiased;
    protected boolean lineBond;
    int xAxis1;
    int yAxis1;
    int xAxis2;
    int yAxis2;
    int dxStep;
    int dyStep;
    private static int wideWidthMilliAngstroms = 400;

    protected void render() {
        this.endcaps = (byte)3;
        this.showMultipleBonds = this.viewer.getShowMultipleBonds();
        this.modeMultipleBond = this.viewer.getModeMultipleBond();
        this.renderWireframe = this.viewer.getInMotion() && this.viewer.getWireframeRotation();
        this.ssbondsBackbone = this.viewer.getSsbondsBackbone();
        this.hbondsBackbone = this.viewer.getHbondsBackbone();
        this.bondsBackbone = this.hbondsBackbone | this.ssbondsBackbone;
        this.hbondsSolid = this.viewer.getHbondsSolid();
        this.isAntialiased = this.g3d.isAntialiased();
        Bond[] bonds = this.modelSet.getBonds();
        int i = this.modelSet.getBondCount();
        while (--i >= 0) {
            this.bond = bonds[i];
            if ((this.bond.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0) continue;
            this.renderBond();
        }
    }

    protected void renderBond() {
        this.mad = this.bond.getMad();
        this.atomA = this.bond.getAtom1();
        this.atomB = this.bond.getAtom2();
        if (!this.atomA.isModelVisible() || !this.atomB.isModelVisible() || !this.g3d.isInDisplayRange(this.atomA.screenX, this.atomA.screenY) || !this.g3d.isInDisplayRange(this.atomB.screenX, this.atomB.screenY) || this.modelSet.isAtomHidden(this.atomA.getAtomIndex()) || this.modelSet.isAtomHidden(this.atomB.getAtomIndex())) {
            return;
        }
        this.colixA = this.atomA.getColix();
        this.colixB = this.atomB.getColix();
        this.colix = this.bond.getColix();
        if ((this.colix & 0xFFFF87FF) == 2) {
            this.colix = (short)(this.colix & 0x7800);
            this.colixA = Graphics3D.getColixInherited((short)(this.colix | this.viewer.getColixAtomPalette(this.atomA, (byte)1)), this.colixA);
            this.colixB = Graphics3D.getColixInherited((short)(this.colix | this.viewer.getColixAtomPalette(this.atomB, (byte)1)), this.colixB);
        } else {
            this.colixA = Graphics3D.getColixInherited(this.colix, this.colixA);
            this.colixB = Graphics3D.getColixInherited(this.colix, this.colixB);
        }
        int order = this.bond.getOrder() & Short.MAX_VALUE;
        if (this.bondsBackbone) {
            if (this.ssbondsBackbone && (order & 0x100) != 0) {
                this.atomA = this.atomA.getGroup().getLeadAtom(this.atomA);
                this.atomB = this.atomB.getGroup().getLeadAtom(this.atomB);
            } else if (this.hbondsBackbone && (order & 0x7800) != 0) {
                this.atomA = this.atomA.getGroup().getLeadAtom(this.atomA);
                this.atomB = this.atomB.getGroup().getLeadAtom(this.atomB);
            }
        }
        this.xA = this.atomA.screenX;
        this.yA = this.atomA.screenY;
        this.zA = this.atomA.screenZ;
        this.xB = this.atomB.screenX;
        this.yB = this.atomB.screenY;
        this.zB = this.atomB.screenZ;
        if (this.zA == 1 || this.zB == 1) {
            return;
        }
        this.dx = this.xB - this.xA;
        this.dy = this.yB - this.yA;
        this.width = this.viewer.scaleToScreen((this.zA + this.zB) / 2, this.mad);
        if (this.renderWireframe && this.width > 0) {
            this.width = 1;
        }
        this.bondOrder = this.getRenderBondOrder(order);
        switch (this.bondOrder) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.renderBond(0);
                break;
            }
            case 7: 
            case 513: {
                this.bondOrder = 1;
                this.renderBond(order == 513 ? 0 : 1);
                break;
            }
            case 514: 
            case 515: {
                this.bondOrder = 2;
                this.renderBond(order == 515 ? this.getAromaticDottedBondMask() : 0);
                break;
            }
            case 1025: 
            case 1026: {
                this.renderTriangle(this.bond);
                break;
            }
            default: {
                if ((this.bondOrder & 0xE0) != 0) {
                    this.bondOrder = JmolConstants.getPartialBondOrder(order);
                    this.renderBond(JmolConstants.getPartialBondDotted(order));
                    break;
                }
                if ((this.bondOrder & 0x7800) == 0) break;
                if (this.hbondsSolid) {
                    this.bondOrder = 1;
                    this.renderBond(0);
                    break;
                }
                this.renderHbondDashed();
            }
        }
    }

    int getRenderBondOrder(int order) {
        if (((order &= Short.MAX_VALUE) & 0xE0) != 0) {
            return order;
        }
        if ((order & 0x100) != 0) {
            order &= 0xFFFFFEFF;
        }
        if ((order & 0x3FF) != 0 && (order == 1 || !this.showMultipleBonds || this.modeMultipleBond == 0 || this.modeMultipleBond == 2 && this.mad > 500)) {
            return 1;
        }
        return order;
    }

    protected void renderBond(int dottedMask) {
        boolean bl = this.lineBond = this.width <= 1;
        if (this.lineBond && (this.isAntialiased || this.isGenerator)) {
            this.width = 3;
            this.lineBond = false;
        }
        if (this.dx == 0 && this.dy == 0) {
            if (!this.lineBond) {
                int space = this.width / 8 + 3;
                int step = this.width + space;
                int y = this.yA - (this.bondOrder - 1) * step / 2;
                do {
                    this.fillCylinder(this.colixA, this.colixA, this.endcaps, this.width, this.xA, y, this.zA, this.xA, y, this.zA);
                    y += step;
                } while (--this.bondOrder > 0);
            }
            return;
        }
        if (this.bondOrder == 1) {
            if ((dottedMask & 1) != 0) {
                this.drawDashed(this.xA, this.yA, this.zA, this.xB, this.yB, this.zB);
            } else {
                this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.xA, this.yA, this.zA, this.xB, this.yB, this.zB);
            }
            return;
        }
        int dxB = this.dx * this.dx;
        int dyB = this.dy * this.dy;
        int mag2d2 = dxB + dyB;
        this.mag2d = (int)(Math.sqrt(mag2d2) + 0.5);
        this.resetAxisCoordinates();
        while (true) {
            if ((dottedMask & 1) != 0) {
                this.drawDashed(this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB);
            } else {
                this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB);
            }
            dottedMask >>= 1;
            if (--this.bondOrder <= 0) break;
            this.stepAxisCoordinates();
        }
    }

    void resetAxisCoordinates() {
        int space = this.mag2d >> 3;
        int step = this.width + space;
        this.dxStep = step * this.dy / this.mag2d;
        this.dyStep = step * -this.dx / this.mag2d;
        this.xAxis1 = this.xA;
        this.yAxis1 = this.yA;
        this.xAxis2 = this.xB;
        this.yAxis2 = this.yB;
        if (this.bondOrder > 1) {
            int f = this.bondOrder - 1;
            this.xAxis1 -= this.dxStep * f / 2;
            this.yAxis1 -= this.dyStep * f / 2;
            this.xAxis2 -= this.dxStep * f / 2;
            this.yAxis2 -= this.dyStep * f / 2;
        }
    }

    void stepAxisCoordinates() {
        this.xAxis1 += this.dxStep;
        this.yAxis1 += this.dyStep;
        this.xAxis2 += this.dxStep;
        this.yAxis2 += this.dyStep;
    }

    private void renderTriangle(Bond bond) {
        int dyWide;
        int dxWide;
        if (!this.g3d.checkTranslucent(false)) {
            return;
        }
        int mag2d = (int)Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        int wideWidthPixels = this.viewer.scaleToScreen(this.zB, wideWidthMilliAngstroms);
        if (mag2d == 0) {
            dxWide = 0;
            dyWide = wideWidthPixels;
        } else {
            dxWide = wideWidthPixels * -this.dy / mag2d;
            dyWide = wideWidthPixels * this.dx / mag2d;
        }
        int xWideUp = this.xB + dxWide / 2;
        int xWideDn = xWideUp - dxWide;
        int yWideUp = this.yB + dyWide / 2;
        int yWideDn = yWideUp - dyWide;
        this.g3d.setColix(this.colixA);
        if (this.colixA == this.colixB) {
            this.g3d.drawfillTriangle(this.xA, this.yA, this.zA, xWideUp, yWideUp, this.zB, xWideDn, yWideDn, this.zB);
        } else {
            int xMidUp = (this.xA + xWideUp) / 2;
            int yMidUp = (this.yA + yWideUp) / 2;
            int zMid = (this.zA + this.zB) / 2;
            int xMidDn = (this.xA + xWideDn) / 2;
            int yMidDn = (this.yA + yWideDn) / 2;
            this.g3d.drawfillTriangle(this.xA, this.yA, this.zA, xMidUp, yMidUp, zMid, xMidDn, yMidDn, zMid);
            this.g3d.setColix(this.colixB);
            this.g3d.drawfillTriangle(xMidUp, yMidUp, zMid, xMidDn, yMidDn, zMid, xWideDn, yWideDn, this.zB);
            this.g3d.drawfillTriangle(xMidUp, yMidUp, zMid, xWideUp, yWideUp, this.zB, xWideDn, yWideDn, this.zB);
        }
    }

    private int getAromaticDottedBondMask() {
        Atom atomC = this.atomB.findAromaticNeighbor(this.atomA.getAtomIndex());
        if (atomC == null) {
            return 1;
        }
        int dyAC = atomC.screenY - this.yA;
        int dxAC = atomC.screenX - this.xA;
        return this.dx * dyAC - this.dy * dxAC < 0 ? 2 : 1;
    }

    void drawDashed(int xA, int yA, int zA, int xB, int yB, int zB) {
        int dx = xB - xA;
        int dy = yB - yA;
        int dz = zB - zA;
        for (int i = 2; i <= 9; i += 2) {
            int xS = xA + dx * i / 12;
            int yS = yA + dy * i / 12;
            int zS = zA + dz * i / 12;
            int xE = xA + dx * (i += 3) / 12;
            int yE = yA + dy * i / 12;
            int zE = zA + dz * i / 12;
            this.fillCylinder(this.colixA, this.colixB, (byte)2, this.width, xS, yS, zS, xE, yE, zE);
        }
    }

    void renderHbondDashed() {
        int dx = this.xB - this.xA;
        int dy = this.yB - this.yA;
        int dz = this.zB - this.zA;
        for (int i = 1; i < 10; ++i) {
            int xS = this.xA + dx * i / 10;
            int yS = this.yA + dy * i / 10;
            int zS = this.zA + dz * i / 10;
            short colixS = i < 5 ? this.colixA : this.colixB;
            int xE = this.xA + dx * (i += 2) / 10;
            int yE = this.yA + dy * i / 10;
            int zE = this.zA + dz * i / 10;
            short colixE = i < 5 ? this.colixA : this.colixB;
            this.fillCylinder(colixS, colixE, (byte)2, this.width, xS, yS, zS, xE, yE, zE);
        }
    }

    protected void fillCylinder(short colixA, short colixB, byte endcaps, int diameter, int xA, int yA, int zA, int xB, int yB, int zB) {
        if (this.lineBond) {
            this.g3d.drawLine(colixA, colixB, xA, yA, zA, xB, yB, zB);
        } else {
            this.g3d.fillCylinder(colixA, colixB, endcaps, diameter, xA, yA, zA, xB, yB, zB);
        }
    }
}

