/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.shape.Mesh;
import org.jmol.shape.Shape;
import org.jmol.shapebio.BioShapeCollection;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

class BioShape {
    int modelIndex;
    int modelVisibilityFlags = 0;
    BioShapeCollection shape;
    BioPolymer bioPolymer;
    Mesh[] meshes;
    boolean[] meshReady;
    short[] mads;
    short[] colixes;
    byte[] paletteIDs;
    BitSet bsColixSet;
    BitSet bsSizeSet;
    BitSet bsSizeDefault = new BitSet();
    boolean isActive;
    int monomerCount;
    Monomer[] monomers;
    Vector3f[] wingVectors;
    int[] leadAtomIndices;
    boolean hasBfactorRange = false;
    int bfactorMin;
    int bfactorMax;
    int range;
    float floatRange;
    private static final double eightPiSquared100 = 7895.6835208714865;

    BioShape(BioShapeCollection shape, int modelIndex, BioPolymer bioPolymer) {
        this.shape = shape;
        this.modelIndex = modelIndex;
        this.bioPolymer = bioPolymer;
        this.isActive = shape.isActive;
        this.monomerCount = bioPolymer.getMonomerCount();
        if (this.monomerCount > 0) {
            this.colixes = new short[this.monomerCount];
            this.paletteIDs = new byte[this.monomerCount];
            this.mads = new short[this.monomerCount + 1];
            this.monomers = bioPolymer.getMonomers();
            this.meshReady = new boolean[this.monomerCount];
            this.meshes = new Mesh[this.monomerCount];
            this.wingVectors = bioPolymer.getWingVectors();
            this.leadAtomIndices = bioPolymer.getLeadAtomIndices();
        }
    }

    void calcBfactorRange() {
        this.bfactorMin = this.bfactorMax = this.monomers[0].getLeadAtom().getBfactor100();
        int i = this.monomerCount;
        while (--i > 0) {
            int bfactor = this.monomers[i].getLeadAtom().getBfactor100();
            if (bfactor < this.bfactorMin) {
                this.bfactorMin = bfactor;
                continue;
            }
            if (bfactor <= this.bfactorMax) continue;
            this.bfactorMax = bfactor;
        }
        this.range = this.bfactorMax - this.bfactorMin;
        this.floatRange = this.range;
        this.hasBfactorRange = true;
    }

    short calcMeanPositionalDisplacement(int bFactor100) {
        return (short)(Math.sqrt((double)bFactor100 / 7895.6835208714865) * 1000.0);
    }

    void findNearestAtomIndex(int xMouse, int yMouse, Atom[] closest) {
        this.bioPolymer.findNearestAtomIndex(xMouse, yMouse, closest, this.mads, this.shape.myVisibilityFlag);
    }

    void setMad(short mad, BitSet bsSelected) {
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        int flag = this.shape.myVisibilityFlag;
        int i = this.monomerCount;
        while (--i >= 0) {
            int leadAtomIndex = this.leadAtomIndices[i];
            if (!bsSelected.get(leadAtomIndex)) continue;
            this.mads[i] = this.setMad(i, mad);
            boolean isVisible = this.mads[i] > 0;
            this.bsSizeSet.set(i, isVisible);
            this.monomers[i].setShapeVisibility(flag, isVisible);
            this.shape.atoms[leadAtomIndex].setShapeVisibility(flag, isVisible);
            this.falsifyMesh(i, true);
        }
        if (this.monomerCount > 1) {
            this.mads[this.monomerCount] = this.mads[this.monomerCount - 1];
        }
    }

    private short setMad(int groupIndex, short mad) {
        this.bsSizeDefault.set(groupIndex, mad == -1 || mad == -2);
        if (mad >= 0) {
            return mad;
        }
        switch (mad) {
            case -2: 
            case -1: {
                if (mad == -1 && this.shape.madOn >= 0) {
                    return this.shape.madOn;
                }
                switch (this.monomers[groupIndex].getProteinStructureType()) {
                    case 2: 
                    case 3: {
                        return this.shape.madHelixSheet;
                    }
                    case 4: 
                    case 5: {
                        return this.shape.madDnaRna;
                    }
                }
                return this.shape.madTurnRandom;
            }
            case -3: {
                if (!this.hasBfactorRange) {
                    this.calcBfactorRange();
                }
                Atom atom = this.monomers[groupIndex].getLeadAtom();
                int bfactor100 = atom.getBfactor100();
                int scaled = bfactor100 - this.bfactorMin;
                if (this.range == 0) {
                    return 0;
                }
                float percentile = (float)scaled / this.floatRange;
                if (percentile < 0.0f || percentile > 1.0f) {
                    Logger.error("Que ha ocurrido? " + percentile);
                }
                return (short)(1750.0f * percentile + 250.0f);
            }
            case -4: {
                Atom atom = this.monomers[groupIndex].getLeadAtom();
                return (short)(2 * this.calcMeanPositionalDisplacement(atom.getBfactor100()));
            }
        }
        Logger.error("unrecognized setMad(" + mad + ")");
        return 0;
    }

    void falsifyMesh(int index, boolean andNearby) {
        if (this.meshReady == null) {
            return;
        }
        this.meshReady[index] = false;
        if (!andNearby) {
            return;
        }
        if (index > 0) {
            this.meshReady[index - 1] = false;
        }
        if (index < this.monomerCount - 1) {
            this.meshReady[index + 1] = false;
        }
    }

    void setColix(short colix, byte pid, BitSet bsSelected) {
        this.isActive = true;
        if (this.bsColixSet == null) {
            this.bsColixSet = new BitSet();
        }
        int i = this.monomerCount;
        while (--i >= 0) {
            int atomIndex = this.leadAtomIndices[i];
            if (!bsSelected.get(atomIndex)) continue;
            this.colixes[i] = this.shape.setColix(colix, pid, atomIndex);
            this.paletteIDs[i] = pid;
            this.bsColixSet.set(i, this.colixes[i] != 0);
        }
    }

    void setTranslucent(boolean isTranslucent, BitSet bsSelected, float translucentLevel) {
        this.isActive = true;
        if (this.bsColixSet == null) {
            this.bsColixSet = new BitSet();
        }
        int i = this.monomerCount;
        while (--i >= 0) {
            if (!bsSelected.get(this.leadAtomIndices[i])) continue;
            this.colixes[i] = Graphics3D.getColixTranslucent(this.colixes[i], isTranslucent, translucentLevel);
            this.bsColixSet.set(i, this.colixes[i] != 0);
        }
    }

    void setShapeState(Hashtable temp, Hashtable temp2) {
        if (!this.isActive) {
            return;
        }
        String type = JmolConstants.shapeClassBases[this.shape.shapeID];
        for (int i = 0; i < this.monomerCount; ++i) {
            int atomIndex1 = this.monomers[i].getFirstAtomIndex();
            int atomIndex2 = this.monomers[i].getLastAtomIndex();
            if (this.bsSizeSet != null && (this.bsSizeSet.get(i) || this.bsColixSet != null && this.bsColixSet.get(i))) {
                if (this.bsSizeDefault.get(i)) {
                    Shape.setStateInfo(temp, atomIndex1, atomIndex2, type + (this.bsSizeSet.get(i) ? " on" : " off"));
                } else {
                    Shape.setStateInfo(temp, atomIndex1, atomIndex2, type + " " + (float)this.mads[i] / 2000.0f);
                }
            }
            if (this.bsColixSet == null || !this.bsColixSet.get(i)) continue;
            Shape.setStateInfo(temp2, atomIndex1, atomIndex2, this.shape.getColorCommand(type, this.paletteIDs[i], this.colixes[i]));
        }
    }

    void setModelClickability() {
        if (!this.isActive || this.wingVectors == null) {
            return;
        }
        boolean isNucleicPolymer = this.bioPolymer instanceof NucleicPolymer;
        int i = this.monomerCount;
        while (--i >= 0) {
            if (this.mads[i] <= 0) continue;
            int iAtom = this.leadAtomIndices[i];
            if (this.monomers[i].getModel().isAtomHidden(iAtom)) continue;
            this.shape.atoms[iAtom].setClickable(JmolConstants.ALPHA_CARBON_VISIBILITY_FLAG);
            if (!isNucleicPolymer) continue;
            ((NucleicMonomer)this.monomers[i]).setModelClickability();
        }
    }
}

