/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.RocketsRenderer;

public class CartoonRenderer
extends RocketsRenderer {
    private boolean newRockets = true;
    private boolean renderAsRockets;
    Point3i ptConnect = new Point3i();
    private final Point3f[] ring6Points = new Point3f[6];
    private final Point3i[] ring6Screens = new Point3i[6];
    private final Point3f[] ring5Points = new Point3f[5];
    private final Point3i[] ring5Screens = new Point3i[5];

    public CartoonRenderer() {
        this.ring6Screens[5] = new Point3i();
        int i = 5;
        while (--i >= 0) {
            this.ring5Screens[i] = new Point3i();
            this.ring6Screens[i] = new Point3i();
        }
    }

    protected void renderBioShape(BioShape bioShape) {
        int i;
        if (bioShape.wingVectors == null || this.isCarbohydrate) {
            return;
        }
        this.calcScreenControlPoints();
        if (this.isNucleic) {
            this.renderNucleic();
            return;
        }
        boolean val = this.viewer.getCartoonRocketFlag();
        if (this.renderAsRockets != val) {
            for (i = 0; i < this.monomerCount; ++i) {
                bioShape.falsifyMesh(i, false);
            }
            this.renderAsRockets = val;
        }
        if (this.renderAsBarrels != (val = this.viewer.getRocketBarrelFlag())) {
            for (i = 0; i < this.monomerCount; ++i) {
                bioShape.falsifyMesh(i, false);
            }
            this.renderAsBarrels = val;
        }
        this.ribbonTopScreens = this.calcScreens(0.5f);
        this.ribbonBottomScreens = this.calcScreens(-0.5f);
        this.calcRopeMidPoints(this.newRockets);
        if (this.renderAsBarrels) {
            this.calcScreenControlPoints(this.cordMidPoints);
            this.controlPoints = this.cordMidPoints;
        }
        this.render1();
        this.viewer.freeTempPoints(this.cordMidPoints);
        this.viewer.freeTempScreens(this.ribbonTopScreens);
        this.viewer.freeTempScreens(this.ribbonBottomScreens);
    }

    void renderNucleic() {
        boolean isTraceAlpha = this.viewer.getTraceAlpha();
        int i = this.monomerCount;
        while (--i >= 0) {
            if (!this.bsVisible.get(i)) continue;
            if (isTraceAlpha) {
                this.ptConnect.set((this.controlPointScreens[i].x + this.controlPointScreens[i + 1].x) / 2, (this.controlPointScreens[i].y + this.controlPointScreens[i + 1].y) / 2, (this.controlPointScreens[i].z + this.controlPointScreens[i + 1].z) / 2);
            } else {
                this.ptConnect.set(this.controlPointScreens[i + 1]);
            }
            this.renderHermiteConic(i, false);
            this.colix = this.getLeadColix(i);
            if (!this.g3d.setColix(this.colix)) continue;
            this.renderNucleicBaseStep((NucleicMonomer)this.monomers[i], this.mads[i], this.ptConnect);
        }
    }

    protected void render1() {
        boolean lastWasSheet = false;
        boolean lastWasHelix = false;
        ProteinStructure previousStructure = null;
        int i = this.monomerCount;
        while (--i >= 0) {
            boolean isHelixRocket;
            ProteinStructure thisStructure = this.monomers[i].getProteinStructure();
            if (thisStructure != previousStructure) {
                lastWasHelix = false;
                lastWasSheet = false;
            }
            previousStructure = thisStructure;
            boolean isHelix = this.isHelix(i);
            boolean isSheet = this.isSheet(i);
            boolean bl = isHelixRocket = this.renderAsRockets || this.renderAsBarrels ? isHelix : false;
            if (this.bsVisible.get(i) && !isHelixRocket) {
                if (isSheet || isHelix) {
                    if (lastWasSheet && isSheet || lastWasHelix && isHelix) {
                        this.renderHermiteRibbon(true, i, true);
                    } else {
                        this.renderHermiteArrowHead(i);
                    }
                } else if (i != this.monomerCount - 1) {
                    this.renderHermiteConic(i, true);
                }
            }
            lastWasSheet = isSheet;
            lastWasHelix = isHelix;
        }
        if (this.renderAsRockets || this.renderAsBarrels) {
            this.renderRockets();
        }
    }

    private void renderRockets() {
        this.tPending = false;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (!this.bsVisible.get(i) || !this.isHelix(i)) continue;
            this.renderSpecialSegment(this.monomers[i], this.getLeadColix(i), this.mads[i]);
        }
        this.renderPending();
    }

    private void renderNucleicBaseStep(NucleicMonomer nucleotide, short thisMad, Point3i backboneScreen) {
        Point3i stepScreen;
        nucleotide.getBaseRing6Points(this.ring6Points);
        this.viewer.transformPoints(this.ring6Points, this.ring6Screens);
        this.renderRing6();
        boolean hasRing5 = nucleotide.maybeGetBaseRing5Points(this.ring5Points);
        if (hasRing5) {
            this.viewer.transformPoints(this.ring5Points, this.ring5Screens);
            this.renderRing5();
            stepScreen = this.ring5Screens[3];
        } else {
            stepScreen = this.ring6Screens[2];
        }
        this.mad = (short)(thisMad > 1 ? thisMad / 2 : thisMad);
        this.g3d.fillCylinder((byte)3, this.viewer.scaleToScreen(backboneScreen.z, this.mad), backboneScreen, stepScreen);
        --this.ring6Screens[5].z;
        int i = 5;
        while (--i > 0) {
            --this.ring6Screens[i].z;
            if (!hasRing5) continue;
            --this.ring5Screens[i].z;
        }
        i = 6;
        while (--i > 0) {
            this.g3d.fillCylinder((byte)3, 3, this.ring6Screens[i], this.ring6Screens[i - 1]);
        }
        if (hasRing5) {
            i = 5;
            while (--i > 0) {
                this.g3d.fillCylinder((byte)3, 3, this.ring5Screens[i], this.ring5Screens[i - 1]);
            }
        } else {
            this.g3d.fillCylinder((byte)3, 3, this.ring6Screens[5], this.ring6Screens[0]);
        }
    }

    private void renderRing6() {
        this.g3d.calcSurfaceShade(this.ring6Screens[0], this.ring6Screens[2], this.ring6Screens[4]);
        this.g3d.fillTriangle(this.ring6Screens[0], this.ring6Screens[2], this.ring6Screens[4]);
        this.g3d.fillTriangle(this.ring6Screens[0], this.ring6Screens[1], this.ring6Screens[2]);
        this.g3d.fillTriangle(this.ring6Screens[0], this.ring6Screens[4], this.ring6Screens[5]);
        this.g3d.fillTriangle(this.ring6Screens[2], this.ring6Screens[3], this.ring6Screens[4]);
    }

    private void renderRing5() {
        this.g3d.fillTriangle(this.ring5Screens[0], this.ring5Screens[2], this.ring5Screens[3]);
        this.g3d.fillTriangle(this.ring5Screens[0], this.ring5Screens[1], this.ring5Screens[2]);
        this.g3d.fillTriangle(this.ring5Screens[0], this.ring5Screens[3], this.ring5Screens[4]);
    }
}

