/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.Helix;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Sheet;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.BioShapeRenderer;

public class RocketsRenderer
extends BioShapeRenderer {
    private static final float MIN_CONE_HEIGHT = 0.05f;
    protected boolean renderAsBarrels;
    protected Point3f[] cordMidPoints;
    protected boolean tPending;
    private ProteinStructure proteinstructurePending;
    private int startIndexPending;
    private int endIndexPending;
    private Point3f screenA = new Point3f();
    private Point3f screenB = new Point3f();
    private Point3f screenC = new Point3f();
    private static final byte[] boxFaces = new byte[]{0, 1, 3, 2, 0, 2, 6, 4, 0, 4, 5, 1, 7, 5, 4, 6, 7, 6, 2, 3, 7, 3, 1, 5};
    private final Point3f[] corners = new Point3f[8];
    private final Point3f[] screenCorners = new Point3f[8];
    private final Point3f pointTipOffset;
    private final Vector3f scaledWidthVector;
    private final Vector3f scaledHeightVector;
    private static final byte[] arrowHeadFaces = new byte[]{0, 1, 3, 2, 0, 4, 5, 2, 1, 4, 5, 3};
    private final Vector3f lengthVector;
    private final Point3f pointCorner;

    public RocketsRenderer() {
        int i = 8;
        while (--i >= 0) {
            this.screenCorners[i] = new Point3f();
            this.corners[i] = new Point3f();
        }
        this.pointTipOffset = new Point3f();
        this.scaledWidthVector = new Vector3f();
        this.scaledHeightVector = new Vector3f();
        this.lengthVector = new Vector3f();
        this.pointCorner = new Point3f();
    }

    protected void renderBioShape(BioShape bioShape) {
        if (!(bioShape.bioPolymer instanceof AminoPolymer)) {
            return;
        }
        boolean val = this.viewer.getRocketBarrelFlag();
        if (this.renderAsBarrels != val) {
            for (int i = 0; i < this.monomerCount; ++i) {
                bioShape.falsifyMesh(i, false);
            }
            this.renderAsBarrels = val;
        }
        this.calcRopeMidPoints(false);
        this.calcScreenControlPoints(this.cordMidPoints);
        this.controlPoints = this.cordMidPoints;
        this.render1();
        this.viewer.freeTempPoints(this.cordMidPoints);
    }

    protected boolean isSheet(int i) {
        return this.structureTypes[i] == 2;
    }

    protected void calcRopeMidPoints(boolean isNewStyle) {
        Point3f point;
        int midPointCount = this.monomerCount + 1;
        this.cordMidPoints = this.viewer.allocTempPoints(midPointCount);
        ProteinStructure proteinstructurePrev = null;
        for (int i = 0; i < this.monomerCount; ++i) {
            point = this.cordMidPoints[i];
            Monomer residue = this.monomers[i];
            if (isNewStyle && !this.renderAsBarrels) {
                point.set(this.controlPoints[i]);
                continue;
            }
            if (this.isHelix(i) || !isNewStyle && this.isSheet(i)) {
                ProteinStructure proteinstructure = residue.getProteinStructure();
                point.set(i - 1 != proteinstructure.getMonomerIndex() ? proteinstructure.getAxisStartPoint() : proteinstructure.getAxisEndPoint());
                proteinstructurePrev = proteinstructure;
                continue;
            }
            if (proteinstructurePrev != null) {
                point.set(proteinstructurePrev.getAxisEndPoint());
            } else {
                point.set(this.controlPoints[i]);
            }
            proteinstructurePrev = null;
        }
        point = this.cordMidPoints[this.monomerCount];
        if (proteinstructurePrev != null) {
            point.set(proteinstructurePrev.getAxisEndPoint());
        } else {
            point.set(this.controlPoints[this.monomerCount]);
        }
    }

    protected void render1() {
        this.tPending = false;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (!this.bsVisible.get(i)) continue;
            Monomer monomer = this.monomers[i];
            if (this.isHelix(i) || this.isSheet(i)) {
                this.renderSpecialSegment(monomer, this.getLeadColix(i), this.mads[i]);
                continue;
            }
            this.renderPending();
            this.renderHermiteConic(i, true);
        }
        this.renderPending();
    }

    protected void renderSpecialSegment(Monomer monomer, short thisColix, short thisMad) {
        ProteinStructure proteinstructure = monomer.getProteinStructure();
        if (this.tPending) {
            if (proteinstructure == this.proteinstructurePending && thisMad == this.mad && thisColix == this.colix && proteinstructure.getIndex(monomer) == this.endIndexPending + 1) {
                ++this.endIndexPending;
                return;
            }
            this.renderPending();
        }
        this.proteinstructurePending = proteinstructure;
        this.startIndexPending = this.endIndexPending = proteinstructure.getIndex(monomer);
        this.colix = thisColix;
        this.mad = thisMad;
        this.tPending = true;
    }

    protected void renderPending() {
        boolean tEnd;
        if (!this.tPending) {
            return;
        }
        Point3f[] segments = this.proteinstructurePending.getSegments();
        boolean bl = tEnd = this.endIndexPending == this.proteinstructurePending.getMonomerCount() - 1;
        if (this.proteinstructurePending instanceof Helix) {
            this.renderPendingRocketSegment(this.endIndexPending, segments[this.startIndexPending], segments[this.endIndexPending], segments[this.endIndexPending + 1], tEnd);
        } else if (this.proteinstructurePending instanceof Sheet) {
            this.renderPendingSheet(segments[this.startIndexPending], segments[this.endIndexPending], segments[this.endIndexPending + 1], tEnd);
        }
        this.tPending = false;
    }

    private void renderPendingRocketSegment(int i, Point3f pointStart, Point3f pointBeforeEnd, Point3f pointEnd, boolean tEnd) {
        this.viewer.transformPoint(pointStart, this.screenA);
        this.viewer.transformPoint(pointEnd, this.screenB);
        int zMid = (int)Math.floor((this.screenA.z + this.screenB.z) / 2.0f);
        short diameter = this.viewer.scaleToScreen(zMid, this.mad);
        if (tEnd) {
            this.viewer.transformPoint(pointBeforeEnd, this.screenC);
            if (this.g3d.setColix(this.colix)) {
                if (this.renderAsBarrels || pointBeforeEnd.distance(pointEnd) <= 0.05f) {
                    this.g3d.fillCylinderBits((byte)2, diameter, this.screenB, this.screenC);
                } else {
                    this.renderCone(i, pointBeforeEnd, pointEnd, this.screenC, this.screenB);
                }
            }
            if (this.startIndexPending == this.endIndexPending) {
                return;
            }
            Point3f t = this.screenB;
            this.screenB = this.screenC;
            this.screenC = t;
        }
        if (this.g3d.setColix(this.colix)) {
            this.g3d.fillCylinderBits((byte)2, diameter, this.screenA, this.screenB);
        }
    }

    private void renderPendingSheet(Point3f pointStart, Point3f pointBeforeEnd, Point3f pointEnd, boolean tEnd) {
        if (!this.g3d.setColix(this.colix)) {
            return;
        }
        if (tEnd) {
            this.drawArrowHeadBox(pointBeforeEnd, pointEnd);
            this.drawBox(pointStart, pointBeforeEnd);
        } else {
            this.drawBox(pointStart, pointEnd);
        }
    }

    void buildBox(Point3f pointCorner, Vector3f scaledWidthVector, Vector3f scaledHeightVector, Vector3f lengthVector) {
        int i = 8;
        while (--i >= 0) {
            Point3f corner = this.corners[i];
            corner.set(pointCorner);
            if ((i & 1) != 0) {
                corner.add(scaledWidthVector);
            }
            if ((i & 2) != 0) {
                corner.add(scaledHeightVector);
            }
            if ((i & 4) != 0) {
                corner.add(lengthVector);
            }
            this.viewer.transformPoint(corner, this.screenCorners[i]);
        }
    }

    void buildArrowHeadBox(Point3f pointCorner, Vector3f scaledWidthVector, Vector3f scaledHeightVector, Point3f pointTip) {
        int i = 4;
        while (--i >= 0) {
            Point3f corner = this.corners[i];
            corner.set(pointCorner);
            if ((i & 1) != 0) {
                corner.add(scaledWidthVector);
            }
            if ((i & 2) != 0) {
                corner.add(scaledHeightVector);
            }
            this.viewer.transformPoint(corner, this.screenCorners[i]);
        }
        this.corners[4].set(pointTip);
        this.viewer.transformPoint(pointTip, this.screenCorners[4]);
        this.corners[5].add(pointTip, scaledHeightVector);
        this.viewer.transformPoint(this.corners[5], this.screenCorners[5]);
    }

    void drawBox(Point3f pointA, Point3f pointB) {
        Sheet sheet = (Sheet)this.proteinstructurePending;
        float scale = (float)this.mad / 1000.0f;
        this.scaledWidthVector.set(sheet.getWidthUnitVector());
        this.scaledWidthVector.scale(scale);
        this.scaledHeightVector.set(sheet.getHeightUnitVector());
        this.scaledHeightVector.scale(scale / 4.0f);
        this.pointCorner.add(this.scaledWidthVector, this.scaledHeightVector);
        this.pointCorner.scaleAdd(-0.5f, pointA);
        this.lengthVector.sub(pointB, pointA);
        this.buildBox(this.pointCorner, this.scaledWidthVector, this.scaledHeightVector, this.lengthVector);
        for (int i = 0; i < 6; ++i) {
            byte i0 = boxFaces[i * 4];
            byte i1 = boxFaces[i * 4 + 1];
            byte i2 = boxFaces[i * 4 + 2];
            byte i3 = boxFaces[i * 4 + 3];
            this.g3d.fillQuadrilateral(this.screenCorners[i0], this.screenCorners[i1], this.screenCorners[i2], this.screenCorners[i3]);
        }
    }

    void drawArrowHeadBox(Point3f base, Point3f tip) {
        Sheet sheet = (Sheet)this.proteinstructurePending;
        float scale = (float)this.mad / 1000.0f;
        this.scaledWidthVector.set(sheet.getWidthUnitVector());
        this.scaledWidthVector.scale(scale * 1.25f);
        this.scaledHeightVector.set(sheet.getHeightUnitVector());
        this.scaledHeightVector.scale(scale / 3.0f);
        this.pointCorner.add(this.scaledWidthVector, this.scaledHeightVector);
        this.pointCorner.scaleAdd(-0.5f, base);
        this.pointTipOffset.set(this.scaledHeightVector);
        this.pointTipOffset.scaleAdd(-0.5f, tip);
        this.buildArrowHeadBox(this.pointCorner, this.scaledWidthVector, this.scaledHeightVector, this.pointTipOffset);
        this.g3d.fillTriangle(this.screenCorners[0], this.screenCorners[1], this.screenCorners[4]);
        this.g3d.fillTriangle(this.screenCorners[2], this.screenCorners[3], this.screenCorners[5]);
        for (int i = 0; i < 12; i += 4) {
            byte i0 = arrowHeadFaces[i];
            byte i1 = arrowHeadFaces[i + 1];
            byte i2 = arrowHeadFaces[i + 2];
            byte i3 = arrowHeadFaces[i + 3];
            this.g3d.fillQuadrilateral(this.screenCorners[i0], this.screenCorners[i1], this.screenCorners[i2], this.screenCorners[i3]);
        }
    }
}

