/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import javax.vecmath.Point3i;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.BioShapeRenderer;
import org.jmol.shapebio.Strands;

public class StrandsRenderer
extends BioShapeRenderer {
    protected int strandCount;
    protected float strandSeparation;
    protected float baseOffset;

    protected void renderBioShape(BioShape bioShape) {
        if (!this.setStrandCount()) {
            return;
        }
        this.render1();
    }

    protected boolean setStrandCount() {
        if (this.wingVectors == null) {
            return false;
        }
        this.strandCount = this.viewer.getStrandCount(((Strands)this.shape).shapeID);
        this.strandSeparation = this.strandCount <= 1 ? 0.0f : 1.0f / (float)(this.strandCount - 1);
        this.baseOffset = (this.strandCount & 1) == 0 ? this.strandSeparation / 2.0f : this.strandSeparation;
        return true;
    }

    protected void render1() {
        Point3i[] screens;
        int i = this.strandCount >> 1;
        while (--i >= 0) {
            float f = (float)i * this.strandSeparation + this.baseOffset;
            screens = this.calcScreens(f);
            this.render1Strand(screens);
            this.viewer.freeTempScreens(screens);
            screens = this.calcScreens(-f);
            this.render1Strand(screens);
            this.viewer.freeTempScreens(screens);
        }
        if (this.strandCount % 2 == 1) {
            screens = this.calcScreens(0.0f);
            this.render1Strand(screens);
            this.viewer.freeTempScreens(screens);
        }
    }

    private void render1Strand(Point3i[] screens) {
        int i = this.monomerCount;
        while (--i >= 0) {
            if (!this.bsVisible.get(i)) continue;
            this.renderHermiteCylinder(screens, i);
        }
    }
}

