/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.util.Escape;

class Dipole {
    String thisID = "";
    short mad;
    short colix = 0;
    short type;
    Point3f origin;
    Point3f center;
    Vector3f vector;
    String dipoleInfo = "";
    float dipoleValue;
    boolean isUserValue;
    float offsetSide;
    float offsetAngstroms;
    int offsetPercent;
    int visibilityFlags;
    int modelIndex;
    boolean visible;
    boolean noCross;
    boolean haveAtoms;
    boolean isValid;
    Atom[] atoms = new Atom[2];
    Point3f[] coords = new Point3f[2];
    Bond bond;
    static final short DIPOLE_TYPE_UNKNOWN = 0;
    static final short DIPOLE_TYPE_POINTS = 1;
    static final short DIPOLE_TYPE_ATOMS = 2;
    static final short DIPOLE_TYPE_BOND = 3;
    static final short DIPOLE_TYPE_MOLECULAR = 4;
    static final short DIPOLE_TYPE_POINTVECTOR = 5;

    Dipole() {
    }

    Dipole(int modelIndex, String thisID, String dipoleInfo, short colix, short mad, boolean visible) {
        this.modelIndex = modelIndex;
        this.thisID = thisID;
        this.dipoleInfo = dipoleInfo;
        this.colix = colix;
        this.mad = mad;
        this.visible = visible;
        this.type = 0;
    }

    void setTranslucent(boolean isTranslucent, float translucentLevel) {
        this.colix = Graphics3D.getColixTranslucent(this.colix, isTranslucent, translucentLevel);
    }

    void set(String thisID, String dipoleInfo, Atom[] atoms, float dipoleValue, short mad, float offsetAngstroms, int offsetPercent, float offsetSide, Point3f origin, Vector3f vector) {
        this.thisID = thisID;
        this.dipoleInfo = dipoleInfo;
        this.dipoleValue = dipoleValue;
        this.mad = mad;
        this.offsetAngstroms = offsetAngstroms;
        this.offsetPercent = offsetPercent;
        this.offsetSide = offsetSide;
        this.vector = new Vector3f(vector);
        this.origin = new Point3f(origin);
        boolean bl = this.haveAtoms = atoms[0] != null;
        if (this.haveAtoms) {
            this.atoms[0] = atoms[0];
            this.atoms[1] = atoms[1];
            this.centerDipole();
        } else {
            this.center = null;
        }
    }

    private void set(Point3f pt1, Point3f pt2) {
        this.coords[0] = new Point3f(pt1);
        this.coords[1] = new Point3f(pt2);
        boolean bl = this.isValid = this.coords[0].distance(this.coords[1]) > 0.1f;
        if (this.dipoleValue < 0.0f) {
            this.origin = new Point3f(pt2);
            this.vector = new Vector3f(pt1);
            this.dipoleValue = -this.dipoleValue;
        } else {
            this.origin = new Point3f(pt1);
            this.vector = new Vector3f(pt2);
        }
        this.dipoleInfo = "" + this.origin + this.vector;
        this.vector.sub(this.origin);
        if (this.dipoleValue == 0.0f) {
            this.dipoleValue = this.vector.length();
        } else {
            this.vector.scale(this.dipoleValue / this.vector.length());
        }
        this.type = 1;
    }

    void set(float value) {
        float d = this.dipoleValue;
        this.dipoleValue = value;
        if (value == 0.0f) {
            this.isValid = false;
        }
        if (this.vector == null) {
            return;
        }
        this.vector.scale(this.dipoleValue / this.vector.length());
        if (d * this.dipoleValue < 0.0f) {
            this.origin.sub(this.vector);
        }
    }

    void set(Point3f pt1, Point3f pt2, float value) {
        this.dipoleValue = value;
        this.atoms[0] = null;
        this.set(pt1, pt2);
    }

    void set(Point3f pt1, Vector3f dipole) {
        this.set(dipole.length());
        Point3f pt2 = new Point3f(pt1);
        pt2.add(dipole);
        this.set(pt1, pt2);
        this.type = (short)5;
    }

    void set(Atom atom1, Atom atom2, float value) {
        this.set(value);
        this.set((Point3f)atom1, atom2);
        this.offsetSide = 0.4f;
        this.mad = (short)5;
        this.atoms[0] = atom1;
        this.atoms[1] = atom2;
        this.haveAtoms = true;
        this.centerDipole();
    }

    void centerDipole() {
        boolean bl = this.isValid = this.atoms[0] != this.atoms[1] && this.dipoleValue != 0.0f;
        if (!this.isValid) {
            return;
        }
        float f = this.atoms[0].distance(this.atoms[1]) / (2.0f * this.dipoleValue) - 0.5f;
        this.origin.scaleAdd(f, this.vector, this.atoms[0]);
        this.center = new Point3f();
        this.center.scaleAdd(0.5f, this.vector, this.origin);
        this.bond = this.atoms[0].getBond(this.atoms[1]);
        this.type = (short)(this.bond == null ? 2 : 3);
    }

    boolean isBondType() {
        return this.type == 2 || this.type == 3;
    }

    public String getShapeState() {
        if (!this.isValid) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        s.append("dipole ID ").append(this.thisID);
        if (this.haveAtoms) {
            s.append(" ({").append(this.atoms[0].getAtomIndex()).append(" ").append(this.atoms[1].getAtomIndex()).append("})");
        } else {
            if (this.coords[0] == null) {
                return "";
            }
            s.append(" ").append(Escape.escape(this.coords[0])).append(" ").append(Escape.escape(this.coords[1]));
        }
        if (this.isUserValue) {
            s.append(" value ").append(this.dipoleValue);
        }
        if (this.mad != 5) {
            s.append(" width ").append((float)this.mad / 1000.0f);
        }
        if (this.offsetAngstroms != 0.0f) {
            s.append(" offset ").append(this.offsetAngstroms);
        } else if (this.offsetPercent != 0) {
            s.append(" offset ").append(this.offsetPercent);
        }
        if (this.offsetSide != 0.4f) {
            s.append(" offsetSide ").append(this.offsetSide);
        }
        if (this.noCross) {
            s.append(" nocross");
        }
        if (!this.visible) {
            s.append(" off");
        }
        s.append(";\n");
        return s.toString();
    }
}

