/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shapespecial.DrawMesh;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;

public class Draw
extends MeshCollection {
    DrawMesh[] dmeshes = new DrawMesh[4];
    DrawMesh thisMesh;
    private Point3f[] ptList;
    private Vector3f offset = new Vector3f();
    private int nPoints;
    private int diameter;
    private float width;
    private float newScale;
    private float length;
    private boolean isCurve;
    private boolean isArc;
    private boolean isArrow;
    private boolean isLine;
    private boolean isVector;
    private boolean isCircle;
    private boolean isPerpendicular;
    private boolean isCylinder;
    private boolean isVertices;
    private boolean isPlane;
    private boolean isReversed;
    private boolean isRotated45;
    private boolean isCrossed;
    private boolean isValid;
    private boolean noHead;
    private int indicatedModelIndex = -1;
    private int[] modelInfo;
    private boolean makePoints;
    private int nidentifiers;
    private int nbitsets;
    private Point4f plane;
    private BitSet bsAllModels;
    private Vector vData;
    private static final int PT_COORD = 1;
    private static final int PT_IDENTIFIER = 2;
    private static final int PT_BITSET = 3;
    private static final int PT_MODEL_INDEX = 4;
    private static final int PT_MODEL_BASED_POINTS = 5;
    private final Vector3f vAB = new Vector3f();
    private final Vector3f vAC = new Vector3f();
    private static final int MAX_OBJECT_CLICK_DISTANCE_SQUARED = 100;
    private DrawMesh pickedMesh = null;
    private int pickedModel;
    private int pickedVertex;
    private final Point3i ptXY = new Point3i();

    public void allocMesh(String thisID) {
        this.dmeshes = (DrawMesh[])ArrayUtil.ensureLength(this.dmeshes, this.meshCount + 1);
        this.meshes = this.dmeshes;
        DrawMesh drawMesh = new DrawMesh(thisID, this.g3d, this.colix);
        this.dmeshes[this.meshCount++] = drawMesh;
        this.thisMesh = drawMesh;
        this.currentMesh = drawMesh;
    }

    void setPropertySuper(String propertyName, Object value, BitSet bs) {
        this.currentMesh = this.thisMesh;
        super.setProperty(propertyName, value, bs);
        this.thisMesh = (DrawMesh)this.currentMesh;
    }

    public void initShape() {
        super.initShape();
        this.myType = "draw";
    }

    public void setProperty(String propertyName, Object value, BitSet bs) {
        if (Logger.debugging) {
            Logger.debug("draw " + propertyName + " " + value);
        }
        if ("init" == propertyName) {
            this.colix = (short)5;
            this.newScale = 0.0f;
            this.noHead = false;
            this.isCrossed = false;
            this.isRotated45 = false;
            this.isReversed = false;
            this.isFixed = false;
            this.isLine = false;
            this.isCylinder = false;
            this.isCircle = false;
            this.isPlane = false;
            this.isArrow = false;
            this.isArc = false;
            this.isCurve = false;
            this.isVector = false;
            this.isPerpendicular = false;
            this.isVertices = false;
            this.isValid = true;
            this.length = Float.MAX_VALUE;
            this.diameter = 0;
            this.width = 0.0f;
            this.indicatedModelIndex = -1;
            this.offset = null;
            this.plane = null;
            this.nbitsets = 0;
            this.nidentifiers = 0;
            this.vData = new Vector();
            this.modelCount = this.viewer.getModelCount();
            this.bsAllModels = null;
            this.setPropertySuper("thisID", "+PREVIOUS_MESH+", null);
            this.setPropertySuper("init", value, bs);
            return;
        }
        if ("length" == propertyName) {
            this.length = ((Float)value).floatValue();
            return;
        }
        if ("fixed" == propertyName) {
            this.isFixed = (Boolean)value;
            return;
        }
        if ("modelIndex" == propertyName) {
            this.indicatedModelIndex = (Integer)value;
            if (this.indicatedModelIndex < 0 || this.indicatedModelIndex >= this.modelCount) {
                return;
            }
            Object[] objectArray = new Object[2];
            objectArray[0] = new Integer(4);
            this.modelInfo = new int[]{this.indicatedModelIndex, 0};
            objectArray[1] = this.modelInfo;
            this.vData.add(objectArray);
            return;
        }
        if ("planedef" == propertyName) {
            this.plane = (Point4f)value;
            return;
        }
        if ("perp" == propertyName) {
            this.isPerpendicular = true;
            return;
        }
        if ("cylinder" == propertyName) {
            this.isCylinder = true;
            return;
        }
        if ("plane" == propertyName) {
            this.isPlane = true;
            return;
        }
        if ("curve" == propertyName) {
            this.isCurve = true;
            return;
        }
        if ("arrow" == propertyName) {
            this.isArrow = true;
            return;
        }
        if ("line" == propertyName) {
            this.isLine = true;
            this.isCurve = true;
            return;
        }
        if ("arc" == propertyName) {
            this.isCurve = true;
            this.isArc = true;
            if (this.isArrow) {
                this.isArrow = false;
                this.isVector = true;
            }
            return;
        }
        if ("circle" == propertyName) {
            this.isCircle = true;
            return;
        }
        if ("vector" == propertyName) {
            this.isArrow = true;
            this.isVector = true;
            return;
        }
        if ("vertices" == propertyName) {
            this.isVertices = true;
            return;
        }
        if ("reverse" == propertyName) {
            this.isReversed = true;
            return;
        }
        if ("nohead" == propertyName) {
            this.noHead = true;
            return;
        }
        if ("rotate45" == propertyName) {
            this.isRotated45 = true;
            return;
        }
        if ("crossed" == propertyName) {
            this.isCrossed = true;
            return;
        }
        if ("points" == propertyName) {
            this.newScale = ((Integer)value).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 1.0f;
            }
            return;
        }
        if ("scale" == propertyName) {
            this.newScale = ((Integer)value).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 0.01f;
            }
            if (this.thisMesh != null) {
                Draw.scaleDrawing(this.thisMesh, this.newScale);
                this.thisMesh.initialize(1073741845);
            }
            return;
        }
        if ("diameter" == propertyName) {
            this.diameter = ((Float)value).intValue();
            return;
        }
        if ("width" == propertyName) {
            this.width = ((Float)value).floatValue();
            return;
        }
        if ("identifier" == propertyName) {
            String thisID = (String)value;
            int meshIndex = this.getIndexFromName(thisID);
            if (meshIndex >= 0) {
                this.vData.add(new Object[]{new Integer(2), new int[]{meshIndex, this.isReversed ? 1 : 0, this.isVertices ? 1 : 0}});
                this.isVertices = false;
                this.isReversed = false;
                ++this.nidentifiers;
            } else {
                Logger.error("draw identifier " + value + " not found");
                this.isValid = false;
            }
            return;
        }
        if ("coord" == propertyName) {
            this.vData.add(new Object[]{new Integer(1), value});
            if (this.indicatedModelIndex >= 0) {
                this.modelInfo[1] = this.modelInfo[1] + 1;
            }
            return;
        }
        if ("offset" == propertyName) {
            this.offset = new Vector3f((Point3f)value);
            if (this.thisMesh != null) {
                this.thisMesh.offset(this.offset);
            }
            return;
        }
        if ("atomSet" == propertyName) {
            if (BitSetUtil.cardinalityOf((BitSet)value) == 0) {
                return;
            }
            bs = (BitSet)value;
            this.vData.add(new Object[]{new Integer(3), bs});
            ++this.nbitsets;
            if (this.isCircle && this.diameter == 0 && this.width == 0.0f) {
                this.width = this.viewer.calcRotationRadius(bs) * 2.0f;
            }
            return;
        }
        if ("modelBasedPoints" == propertyName) {
            this.vData.add(new Object[]{new Integer(5), value});
            return;
        }
        if ("set" == propertyName) {
            if (this.thisMesh == null) {
                this.allocMesh(null);
                this.thisMesh.colix = this.colix;
            }
            boolean bl = this.thisMesh.isValid = this.isValid ? this.setDrawing() : false;
            if (this.thisMesh.isValid) {
                if (this.thisMesh.vertexCount > 2 && this.length != Float.MAX_VALUE && this.newScale == 1.0f) {
                    this.newScale = this.length;
                }
                Draw.scaleDrawing(this.thisMesh, this.newScale);
                this.thisMesh.initialize(1073741845);
                Draw.setAxes(this.thisMesh);
                this.thisMesh.title = this.title;
                this.thisMesh.visible = true;
            }
            this.nPoints = -1;
            this.vData = null;
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            int modelIndex = ((int[])((Object[])value)[2])[0];
            int i = this.meshCount;
            while (--i >= 0) {
                if (this.meshes[i] == null) continue;
                if (this.dmeshes[i].modelFlags != null) {
                    this.dmeshes[i].deleteAtoms(modelIndex);
                    continue;
                }
                if (this.meshes[i].modelIndex == modelIndex) {
                    --this.meshCount;
                    if (this.meshes[i] == this.currentMesh) {
                        this.thisMesh = null;
                        this.currentMesh = null;
                    }
                    this.dmeshes = (DrawMesh[])ArrayUtil.deleteElements(this.meshes, i, 1);
                    this.meshes = this.dmeshes;
                    continue;
                }
                if (this.meshes[i].modelIndex <= modelIndex) continue;
                --this.meshes[i].modelIndex;
            }
            return;
        }
        this.setPropertySuper(propertyName, value, bs);
    }

    public Object getProperty(String property, int index) {
        if (property == "command") {
            return this.getDrawCommand(this.thisMesh);
        }
        if (property == "type") {
            return new Integer(this.thisMesh == null ? 0 : this.thisMesh.drawType);
        }
        if (property.indexOf("getCenter:") == 0) {
            return this.getSpinCenter(property.substring(10), index, Integer.MIN_VALUE);
        }
        if (property.indexOf("getSpinAxis:") == 0) {
            return this.getSpinAxis(property.substring(12), index);
        }
        return super.getProperty(property, index);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Point3f getSpinCenter(String axisID, int vertexIndex, int modelIndex) {
        int meshIndex;
        String id;
        int pt = axisID.indexOf("[");
        if (pt > 0) {
            id = axisID.substring(0, pt);
            int pt2 = axisID.lastIndexOf("]");
            if (pt2 < pt) {
                pt2 = axisID.length();
            }
            try {
                vertexIndex = Integer.parseInt(axisID.substring(pt + 1, pt2)) - 1;
            }
            catch (Exception e) {}
        } else {
            id = axisID;
        }
        if ((meshIndex = this.getIndexFromName(id)) < 0) return null;
        DrawMesh m = this.dmeshes[meshIndex];
        if (m.vertices == null) return null;
        if (m.vertexCount <= vertexIndex) {
            return null;
        }
        Point3f point3f = vertexIndex >= 0 ? m.vertices[vertexIndex] : (m.ptCenters == null || modelIndex < 0 ? m.ptCenter : m.ptCenters[modelIndex]);
        return point3f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Vector3f getSpinAxis(String axisID, int modelIndex) {
        int meshIndex = this.getIndexFromName(axisID);
        if (meshIndex < 0) return null;
        DrawMesh m = this.dmeshes[meshIndex];
        if (m.vertices == null) {
            return null;
        }
        Vector3f vector3f = m.ptCenters == null || modelIndex < 0 ? m.axis : m.axes[modelIndex];
        return vector3f;
    }

    private boolean setDrawing() {
        if (this.thisMesh == null) {
            this.allocMesh(null);
        }
        this.thisMesh.clear("draw");
        int nData = this.vData.size();
        if (nData == 0) {
            return false;
        }
        if (this.indicatedModelIndex < 0 && (this.isFixed || this.isArrow || this.isCurve || this.isCircle || this.isCylinder || this.modelCount == 1)) {
            this.thisMesh.isFixed = this.isFixed;
            this.thisMesh.modelIndex = this.viewer.getDisplayModelIndex();
            if (this.thisMesh.modelIndex < 0) {
                this.thisMesh.modelIndex = 0;
            }
            if (this.isFixed && !this.isArrow && !this.isCurve && this.modelCount > 1) {
                this.thisMesh.modelIndex = -1;
            }
            this.thisMesh.setPolygonCount(1);
            this.thisMesh.ptCenters = null;
            this.thisMesh.modelFlags = null;
            this.thisMesh.drawTypes = null;
            this.thisMesh.drawVertexCounts = null;
            if (this.setPoints(-1, -1)) {
                this.setPoints(-1, this.nPoints);
            }
            this.setPolygon(0);
        } else {
            this.thisMesh.modelIndex = -1;
            this.thisMesh.setPolygonCount(this.modelCount);
            this.thisMesh.ptCenters = new Point3f[this.modelCount];
            this.thisMesh.modelFlags = new BitSet();
            this.thisMesh.drawTypes = new int[this.modelCount];
            this.thisMesh.drawVertexCounts = new int[this.modelCount];
            this.thisMesh.vertexCount = 0;
            if (this.indicatedModelIndex >= 0) {
                this.setPoints(-1, 0);
                this.thisMesh.drawType = -1;
                this.thisMesh.drawVertexCount = -1;
                this.indicatedModelIndex = -1;
            } else {
                for (int iModel = 0; iModel < this.modelCount; ++iModel) {
                    if (this.setPoints(iModel, -1)) {
                        this.setPoints(iModel, this.nPoints);
                        this.setPolygon(iModel);
                        this.thisMesh.setCenter(iModel);
                        this.thisMesh.drawTypes[iModel] = this.thisMesh.drawType;
                        this.thisMesh.drawVertexCounts[iModel] = this.thisMesh.drawVertexCount;
                        this.thisMesh.drawType = -1;
                        this.thisMesh.drawVertexCount = -1;
                        continue;
                    }
                    this.thisMesh.drawTypes[iModel] = 0;
                    this.thisMesh.polygonIndexes[iModel] = new int[0];
                }
            }
        }
        this.thisMesh.diameter = this.diameter;
        this.thisMesh.isVector = this.isVector;
        this.thisMesh.nohead = this.noHead;
        this.thisMesh.width = this.thisMesh.drawType == 5 ? -Math.abs(this.width) : this.width;
        this.thisMesh.setCenter(-1);
        if (this.offset != null) {
            this.thisMesh.offset(this.offset);
        }
        if (this.thisMesh.thisID == null) {
            this.thisMesh.thisID = JmolConstants.getDrawTypeName(this.thisMesh.drawType) + ++this.nUnnamed;
        }
        return true;
    }

    private void addPoint(Point3f newPt, int iModel) {
        boolean isOK;
        boolean bl = isOK = iModel < 0 || this.bsAllModels.get(iModel);
        if (this.makePoints) {
            if (!isOK) {
                return;
            }
            this.ptList[this.nPoints] = new Point3f(newPt);
            if (newPt.z == Float.MAX_VALUE || newPt.z == -3.4028235E38f) {
                this.thisMesh.haveXyPoints = true;
            }
        } else if (iModel >= 0) {
            this.bsAllModels.set(iModel);
        }
        ++this.nPoints;
    }

    private boolean setPoints(int iModel, int n) {
        boolean bl = this.makePoints = n >= 0;
        if (this.makePoints) {
            this.ptList = new Point3f[Math.max(5, n)];
            if (this.bsAllModels == null) {
                this.bsAllModels = this.viewer.getVisibleFramesBitSet();
            }
        }
        this.nPoints = 0;
        int nData = this.vData.size();
        int modelIndex = 0;
        BitSet bsModel = iModel < 0 ? null : this.viewer.getModelAtomBitSet(iModel, false);
        block7: for (int i = 0; i < nData; ++i) {
            Object[] info = (Object[])this.vData.elementAt(i);
            switch ((Integer)info[0]) {
                case 4: {
                    int j;
                    int[] modelInfo = (int[])info[1];
                    modelIndex = modelInfo[0];
                    this.nPoints = modelInfo[1];
                    int nVertices = Math.max(this.nPoints, 3);
                    int n0 = this.thisMesh.vertexCount;
                    if (this.nPoints <= 0) continue block7;
                    this.thisMesh.polygonIndexes[modelIndex] = new int[nVertices];
                    int[] p = this.thisMesh.polygonIndexes[modelIndex];
                    for (j = 0; j < this.nPoints; ++j) {
                        info = (Object[])this.vData.elementAt(++i);
                        p[j] = this.thisMesh.addVertexCopy((Point3f)info[1]);
                    }
                    for (j = this.nPoints; j < 3; ++j) {
                        p[j] = n0 + this.nPoints - 1;
                    }
                    this.thisMesh.drawTypes[modelIndex] = this.thisMesh.drawVertexCounts[modelIndex] = this.nPoints;
                    continue block7;
                }
                case 1: {
                    this.addPoint((Point3f)info[1], this.makePoints ? iModel : -1);
                    continue block7;
                }
                case 3: {
                    BitSet bs = BitSetUtil.copy((BitSet)info[1]);
                    if (bsModel != null) {
                        bs.and(bsModel);
                    }
                    if (BitSetUtil.firstSetBit(bs) < 0) continue block7;
                    this.addPoint(this.viewer.getAtomSetCenter(bs), this.makePoints ? iModel : -1);
                    continue block7;
                }
                case 2: {
                    boolean isVertices;
                    int[] idInfo = (int[])info[1];
                    DrawMesh m = this.dmeshes[idInfo[0]];
                    boolean isReversed = idInfo[1] == 1;
                    boolean bl2 = isVertices = idInfo[2] == 1;
                    if (m.modelIndex > 0 && m.modelIndex != iModel) {
                        return false;
                    }
                    if (this.bsAllModels == null) {
                        this.bsAllModels = new BitSet();
                    }
                    if (this.isPlane && !this.isCircle || this.isPerpendicular || isVertices) {
                        if (isReversed) {
                            if (iModel < 0 || iModel >= m.polygonCount) {
                                int ipt = m.drawVertexCount;
                                while (--ipt >= 0) {
                                    this.addPoint(m.vertices[ipt], iModel);
                                }
                                continue block7;
                            }
                            if (m.polygonIndexes[iModel] == null) continue block7;
                            int ipt = m.drawVertexCounts[iModel];
                            while (--ipt >= 0) {
                                this.addPoint(m.vertices[m.polygonIndexes[iModel][ipt]], iModel);
                            }
                            continue block7;
                        }
                        if (iModel < 0 || iModel >= m.polygonCount) {
                            for (int ipt = 0; ipt < m.drawVertexCount; ++ipt) {
                                this.addPoint(m.vertices[ipt], iModel);
                            }
                            continue block7;
                        }
                        if (m.polygonIndexes[iModel] == null) continue block7;
                        int ipt = m.drawVertexCounts[iModel];
                        while (--ipt >= 0) {
                            this.addPoint(m.vertices[m.polygonIndexes[iModel][ipt]], iModel);
                        }
                        continue block7;
                    }
                    if (iModel < 0 || m.ptCenters == null || m.ptCenters[iModel] == null) {
                        this.addPoint(m.ptCenter, iModel);
                        continue block7;
                    }
                    this.addPoint(m.ptCenters[iModel], iModel);
                    continue block7;
                }
                case 5: {
                    BitSet bs;
                    String[] modelBasedPoints = (String[])info[1];
                    if (this.bsAllModels == null) {
                        this.bsAllModels = new BitSet();
                    }
                    for (int j = 0; j < modelBasedPoints.length; ++j) {
                        if (iModel >= 0 && j != iModel) continue;
                        Object point = Escape.unescapePointOrBitset(modelBasedPoints[j]);
                        this.bsAllModels.set(j);
                        if (point instanceof Point3f) {
                            this.addPoint((Point3f)point, j);
                            continue;
                        }
                        if (!(point instanceof BitSet)) continue;
                        bs = (BitSet)point;
                        if (bsModel != null) {
                            bs.and(bsModel);
                        }
                        if (BitSetUtil.firstSetBit(bs) < 0) continue;
                        this.addPoint(this.viewer.getAtomSetCenter(bs), j);
                    }
                    continue block7;
                }
            }
        }
        if (this.makePoints && this.isCrossed && this.nPoints == 4) {
            Point3f pt = this.ptList[1];
            this.ptList[1] = this.ptList[2];
            this.ptList[2] = pt;
        }
        return this.nPoints > 0;
    }

    private void setPolygon(int nPoly) {
        int nVertices = this.nPoints;
        int drawType = 1;
        if (this.isArc) {
            if (nVertices == 4) {
                drawType = 19;
            } else {
                this.isArc = false;
                this.isVector = false;
                this.isCurve = false;
                this.isArrow = true;
            }
        }
        if (this.isCircle) {
            drawType = this.isPlane ? 18 : 16;
        } else if ((this.isCurve || this.isArrow) && nVertices >= 2 && !this.isArc) {
            int n = this.isLine ? 20 : (drawType = this.isCurve ? 17 : 15);
        }
        if (this.isVector && !this.isArc) {
            if (nVertices > 2) {
                nVertices = 2;
            } else if (this.plane == null && nVertices != 2) {
                this.isVector = false;
            }
        }
        if (this.thisMesh.haveXyPoints) {
            this.isPerpendicular = false;
            if (nVertices == 3 && this.isPlane) {
                this.isPlane = false;
            }
            this.length = Float.MAX_VALUE;
            this.thisMesh.diameter = 0;
        } else if (nVertices == 2 && this.isVector) {
            this.ptList[1].add(this.ptList[0]);
        }
        if (drawType == 1) {
            Point3f pt;
            float dist;
            Point3f center = new Point3f();
            Vector3f normal = new Vector3f();
            if (nVertices == 1 && this.plane != null) {
                dist = Graphics3D.distanceToPlane(this.plane, this.ptList[0]);
                this.vAC.set(this.plane.x, this.plane.y, this.plane.z);
                this.vAC.normalize();
                this.vAC.scale(-dist);
                this.vAC.add(this.ptList[0]);
                this.ptList[1] = new Point3f(this.vAC);
                nVertices = -2;
                if (this.isArrow) {
                    drawType = 15;
                }
            } else if (nVertices == 3 && this.isPlane && !this.isPerpendicular) {
                pt = new Point3f(this.ptList[1]);
                pt.sub(this.ptList[0]);
                pt.scale(0.5f);
                this.ptList[3] = new Point3f(this.ptList[2]);
                this.ptList[2].add(pt);
                this.ptList[3].sub(pt);
                nVertices = 4;
            } else if (nVertices >= 3 && !this.isPlane && this.isPerpendicular) {
                Graphics3D.calcNormalizedNormal(this.ptList[0], this.ptList[1], this.ptList[2], normal, this.vAB, this.vAC);
                center = new Point3f();
                Graphics3D.calcAveragePointN(this.ptList, nVertices, center);
                dist = this.length == Float.MAX_VALUE ? this.ptList[0].distance(center) : this.length;
                normal.scale(dist);
                this.ptList[0].set(center);
                this.ptList[1].set(center);
                this.ptList[1].add(normal);
                nVertices = 2;
            } else if (nVertices == 2 && this.isPerpendicular) {
                Graphics3D.calcAveragePoint(this.ptList[0], this.ptList[1], center);
                float f = dist = this.length == Float.MAX_VALUE ? this.ptList[0].distance(center) : this.length;
                if (this.isPlane && this.length != Float.MAX_VALUE) {
                    dist /= 2.0f;
                }
                if (this.isPlane && this.isRotated45) {
                    dist *= 1.4142f;
                }
                this.g3d.calcXYNormalToLine(this.ptList[0], this.ptList[1], normal);
                normal.scale(dist);
                if (this.isPlane) {
                    this.ptList[2] = new Point3f(center);
                    this.ptList[2].sub(normal);
                    pt = new Point3f(center);
                    pt.add(normal);
                    Graphics3D.calcNormalizedNormal(this.ptList[0], this.ptList[1], this.ptList[2], normal, this.vAB, this.vAC);
                    normal.scale(dist);
                    this.ptList[3] = new Point3f(center);
                    this.ptList[3].add(normal);
                    this.ptList[1].set(center);
                    this.ptList[1].sub(normal);
                    this.ptList[0].set(pt);
                    if (this.isRotated45) {
                        Graphics3D.calcAveragePoint(this.ptList[0], this.ptList[1], this.ptList[0]);
                        Graphics3D.calcAveragePoint(this.ptList[1], this.ptList[2], this.ptList[1]);
                        Graphics3D.calcAveragePoint(this.ptList[2], this.ptList[3], this.ptList[2]);
                        Graphics3D.calcAveragePoint(this.ptList[3], pt, this.ptList[3]);
                    }
                    nVertices = 4;
                } else {
                    this.ptList[0].set(center);
                    this.ptList[1].set(center);
                    this.ptList[0].sub(normal);
                    this.ptList[1].add(normal);
                }
                if (this.isArrow && nVertices != -2) {
                    this.isArrow = false;
                }
            } else if (nVertices == 2 && this.length != Float.MAX_VALUE) {
                Graphics3D.calcAveragePoint(this.ptList[0], this.ptList[1], center);
                normal.set(this.ptList[1]);
                normal.sub(center);
                normal.scale(0.5f / normal.length() * this.length);
                this.ptList[0].set(center);
                this.ptList[1].set(center);
                this.ptList[0].sub(normal);
                this.ptList[1].add(normal);
            }
            if (nVertices > 4) {
                nVertices = 4;
            }
            switch (nVertices) {
                case -2: {
                    nVertices = 2;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    drawType = this.isCylinder ? 5 : 2;
                    break;
                }
                default: {
                    drawType = 4;
                }
            }
        }
        this.thisMesh.drawType = drawType;
        this.thisMesh.drawVertexCount = nVertices;
        if (nVertices == 0) {
            return;
        }
        int nVertices0 = this.thisMesh.vertexCount;
        for (int i = 0; i < nVertices; ++i) {
            this.thisMesh.addVertexCopy(this.ptList[i]);
        }
        int npoints = nVertices < 3 ? 3 : nVertices;
        this.thisMesh.setPolygonCount(nPoly + 1);
        this.thisMesh.polygonIndexes[nPoly] = new int[npoints];
        for (int i = 0; i < npoints; ++i) {
            this.thisMesh.polygonIndexes[nPoly][i] = nVertices0 + (i < nVertices ? i : nVertices - 1);
        }
    }

    private static void scaleDrawing(DrawMesh mesh, float newScale) {
        if (newScale == 0.0f || mesh.vertexCount == 0 || mesh.scale == newScale) {
            return;
        }
        float f = newScale / mesh.scale;
        mesh.scale = newScale;
        if (mesh.haveXyPoints || mesh.drawType == 19) {
            return;
        }
        Vector3f diff = new Vector3f();
        int iptlast = -1;
        int ipt = 0;
        int i = mesh.polygonCount;
        while (--i >= 0) {
            Point3f center;
            Point3f point3f = mesh.isVector ? mesh.vertices[0] : (center = mesh.ptCenters == null ? mesh.ptCenter : mesh.ptCenters[i]);
            if (center == null) {
                return;
            }
            if (mesh.polygonIndexes[i] == null) continue;
            iptlast = -1;
            int iV = mesh.polygonIndexes[i].length;
            while (--iV >= 0) {
                ipt = mesh.polygonIndexes[i][iV];
                if (ipt == iptlast) continue;
                iptlast = ipt;
                diff.sub(mesh.vertices[ipt], center);
                diff.scale(f);
                diff.add(center);
                mesh.vertices[ipt].set(diff);
            }
        }
    }

    private static final void setAxes(DrawMesh m) {
        m.axis = new Vector3f(0.0f, 0.0f, 0.0f);
        m.axes = new Vector3f[m.polygonCount > 0 ? m.polygonCount : 1];
        if (m.vertices == null) {
            return;
        }
        int n = 0;
        int i = m.polygonCount;
        while (--i >= 0) {
            int[] p = m.polygonIndexes[i];
            m.axes[i] = new Vector3f();
            if (p != null && p.length != 0) {
                if (m.drawVertexCount == 2 || m.drawVertexCount < 0 && m.drawVertexCounts[i] == 2) {
                    m.axes[i].sub(m.vertices[p[0]], m.vertices[p[1]]);
                    ++n;
                } else {
                    Graphics3D.calcNormalizedNormal(m.vertices[p[0]], m.vertices[p[1]], m.vertices[p[2]], m.axes[i], m.vAB, m.vAC);
                    ++n;
                }
            }
            m.axis.add(m.axes[i]);
        }
        if (n == 0) {
            return;
        }
        m.axis.scale(1.0f / (float)n);
    }

    public void setVisibilityFlags(BitSet bs) {
        for (int i = 0; i < this.meshCount; ++i) {
            DrawMesh m = this.dmeshes[i];
            int n = m.visibilityFlags = m.isValid && m.visible ? this.myVisibilityFlag : 0;
            if (m.modelIndex >= 0 && !bs.get(m.modelIndex)) {
                m.visibilityFlags = 0;
                continue;
            }
            if (m.modelFlags == null) continue;
            int iModel = this.modelCount;
            while (--iModel >= 0) {
                m.modelFlags.set(iModel, bs.get(iModel));
            }
        }
    }

    public Point3f checkObjectClicked(int x, int y, int modifiers, BitSet bsVisible) {
        boolean isPickingMode = this.viewer.getPickingMode() == 4;
        boolean isSpinMode = this.viewer.getPickingMode() == 5;
        boolean isDrawPicking = this.viewer.getDrawPicking();
        if (!(isPickingMode || isDrawPicking || isSpinMode)) {
            return null;
        }
        if (!this.findPickedObject(x, y, false, bsVisible)) {
            return null;
        }
        Point3f v = this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][this.pickedVertex]];
        if (isDrawPicking && !isPickingMode) {
            if (modifiers != 0) {
                this.viewer.setStatusAtomPicked(-2, "[\"draw\",\"" + this.pickedMesh.thisID + "\"," + this.pickedModel + "," + this.pickedVertex + "," + v.x + "," + v.y + "," + v.z + "]" + (this.pickedMesh.title == null ? "" : "\"" + this.pickedMesh.title[this.pickedModel] + "\""));
            }
            return v;
        }
        if (modifiers == 0 || this.pickedMesh.polygonIndexes[this.pickedModel][0] == this.pickedMesh.polygonIndexes[this.pickedModel][1]) {
            return modifiers == 0 ? v : null;
        }
        if (this.pickedVertex == 0) {
            this.viewer.startSpinningAxis(this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][0]], this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][1]], (modifiers & 1) != 0);
        } else {
            this.viewer.startSpinningAxis(this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][1]], this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][0]], (modifiers & 1) != 0);
        }
        return null;
    }

    public boolean checkObjectHovered(int x, int y, BitSet bsVisible) {
        String s;
        if (!this.findPickedObject(x, y, false, bsVisible)) {
            return false;
        }
        if (this.g3d.isDisplayAntialiased()) {
            x <<= 1;
            y <<= 1;
        }
        String string = s = this.pickedMesh.title == null ? this.pickedMesh.thisID : this.pickedMesh.title[0];
        if (s.length() > 1 && s.charAt(0) == '>') {
            s = s.substring(1);
        }
        this.viewer.hoverOn(x, y, s);
        return true;
    }

    public synchronized boolean checkObjectDragged(int prevX, int prevY, int x, int y, int modifiers, BitSet bsVisible) {
        if (this.viewer.getPickingMode() != 4) {
            return false;
        }
        if (prevX == Integer.MIN_VALUE) {
            return this.findPickedObject(x, y, true, bsVisible);
        }
        if (prevX == Integer.MAX_VALUE) {
            this.pickedMesh = null;
            return false;
        }
        if (this.pickedMesh == null) {
            return false;
        }
        boolean moveAll = false;
        switch (modifiers) {
            case 17: {
                moveAll = true;
            }
            case 24: 
            case 25: {
                this.move2D(this.pickedMesh, this.pickedMesh.polygonIndexes[this.pickedModel], this.pickedVertex, x, y, moveAll);
                this.thisMesh = this.pickedMesh;
            }
        }
        return true;
    }

    private void move2D(DrawMesh mesh, int[] vertexes, int iVertex, int x, int y, boolean moveAll) {
        int i;
        if (vertexes == null || vertexes.length == 0) {
            return;
        }
        if (this.g3d.isAntialiased()) {
            x <<= 1;
            y <<= 1;
        }
        Point3f pt = new Point3f();
        Point3f coord = new Point3f(mesh.vertices[vertexes[iVertex]]);
        Point3f newcoord = new Point3f();
        Vector3f move = new Vector3f();
        this.viewer.transformPoint(coord, pt);
        pt.x = x;
        pt.y = y;
        this.viewer.unTransformPoint(pt, newcoord);
        move.set(newcoord);
        move.sub(coord);
        int klast = -1;
        int n = i = moveAll ? 0 : iVertex;
        while (i < vertexes.length) {
            if (moveAll || i == iVertex) {
                int k = vertexes[i];
                if (k == klast) break;
                mesh.vertices[k].add(move);
                if (!moveAll) break;
                klast = k;
            }
            ++i;
        }
        if (mesh.ptCenters == null) {
            mesh.setCenter(-1);
        } else {
            i = mesh.ptCenters.length;
            while (--i >= 0) {
                mesh.setCenter(i);
            }
        }
        if (Logger.debugging) {
            Logger.debug(this.getDrawCommand(mesh));
        }
        this.viewer.refresh(3, "draw");
    }

    private boolean findPickedObject(int x, int y, boolean isPicking, BitSet bsVisible) {
        int dmin2 = 100;
        if (this.g3d.isAntialiased()) {
            x <<= 1;
            y <<= 1;
            dmin2 <<= 1;
        }
        this.pickedModel = 0;
        this.pickedVertex = 0;
        this.pickedMesh = null;
        for (int i = 0; i < this.meshCount; ++i) {
            int mCount;
            DrawMesh m = this.dmeshes[i];
            if (m.visibilityFlags == 0) continue;
            int iModel = mCount = m.modelFlags == null ? 1 : this.modelCount;
            while (--iModel >= 0) {
                if (m.modelFlags != null && !m.modelFlags.get(iModel) || m.polygonIndexes == null || iModel >= m.polygonIndexes.length || m.polygonIndexes[iModel] == null) continue;
                int iVertex = m.polygonIndexes[iModel].length;
                while (--iVertex >= 0) {
                    int d2 = this.coordinateInRange(x, y, m.vertices[m.polygonIndexes[iModel][iVertex]], dmin2);
                    if (d2 < 0) continue;
                    this.pickedMesh = m;
                    dmin2 = d2;
                    this.pickedModel = iModel;
                    this.pickedVertex = iVertex;
                }
            }
        }
        return this.pickedMesh != null;
    }

    private int coordinateInRange(int x, int y, Point3f vertex, int dmin2) {
        int d2 = dmin2;
        this.viewer.transformPoint(vertex, this.ptXY);
        d2 = (x - this.ptXY.x) * (x - this.ptXY.x) + (y - this.ptXY.y) * (y - this.ptXY.y);
        return d2 < dmin2 ? d2 : -1;
    }

    private String getDrawCommand(DrawMesh mesh) {
        String key;
        this.modelCount = this.viewer.getModelCount();
        if (mesh != null) {
            return this.getDrawCommand(mesh, mesh.modelIndex);
        }
        StringBuffer sb = new StringBuffer();
        String string = key = this.explicitID && this.previousMeshID != null && TextFormat.isWild(this.previousMeshID) ? this.previousMeshID.toUpperCase() : null;
        if (key != null && key.length() == 0) {
            key = null;
        }
        for (int i = 0; i < this.meshCount; ++i) {
            DrawMesh m = (DrawMesh)this.meshes[i];
            if (key != null && !TextFormat.isMatch(m.thisID.toUpperCase(), key, true, true)) continue;
            sb.append(this.getDrawCommand(m, m.modelIndex));
        }
        return sb.toString();
    }

    private String getDrawCommand(DrawMesh mesh, int iModel) {
        if (mesh.drawType == 0 || mesh.drawVertexCount == 0 && mesh.drawVertexCounts == null) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        if (!mesh.isFixed && iModel >= 0 && this.modelCount > 1) {
            Draw.appendCmd(str, "frame " + this.viewer.getModelNumberDotted(iModel));
        }
        str.append("  draw ID ").append(Escape.escape(mesh.thisID));
        if (mesh.isFixed) {
            str.append(" fixed");
        }
        if (iModel < 0) {
            iModel = 0;
        }
        if (mesh.nohead) {
            str.append(" noHead");
        }
        if (mesh.scale != 1.0f && (mesh.haveXyPoints || mesh.drawType == 19)) {
            str.append(" scale ").append(mesh.scale);
        }
        if (mesh.width != 0.0f) {
            str.append(" diameter ").append(mesh.drawType == 5 ? Math.abs(mesh.width) : mesh.width);
        } else if (mesh.diameter > 0) {
            str.append(" diameter ").append(mesh.diameter);
        }
        int nVertices = mesh.drawVertexCount > 0 ? mesh.drawVertexCount : mesh.drawVertexCounts[iModel >= 0 ? iModel : 0];
        switch (mesh.drawTypes == null ? mesh.drawType : mesh.drawTypes[iModel]) {
            case 20: {
                str.append(" LINE");
                break;
            }
            case 19: {
                str.append(mesh.isVector ? " ARROW ARC" : " ARC");
                break;
            }
            case 15: {
                str.append(mesh.isVector ? " VECTOR" : " ARROW");
                break;
            }
            case 16: {
                str.append(" CIRCLE");
                break;
            }
            case 18: {
                str.append(" CIRCLE PLANE");
                break;
            }
            case 17: {
                str.append(" CURVE");
                break;
            }
            case 5: {
                str.append(" CYLINDER");
                break;
            }
            case 1: {
                nVertices = 1;
                break;
            }
            case 2: {
                nVertices = 2;
            }
        }
        if (mesh.modelIndex < 0 && !mesh.isFixed) {
            for (int i = 0; i < this.modelCount; ++i) {
                if (!Draw.isPolygonDisplayable(mesh, i)) continue;
                if (nVertices == 0) {
                    nVertices = mesh.drawVertexCounts[i];
                }
                str.append(" [ " + i);
                str.append(Draw.getVertexList(mesh, i, nVertices));
                str.append(" ] ");
            }
        } else {
            str.append(Draw.getVertexList(mesh, iModel, nVertices));
        }
        if (mesh.title != null) {
            String s = "";
            for (int i = 0; i < mesh.title.length; ++i) {
                s = s + "|" + mesh.title[i];
            }
            str.append(Escape.escape(s.substring(1)));
        }
        str.append(";\n");
        Draw.appendCmd(str, mesh.getState("draw"));
        Draw.appendCmd(str, this.getColorCommand("draw", mesh.colix));
        return str.toString();
    }

    static boolean isPolygonDisplayable(Mesh mesh, int i) {
        return i < mesh.polygonIndexes.length && mesh.polygonIndexes[i] != null && mesh.polygonIndexes[i].length > 0;
    }

    private static String getVertexList(DrawMesh mesh, int iModel, int nVertices) {
        String str = "";
        try {
            if (iModel >= mesh.polygonIndexes.length) {
                iModel = 0;
            }
            boolean adjustPt = mesh.isVector && mesh.drawType != 19;
            for (int i = 0; i < nVertices; ++i) {
                Point3f pt = mesh.vertices[mesh.polygonIndexes[iModel][i]];
                if (pt.z == Float.MAX_VALUE || pt.z == -3.4028235E38f) {
                    str = str + (i == 0 ? " " : " ,") + "[" + (int)pt.x + " " + (int)pt.y + (pt.z < 0.0f ? " %]" : "]");
                    continue;
                }
                if (adjustPt && i == 1) {
                    Point3f pt1 = new Point3f(pt);
                    pt1.sub(mesh.vertices[mesh.polygonIndexes[iModel][0]]);
                    str = str + " " + Escape.escape(pt1);
                    continue;
                }
                str = str + " " + Escape.escape(pt);
            }
        }
        catch (Exception e) {
            Logger.error("Unexpected error in Draw.getVertexList");
        }
        return str;
    }

    public Vector getShapeDetail() {
        Vector V = new Vector();
        for (int i = 0; i < this.meshCount; ++i) {
            DrawMesh mesh = this.dmeshes[i];
            if (mesh.vertexCount == 0) continue;
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            info.put("fixed", mesh.ptCenters == null ? Boolean.TRUE : Boolean.FALSE);
            info.put("ID", mesh.thisID == null ? "<noid>" : mesh.thisID);
            info.put("drawType", JmolConstants.getDrawTypeName(mesh.drawType));
            if (mesh.diameter > 0) {
                info.put("diameter", new Integer(mesh.diameter));
            }
            if (mesh.width != 0.0f) {
                info.put("width", new Float(mesh.width));
            }
            info.put("scale", new Float(mesh.scale));
            if (mesh.drawType == -1) {
                Vector m = new Vector();
                this.modelCount = this.viewer.getModelCount();
                for (int k = 0; k < this.modelCount; ++k) {
                    if (mesh.ptCenters[k] == null) continue;
                    Hashtable<String, Object> mInfo = new Hashtable<String, Object>();
                    mInfo.put("modelIndex", new Integer(k));
                    mInfo.put("command", this.getDrawCommand(mesh, k));
                    mInfo.put("center", mesh.ptCenters[k]);
                    int nPoints = mesh.drawVertexCounts[k];
                    mInfo.put("vertexCount", new Integer(nPoints));
                    if (nPoints > 1) {
                        mInfo.put("axis", mesh.axes[k]);
                    }
                    Vector<Point3f> v = new Vector<Point3f>();
                    for (int ipt = 0; ipt < nPoints; ++ipt) {
                        v.addElement(mesh.vertices[mesh.polygonIndexes[k][ipt]]);
                    }
                    mInfo.put("vertices", v);
                    if (mesh.drawTypes[k] == 2) {
                        float d = mesh.vertices[mesh.polygonIndexes[k][0]].distance(mesh.vertices[mesh.polygonIndexes[k][1]]);
                        mInfo.put("length_Ang", new Float(d));
                    }
                    m.addElement(mInfo);
                }
                info.put("models", m);
            } else {
                info.put("command", this.getDrawCommand(mesh));
                info.put("center", mesh.ptCenter);
                if (mesh.drawVertexCount > 1) {
                    info.put("axis", mesh.axis);
                }
                Vector<Point3f> v = new Vector<Point3f>();
                for (int j = 0; j < mesh.vertexCount; ++j) {
                    v.addElement(mesh.vertices[j]);
                }
                info.put("vertices", v);
                if (mesh.drawType == 2) {
                    info.put("length_Ang", new Float(mesh.vertices[0].distance(mesh.vertices[1])));
                }
            }
            V.addElement(info);
        }
        return V;
    }

    public String getShapeState() {
        StringBuffer s = new StringBuffer("\n");
        Draw.appendCmd(s, "draw delete");
        this.modelCount = this.viewer.getModelCount();
        for (int i = 0; i < this.meshCount; ++i) {
            DrawMesh mesh = this.dmeshes[i];
            if (mesh.vertexCount == 0) continue;
            s.append(this.getDrawCommand(mesh, mesh.modelIndex));
            if (mesh.visible) continue;
            s.append("draw off;\n");
        }
        return s.toString();
    }
}

