/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.MeshRenderer;
import org.jmol.shapespecial.Draw;
import org.jmol.shapespecial.DrawMesh;

public class DrawRenderer
extends MeshRenderer {
    private int drawType;
    private DrawMesh dmesh;
    private Point3f[] controlHermites;
    private final Point3f vpt0 = new Point3f();
    private final Point3f vpt1 = new Point3f();
    private final Point3f vpt2 = new Point3f();
    private final Vector3f vTemp = new Vector3f();
    private final Vector3f vTemp2 = new Vector3f();
    private final Point3f pt0f = new Point3f();
    private final Point3i pt0i = new Point3i();

    protected void render() {
        this.imageFontScaling = this.viewer.getImageFontScaling();
        Draw draw = (Draw)this.shape;
        int i = draw.meshCount;
        while (--i >= 0) {
            this.dmesh = (DrawMesh)draw.meshes[i];
            if (!this.render1(this.dmesh)) continue;
            this.renderInfo();
        }
    }

    protected boolean isPolygonDisplayable(int i) {
        return Draw.isPolygonDisplayable(this.dmesh, i) && (this.dmesh.modelFlags == null || this.dmesh.modelFlags.get(i));
    }

    protected void render2() {
        int i;
        boolean isSegments;
        boolean isDrawPickMode = this.viewer.getPickingMode() == 4;
        this.drawType = this.dmesh.drawType;
        this.diameter = this.dmesh.diameter;
        this.width = this.dmesh.width;
        int nPoints = this.vertexCount;
        boolean isCurved = (this.drawType == 17 || this.drawType == 15 || this.drawType == 19) && this.vertexCount >= 2;
        boolean bl = isSegments = this.drawType == 20;
        if (this.width > 0.0f && isCurved) {
            this.pt1f.set(0.0f, 0.0f, 0.0f);
            int n = this.drawType == 19 ? 2 : this.vertexCount;
            for (i = 0; i < n; ++i) {
                this.pt1f.add(this.vertices[i]);
            }
            this.pt1f.scale(1.0f / (float)n);
            this.viewer.transformPoint(this.pt1f, this.pt1i);
            this.diameter = this.viewer.scaleToScreen(this.pt1i.z, (int)(this.width * 1000.0f));
            if (this.diameter == 0) {
                this.diameter = 1;
            }
        }
        if (this.dmesh.isVector && this.dmesh.haveXyPoints) {
            int ptXY = 0;
            for (i = 0; i < 2; ++i) {
                if (this.vertices[i].z != Float.MAX_VALUE && this.vertices[i].z != -3.4028235E38f) continue;
                ptXY += i + 1;
            }
            if (--ptXY < 2) {
                this.renderXyArrow(ptXY);
                return;
            }
        }
        int tension = 5;
        switch (this.drawType) {
            default: {
                super.render2();
                break;
            }
            case 16: 
            case 18: {
                this.viewer.transformPoint(this.vertices[0], this.pt1i);
                if (this.diameter == 0 && this.width == 0.0f) {
                    this.width = 1.0f;
                }
                if (this.width > 0.0f) {
                    this.diameter = this.viewer.scaleToScreen(this.pt1i.z, (int)(this.width * 1000.0f));
                }
                if (this.diameter <= 0 || !this.mesh.drawTriangles && !this.mesh.fillTriangles) break;
                this.g3d.drawCircleCentered(this.colix, this.diameter, this.pt1i.x, this.pt1i.y, this.pt1i.z, this.mesh.fillTriangles);
                break;
            }
            case 17: 
            case 20: {
                break;
            }
            case 19: {
                float theta = this.vertices[3].x;
                float nDegrees = this.vertices[3].y;
                float fractionalOffset = this.vertices[3].z;
                this.vTemp.set(this.vertices[1]);
                this.vTemp.sub(this.vertices[0]);
                this.pt1f.scaleAdd(fractionalOffset, this.vTemp, this.vertices[0]);
                Matrix3f mat = new Matrix3f();
                mat.set(new AxisAngle4f(this.vTemp, (float)((double)theta * Math.PI / 180.0)));
                this.vTemp2.set(this.vertices[2]);
                this.vTemp2.sub(this.vertices[0]);
                this.vTemp2.cross(this.vTemp, this.vTemp2);
                this.vTemp2.cross(this.vTemp2, this.vTemp);
                this.vTemp2.normalize();
                this.vTemp2.scale(this.dmesh.scale);
                mat.transform(this.vTemp2);
                float degrees = nDegrees / 5.0f;
                while (Math.abs(degrees) > 5.0f) {
                    degrees /= 2.0f;
                }
                nPoints = (int)(nDegrees / degrees + 0.5f) + 1;
                while (nPoints < 10) {
                    nPoints = (int)(nDegrees / (degrees /= 2.0f) + 0.5f) + 1;
                }
                mat.set(new AxisAngle4f(this.vTemp, (float)((double)degrees * Math.PI / 180.0)));
                this.screens = this.viewer.allocTempScreens(nPoints);
                int iBase = nPoints - (this.dmesh.scale < 2.0f ? 3 : 3);
                for (int i2 = 0; i2 < nPoints; ++i2) {
                    if (i2 == iBase) {
                        this.vpt0.set(this.vpt1);
                    }
                    this.vpt1.scaleAdd(1.0f, this.vTemp2, this.pt1f);
                    if (i2 == 0) {
                        this.vpt2.set(this.vpt1);
                    }
                    this.viewer.transformPoint(this.vpt1, this.screens[i2]);
                    mat.transform(this.vTemp2);
                }
                if (this.dmesh.isVector && !this.dmesh.nohead) {
                    this.renderArrowHead(this.vpt0, this.vpt1, 0.3f, false, false);
                    this.viewer.transformPoint(this.pt1f, this.screens[nPoints - 1]);
                }
                this.pt1f.set(this.vpt2);
                break;
            }
            case 15: {
                if (this.vertexCount == 2) {
                    this.renderArrowHead(this.vertices[0], this.vertices[1], 0.0f, false, true);
                    return;
                }
                int nHermites = 5;
                if (this.controlHermites == null || this.controlHermites.length < nHermites + 1) {
                    this.controlHermites = new Point3f[nHermites + 1];
                }
                Graphics3D.getHermiteList(tension, this.vertices[this.vertexCount - 3], this.vertices[this.vertexCount - 2], this.vertices[this.vertexCount - 1], this.vertices[this.vertexCount - 1], this.vertices[this.vertexCount - 1], this.controlHermites, 0, nHermites);
                this.renderArrowHead(this.controlHermites[nHermites - 2], this.controlHermites[nHermites - 1], 0.0f, false, false);
            }
        }
        if (this.diameter == 0) {
            this.diameter = 3;
        }
        if (isCurved) {
            int i3 = 0;
            int i0 = 0;
            while (i3 < nPoints - 1) {
                this.g3d.fillHermite(tension, this.diameter, this.diameter, this.diameter, this.screens[i0], this.screens[i3], this.screens[i3 + 1], this.screens[i3 + (i3 == nPoints - 2 ? 1 : 2)]);
                i0 = i3++;
            }
        } else if (isSegments) {
            for (int i4 = 0; i4 < nPoints - 1; ++i4) {
                this.drawLine(i4, i4 + 1, true);
            }
        }
        if (isDrawPickMode && !this.isGenerator) {
            this.renderHandles();
        }
    }

    private void renderXyArrow(int ptXY) {
        int ptXYZ = 1 - ptXY;
        Point3f[] arrowPt = new Point3f[2];
        arrowPt[ptXYZ] = this.vpt1;
        arrowPt[ptXY] = this.vpt0;
        this.vpt0.set(this.screens[ptXY].x, this.screens[ptXY].y, this.screens[ptXY].z);
        this.viewer.rotatePoint(this.vertices[ptXYZ], this.vpt1);
        this.vpt1.z *= -1.0f;
        float zoomDimension = this.viewer.getScreenDim();
        float scaleFactor = zoomDimension / 20.0f;
        this.vpt1.scaleAdd(this.dmesh.scale * scaleFactor, this.vpt1, this.vpt0);
        if (this.diameter == 0) {
            this.diameter = 1;
        }
        this.renderLine(this.vpt0, this.vpt1, this.diameter, (byte)2, this.pt1i, this.pt2i);
        this.renderArrowHead(this.vpt0, this.vpt1, 0.0f, true, false);
    }

    private void renderArrowHead(Point3f pt1, Point3f pt2, float factor2, boolean isTransformed, boolean withShaft) {
        int headDiameter;
        if (this.dmesh.nohead) {
            return;
        }
        float fScale = this.dmesh.drawArrowScale;
        if (fScale == 0.0f) {
            fScale = this.viewer.getDefaultDrawArrowScale();
        }
        if (fScale <= 0.0f) {
            fScale = 0.5f;
        }
        if (isTransformed) {
            fScale *= 40.0f;
        }
        if (factor2 > 0.0f) {
            fScale *= factor2;
        }
        this.pt0f.set(pt1);
        this.pt2f.set(pt2);
        float d = this.pt0f.distance(this.pt2f);
        if (d == 0.0f) {
            return;
        }
        this.vTemp.set(this.pt2f);
        this.vTemp.sub(this.pt0f);
        this.vTemp.normalize();
        this.vTemp.scale(fScale / 5.0f);
        if (!withShaft) {
            this.pt2f.add(this.vTemp);
        }
        this.vTemp.scale(5.0f);
        this.pt1f.set(this.pt2f);
        this.pt1f.sub(this.vTemp);
        if (isTransformed) {
            this.pt1i.set((int)this.pt1f.x, (int)this.pt1f.y, (int)this.pt1f.z);
            this.pt2i.set((int)this.pt2f.x, (int)this.pt2f.y, (int)this.pt2f.z);
        } else {
            this.viewer.transformPoint(this.pt2f, this.pt2i);
            this.viewer.transformPoint(this.pt1f, this.pt1i);
            this.viewer.transformPoint(this.pt0f, this.pt0i);
        }
        if (this.pt2i.z == 1 || this.pt1i.z == 1) {
            return;
        }
        if (this.diameter > 0) {
            headDiameter = this.diameter * 3;
        } else {
            this.vTemp.set(this.pt2i.x - this.pt1i.x, this.pt2i.y - this.pt1i.y, this.pt2i.z - this.pt1i.z);
            headDiameter = (int)((double)this.vTemp.length() * 0.5);
            this.diameter = headDiameter / 5;
        }
        if (this.diameter < 1) {
            this.diameter = 1;
        }
        if (headDiameter > 2) {
            this.g3d.fillCone((byte)2, headDiameter, this.pt1i, this.pt2i);
        }
        if (withShaft) {
            this.g3d.fillCylinder((byte)4, this.diameter, this.pt0i, this.pt1i);
        }
    }

    private void renderHandles() {
        int diameter = (int)(10.0f * this.imageFontScaling);
        switch (this.drawType) {
            case 0: 
            case 3: {
                return;
            }
        }
        int i = this.dmesh.polygonCount;
        while (--i >= 0) {
            int[] vertexIndexes;
            if (!this.isPolygonDisplayable(i) || (vertexIndexes = this.dmesh.polygonIndexes[i]) == null) continue;
            int j = vertexIndexes.length;
            while (--j >= 0) {
                int k = vertexIndexes[j];
                this.g3d.fillScreenedCircleCentered((short)23, diameter, this.screens[k].x, this.screens[k].y, this.screens[k].z);
            }
            break block3;
        }
    }

    private void renderInfo() {
        if (this.mesh.title == null || this.viewer.getDrawHover() || !this.g3d.setColix(this.viewer.getColixBackgroundContrast())) {
            return;
        }
        int i = this.dmesh.polygonCount;
        while (--i >= 0) {
            if (!this.isPolygonDisplayable(i)) continue;
            byte fid = this.g3d.getFontFid(14.0f * this.imageFontScaling);
            this.g3d.setFont(fid);
            String s = this.mesh.title[i < this.mesh.title.length ? i : this.mesh.title.length - 1];
            int pt = 0;
            if (s.length() > 1 && s.charAt(0) == '>') {
                pt = this.dmesh.polygonIndexes[i].length - 1;
                s = s.substring(1);
                if (this.drawType == 19) {
                    this.pt1f.set(this.pt2f);
                }
            }
            if (this.drawType != 19) {
                this.pt1f.set(this.vertices[this.dmesh.polygonIndexes[i][pt]]);
            }
            this.viewer.transformPoint(this.pt1f, this.pt1i);
            int offset = (int)(5.0f * this.imageFontScaling);
            this.g3d.drawString(s, null, this.pt1i.x + offset, this.pt1i.y - offset, this.pt1i.z, this.pt1i.z);
            break;
        }
    }
}

