/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Enumeration;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.shape.Shape;
import org.jmol.shape.ShapeRenderer;
import org.jmol.shapespecial.Ellipsoids;
import org.jmol.util.Logger;
import org.jmol.util.Quadric;

public class EllipsoidsRenderer
extends ShapeRenderer {
    private Ellipsoids ellipsoids;
    private boolean drawDots;
    private boolean drawArcs;
    private boolean drawAxes;
    private boolean drawFill;
    private boolean drawBall;
    private boolean wireframeOnly;
    private int dotCount;
    private int[] coords;
    private Vector3f[] axes;
    private final float[] factoredLengths = new float[3];
    private int diameter;
    private int diameter0;
    private int selectedOctant = -1;
    private Point3i[] selectedPoints = new Point3i[3];
    private int iCutout = -1;
    private Matrix3f mat = new Matrix3f();
    private Matrix3f mTemp = new Matrix3f();
    private Matrix4f mDeriv = new Matrix4f();
    private Matrix3f matScreenToCartesian = new Matrix3f();
    private Matrix3f matScreenToEllipsoid = new Matrix3f();
    private Matrix3f matEllipsoidToScreen = new Matrix3f();
    private double[] coef = new double[10];
    private final Vector3f v1 = new Vector3f();
    private final Vector3f v2 = new Vector3f();
    private final Vector3f v3 = new Vector3f();
    private final Point3f pt1 = new Point3f();
    private final Point3f pt2 = new Point3f();
    private final Point3i s0 = new Point3i();
    private final Point3i s1 = new Point3i();
    private final Point3i s2 = new Point3i();
    private static final float toRadians = (float)Math.PI / 180;
    private static final float[] cossin = new float[36];
    private final Point3i[] screens = new Point3i[32];
    private final Point3f[] points = new Point3f[6];
    private static int[] axisPoints;
    private static int[] octants;
    private int dx;
    private float perspectiveFactor;
    private static final Vector3f[] unitVectors;
    private static final Point3f[] unitAxisPoints;

    public EllipsoidsRenderer() {
        int i;
        for (i = 0; i < this.points.length; ++i) {
            this.points[i] = new Point3f();
        }
        for (i = 0; i < this.screens.length; ++i) {
            this.screens[i] = new Point3i();
        }
    }

    protected void render() {
        this.ellipsoids = (Ellipsoids)this.shape;
        if (this.ellipsoids.mads == null && !this.ellipsoids.haveEllipsoids) {
            return;
        }
        this.wireframeOnly = this.viewer.getWireframeRotation() && this.viewer.getInMotion();
        this.drawAxes = this.viewer.getBooleanProperty("ellipsoidAxes");
        this.drawArcs = this.viewer.getBooleanProperty("ellipsoidArcs");
        this.drawBall = this.viewer.getBooleanProperty("ellipsoidBall") && !this.wireframeOnly;
        this.drawDots = this.viewer.getBooleanProperty("ellipsoidDots") && !this.wireframeOnly;
        this.drawFill = this.viewer.getBooleanProperty("ellipsoidFill") && !this.wireframeOnly;
        this.diameter0 = (int)(((Float)this.viewer.getParameter("ellipsoidAxisDiameter")).floatValue() * 1000.0f);
        if (this.drawBall) {
            this.drawDots = false;
        }
        if (!(this.drawDots || this.drawArcs || this.drawBall)) {
            this.drawAxes = true;
        }
        if (this.drawDots) {
            this.drawArcs = false;
            this.drawFill = false;
        }
        if (this.drawDots) {
            this.dotCount = (Integer)this.viewer.getParameter("ellipsoidDotCount");
            if (this.coords == null || this.coords.length != this.dotCount * 3) {
                this.coords = new int[this.dotCount * 3];
            }
        }
        Matrix4f m4 = this.viewer.getMatrixtransform();
        this.mat.setRow(0, m4.m00, m4.m01, m4.m02);
        this.mat.setRow(1, m4.m10, m4.m11, m4.m12);
        this.mat.setRow(2, m4.m20, m4.m21, m4.m22);
        this.matScreenToCartesian.invert(this.mat);
        Atom[] atoms = this.modelSet.atoms;
        int i = this.modelSet.getAtomCount();
        while (--i >= 0) {
            Object[] ellipsoid;
            Atom atom = atoms[i];
            if (!atom.isShapeVisible(this.myVisibilityFlag) || this.modelSet.isAtomHidden(i) || atom.screenZ <= 1 || (ellipsoid = atom.getEllipsoid()) == null) continue;
            this.colix = Shape.getColix(this.ellipsoids.colixes, i, atom);
            if (!this.g3d.setColix(this.colix)) continue;
            this.render1(atom, ellipsoid);
        }
        if (this.ellipsoids.haveEllipsoids) {
            Enumeration e = this.ellipsoids.htEllipsoids.elements();
            while (e.hasMoreElements()) {
                Ellipsoids.Ellipsoid ellipsoid = (Ellipsoids.Ellipsoid)e.nextElement();
                if (!ellipsoid.visible || !ellipsoid.isValid) continue;
                this.renderEllipsoid(ellipsoid);
            }
        }
        this.coords = null;
    }

    private void render1(Atom atom, Object[] ellipsoid) {
        this.s0.set(atom.screenX, atom.screenY, atom.screenZ);
        float[] lengths = (float[])ellipsoid[1];
        boolean isOK = true;
        int i = 3;
        while (--i >= 0) {
            this.factoredLengths[i] = lengths[i + 3];
            if (!Float.isNaN(this.factoredLengths[i])) continue;
            isOK = false;
        }
        this.axes = (Vector3f[])ellipsoid[0];
        if (this.axes == null) {
            this.axes = unitVectors;
        }
        this.setMatrices();
        this.setAxes(atom, 1.0f);
        if (this.g3d.isClippedXY(this.dx + this.dx, atom.screenX, atom.screenY)) {
            return;
        }
        this.diameter = this.viewer.scaleToScreen(atom.screenZ, this.wireframeOnly ? 1 : this.diameter0);
        if (!isOK || this.drawBall) {
            this.renderBall();
            if (!isOK) {
                return;
            }
            if (this.drawArcs || this.drawAxes) {
                this.g3d.setColix(this.viewer.getColixBackgroundContrast());
                if (this.drawAxes) {
                    this.renderAxes();
                }
                if (this.drawArcs) {
                    this.renderArcs(atom);
                }
                this.g3d.setColix(this.colix);
            }
        } else {
            if (this.drawAxes) {
                this.renderAxes();
            }
            if (this.drawArcs) {
                this.renderArcs(atom);
            }
        }
        if (this.drawDots) {
            this.renderDots(atom);
        }
    }

    private void setMatrices() {
        Quadric.setEllipsoidMatrix(this.axes, this.factoredLengths, this.v1, this.mat);
        this.matScreenToEllipsoid.mul(this.mat, this.matScreenToCartesian);
        this.matEllipsoidToScreen.invert(this.matScreenToEllipsoid);
        this.perspectiveFactor = this.viewer.scaleToPerspective(this.s0.z, 1.0f);
        this.matScreenToEllipsoid.mul(1.0f / this.perspectiveFactor);
    }

    private void setAxes(Point3f center, float f) {
        for (int i = 0; i < 6; ++i) {
            int iAxis = axisPoints[i];
            int i012 = Math.abs(iAxis) - 1;
            this.points[i].scaleAdd(f * this.factoredLengths[i012] * (float)(iAxis < 0 ? -1 : 1), this.axes[i012], center);
            this.pt1.set(unitAxisPoints[i]);
            this.pt1.scale(f);
            this.matEllipsoidToScreen.transform(this.pt1);
            this.screens[i].set((int)((float)this.s0.x + this.pt1.x * this.perspectiveFactor), (int)((float)this.s0.y + this.pt1.y * this.perspectiveFactor), (int)(this.pt1.z + (float)this.s0.z));
        }
        this.dx = 2 + this.viewer.scaleToScreen(this.s0.z, (int)((double)f * (Float.isNaN(this.factoredLengths[2]) ? 1.0 : (double)this.factoredLengths[2]) * 1000.0));
    }

    private void renderAxes() {
        if (this.drawBall && this.drawFill) {
            this.g3d.fillCylinder((byte)2, this.diameter, this.s0, this.selectedPoints[0]);
            this.g3d.fillCylinder((byte)2, this.diameter, this.s0, this.selectedPoints[1]);
            this.g3d.fillCylinder((byte)2, this.diameter, this.s0, this.selectedPoints[2]);
            return;
        }
        if (Logger.debugging) {
            this.g3d.setColix((short)10);
            this.g3d.fillCylinder((byte)2, this.diameter, this.screens[0], this.screens[1]);
            this.g3d.setColix((short)11);
            this.g3d.fillCylinder((byte)2, this.diameter, this.screens[2], this.screens[3]);
            this.g3d.setColix((short)7);
            this.g3d.fillCylinder((byte)2, this.diameter, this.screens[4], this.screens[5]);
            this.g3d.setColix(this.colix);
        } else {
            this.g3d.fillCylinder((byte)2, this.diameter, this.screens[0], this.screens[1]);
            this.g3d.fillCylinder((byte)2, this.diameter, this.screens[2], this.screens[3]);
            this.g3d.fillCylinder((byte)2, this.diameter, this.screens[4], this.screens[5]);
        }
    }

    private void renderDots(Point3f ptAtom) {
        int i = 0;
        while (i < this.coords.length) {
            float fz;
            float fx = (float)Math.random();
            float fy = (float)Math.random();
            if (Float.isNaN(fz = (float)Math.sqrt(1.0f - (fx *= (float)(Math.random() > 0.5 ? -1 : 1)) * fx - (fy *= (float)(Math.random() > 0.5 ? -1 : 1)) * fy))) continue;
            fz = (float)(Math.random() > 0.5 ? -1 : 1) * fz;
            this.pt1.scaleAdd(fx * this.factoredLengths[0], this.axes[0], ptAtom);
            this.pt1.scaleAdd(fy * this.factoredLengths[1], this.axes[1], this.pt1);
            this.pt1.scaleAdd(fz * this.factoredLengths[2], this.axes[2], this.pt1);
            this.viewer.transformPoint(this.pt1, this.s1);
            this.coords[i++] = this.s1.x;
            this.coords[i++] = this.s1.y;
            this.coords[i++] = this.s1.z;
        }
        this.g3d.drawPoints(this.dotCount, this.coords);
    }

    private void renderArcs(Point3f ptAtom) {
        for (int i = 1; i < 8; i += 2) {
            int pt = i * 3;
            this.renderArc(ptAtom, octants[pt], octants[pt + 1]);
            this.renderArc(ptAtom, octants[pt + 1], octants[pt + 2]);
            this.renderArc(ptAtom, octants[pt + 2], octants[pt]);
        }
    }

    private void renderArc(Point3f ptAtom, int ptA, int ptB) {
        this.v1.set(this.points[ptA]);
        this.v1.sub(ptAtom);
        this.v2.set(this.points[ptB]);
        this.v2.sub(ptAtom);
        float d1 = this.v1.length();
        float d2 = this.v2.length();
        this.v1.normalize();
        this.v2.normalize();
        this.v3.cross(this.v1, this.v2);
        this.pt1.set(this.points[ptA]);
        this.s1.set(this.screens[ptA]);
        boolean fillArc = this.drawFill && !this.drawBall;
        short normix = this.ellipsoids.g3d.get2SidedNormix(this.v3);
        if (!fillArc && !this.wireframeOnly) {
            this.screens[6].set(this.s1);
        }
        int i = 0;
        int pt = 0;
        while (i < 18) {
            this.pt2.scaleAdd(cossin[pt] * d1, this.v1, ptAtom);
            this.pt2.scaleAdd(cossin[pt + 1] * d2, this.v2, this.pt2);
            this.viewer.transformPoint(this.pt2, this.s2);
            if (fillArc) {
                this.g3d.fillTriangle(this.s0, this.colix, normix, this.s1, this.colix, normix, this.s2, this.colix, normix);
            } else if (this.wireframeOnly) {
                this.g3d.fillCylinder((byte)2, this.diameter, this.s1, this.s2);
            } else {
                this.screens[i + 7].set(this.s2);
            }
            this.pt1.set(this.pt2);
            this.s1.set(this.s2);
            ++i;
            pt += 2;
        }
        if (!fillArc && !this.wireframeOnly) {
            for (i = 0; i < 18; ++i) {
                this.g3d.fillHermite(5, this.diameter, this.diameter, this.diameter, this.screens[i == 0 ? i + 6 : i + 5], this.screens[i + 6], this.screens[i + 7], this.screens[i == 17 ? i + 7 : i + 8]);
            }
        }
    }

    private void renderEllipsoid(Ellipsoids.Ellipsoid ellipsoid) {
        this.axes = ellipsoid.axes;
        for (int i = 0; i < 3; ++i) {
            this.factoredLengths[i] = ellipsoid.lengths[i];
        }
        this.viewer.transformPoint(ellipsoid.center, this.s0);
        this.setMatrices();
        this.setAxes(ellipsoid.center, 1.0f);
        this.colix = ellipsoid.colix;
        if (!this.g3d.setColix(this.colix)) {
            return;
        }
        this.renderBall();
    }

    private void renderBall() {
        this.setSelectedOctant();
        Quadric.getEquationForQuadricWithCenter(this.s0.x, this.s0.y, this.s0.z, this.matScreenToEllipsoid, this.v1, this.mTemp, this.coef, this.mDeriv);
        this.g3d.renderEllipsoid(this.s0.x, this.s0.y, this.s0.z, this.dx + this.dx, this.matScreenToEllipsoid, this.coef, this.mDeriv, this.selectedOctant, this.selectedOctant >= 0 ? this.selectedPoints : null);
    }

    private void setSelectedOctant() {
        int zMin = Integer.MAX_VALUE;
        this.selectedOctant = -1;
        this.iCutout = -1;
        if (this.drawFill) {
            for (int i = 0; i < 8; ++i) {
                int ptA = octants[i * 3];
                int ptB = octants[i * 3 + 1];
                int ptC = octants[i * 3 + 2];
                int z = this.screens[ptA].z + this.screens[ptB].z + this.screens[ptC].z;
                if (z >= zMin) continue;
                zMin = z;
                this.iCutout = i;
            }
            this.selectedPoints[0] = this.screens[octants[this.iCutout * 3]];
            this.s1.set(this.selectedPoints[0]);
            this.selectedPoints[1] = this.screens[octants[this.iCutout * 3 + 1]];
            this.s1.add(this.selectedPoints[1]);
            this.selectedPoints[2] = this.screens[octants[this.iCutout * 3 + 2]];
            this.s1.add(this.selectedPoints[2]);
            this.s1.scaleAdd(-3, this.s0, this.s1);
            this.pt1.set(this.s1.x, this.s1.y, this.s1.z);
            this.matScreenToEllipsoid.transform(this.pt1);
            this.selectedOctant = Quadric.getOctant(this.pt1);
        }
    }

    static {
        int pt = 0;
        for (int i = 5; i <= 90; i += 5) {
            EllipsoidsRenderer.cossin[pt++] = (float)Math.cos((float)i * ((float)Math.PI / 180));
            EllipsoidsRenderer.cossin[pt++] = (float)Math.sin((float)i * ((float)Math.PI / 180));
        }
        axisPoints = new int[]{-1, 1, -2, 2, -3, 3};
        octants = new int[]{5, 0, 3, 5, 2, 0, 4, 0, 2, 4, 3, 0, 5, 2, 1, 5, 1, 3, 4, 3, 1, 4, 1, 2};
        unitVectors = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
        unitAxisPoints = new Point3f[]{new Point3f(-1.0f, 0.0f, 0.0f), new Point3f(1.0f, 0.0f, 0.0f), new Point3f(0.0f, -1.0f, 0.0f), new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 0.0f, -1.0f), new Point3f(0.0f, 0.0f, 1.0f)};
    }
}

