/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.MeshRenderer;
import org.jmol.shapesurface.Isosurface;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.Logger;

public class IsosurfaceRenderer
extends MeshRenderer {
    private boolean iShowNormals;
    protected boolean iHideBackground;
    protected boolean isBicolorMap;
    protected short backgroundColix;
    protected int nError = 0;
    protected float[] vertexValues;
    protected IsosurfaceMesh imesh;
    private final Point3f ptTemp = new Point3f();
    private final Point3i ptTempi = new Point3i();

    protected void render() {
        this.iShowNormals = this.viewer.getTestFlag4();
        Isosurface isosurface = (Isosurface)this.shape;
        int i = isosurface.meshCount;
        while (--i >= 0) {
            this.imesh = (IsosurfaceMesh)isosurface.meshes[i];
            this.render1(this.imesh);
        }
    }

    protected void transform() {
        this.vertexValues = this.imesh.vertexValues;
        int i = this.vertexCount;
        while (--i >= 0) {
            if (this.vertexValues != null && Float.isNaN(this.vertexValues[i]) && !this.imesh.hasGridPoints) continue;
            this.viewer.transformPoint(this.vertices[i], this.screens[i]);
        }
    }

    protected void render2() {
        this.isBicolorMap = this.imesh.jvxlData.isBicolorMap;
        super.render2();
        if (!this.g3d.setColix((short)4)) {
            return;
        }
        if (this.imesh.showContourLines) {
            this.renderContourLines();
        }
    }

    private void renderContourLines() {
        Vector[] vContours = this.imesh.getContours();
        if (vContours == null) {
            return;
        }
        int i = vContours.length;
        block0: while (--i >= 0) {
            Vector v = vContours[i];
            if (v.size() < 5) continue;
            if (!this.g3d.setColix(this.mesh.fillTriangles ? (short)4 : Graphics3D.getColix(((int[])v.get(3))[0]))) {
                return;
            }
            int n = v.size() - 1;
            for (int j = 5; j < n; ++j) {
                Point3f pt1 = (Point3f)v.get(j);
                Point3f pt2 = (Point3f)v.get(++j);
                this.viewer.transformPoint(pt1, this.pt1i);
                this.viewer.transformPoint(pt2, this.pt2i);
                if (Float.isNaN(pt1.x) || Float.isNaN(pt2.x)) continue block0;
                this.g3d.drawLine(this.pt1i, this.pt2i);
            }
        }
    }

    protected void renderPoints() {
        int i;
        int incr = this.imesh.vertexIncrement;
        int diam = 4;
        boolean showNumbers = this.viewer.getTestFlag2();
        if (showNumbers) {
            this.g3d.setFont(this.g3d.getFontFid("Monospaced", 10.0f));
        }
        int n = i = !this.imesh.hasGridPoints || this.imesh.firstRealVertex < 0 ? 0 : this.imesh.firstRealVertex;
        while (i < this.vertexCount) {
            if (!(this.vertexValues != null && Float.isNaN(this.vertexValues[i]) || this.frontOnly && this.transformedVectors[this.normixes[i]].z < 0.0f)) {
                if (this.imesh.vertexColixes != null) {
                    this.g3d.setColix(this.imesh.vertexColixes[i]);
                }
                this.g3d.fillSphereCentered(diam, this.screens[i]);
                if (showNumbers && this.screens[i].z > 10) {
                    this.g3d.drawStringNoSlab(i + (this.imesh.isColorSolid ? "" : " " + this.imesh.vertexValues[i]), null, this.screens[i].x, this.screens[i].y, this.screens[i].z);
                }
            }
            i += incr;
        }
        if (incr != 3) {
            return;
        }
        this.g3d.setColix(this.isTranslucent ? Graphics3D.getColixTranslucent((short)12, true, 0.5f) : (short)12);
        for (i = 1; i < this.vertexCount; i += 3) {
            this.g3d.fillCylinder((byte)3, 1, this.screens[i], this.screens[i + 1]);
        }
        this.g3d.setColix(this.isTranslucent ? Graphics3D.getColixTranslucent((short)21, true, 0.5f) : (short)21);
        for (i = 1; i < this.vertexCount; i += 3) {
            this.g3d.fillSphereCentered(4, this.screens[i]);
        }
        this.g3d.setColix(this.isTranslucent ? Graphics3D.getColixTranslucent((short)7, true, 0.5f) : (short)7);
        for (i = 2; i < this.vertexCount; i += 3) {
            this.g3d.fillSphereCentered(4, this.screens[i]);
        }
    }

    protected void renderTriangles(boolean fill, boolean iShowTriangles) {
        boolean generateSet;
        int[][] polygonIndexes = this.imesh.polygonIndexes;
        this.colix = this.imesh.colix;
        short[] vertexColixes = this.imesh.vertexColixes;
        this.g3d.setColix(this.imesh.colix);
        boolean bl = generateSet = this.isGenerator && fill;
        if (generateSet) {
            this.frontOnly = false;
            this.bsFaces.clear();
        }
        boolean colorSolid = vertexColixes == null || this.imesh.isColorSolid;
        short colix = this.colix;
        if (!colorSolid && !fill && this.imesh.fillTriangles && this.imesh.jvxlData.jvxlPlane != null) {
            colorSolid = true;
            colix = 4;
        }
        boolean colorArrayed = fill && colorSolid && this.imesh.polygonColixes != null;
        int i = this.imesh.polygonCount;
        while (--i >= 0) {
            short colixA;
            short colixB;
            short colixC;
            int[] vertexIndexes = polygonIndexes[i];
            if (vertexIndexes == null) continue;
            int iA = vertexIndexes[0];
            int iB = vertexIndexes[1];
            int iC = vertexIndexes[2];
            short nA = this.normixes[iA];
            short nB = this.normixes[iB];
            short nC = this.normixes[iC];
            if (this.frontOnly && this.transformedVectors[nA].z < 0.0f && this.transformedVectors[nB].z < 0.0f && this.transformedVectors[nC].z < 0.0f) continue;
            if (colorSolid) {
                short c;
                if (colorArrayed && i < this.imesh.polygonColixes.length && (c = this.imesh.polygonColixes[i]) != 0) {
                    colix = c;
                }
                colixB = colixC = colix;
                colixA = colixC;
            } else {
                colixA = vertexColixes[iA];
                colixB = vertexColixes[iB];
                colixC = vertexColixes[iC];
                if (this.isBicolorMap && (colixA != colixB || colixB != colixC)) continue;
            }
            if (fill) {
                block14: {
                    if (generateSet) {
                        this.bsFaces.set(i);
                        continue;
                    }
                    if (iShowTriangles) {
                        this.g3d.fillTriangle(this.screens[iA], colixA, nA, this.screens[iB], colixB, nB, this.screens[iC], colixC, nC, 0.1f);
                    } else {
                        try {
                            this.g3d.fillTriangle(this.screens[iA], colixA, nA, this.screens[iB], colixB, nB, this.screens[iC], colixC, nC);
                        }
                        catch (Exception e) {
                            if (this.nError++ >= 1) break block14;
                            Logger.warn("IsosurfaceRenderer -- competing thread bug?\n", e);
                        }
                    }
                }
                if (!this.iShowNormals) continue;
                this.renderNormals();
                continue;
            }
            int check = vertexIndexes[3];
            if (check == 0) continue;
            if (vertexColixes == null) {
                this.g3d.drawTriangle(this.screens[iA], this.screens[iB], this.screens[iC], check);
                continue;
            }
            this.g3d.drawTriangle(this.screens[iA], colixA, this.screens[iB], colixB, this.screens[iC], colixC, check);
        }
        if (generateSet) {
            this.renderExport();
        }
    }

    private void renderNormals() {
        if (!this.g3d.setColix((short)8)) {
            return;
        }
        int i = this.vertexCount;
        while (--i >= 0) {
            short n;
            if (this.vertexValues != null && !Float.isNaN(this.vertexValues[i])) {
                this.ptTemp.set(this.mesh.vertices[i]);
            }
            if ((n = this.mesh.normixes[i]) < 0) continue;
            this.ptTemp.add(this.g3d.getNormixVector(n));
            this.viewer.transformPoint(this.ptTemp, this.ptTempi);
            this.g3d.fillCylinder((byte)3, 1, this.screens[i], this.ptTempi);
        }
    }
}

