/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.BitSet;
import javax.vecmath.Vector3f;
import org.jmol.shapesurface.Isosurface;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

public class LcaoCartoon
extends Isosurface {
    private String thisType;
    private int myColorPt;
    private String lcaoID;
    private BitSet thisSet;
    private boolean isMolecular;
    private Vector3f rotationAxis;
    private Float lcaoScale;
    private boolean isTranslucent;
    private float translucentLevel;
    private Integer lcaoColorPos;
    private Integer lcaoColorNeg;

    public void initShape() {
        super.initShape();
        this.myType = "lcaoCartoon";
        this.allowMesh = false;
    }

    public void setProperty(String propertyName, Object value, BitSet bs) {
        if (Logger.debugging) {
            Logger.debug("\nLcaoCartoon.setProperty " + propertyName + " " + value);
        }
        if ("init" == propertyName) {
            this.myColorPt = 0;
            this.lcaoID = null;
            this.thisSet = bs;
            this.isMolecular = false;
            this.thisType = null;
            this.rotationAxis = null;
            super.setProperty("init", null, null);
            return;
        }
        if ("lcaoID" == propertyName) {
            this.lcaoID = (String)value;
            return;
        }
        if ("thisID" == propertyName) {
            this.lcaoID = (String)value;
        }
        if ("selectType" == propertyName) {
            this.thisType = (String)value;
            return;
        }
        if ("rotationAxis" == propertyName) {
            this.rotationAxis = (Vector3f)value;
            return;
        }
        if ("scale" == propertyName) {
            this.lcaoScale = (Float)value;
        }
        if ("colorRGB" == propertyName) {
            this.lcaoColorPos = (Integer)value;
            if (this.myColorPt++ == 0) {
                this.lcaoColorNeg = this.lcaoColorPos;
            }
        }
        if ("select" == propertyName) {
            this.thisSet = (BitSet)value;
        }
        if ("translucentLevel" == propertyName) {
            this.translucentLevel = ((Float)value).floatValue();
        }
        if ("settranslucency" == propertyName) {
            this.isTranslucent = ((String)value).equals("translucent");
            return;
        }
        if ("translucency" == propertyName) {
            this.isTranslucent = ((String)value).equals("translucent");
            if (this.lcaoID == null) {
                return;
            }
        }
        if ("molecular" == propertyName) {
            this.isMolecular = true;
            if (value == null) {
                return;
            }
            propertyName = "create";
        }
        if ("create" == propertyName) {
            this.myColorPt = 0;
            this.thisType = (String)value;
            this.createLcaoCartoon();
            return;
        }
        if ("delete" == propertyName) {
            this.deleteLcaoCartoon();
            return;
        }
        if ("on" == propertyName) {
            this.setLcaoOn(true);
            return;
        }
        if ("off" == propertyName) {
            this.setLcaoOn(false);
            return;
        }
        super.setProperty(propertyName, value, bs);
        if ("lobe" == propertyName || "sphere" == propertyName) {
            this.setScriptInfo();
        }
    }

    private void setLcaoOn(boolean TF) {
        int atomCount;
        int i = atomCount = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (this.lcaoID == null && !this.thisSet.get(i)) continue;
            this.setLcaoOn(i, TF);
        }
    }

    private void setLcaoOn(int iAtom, boolean TF) {
        String id = this.getID(this.lcaoID, iAtom);
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i].thisID.indexOf(id) != 0) continue;
            this.meshes[i].visible = TF;
        }
    }

    private void deleteLcaoCartoon() {
        int atomCount;
        int i = atomCount = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (this.lcaoID == null && !this.thisSet.get(i)) continue;
            this.deleteLcaoCartoon(i);
        }
    }

    private void deleteLcaoCartoon(int iAtom) {
        String id = this.getID(this.lcaoID, iAtom);
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i].thisID.indexOf(id) != 0) continue;
            this.deleteMesh(i);
        }
    }

    private void createLcaoCartoon() {
        this.isMolecular = this.isMolecular && (this.thisType.indexOf("px") >= 0 || this.thisType.indexOf("py") >= 0 || this.thisType.indexOf("pz") >= 0);
        int atomCount = this.viewer.getAtomCount();
        String lcaoID0 = this.lcaoID;
        for (int i = 0; i < atomCount; ++i) {
            if (!this.thisSet.get(i)) continue;
            this.createLcaoCartoon(i);
            this.lcaoID = lcaoID0;
        }
    }

    private void createLcaoCartoon(int iAtom) {
        String id = this.getID(this.lcaoID, iAtom);
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i].thisID.indexOf(id) != 0) continue;
            this.deleteMesh(i);
        }
        super.setProperty("init", null, null);
        super.setProperty("thisID", id, null);
        if (this.lcaoScale != null) {
            super.setProperty("scale", this.lcaoScale, null);
        }
        if (this.lcaoColorNeg != null) {
            super.setProperty("colorRGB", this.lcaoColorNeg, null);
            super.setProperty("colorRGB", this.lcaoColorPos, null);
        }
        super.setProperty("lcaoType", this.thisType, null);
        super.setProperty("atomIndex", new Integer(iAtom), null);
        Vector3f[] axes = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f(this.modelSet.atoms[iAtom]), new Vector3f()};
        if (this.rotationAxis != null) {
            axes[3].set(this.rotationAxis);
        }
        if (this.isMolecular) {
            if (this.thisType.indexOf("px") >= 0) {
                axes[0].set(0.0f, -1.0f, 0.0f);
                axes[1].set(1.0f, 0.0f, 0.0f);
            } else if (this.thisType.indexOf("py") >= 0) {
                axes[0].set(-1.0f, 0.0f, 0.0f);
                axes[1].set(0.0f, 0.0f, 1.0f);
            } else if (this.thisType.indexOf("pz") >= 0) {
                axes[0].set(0.0f, 0.0f, 1.0f);
                axes[1].set(1.0f, 0.0f, 0.0f);
            }
            if (this.thisType.indexOf("-") == 0) {
                axes[0].scale(-1.0f);
            }
        }
        if (this.isMolecular || this.thisType.equalsIgnoreCase("s") || this.viewer.getHybridizationAndAxes(iAtom, axes[0], axes[1], this.thisType, true) != null) {
            super.setProperty("lcaoCartoon", axes, null);
        }
        if (this.isTranslucent) {
            int i2 = this.meshCount;
            while (--i2 >= 0) {
                if (this.meshes[i2].thisID.indexOf(id) != 0) continue;
                this.meshes[i2].setTranslucent(true, this.translucentLevel);
            }
        }
    }

    private String getID(String id, int i) {
        return (id != null ? id : "lcao_" + (i + 1) + "_") + (this.thisType == null ? "" : TextFormat.simpleReplace(this.thisType, "-", this.thisType.indexOf("-p") == 0 ? "" : "_"));
    }

    public String getShapeState() {
        StringBuffer sb = new StringBuffer();
        if (this.lcaoScale != null) {
            LcaoCartoon.appendCmd(sb, "lcaoCartoon scale " + this.lcaoScale.floatValue());
        }
        if (this.lcaoColorNeg != null) {
            LcaoCartoon.appendCmd(sb, "lcaoCartoon color " + Escape.escapeColor(this.lcaoColorNeg) + " " + Escape.escapeColor(this.lcaoColorPos));
        }
        if (this.isTranslucent) {
            LcaoCartoon.appendCmd(sb, "lcaoCartoon translucent " + this.translucentLevel);
        }
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i].visible) continue;
            LcaoCartoon.appendCmd(sb, "lcaoCartoon ID " + this.meshes[i].thisID + " off");
        }
        return super.getShapeState() + sb.toString();
    }
}

