/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point4f;
import org.jmol.shapesurface.Isosurface;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class MolecularOrbital
extends Isosurface {
    private String moTranslucency = null;
    private Float moTranslucentLevel = null;
    private Point4f moPlane = null;
    private Float moCutoff = null;
    private Float moResolution = null;
    private Float moScale = null;
    private Integer moColorPos = null;
    private Integer moColorNeg = null;
    private boolean moIsPositiveOnly = false;
    private int moFill = 0x40000020;
    private int moMesh = 1073741851;
    private int moDots = 1073741855;
    private int moFrontOnly = 0x40000014;
    private String moTitleFormat = null;
    private boolean moDebug;
    private int myColorPt;
    private String strID;
    private int moNumber;
    private Hashtable htModels;
    private Hashtable thisModel;

    public void initShape() {
        super.initShape();
        this.myType = "molecularOrbital";
        super.setProperty("thisID", "mo", null);
    }

    public void setProperty(String propertyName, Object value, BitSet bs) {
        if (Logger.debugging) {
            Logger.debug("MolecularOrbital.setProperty " + propertyName + " " + value);
        }
        if ("init" == propertyName) {
            this.myColorPt = 0;
            this.moDebug = false;
            int modelIndex = (Integer)value;
            this.strID = this.getId(modelIndex);
            Logger.info("MO init " + this.strID);
            super.setProperty("init", null, null);
            super.setProperty("modelIndex", new Integer(modelIndex), null);
            if (this.htModels == null) {
                this.htModels = new Hashtable();
            }
            if (!this.htModels.containsKey(this.strID)) {
                this.htModels.put(this.strID, new Hashtable());
            }
            this.thisModel = (Hashtable)this.htModels.get(this.strID);
            this.moNumber = !this.thisModel.containsKey("moNumber") ? 0 : (Integer)this.thisModel.get("moNumber");
            return;
        }
        if ("cutoff" == propertyName) {
            this.thisModel.put("moCutoff", value);
            this.thisModel.put("moIsPositiveOnly", Boolean.FALSE);
            return;
        }
        if ("scale" == propertyName) {
            this.thisModel.put("moScale", value);
            return;
        }
        if ("cutoffPositive" == propertyName) {
            this.thisModel.put("moCutoff", value);
            this.thisModel.put("moIsPositiveOnly", Boolean.TRUE);
            return;
        }
        if ("resolution" == propertyName) {
            this.thisModel.put("moResolution", value);
            return;
        }
        if ("titleFormat" == propertyName) {
            this.moTitleFormat = (String)value;
            return;
        }
        if ("color" == propertyName) {
            if (!(value instanceof Integer)) {
                return;
            }
            this.thisModel.remove("moTranslucency");
            super.setProperty("color", value, bs);
            propertyName = "colorRGB";
            this.myColorPt = 0;
        }
        if ("colorRGB" == propertyName) {
            this.moColorPos = (Integer)value;
            if (this.myColorPt++ == 0) {
                this.moColorNeg = this.moColorPos;
            }
            this.thisModel.put("moColorNeg", this.moColorNeg);
            this.thisModel.put("moColorPos", this.moColorPos);
            return;
        }
        if ("plane" == propertyName) {
            if (value == null) {
                this.thisModel.remove("moPlane");
            } else {
                this.thisModel.put("moPlane", value);
            }
            return;
        }
        if ("molecularOrbital" == propertyName) {
            this.moNumber = (Integer)value;
            this.thisModel.put("moNumber", value);
            this.setOrbital(this.moNumber);
            return;
        }
        if ("translucentLevel" == propertyName) {
            if (this.thisModel == null) {
                if (this.currentMesh == null) {
                    return;
                }
                this.thisModel = (Hashtable)this.htModels.get(this.currentMesh.thisID);
            }
            this.thisModel.put("moTranslucentLevel", value);
        }
        if ("delete" == propertyName) {
            this.htModels.remove(this.strID);
        }
        if ("token" == propertyName) {
            int tok = (Integer)value;
            switch (tok) {
                case 528399: 
                case 1073741855: {
                    this.moDots = tok;
                    break;
                }
                case 0x40000010: 
                case 0x40000020: {
                    this.moFill = tok;
                    break;
                }
                case 1073741851: 
                case 1073741857: {
                    this.moMesh = tok;
                    break;
                }
                case 0x40000014: 
                case 1073741859: {
                    this.moFrontOnly = tok;
                }
            }
        }
        if ("translucency" == propertyName) {
            if (this.thisModel == null) {
                if (this.currentMesh == null) {
                    return;
                }
                this.thisModel = (Hashtable)this.htModels.get(this.currentMesh.thisID);
            }
            this.thisModel.put("moTranslucency", value);
        }
        if (propertyName == "deleteModelAtoms") {
            int modelIndex = ((int[])((Object[])value)[2])[0];
            Hashtable<String, Hashtable> htModelsNew = new Hashtable<String, Hashtable>();
            int i = this.meshCount;
            while (--i >= 0) {
                if (this.meshes[i] == null) continue;
                if (this.meshes[i].modelIndex == modelIndex) {
                    --this.meshCount;
                    if (this.meshes[i] == this.currentMesh) {
                        this.currentMesh = null;
                        this.thisModel = null;
                    }
                    this.meshes = (IsosurfaceMesh[])ArrayUtil.deleteElements(this.meshes, i, 1);
                    continue;
                }
                Hashtable htModel = (Hashtable)this.htModels.get(this.meshes[i].thisID);
                if (this.meshes[i].modelIndex > modelIndex) {
                    --this.meshes[i].modelIndex;
                    this.meshes[i].thisID = this.getId(this.meshes[i].modelIndex);
                }
                htModelsNew.put(this.meshes[i].thisID, htModel);
            }
            this.htModels = htModelsNew;
            return;
        }
        super.setProperty(propertyName, value, bs);
    }

    private String getId(int modelIndex) {
        return "mo_model" + this.viewer.getModelNumber(modelIndex);
    }

    public Object getProperty(String propertyName, int param) {
        if (propertyName == "list") {
            String s = (String)super.getProperty("list", param);
            if (s.length() > 1) {
                s = s + "cutoff = " + super.getProperty("cutoff", 0) + "\n";
            }
            return this.viewer.getMoInfo(-1) + "\n" + s;
        }
        if (propertyName == "moNumber") {
            return new Integer(this.moNumber);
        }
        if (propertyName == "showMO") {
            int i0;
            int nOrb;
            StringBuffer str = new StringBuffer();
            String infoType = "jvxlFileData";
            Vector mos = (Vector)this.sg.getMoData().get("mos");
            int n = nOrb = mos == null ? 0 : mos.size();
            if (nOrb == 0) {
                return "";
            }
            int thisMO = param;
            int currentMO = this.moNumber;
            if (currentMO == 0) {
                thisMO = 0;
            }
            int nTotal = thisMO > 0 ? 1 : nOrb;
            for (int i = i0 = nTotal == 1 && currentMO > 0 ? currentMO : 1; i <= nOrb; ++i) {
                if (thisMO != 0 && thisMO != i && (thisMO != Integer.MAX_VALUE || i != currentMO)) continue;
                if (thisMO != Integer.MAX_VALUE) {
                    super.setProperty("init", "mo_show", null);
                    this.setOrbital(i);
                }
                str.append(super.getProperty(infoType, nTotal));
                infoType = "jvxlSurfaceData";
                if (thisMO != Integer.MAX_VALUE) {
                    super.setProperty("delete", "mo_show", null);
                }
                if (nTotal == 1) break;
            }
            return str.toString();
        }
        return super.getProperty(propertyName, param);
    }

    protected void clearSg() {
    }

    private boolean getSettings(String strID) {
        this.thisModel = (Hashtable)this.htModels.get(strID);
        if (this.thisModel == null || this.thisModel.get("moNumber") == null) {
            return false;
        }
        this.moTranslucency = (String)this.thisModel.get("moTranslucency");
        this.moTranslucentLevel = (Float)this.thisModel.get("moTranslucentLevel");
        this.moPlane = (Point4f)this.thisModel.get("moPlane");
        this.moCutoff = (Float)this.thisModel.get("moCutoff");
        if (this.moCutoff == null) {
            this.moCutoff = (Float)this.sg.getMoData().get("defaultCutoff");
        }
        if (this.moCutoff == null) {
            this.moCutoff = new Float(0.05f);
        }
        this.thisModel.put("moCutoff", new Float(this.moCutoff.floatValue()));
        this.moResolution = (Float)this.thisModel.get("moResolution");
        this.moScale = (Float)this.thisModel.get("moScale");
        this.moColorPos = (Integer)this.thisModel.get("moColorPos");
        this.moColorNeg = (Integer)this.thisModel.get("moColorNeg");
        this.moNumber = (Integer)this.thisModel.get("moNumber");
        Object b = this.thisModel.get("moIsPositiveOnly");
        this.moIsPositiveOnly = b != null && (Boolean)b != false;
        return true;
    }

    private void setOrbital(int moNumber) {
        super.setProperty("reset", this.strID, null);
        if (this.moDebug) {
            super.setProperty("debug", Boolean.TRUE, null);
        }
        this.getSettings(this.strID);
        if (this.moScale != null) {
            super.setProperty("scale", this.moScale, null);
        }
        if (this.moResolution != null) {
            super.setProperty("resolution", this.moResolution, null);
        }
        if (this.moPlane != null) {
            super.setProperty("plane", this.moPlane, null);
            if (this.moCutoff != null) {
                super.setProperty("red", new Float(-this.moCutoff.floatValue()), null);
                super.setProperty("blue", this.moCutoff, null);
            }
        } else {
            if (this.moCutoff != null) {
                super.setProperty(this.moIsPositiveOnly ? "cutoffPositive" : "cutoff", this.moCutoff, null);
            }
            if (this.moColorNeg != null) {
                super.setProperty("colorRGB", this.moColorNeg, null);
            }
            if (this.moColorPos != null) {
                super.setProperty("colorRGB", this.moColorPos, null);
            }
        }
        super.setProperty("title", this.moTitleFormat, null);
        super.setProperty("fileName", this.viewer.getFileName(), null);
        super.setProperty("molecularOrbital", new Integer(moNumber), null);
        if (this.moPlane != null && this.moColorNeg != null) {
            super.setProperty("colorRGB", this.moColorNeg, null);
        }
        if (this.moPlane != null && this.moColorPos != null) {
            super.setProperty("colorRGB", this.moColorPos, null);
        }
        this.currentMesh.isColorSolid = false;
        if (this.moTranslucentLevel != null) {
            super.setProperty("translucenctLevel", this.moTranslucentLevel, null);
        }
        if (this.moTranslucency != null) {
            super.setProperty("translucency", this.moTranslucency, null);
        }
        super.setProperty("token", new Integer(this.moFill), null);
        super.setProperty("token", new Integer(this.moMesh), null);
        super.setProperty("token", new Integer(this.moDots), null);
        super.setProperty("token", new Integer(this.moFrontOnly), null);
        this.thisModel.put("mesh", this.currentMesh);
    }

    public String getShapeState() {
        if (this.htModels == null) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.modelCount; ++i) {
            s.append(this.getMoState(i));
        }
        return s.toString();
    }

    private String getMoState(int modelIndex) {
        this.strID = this.getId(modelIndex);
        if (!this.getSettings(this.strID)) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        if (this.modelCount > 1) {
            MolecularOrbital.appendCmd(s, "frame " + this.viewer.getModelNumber(modelIndex));
        }
        if (this.moCutoff != null) {
            MolecularOrbital.appendCmd(s, "mo cutoff " + (this.sg.getIsPositiveOnly() ? "+" : "") + this.moCutoff);
        }
        if (this.moScale != null) {
            MolecularOrbital.appendCmd(s, "mo scale " + this.moScale);
        }
        if (this.moResolution != null) {
            MolecularOrbital.appendCmd(s, "mo resolution " + this.moResolution);
        }
        if (this.moPlane != null) {
            MolecularOrbital.appendCmd(s, "mo plane {" + this.moPlane.x + " " + this.moPlane.y + " " + this.moPlane.z + " " + this.moPlane.w + "}");
        }
        if (this.moTitleFormat != null) {
            MolecularOrbital.appendCmd(s, "mo titleFormat " + Escape.escape(this.moTitleFormat));
        }
        if (this.moColorNeg != null) {
            MolecularOrbital.appendCmd(s, "mo color " + Escape.escapeColor(this.moColorNeg) + (this.moColorNeg.equals(this.moColorPos) ? "" : " " + Escape.escapeColor(this.moColorPos)));
        }
        MolecularOrbital.appendCmd(s, "mo " + this.moNumber);
        if (this.moTranslucency != null) {
            MolecularOrbital.appendCmd(s, "mo translucent " + this.moTranslucentLevel);
        }
        MolecularOrbital.appendCmd(s, ((IsosurfaceMesh)this.thisModel.get("mesh")).getState("mo"));
        return s.toString();
    }
}

