/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.text.NumberFormat;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.shapesurface.IsosurfaceRenderer;
import org.jmol.shapesurface.MolecularOrbital;

public class MolecularOrbitalRenderer
extends IsosurfaceRenderer {
    private NumberFormat nf;

    protected void render() {
        this.imageFontScaling = this.viewer.getImageFontScaling();
        MolecularOrbital mo = (MolecularOrbital)this.shape;
        int modelIndex = this.viewer.getCurrentModelIndex();
        int i = mo.meshCount;
        while (--i >= 0) {
            this.imesh = (IsosurfaceMesh)mo.meshes[i];
            if (!this.render1(this.imesh) || modelIndex < 0) continue;
            this.renderInfo();
        }
    }

    private void renderInfo() {
        if (this.mesh.title == null || this.isGenerator || !this.g3d.setColix(this.viewer.getColixBackgroundContrast())) {
            return;
        }
        if (this.nf == null) {
            this.nf = NumberFormat.getInstance();
        }
        if (this.nf != null) {
            this.nf.setMaximumFractionDigits(3);
            this.nf.setMinimumFractionDigits(3);
        }
        byte fid = this.g3d.getFontFid("Monospaced", 14.0f * this.imageFontScaling);
        this.g3d.setFont(fid);
        int lineheight = (int)(15.0f * this.imageFontScaling);
        int x = (int)(5.0f * this.imageFontScaling);
        int y = lineheight;
        for (int i = 0; i < this.mesh.title.length; ++i) {
            if (this.mesh.title[i].length() <= 0) continue;
            this.g3d.drawStringNoSlab(this.mesh.title[i], null, x, y, 0);
            y += lineheight;
        }
    }
}

