/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;

class PointGroup {
    private static final int[] axesMaxN = new int[]{15, 0, 0, 1, 3, 1, 10, 0, 1, 0, 6, 0, 1, 0, 0, 0, 15, 10, 6, 6, 10, 0, 1};
    private static final int[] nUnique = new int[]{1, 0, 0, 2, 2, 4, 2, 0, 4, 0, 4, 0, 4, 0, 0, 0, 1, 2, 2, 4, 2, 0, 4};
    private static final int s3 = 3;
    private static final int s4 = 4;
    private static final int s5 = 5;
    private static final int s6 = 6;
    private static final int s8 = 8;
    private static final int s10 = 10;
    private static final int s12 = 12;
    private static final int firstProper = 14;
    private static final int c2 = 16;
    private static final int c3 = 17;
    private static final int c4 = 18;
    private static final int c5 = 19;
    private static final int c6 = 20;
    private static final int c8 = 22;
    private static final int maxAxis = axesMaxN.length;
    private int[] nAxes = new int[maxAxis];
    private Operation[][] axes = new Operation[maxAxis][];
    private int nAtoms;
    private float radius;
    private float distanceTolerance = 0.2f;
    private float linearTolerance = 8.0f;
    private float cosTolerance = 0.99f;
    private String name = "C_1?";
    private Operation principalAxis;
    private Operation principalPlane;
    private final Vector3f vTemp = new Vector3f();
    private int centerAtomIndex = -1;
    private boolean haveInversionCenter;
    private final Point3f center = new Point3f();
    private Point3f[] atoms;
    private int[] elements;
    private static final int ATOM_COUNT_MAX = 100;
    int maxElement = 0;
    int[] eCounts;
    static final int OPERATION_PLANE = 0;
    static final int OPERATION_PROPER_AXIS = 1;
    static final int OPERATION_IMPROPER_AXIS = 2;
    static final int OPERATION_INVERSION_CENTER = 3;
    static final String[] typeNames = new String[]{"plane", "proper axis", "improper axis", "center of inversion"};
    int nOps = 0;
    String drawInfo;
    String drawType = "";
    int drawIndex;
    Hashtable info;
    String textInfo;

    String getName() {
        return this.name;
    }

    static PointGroup getPointGroup(PointGroup pgLast, Atom[] atomset, BitSet bsAtoms, boolean haveVibration, float distanceTolerance, float linearTolerance) {
        PointGroup pg = new PointGroup();
        return pg.set(pgLast, atomset, bsAtoms, haveVibration, distanceTolerance, linearTolerance) ? pg : pgLast;
    }

    private PointGroup() {
    }

    private boolean isEqual(PointGroup pg) {
        if (pg == null) {
            return false;
        }
        if (this.linearTolerance != pg.linearTolerance || this.distanceTolerance != pg.distanceTolerance || this.nAtoms != pg.nAtoms) {
            return false;
        }
        for (int i = 0; i < this.nAtoms; ++i) {
            if (this.elements[i] == pg.elements[i] && this.atoms[i].distance(pg.atoms[i]) == 0.0f) continue;
            return false;
        }
        return true;
    }

    private boolean set(PointGroup pgLast, Atom[] atomset, BitSet bsAtoms, boolean haveVibration, float distanceTolerance, float linearTolerance) {
        this.distanceTolerance = distanceTolerance;
        this.linearTolerance = linearTolerance;
        this.cosTolerance = (float)Math.cos((double)(linearTolerance / 180.0f) * Math.PI);
        if (!this.getAtomsAndElements(atomset, bsAtoms)) {
            Logger.error("Too many atoms for point group calculation");
            this.name = "point group not determined -- atomCount > 100 -- select fewer atoms and try again.";
            return true;
        }
        this.getElementCounts();
        if (haveVibration) {
            Point3f[] atomVibs = new Point3f[this.atoms.length];
            int i = this.atoms.length;
            while (--i >= 0) {
                atomVibs[i] = new Point3f(this.atoms[i]);
                Vector3f v = ((Atom)this.atoms[i]).getVibrationVector();
                if (v == null) continue;
                atomVibs[i].add(v);
            }
            this.atoms = atomVibs;
        }
        if (this.isEqual(pgLast)) {
            return false;
        }
        this.findInversionCenter();
        if (this.isLinear(this.atoms)) {
            this.name = this.haveInversionCenter ? "D(infinity)h" : "C(infinity)v";
            this.vTemp.sub(this.atoms[1], this.atoms[0]);
            this.addAxis(16, this.vTemp);
            this.principalAxis = this.axes[16][0];
            if (this.haveInversionCenter) {
                this.axes[0] = new Operation[1];
                int n = this.nAxes[0];
                this.nAxes[0] = n + 1;
                Operation operation = new Operation(this.vTemp);
                this.axes[0][n] = operation;
                this.principalPlane = operation;
            }
            return true;
        }
        this.axes[0] = new Operation[15];
        int nPlanes = 0;
        this.findCAxes();
        nPlanes = this.findPlanes();
        this.findAdditionalAxes(nPlanes);
        int n = this.getHighestOrder();
        if (this.nAxes[17] > 1) {
            this.name = this.nAxes[19] > 1 ? (this.haveInversionCenter ? "Ih" : "I") : (this.nAxes[18] > 1 ? (this.haveInversionCenter ? "Oh" : "O") : (nPlanes > 0 ? (this.haveInversionCenter ? "Th" : "Td") : "T"));
        } else if (n < 2) {
            if (nPlanes == 1) {
                this.name = "Cs";
                return true;
            }
            if (this.haveInversionCenter) {
                this.name = "Ci";
                return true;
            }
            this.name = "C1";
        } else if (n % 2 == 1 && this.nAxes[16] > 0 || n % 2 == 0 && this.nAxes[16] > 1) {
            this.principalAxis = this.setPrincipalAxis(n, nPlanes);
            if (nPlanes == 0) {
                this.name = n < 14 ? "S" + n : "D" + (n - 14);
            } else {
                n = n < 14 ? (n /= 2) : (n -= 14);
                this.name = nPlanes == n ? "D" + n + "d" : "D" + n + "h";
            }
        } else if (nPlanes == 0) {
            this.principalAxis = this.axes[n][0];
            this.name = n < 14 ? "S" + n : "C" + (n - 14);
        } else if (nPlanes == n - 14) {
            this.principalAxis = this.axes[n][0];
            this.name = "C" + nPlanes + "v";
        } else {
            this.principalAxis = this.axes[n < 14 ? n + 14 : n][0];
            this.principalPlane = this.axes[0][0];
            n = n < 14 ? (n /= 2) : (n -= 14);
            this.name = "C" + n + "h";
        }
        return true;
    }

    private Operation setPrincipalAxis(int n, int nPlanes) {
        Operation principalPlane = this.setPrincipalPlane(n, nPlanes);
        if (nPlanes == 0 && n < 14 || this.nAxes[n] == 1) {
            if (nPlanes > 0 && n < 14) {
                n = 14 + n / 2;
            }
            return this.axes[n][0];
        }
        if (principalPlane == null) {
            return null;
        }
        for (int i = 0; i < this.nAxes[16]; ++i) {
            if (!this.isParallel(principalPlane.normalOrAxis, this.axes[16][i].normalOrAxis)) continue;
            if (i != 0) {
                Operation o = this.axes[16][0];
                this.axes[16][0] = this.axes[16][i];
                this.axes[16][i] = o;
            }
            return this.axes[16][0];
        }
        return null;
    }

    private Operation setPrincipalPlane(int n, int nPlanes) {
        if (nPlanes == 1) {
            this.principalPlane = this.axes[0][0];
            return this.principalPlane;
        }
        if (nPlanes == 0 || nPlanes == n - 14) {
            return null;
        }
        for (int i = 0; i < nPlanes; ++i) {
            int nPerp = 0;
            for (int j = 0; j < nPlanes; ++j) {
                if (!this.isPerpendicular(this.axes[0][i].normalOrAxis, this.axes[0][j].normalOrAxis) || ++nPerp <= 2) continue;
                if (i != 0) {
                    Operation o = this.axes[0][0];
                    this.axes[0][0] = this.axes[0][i];
                    this.axes[0][i] = o;
                }
                this.principalPlane = this.axes[0][0];
                return this.principalPlane;
            }
        }
        return null;
    }

    private boolean getAtomsAndElements(Atom[] atomset, BitSet bsAtoms) {
        int atomCount = BitSetUtil.cardinalityOf(bsAtoms);
        if (atomCount > 100) {
            return false;
        }
        this.atoms = new Point3f[atomCount];
        Point3f[] atoms = this.atoms;
        this.elements = new int[atomCount];
        if (atomCount == 0) {
            return true;
        }
        this.nAtoms = 0;
        int i = BitSetUtil.length(bsAtoms);
        while (--i >= 0) {
            if (!bsAtoms.get(i)) continue;
            atoms[this.nAtoms] = new Point3f(atomset[i]);
            int bondIndex = 1 + Math.max(3, atomset[i].getCovalentBondCount());
            this.elements[this.nAtoms] = atomset[i].getElementNumber() * bondIndex;
            this.center.add(atoms[this.nAtoms++]);
        }
        this.center.scale(1.0f / (float)this.nAtoms);
        i = this.nAtoms;
        while (--i >= 0) {
            float r = this.center.distance(atoms[i]);
            if (r < this.distanceTolerance) {
                this.centerAtomIndex = i;
            }
            this.radius = Math.max(this.radius, r);
        }
        return true;
    }

    private void findInversionCenter() {
        this.haveInversionCenter = this.checkOperation(null, this.center, -1);
        if (this.haveInversionCenter) {
            this.axes[1] = new Operation[1];
            this.axes[1][0] = new Operation();
        }
    }

    private boolean checkOperation(Quaternion q, Point3f center, int iOrder) {
        Point3f pt = new Point3f();
        int nFound = 0;
        boolean isInversion = iOrder < 14;
        int i = this.atoms.length;
        block0: while (--i >= 0 && nFound < this.atoms.length) {
            if (i == this.centerAtomIndex) {
                ++nFound;
                continue;
            }
            Point3f a1 = this.atoms[i];
            int e1 = this.elements[i];
            if (q != null) {
                pt.set(a1);
                pt.sub(center);
                q.transform(pt, pt);
                pt.add(center);
            } else {
                pt.set(a1);
            }
            if (isInversion) {
                this.vTemp.sub(center, pt);
                pt.scaleAdd(2.0f, this.vTemp, pt);
            }
            if ((q != null || isInversion) && pt.distance(a1) < this.distanceTolerance) {
                ++nFound;
                continue;
            }
            int j = this.atoms.length;
            while (--j >= 0) {
                Point3f a2;
                if (j == i || this.elements[j] != e1 || !(pt.distance(a2 = this.atoms[j]) < this.distanceTolerance)) continue;
                ++nFound;
                continue block0;
            }
        }
        return nFound == this.atoms.length;
    }

    private boolean isLinear(Point3f[] atoms) {
        Vector3f v1 = null;
        int i = atoms.length;
        while (--i >= 0) {
            if (i == this.centerAtomIndex) continue;
            if (v1 == null) {
                v1 = new Vector3f();
                v1.sub(atoms[i], this.center);
                v1.normalize();
                this.vTemp.set(v1);
                continue;
            }
            this.vTemp.sub(atoms[i], this.center);
            this.vTemp.normalize();
            if (this.isParallel(v1, this.vTemp)) continue;
            return false;
        }
        return true;
    }

    private boolean isParallel(Vector3f v1, Vector3f v2) {
        return Math.abs(v1.dot(v2)) >= this.cosTolerance;
    }

    private boolean isPerpendicular(Vector3f v1, Vector3f v2) {
        return Math.abs(v1.dot(v2)) <= 1.0f - this.cosTolerance;
    }

    private void getElementCounts() {
        int i = this.atoms.length;
        while (--i >= 0) {
            int e1 = this.elements[i];
            if (e1 <= this.maxElement) continue;
            this.maxElement = e1;
        }
        this.eCounts = new int[++this.maxElement];
        i = this.atoms.length;
        while (--i >= 0) {
            int n = this.elements[i];
            this.eCounts[n] = this.eCounts[n] + 1;
        }
    }

    private int findCAxes() {
        int i;
        int i2;
        int j;
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        Vector3f v3 = new Vector3f();
        Point3f pt = new Point3f();
        int i3 = this.atoms.length;
        while (--i3 >= 0) {
            if (i3 == this.centerAtomIndex) continue;
            Point3f a1 = this.atoms[i3];
            int e1 = this.elements[i3];
            j = this.atoms.length;
            while (--j > i3) {
                int iOrder;
                float order;
                boolean isIntegerOrder;
                Point3f a2 = this.atoms[j];
                if (this.elements[j] != e1) continue;
                pt.add(a1, a2);
                pt.scale(0.5f);
                v1.sub(a1, this.center);
                v2.sub(a2, this.center);
                v1.normalize();
                v2.normalize();
                if (this.isParallel(v1, v2)) {
                    this.getAllAxes(v1);
                    continue;
                }
                if (this.nAxes[16] < axesMaxN[16]) {
                    v3.set(pt);
                    this.getAllAxes(v3);
                }
                if (!(isIntegerOrder = (order = (float)(Math.PI * 2 / (double)v1.angle(v2))) - (float)(iOrder = (int)(order + 0.01f)) <= 0.02f) || (iOrder += 14) >= maxAxis || this.nAxes[iOrder] >= axesMaxN[iOrder]) continue;
                v3.cross(v1, v2);
                this.checkAxisOrder(iOrder, v3, this.center);
            }
        }
        Vector3f[] vs = new Vector3f[this.nAxes[16] * 2];
        for (int i4 = 0; i4 < vs.length; ++i4) {
            vs[i4] = new Vector3f();
        }
        int n = 0;
        for (i2 = 0; i2 < this.nAxes[16]; ++i2) {
            vs[n++].set(this.axes[16][i2].normalOrAxis);
            vs[n].set(this.axes[16][i2].normalOrAxis);
            vs[n++].scale(-1.0f);
        }
        i2 = vs.length;
        while (--i2 >= 2) {
            j = i2;
            while (--j >= 1) {
                int k = j;
                while (--k >= 0) {
                    v3.set(vs[i2]);
                    v3.add(vs[j]);
                    v3.add(vs[k]);
                    if ((double)v3.length() < 1.0) continue;
                    this.checkAxisOrder(17, v3, this.center);
                }
            }
        }
        int nMin = Integer.MAX_VALUE;
        int iMin = -1;
        for (i = 0; i < this.maxElement; ++i) {
            if (this.eCounts[i] >= nMin || this.eCounts[i] <= 2) continue;
            nMin = this.eCounts[i];
            iMin = i;
        }
        block8: for (i = 0; i < this.atoms.length - 2; ++i) {
            if (this.elements[i] != iMin) continue;
            for (int j2 = i + 1; j2 < this.atoms.length - 1; ++j2) {
                if (this.elements[j2] != iMin) continue;
                for (int k = j2 + 1; k < this.atoms.length; ++k) {
                    if (this.elements[k] != iMin) continue;
                    v1.sub(this.atoms[i], this.atoms[j2]);
                    v2.sub(this.atoms[i], this.atoms[k]);
                    v1.normalize();
                    v2.normalize();
                    v3.cross(v1, v2);
                    this.getAllAxes(v3);
                    pt.set(this.atoms[i]);
                    pt.add(this.atoms[j2]);
                    pt.add(this.atoms[k]);
                    v1.set(pt);
                    v1.normalize();
                    if (!this.isParallel(v1, v3)) {
                        this.getAllAxes(v1);
                    }
                    if (this.nAxes[19] == axesMaxN[19]) break block8;
                }
            }
        }
        vs = new Vector3f[this.maxElement];
        i = this.atoms.length;
        while (--i >= 0) {
            int e1 = this.elements[i];
            if (vs[e1] == null) {
                vs[e1] = new Vector3f();
            } else if (this.haveInversionCenter) continue;
            vs[e1].add(this.atoms[i]);
        }
        if (!this.haveInversionCenter) {
            for (i = 0; i < this.maxElement; ++i) {
                if (vs[i] == null) continue;
                vs[i].scale(1.0f / (float)this.eCounts[i]);
            }
        }
        for (i = 0; i < this.maxElement; ++i) {
            if (vs[i] == null) continue;
            for (int j3 = 0; j3 < this.maxElement; ++j3) {
                if (i == j3 || vs[j3] == null) continue;
                if (this.haveInversionCenter) {
                    v1.cross(vs[i], vs[j3]);
                } else {
                    v1.set(vs[i]);
                    v1.sub(vs[j3]);
                }
                this.checkAxisOrder(16, v1, this.center);
            }
        }
        return this.getHighestOrder();
    }

    private void getAllAxes(Vector3f v3) {
        for (int o = 16; o < maxAxis; ++o) {
            if (this.nAxes[o] >= axesMaxN[o]) continue;
            this.checkAxisOrder(o, v3, this.center);
        }
    }

    private int getHighestOrder() {
        int n = 0;
        n = 14;
        while (--n > 1 && this.nAxes[n] == 0) {
        }
        if (n > 1) {
            return n + 14 < maxAxis && this.nAxes[n + 14] > 0 ? n + 14 : n;
        }
        n = maxAxis;
        while (--n > 1 && this.nAxes[n] == 0) {
        }
        return n;
    }

    private boolean checkAxisOrder(int iOrder, Vector3f v, Point3f center) {
        switch (iOrder) {
            case 22: {
                if (this.nAxes[17] > 0) {
                    return false;
                }
            }
            case 18: 
            case 20: {
                if (this.nAxes[19] <= 0) break;
                return false;
            }
            case 17: {
                if (this.nAxes[22] <= 0) break;
                return false;
            }
            case 19: {
                if (this.nAxes[18] <= 0 && this.nAxes[20] <= 0 && this.nAxes[22] <= 0) break;
                return false;
            }
        }
        v.normalize();
        if (this.haveAxis(iOrder, v)) {
            return false;
        }
        Quaternion q = new Quaternion(v, (iOrder < 14 ? 180 : 0) + 360 / (iOrder % 14));
        if (!this.checkOperation(q, center, iOrder)) {
            return false;
        }
        this.addAxis(iOrder, v);
        switch (iOrder) {
            case 16: {
                this.checkAxisOrder(4, v, center);
                break;
            }
            case 17: {
                this.checkAxisOrder(3, v, center);
                if (!this.haveInversionCenter) break;
                this.addAxis(6, v);
                break;
            }
            case 18: {
                this.addAxis(16, v);
                this.checkAxisOrder(4, v, center);
                this.checkAxisOrder(8, v, center);
                break;
            }
            case 19: {
                this.checkAxisOrder(5, v, center);
                if (!this.haveInversionCenter) break;
                this.addAxis(10, v);
                break;
            }
            case 20: {
                this.addAxis(16, v);
                this.addAxis(17, v);
                this.checkAxisOrder(3, v, center);
                this.checkAxisOrder(6, v, center);
                this.checkAxisOrder(12, v, center);
                break;
            }
            case 22: {
                this.addAxis(16, v);
                this.addAxis(18, v);
            }
        }
        return true;
    }

    private void addAxis(int iOrder, Vector3f v) {
        if (this.haveAxis(iOrder, v)) {
            return;
        }
        if (this.axes[iOrder] == null) {
            this.axes[iOrder] = new Operation[axesMaxN[iOrder]];
        }
        int n = iOrder;
        int n2 = this.nAxes[n];
        this.nAxes[n] = n2 + 1;
        this.axes[iOrder][n2] = new Operation(v, iOrder);
    }

    private boolean haveAxis(int iOrder, Vector3f v) {
        if (this.nAxes[iOrder] == axesMaxN[iOrder]) {
            return true;
        }
        if (this.nAxes[iOrder] > 0) {
            int i = this.nAxes[iOrder];
            while (--i >= 0) {
                if (!this.isParallel(v, this.axes[iOrder][i].normalOrAxis)) continue;
                return true;
            }
        }
        return false;
    }

    private int findPlanes() {
        Point3f pt = new Point3f();
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        Vector3f v3 = new Vector3f();
        int nPlanes = 0;
        boolean haveAxes = this.getHighestOrder() > 1;
        int i = this.atoms.length;
        while (--i >= 0) {
            if (i == this.centerAtomIndex) continue;
            Point3f a1 = this.atoms[i];
            int e1 = this.elements[i];
            int j = this.atoms.length;
            while (--j > i) {
                if (haveAxes && this.elements[j] != e1) continue;
                Point3f a2 = this.atoms[j];
                pt.add(a1, a2);
                pt.scale(0.5f);
                v1.sub(a1, this.center);
                v2.sub(a2, this.center);
                if (!this.isParallel(v1, v2)) {
                    v3.cross(v1, v2);
                    v3.normalize();
                    nPlanes = this.getPlane(nPlanes, v3, this.center);
                }
                v3.set(a2);
                v3.sub(a1);
                v3.normalize();
                if ((nPlanes = this.getPlane(nPlanes, v3, this.center)) != axesMaxN[0]) continue;
                return nPlanes;
            }
        }
        if (haveAxes) {
            for (i = 16; i < maxAxis; ++i) {
                for (int j = 0; j < this.nAxes[i]; ++j) {
                    nPlanes = this.getPlane(nPlanes, this.axes[i][j].normalOrAxis, this.center);
                }
            }
        }
        return nPlanes;
    }

    private int getPlane(int nPlanes, Vector3f v3, Point3f center2) {
        if (!this.haveAxis(0, v3) && this.checkOperation(new Quaternion(v3, 180.0f), this.center, -1)) {
            int n = this.nAxes[0];
            this.nAxes[0] = n + 1;
            this.axes[0][n] = new Operation(v3);
        }
        return this.nAxes[0];
    }

    private void findAdditionalAxes(int nPlanes) {
        Operation[] planes = this.axes[0];
        int Cn = 0;
        if (nPlanes > 1 && (Cn = nPlanes + 14) < maxAxis && this.nAxes[Cn] == 0) {
            this.vTemp.cross(planes[0].normalOrAxis, planes[1].normalOrAxis);
            if (!this.checkAxisOrder(Cn, this.vTemp, this.center) && nPlanes > 2) {
                this.vTemp.cross(planes[1].normalOrAxis, planes[2].normalOrAxis);
                this.checkAxisOrder(Cn - 1, this.vTemp, this.center);
            }
        }
        if (this.nAxes[16] == 0 && nPlanes > 2) {
            for (int i = 0; i < nPlanes - 1; ++i) {
                for (int j = i + 1; j < nPlanes; ++j) {
                    this.vTemp.add(planes[1].normalOrAxis, planes[2].normalOrAxis);
                    if (!this.checkAxisOrder(16, this.vTemp, this.center)) continue;
                    System.out.println("found a C2 axis by adding plane normals");
                }
            }
        }
    }

    Object getInfo(int modelIndex, boolean asDraw, boolean asInfo, String type, int index, float scaleFactor) {
        if (asInfo) {
            this.info = new Hashtable();
        }
        Vector3f v = new Vector3f();
        if (scaleFactor == 0.0f) {
            scaleFactor = 1.0f;
        }
        int[][] nType = new int[4][2];
        for (int i = 1; i < maxAxis; ++i) {
            int j = this.nAxes[i];
            while (--j >= 0) {
                int[] nArray = nType[this.axes[i][j].type];
                nArray[0] = nArray[0] + 1;
            }
        }
        StringBuffer sb = new StringBuffer("# " + this.nAtoms + " atoms\n");
        if (asDraw) {
            Operation op;
            int i;
            boolean haveType = type != null && type.length() > 0;
            type = haveType ? type : "";
            this.drawType = type;
            this.drawIndex = index;
            boolean anyProperAxis = type.equalsIgnoreCase("Cn");
            boolean anyImproperAxis = type.equalsIgnoreCase("Sn");
            sb.append("set perspectivedepth off;\n");
            String m = "_" + modelIndex + "_";
            if (!haveType) {
                sb.append("draw delete pg0" + m + "*;draw delete pgva" + m + "*;draw delete pgvp" + m + "*;");
            }
            if (!haveType || type.equalsIgnoreCase("Ci")) {
                sb.append("draw pg0").append(m).append(this.haveInversionCenter ? "inv " : " ").append(Escape.escape(this.center) + (this.haveInversionCenter ? "\"i\";\n" : ";\n"));
            }
            float offset = 0.1f;
            for (i = 2; i < maxAxis; ++i) {
                if (i == 14) {
                    offset = 0.1f;
                }
                if (this.nAxes[i] == 0) continue;
                String label = this.axes[i][0].getLabel();
                float scale = scaleFactor * this.radius + (offset += 0.25f);
                if (haveType && !type.equalsIgnoreCase(label) && (!anyProperAxis || i < 14) && (!anyImproperAxis || i >= 14)) continue;
                for (int j = 0; j < this.nAxes[i]; ++j) {
                    if (index > 0 && j + 1 != index) continue;
                    op = this.axes[i][j];
                    v.set(op.normalOrAxis);
                    v.add(this.center);
                    if (op.type == 2) {
                        scale = -scale;
                    }
                    sb.append("draw pgva").append(m).append(label).append("_").append(j + 1).append(" width 0.05 scale " + scale + " ").append(Escape.escape(v));
                    v.scaleAdd(-2.0f, op.normalOrAxis, v);
                    boolean isPA = this.principalAxis != null && op.index == this.principalAxis.index;
                    sb.append(Escape.escape(v)).append("\"" + label + (isPA ? "*" : "") + "\" color ").append(isPA ? "red" : (op.type == 2 ? "blue" : "yellow")).append(";\n");
                }
            }
            if (!haveType || type.equalsIgnoreCase("Cs")) {
                for (int j = 0; j < this.nAxes[0]; ++j) {
                    if (index > 0 && j + 1 != index) continue;
                    op = this.axes[0][j];
                    v.set(op.normalOrAxis);
                    v.scale(0.025f);
                    v.add(this.center);
                    sb.append("draw pgvp").append(m).append(j + 1).append("disk width " + scaleFactor * this.radius * 2.0f + " cylinder ").append(Escape.escape(v));
                    v.scaleAdd(-0.05f, op.normalOrAxis, v);
                    sb.append(Escape.escape(v)).append(" color translucent yellow;\n");
                    v.set(op.normalOrAxis);
                    v.add(this.center);
                    sb.append("draw pgvp").append(m).append(j + 1).append("ring width 0.05 scale " + scaleFactor * this.radius + " arc ").append(Escape.escape(v));
                    v.scaleAdd(-2.0f, op.normalOrAxis, v);
                    sb.append(Escape.escape(v));
                    v.x = (float)((double)v.x + 0.011);
                    v.y = (float)((double)v.y + 0.012);
                    v.z = (float)((double)v.z + 0.013);
                    sb.append(Escape.escape(v)).append("{0 360 0.5} color ").append(this.principalPlane != null && op.index == this.principalPlane.index ? "red" : "blue").append(";\n");
                }
            }
            sb.append("# name=" + this.name);
            sb.append(", nCi=" + (this.haveInversionCenter ? 1 : 0));
            sb.append(", nCs=" + this.nAxes[0]);
            sb.append(", nCn=" + nType[1][0]);
            sb.append(", nSn=" + nType[2][0]);
            sb.append(": ");
            i = maxAxis;
            while (--i >= 2) {
                if (this.nAxes[i] <= 0) continue;
                String s = " n" + (i < 14 ? "S" : "C") + i % 14;
                sb.append(s + "=" + this.nAxes[i]);
            }
            sb.append(";\n");
            this.drawInfo = sb.toString();
            return this.drawInfo;
        }
        int n = 0;
        int nTotal = 1;
        int i = maxAxis;
        while (--i >= 0) {
            if (this.nAxes[i] <= 0) continue;
            n = nUnique[i];
            String label = this.axes[i][0].getLabel();
            if (this.info != null) {
                this.info.put("n" + label, new Integer(this.nAxes[i]));
            }
            sb.append("\n\n" + this.name + "\tn" + label + "\t" + this.nAxes[i] + "\t" + n);
            nTotal += (n *= this.nAxes[i]);
            int[] nArray = nType[this.axes[i][0].type];
            nArray[1] = nArray[1] + n;
            Vector<Vector3f> vinfo = this.info == null ? null : new Vector<Vector3f>();
            for (int j = 0; j < this.nAxes[i]; ++j) {
                this.axes[i][j].typeIndex = j + 1;
                if (vinfo != null) {
                    vinfo.add(this.axes[i][j].normalOrAxis);
                }
                sb.append("\n" + this.name + "\t" + label + "_" + (j + 1) + "\t" + this.axes[i][j].normalOrAxis);
            }
            if (this.info == null) continue;
            this.info.put(label, vinfo);
        }
        if (this.haveInversionCenter) {
            ++nTotal;
            if (this.info == null) {
                sb.append("\n\n" + this.name + "\tCi\t" + Escape.escape(this.center));
            } else {
                this.info.put("Ci", this.center);
            }
        }
        if (this.info == null) {
            sb.append("\n");
            sb.append("\n" + this.name + "\ttype\tnType\tnUnique");
            sb.append("\n" + this.name + "\tE\t  1\t  1");
            n = this.haveInversionCenter ? 1 : 0;
            sb.append("\n" + this.name + "\tCi\t  " + n + "\t  " + n);
            sb.append("\n" + this.name + "\tCs\t");
            TextFormat.rFill(sb, "    ", this.nAxes[0] + "\t");
            TextFormat.rFill(sb, "    ", this.nAxes[0] + "\n");
            sb.append(this.name + "\tCn\t");
            TextFormat.rFill(sb, "    ", nType[1][0] + "\t");
            TextFormat.rFill(sb, "    ", nType[1][1] + "\n");
            sb.append(this.name + "\tSn\t");
            TextFormat.rFill(sb, "    ", nType[2][0] + "\t");
            TextFormat.rFill(sb, "    ", nType[2][1] + "\n");
            sb.append(this.name + "\t\tTOTAL\t");
            TextFormat.rFill(sb, "    ", nTotal + "\n");
            this.textInfo = sb.toString();
            return this.textInfo;
        }
        this.info.put("name", this.name);
        this.info.put("nAtoms", new Integer(this.nAtoms));
        this.info.put("nTotal", new Integer(nTotal));
        this.info.put("nCi", new Integer(this.haveInversionCenter ? 1 : 0));
        this.info.put("nCs", new Integer(this.nAxes[0]));
        this.info.put("nCn", new Integer(nType[1][0]));
        this.info.put("nSn", new Integer(nType[2][0]));
        this.info.put("distanceTolerance", new Float(this.distanceTolerance));
        this.info.put("linearTolerance", new Float(this.linearTolerance));
        this.info.put("detail", sb.toString().replace('\n', ';'));
        if (this.principalAxis != null && this.principalAxis.index > 0) {
            this.info.put("principalAxis", this.principalAxis.normalOrAxis);
        }
        if (this.principalPlane != null && this.principalPlane.index > 0) {
            this.info.put("principalPlane", this.principalPlane.normalOrAxis);
        }
        return this.info;
    }

    boolean isDrawType(String type, int index) {
        return this.drawInfo != null && this.drawType.equals(type == null ? "" : type) && this.drawIndex == index;
    }

    private class Operation {
        int type;
        int order;
        int index;
        int typeIndex;
        Vector3f normalOrAxis;

        Operation() {
            this.index = ++PointGroup.this.nOps;
            this.type = 3;
            this.order = 1;
            if (Logger.debugging) {
                Logger.info("new operation -- " + typeNames[this.type]);
            }
        }

        Operation(Vector3f v, int i) {
            this.index = ++PointGroup.this.nOps;
            this.type = i < 14 ? 2 : 1;
            this.order = i % 14;
            this.normalOrAxis = new Quaternion(v, 180.0f).getNormal();
            if (Logger.debugging) {
                Logger.info("new operation -- " + (this.order == i ? "S" : "C") + this.order + " " + this.normalOrAxis);
            }
        }

        Operation(Vector3f v) {
            if (v == null) {
                return;
            }
            this.index = ++PointGroup.this.nOps;
            this.type = 0;
            this.normalOrAxis = new Quaternion(v, 180.0f).getNormal();
            if (Logger.debugging) {
                Logger.info("new operation -- plane " + this.normalOrAxis);
            }
        }

        String getLabel() {
            switch (this.type) {
                case 0: {
                    return "Cs";
                }
                case 2: {
                    return "S" + this.order;
                }
            }
            return "C" + this.order;
        }
    }
}

