/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import javax.vecmath.Point3f;

class SymmetryInfo {
    boolean coordinatesAreFractional;
    boolean isMultiCell;
    String spaceGroup;
    String[] symmetryOperations;
    String symmetryInfoString;
    int modelIndex;
    int[] cellRange;
    private Point3f periodicOriginXyz;

    boolean isPeriodic() {
        return this.periodicOriginXyz != null;
    }

    SymmetryInfo() {
    }

    float[] setSymmetryInfo(int modelIndex, Hashtable info) {
        this.modelIndex = modelIndex;
        this.cellRange = (int[])info.get("unitCellRange");
        this.periodicOriginXyz = (Point3f)info.get("periodicOriginXyz");
        this.spaceGroup = (String)info.get("spaceGroup");
        if (this.spaceGroup == null || this.spaceGroup == "") {
            this.spaceGroup = "spacegroup unspecified";
        }
        int symmetryCount = info.containsKey("symmetryCount") ? (Integer)info.get("symmetryCount") : 0;
        this.symmetryOperations = (String[])info.get("symmetryOperations");
        this.symmetryInfoString = "Spacegroup: " + this.spaceGroup;
        if (this.symmetryOperations == null) {
            this.symmetryInfoString = this.symmetryInfoString + "\nNumber of symmetry operations: ?\nSymmetry Operations: unspecified\n";
        } else {
            this.symmetryInfoString = this.symmetryInfoString + "\nNumber of symmetry operations: " + (symmetryCount == 0 ? 1 : symmetryCount) + "\nSymmetry Operations:";
            for (int i = 0; i < symmetryCount; ++i) {
                this.symmetryInfoString = this.symmetryInfoString + "\n" + this.symmetryOperations[i];
            }
        }
        this.symmetryInfoString = this.symmetryInfoString + "\n";
        this.coordinatesAreFractional = info.containsKey("coordinatesAreFractional") ? (Boolean)info.get("coordinatesAreFractional") : false;
        this.isMultiCell = this.coordinatesAreFractional && this.symmetryOperations != null;
        float[] notionalUnitcell = (float[])info.get("notionalUnitcell");
        return notionalUnitcell == null || notionalUnitcell[0] == 0.0f ? null : notionalUnitcell;
    }
}

