/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.jmol.util.Parser;

public final class ArrayUtil {
    public static Object ensureLength(Object array, int minimumLength) {
        if (array != null && Array.getLength(array) >= minimumLength) {
            return array;
        }
        return ArrayUtil.setLength(array, minimumLength);
    }

    public static String[] ensureLength(String[] array, int minimumLength) {
        if (array != null && array.length >= minimumLength) {
            return array;
        }
        return ArrayUtil.setLength(array, minimumLength);
    }

    public static float[] ensureLength(float[] array, int minimumLength) {
        if (array != null && array.length >= minimumLength) {
            return array;
        }
        return ArrayUtil.setLength(array, minimumLength);
    }

    public static int[] ensureLength(int[] array, int minimumLength) {
        if (array != null && array.length >= minimumLength) {
            return array;
        }
        return ArrayUtil.setLength(array, minimumLength);
    }

    public static short[] ensureLength(short[] array, int minimumLength) {
        if (array != null && array.length >= minimumLength) {
            return array;
        }
        return ArrayUtil.setLength(array, minimumLength);
    }

    public static byte[] ensureLength(byte[] array, int minimumLength) {
        if (array != null && array.length >= minimumLength) {
            return array;
        }
        return ArrayUtil.setLength(array, minimumLength);
    }

    public static Object doubleLength(Object array) {
        return ArrayUtil.setLength(array, array == null ? 16 : 2 * Array.getLength(array));
    }

    public static String[] doubleLength(String[] array) {
        return ArrayUtil.setLength(array, array == null ? 16 : 2 * array.length);
    }

    public static float[] doubleLength(float[] array) {
        return ArrayUtil.setLength(array, array == null ? 16 : 2 * array.length);
    }

    public static int[] doubleLength(int[] array) {
        return ArrayUtil.setLength(array, array == null ? 16 : 2 * array.length);
    }

    public static short[] doubleLength(short[] array) {
        return ArrayUtil.setLength(array, array == null ? 16 : 2 * array.length);
    }

    public static byte[] doubleLength(byte[] array) {
        return ArrayUtil.setLength(array, array == null ? 16 : 2 * array.length);
    }

    public static boolean[] doubleLength(boolean[] array) {
        return ArrayUtil.setLength(array, array == null ? 16 : 2 * array.length);
    }

    public static Object setLength(Object array, int newLength) {
        if (array == null) {
            return null;
        }
        Object t = Array.newInstance(array.getClass().getComponentType(), newLength);
        int oldLength = Array.getLength(array);
        System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        return t;
    }

    public static Object deleteElements(Object array, int firstElement, int nElements) {
        int n;
        if (nElements == 0 || array == null) {
            return array;
        }
        int oldLength = Array.getLength(array);
        if (oldLength - nElements <= 0) {
            return array;
        }
        Object t = Array.newInstance(array.getClass().getComponentType(), oldLength - nElements);
        if (firstElement > 0) {
            System.arraycopy(array, 0, t, 0, firstElement);
        }
        if ((n = oldLength - firstElement - nElements) > 0) {
            System.arraycopy(array, firstElement + nElements, t, firstElement, n);
        }
        return t;
    }

    public static String[] setLength(String[] array, int newLength) {
        String[] t = new String[newLength];
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }

    public static float[] setLength(float[] array, int newLength) {
        float[] t = new float[newLength];
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }

    public static int[] setLength(int[] array, int newLength) {
        int[] t = new int[newLength];
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }

    public static int[] arrayCopy(int[] array, int i0, int n, boolean isReverse) {
        if (array == null) {
            return null;
        }
        int oldLength = array.length;
        if (n == -1) {
            n = oldLength;
        }
        if (n == -2) {
            n = oldLength / 2;
        }
        int[] t = new int[n -= i0];
        System.arraycopy(array, i0, t, 0, n);
        if (isReverse) {
            int i = n / 2;
            while (--i >= 0) {
                ArrayUtil.swap(t, i, n - 1 - i);
            }
        }
        return t;
    }

    public static short[] setLength(short[] array, int newLength) {
        short[] t = new short[newLength];
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }

    public static byte[] setLength(byte[] array, int newLength) {
        byte[] t = new byte[newLength];
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }

    public static boolean[] setLength(boolean[] array, int newLength) {
        boolean[] t = new boolean[newLength];
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }

    public static void swap(short[] array, int indexA, int indexB) {
        short t = array[indexA];
        array[indexA] = array[indexB];
        array[indexB] = t;
    }

    public static void swap(int[] array, int indexA, int indexB) {
        int t = array[indexA];
        array[indexA] = array[indexB];
        array[indexB] = t;
    }

    public static void swap(float[] array, int indexA, int indexB) {
        float t = array[indexA];
        array[indexA] = array[indexB];
        array[indexB] = t;
    }

    public static String dumpArray(String msg, float[][] A, int x1, int x2, int y1, int y2) {
        String s = "dumpArray: " + msg + "\n";
        for (int x = x1; x <= x2; ++x) {
            s = s + "\t*" + x + "*";
        }
        for (int y = y2; y >= y1; --y) {
            s = s + "\n*" + y + "*";
            for (int x = x1; x <= x2; ++x) {
                s = s + "\t" + (x < A.length && y < A[x].length ? A[x][y] : Float.NaN);
            }
        }
        return s;
    }

    public static String dumpIntArray(int[] A, int n) {
        String str = "";
        for (int i = 0; i < n; ++i) {
            str = str + " " + A[i];
        }
        return str;
    }

    public static Object getMinMax(Object floatOrStringArray, int tok) {
        double sum;
        float[] data;
        if (floatOrStringArray instanceof String[]) {
            data = new float[((String[])floatOrStringArray).length];
            Parser.parseFloatArray((String[])floatOrStringArray, data);
        } else {
            data = (float[])floatOrStringArray;
        }
        switch (tok) {
            case 32: {
                sum = 3.4028234663852886E38;
                break;
            }
            case 64: {
                sum = -3.4028234663852886E38;
                break;
            }
            default: {
                sum = 0.0;
            }
        }
        double sum2 = 0.0;
        int n = 0;
        int i = data.length;
        while (--i >= 0) {
            float v = data[i];
            if (Float.isNaN(v)) continue;
            ++n;
            switch (tok) {
                case 128: {
                    sum2 += (double)v * (double)v;
                }
                case 96: {
                    sum += (double)v;
                    break;
                }
                case 32: {
                    if (!((double)v < sum)) break;
                    sum = v;
                    break;
                }
                case 64: {
                    if (!((double)v > sum)) break;
                    sum = v;
                }
            }
        }
        if (n == 0) {
            return "NaN";
        }
        switch (tok) {
            case 96: {
                sum /= (double)n;
                break;
            }
            case 128: {
                if (n == 1) {
                    return "NaN";
                }
                sum = Math.sqrt((sum2 - sum * sum / (double)n) / (double)(n - 1));
            }
        }
        return new Float(sum);
    }

    public static Object sortOrReverse(Object list, int tok, boolean checkFloat) {
        float[] f = null;
        if (list instanceof String[]) {
            String[] s = (String[])list;
            if (s.length < 2) {
                return list;
            }
            if (checkFloat && !Float.isNaN(Parser.parseFloat(s[0]))) {
                f = new float[s.length];
                Parser.parseFloatArray(s, f);
            } else {
                Object[] s2 = new String[s.length];
                System.arraycopy(s, 0, s2, 0, s.length);
                switch (tok) {
                    case 68157447: {
                        Arrays.sort(s2);
                        return s2;
                    }
                    case 68157445: {
                        int left = 0;
                        for (int right = s2.length - 1; left < right; ++left, --right) {
                            Object temp = s2[left];
                            s2[left] = s2[right];
                            s2[right] = temp;
                        }
                        return s2;
                    }
                }
            }
        } else if (list instanceof float[]) {
            f = new float[((float[])list).length];
            System.arraycopy(list, 0, f, 0, f.length);
            if (f.length < 2) {
                return list;
            }
        } else {
            return list;
        }
        switch (tok) {
            case 68157447: {
                Arrays.sort(f);
                break;
            }
            case 68157445: {
                int left = 0;
                for (int right = f.length - 1; left < right; ++left, --right) {
                    float ftemp = f[left];
                    f[left] = f[right];
                    f[right] = ftemp;
                }
                break;
            }
        }
        return f;
    }
}

