/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.jmol.util.Logger;

public class BinaryDocument {
    protected DataInputStream stream;
    protected boolean isRandom = false;
    protected boolean isBigEndian = true;

    public void close() {
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setStream(BufferedInputStream bis, boolean isBigEndian) {
        if (bis == null) {
            return;
        }
        this.stream = new DataInputStream(bis);
        this.isBigEndian = isBigEndian;
    }

    public void setStream(DataInputStream stream) {
        this.stream = stream;
    }

    public void setRandom(boolean TF) {
        this.isRandom = TF;
    }

    public byte readByte() throws Exception {
        return this.stream.readByte();
    }

    public void readByteArray(byte[] b) throws Exception {
        this.stream.read(b);
    }

    public void readByteArray(byte[] b, int off, int len) throws Exception {
        this.stream.read(b, off, len);
    }

    public short readShort() throws Exception {
        return this.isBigEndian ? this.stream.readShort() : (short)(this.stream.readByte() & 0xFF | (this.stream.readByte() & 0xFF) << 8);
    }

    public int readInt() throws Exception {
        return this.isBigEndian ? this.stream.readInt() : this.readLEInt();
    }

    public int readUnsignedShort() throws Exception {
        int a = this.stream.readByte() & 0xFF;
        int b = this.stream.readByte() & 0xFF;
        return this.isBigEndian ? (a << 8) + b : (b << 8) + a;
    }

    public long readLong() throws Exception {
        return this.isBigEndian ? this.stream.readLong() : (long)this.stream.readByte() & 0xFFL | ((long)this.stream.readByte() & 0xFFL) << 8 | ((long)this.stream.readByte() & 0xFFL) << 16 | ((long)this.stream.readByte() & 0xFFL) << 24 | ((long)this.stream.readByte() & 0xFFL) << 32 | ((long)this.stream.readByte() & 0xFFL) << 40 | ((long)this.stream.readByte() & 0xFFL) << 48 | ((long)this.stream.readByte() & 0xFFL) << 54;
    }

    public float readFloat() throws Exception {
        return this.isBigEndian ? this.stream.readFloat() : Float.intBitsToFloat(this.readLEInt());
    }

    public double readDouble() throws Exception {
        return this.isBigEndian ? this.stream.readDouble() : Double.longBitsToDouble(this.readLELong());
    }

    private int readLEInt() throws Exception {
        return this.stream.readByte() & 0xFF | (this.stream.readByte() & 0xFF) << 8 | (this.stream.readByte() & 0xFF) << 16 | (this.stream.readByte() & 0xFF) << 24;
    }

    private long readLELong() throws Exception {
        return (long)this.stream.readByte() & 0xFFL | ((long)this.stream.readByte() & 0xFFL) << 8 | ((long)this.stream.readByte() & 0xFFL) << 16 | ((long)this.stream.readByte() & 0xFFL) << 24 | ((long)this.stream.readByte() & 0xFFL) << 32 | ((long)this.stream.readByte() & 0xFFL) << 40 | ((long)this.stream.readByte() & 0xFFL) << 48 | ((long)this.stream.readByte() & 0xFFL) << 56;
    }

    public void seek(long offset) {
        try {
            this.stream.reset();
            this.stream.skipBytes((int)offset);
        }
        catch (Exception e) {
            Logger.error(null, e);
        }
    }
}

