/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.PrintStream;
import org.jmol.util.Logger;
import org.jmol.util.LoggerInterface;

public class DefaultLogger
implements LoggerInterface {
    protected void log(PrintStream out, int level, String txt, Throwable e) {
        if (out != null && (txt != null || e != null)) {
            StackTraceElement[] elements;
            txt = txt != null ? txt : "";
            out.println((Logger.logLevel() ? "[" + Logger.getLevel(level) + "] " : "") + txt + (e != null ? ": " + e.getMessage() : ""));
            if (e != null && (elements = e.getStackTrace()) != null) {
                for (int i = 0; i < elements.length; ++i) {
                    out.println(elements[i].getClassName() + " - " + elements[i].getLineNumber() + " - " + elements[i].getMethodName());
                }
            }
        }
    }

    public void debug(String txt) {
        this.log(System.out, 5, txt, null);
    }

    public void info(String txt) {
        this.log(System.out, 4, txt, null);
    }

    public void warn(String txt) {
        this.log(System.out, 3, txt, null);
    }

    public void warn(String txt, Throwable e) {
        this.log(System.out, 3, txt, e);
    }

    public void error(String txt) {
        this.log(System.err, 2, txt, null);
    }

    public void error(String txt, Throwable e) {
        this.log(System.err, 2, txt, e);
    }

    public void fatal(String txt) {
        this.log(System.err, 1, txt, null);
    }

    public void fatal(String txt, Throwable e) {
        this.log(System.err, 1, txt, e);
    }
}

