/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Bond;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;

public class Escape {
    private static final String escapable = "\\\\\tt\rr\nn\"\"";
    static String ESCAPE_SET = " ,./;:_+-~=><?'!@#$%^&*";
    static int nEscape = ESCAPE_SET.length();

    public static String escape(Object x) {
        if (x instanceof String) {
            return Escape.escape("" + x);
        }
        if (x instanceof String[]) {
            return Escape.escape((String[])x);
        }
        return x.toString();
    }

    public static String escapeColor(int argb) {
        return "[x" + Graphics3D.getHexColorFromRGB(argb) + "]";
    }

    public static String escape(Point4f xyzw) {
        return "{" + xyzw.x + " " + xyzw.y + " " + xyzw.z + " " + xyzw.w + "}";
    }

    public static String escape(Tuple3f xyz) {
        return "{" + xyz.x + " " + xyz.y + " " + xyz.z + "}";
    }

    public static String escape(float[] f, boolean asArray) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < f.length; ++i) {
            if (i > 0) {
                sb.append('\n');
            }
            sb.append(f[i]);
        }
        return sb.toString();
    }

    public static String escape(float[][] f, boolean addSemi) {
        StringBuffer sb = new StringBuffer();
        String eol = addSemi ? ";\n" : "\n";
        for (int i = 0; i < f.length; ++i) {
            if (f[i] == null) continue;
            if (i > 0) {
                sb.append(eol);
            }
            for (int j = 0; j < f[i].length; ++j) {
                sb.append(f[i][j]).append('\t');
            }
        }
        return sb.toString();
    }

    public static String escape(int[] f) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < f.length; ++i) {
            if (i > 0) {
                sb.append('\n');
            }
            sb.append("" + f[i]);
        }
        return sb.toString();
    }

    public static String escape(String str) {
        int i;
        if (str == null) {
            return "\"\"";
        }
        boolean haveEscape = false;
        for (i = 0; i < escapable.length(); i += 2) {
            if (str.indexOf(escapable.charAt(i)) < 0) continue;
            haveEscape = true;
            break;
        }
        if (haveEscape) {
            while (i < escapable.length()) {
                int pt = -1;
                char ch = escapable.charAt(i++);
                char ch2 = escapable.charAt(i++);
                StringBuffer sb = new StringBuffer();
                int pt0 = 0;
                while ((pt = str.indexOf(ch, pt + 1)) >= 0) {
                    sb.append(str.substring(pt0, pt)).append('\\').append(ch2);
                    pt0 = pt + 1;
                }
                sb.append(str.substring(pt0, str.length()));
                str = sb.toString();
            }
        }
        i = str.length();
        while (--i >= 0) {
            if (str.charAt(i) <= '\u007f') continue;
            str = str.substring(0, i) + Escape.unicode(str.charAt(i)) + str.substring(i + 1);
        }
        return Escape.chop("\"" + str + "\"");
    }

    private static String chop(String s) {
        int len = s.length();
        if (len < 512) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        String sep = "\"\\\n    + \"";
        int pt = 0;
        for (int i = 72; i < len; i += 72) {
            while (s.charAt(i - 1) == '\\') {
                ++i;
            }
            sb.append(pt == 0 ? "" : sep).append(s.substring(pt, i));
            pt = i;
        }
        sb.append(sep).append(s.substring(pt, len));
        return sb.toString();
    }

    public static String escape(String[] list) {
        if (list == null) {
            return Escape.escape("");
        }
        StringBuffer s = new StringBuffer();
        s.append("[");
        for (int i = 0; i < list.length; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(Escape.escapeNice(list[i]));
        }
        s.append("]");
        return s.toString();
    }

    private static String escapeNice(String s) {
        float f = Parser.parseFloatStrict(s);
        return Float.isNaN(f) ? Escape.escape(s) : s;
    }

    private static String unicode(char c) {
        String s = "0000" + Integer.toHexString(c);
        return "\\u" + s.substring(s.length() - 4);
    }

    public static Object unescapePoint(String strPoint) {
        int nPoints;
        if (strPoint == null || strPoint.length() == 0) {
            return strPoint;
        }
        String str = TextFormat.simpleReplace(strPoint, "\n", " ").trim();
        if (str.charAt(0) != '{' || str.charAt(str.length() - 1) != '}') {
            return strPoint;
        }
        float[] points = new float[5];
        str = str.substring(1, str.length() - 1);
        int[] next = new int[1];
        for (nPoints = 0; nPoints < 5; ++nPoints) {
            points[nPoints] = Parser.parseFloat(str, next);
            if (!Float.isNaN(points[nPoints])) continue;
            if (next[0] >= str.length() || str.charAt(next[0]) != ',') break;
            next[0] = next[0] + 1;
            --nPoints;
        }
        if (nPoints == 3) {
            return new Point3f(points[0], points[1], points[2]);
        }
        if (nPoints == 4) {
            return new Point4f(points[0], points[1], points[2], points[3]);
        }
        return strPoint;
    }

    public static BitSet unescapeBitset(String strBitset) {
        if (strBitset == "{null}") {
            return null;
        }
        BitSet bs = new BitSet();
        int len = strBitset.length();
        int iPrev = -1;
        int iThis = -2;
        if (len < 3) {
            return bs;
        }
        block4: for (int i = 0; i < len; ++i) {
            char ch = strBitset.charAt(i);
            switch (ch) {
                case ' ': 
                case '{': 
                case '}': {
                    if (iThis < 0) continue block4;
                    if (iPrev < 0) {
                        iPrev = iThis;
                    }
                    for (int j = iPrev; j <= iThis; ++j) {
                        bs.set(j);
                    }
                    iPrev = -1;
                    iThis = -2;
                    continue block4;
                }
                case ':': {
                    iPrev = iThis;
                    iThis = -2;
                    continue block4;
                }
                default: {
                    if (!Character.isDigit(ch)) continue block4;
                    if (iThis < 0) {
                        iThis = 0;
                    }
                    iThis = (iThis << 3) + (iThis << 1) + (ch - 48);
                }
            }
        }
        return bs;
    }

    public static int unescapeColor(String strColor) {
        return Graphics3D.getArgbFromString(strColor);
    }

    public static String escape(BitSet bs, boolean isAtoms) {
        char chClose;
        char chOpen = isAtoms ? (char)'(' : '[';
        char c = chClose = isAtoms ? (char)')' : ']';
        if (bs == null) {
            return chOpen + "{}" + chClose;
        }
        StringBuffer s = new StringBuffer(chOpen + "{");
        int imax = bs.size();
        int iLast = -1;
        int iFirst = -2;
        int i = -1;
        while (++i <= imax) {
            boolean isSet = bs.get(i);
            if (i == imax || iLast >= 0 && !isSet) {
                if (iLast >= 0 && iFirst != iLast) {
                    s.append((iFirst == iLast - 1 ? " " : ":") + iLast);
                }
                if (i == imax) break;
                iLast = -1;
            }
            if (!bs.get(i)) continue;
            if (iLast < 0) {
                s.append((iFirst == -2 ? "" : " ") + i);
                iFirst = i;
            }
            iLast = i;
        }
        s.append("}").append(chClose);
        return s.toString();
    }

    public static String escape(BitSet bs) {
        return Escape.escape(bs, true);
    }

    private static String packageJSON(String infoType, StringBuffer sb) {
        return Escape.packageJSON(infoType, sb.toString());
    }

    private static String packageJSON(String infoType, String info) {
        if (infoType == null) {
            return info;
        }
        return "\"" + infoType + "\": " + info;
    }

    private static String packageReadable(String infoName, String infoType, StringBuffer sb) {
        return Escape.packageReadable(infoName, infoType, sb.toString());
    }

    private static String packageReadable(String infoName, String infoType, String info) {
        String s;
        String string = s = infoType == null ? "" : infoType + "\t";
        if (infoName == null) {
            return s + info;
        }
        return "\n" + infoName + "\t" + info;
    }

    private static String fixString(String s) {
        if (s == null || s.indexOf("{\"") == 0) {
            return s;
        }
        s = TextFormat.simpleReplace(s, "\"", "''");
        s = TextFormat.simpleReplace(s, "\n", " | ");
        return "\"" + s + "\"";
    }

    public static String toJSON(String infoType, Object info) {
        StringBuffer sb = new StringBuffer();
        String sep = "";
        if (info == null) {
            return Escape.packageJSON(infoType, (String)null);
        }
        if (info instanceof Integer || info instanceof Float) {
            return Escape.packageJSON(infoType, info.toString());
        }
        if (info instanceof String) {
            return Escape.packageJSON(infoType, Escape.fixString((String)info));
        }
        if (info instanceof String[]) {
            sb.append("[");
            int imax = ((String[])info).length;
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).append(Escape.fixString(((String[])info)[i]));
                sep = ",";
            }
            sb.append("]");
            return Escape.packageJSON(infoType, sb);
        }
        if (info instanceof int[]) {
            sb.append("[");
            int imax = ((int[])info).length;
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).append(((int[])info)[i]);
                sep = ",";
            }
            sb.append("]");
            return Escape.packageJSON(infoType, sb);
        }
        if (info instanceof float[]) {
            sb.append("[");
            int imax = ((float[])info).length;
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).append(((float[])info)[i]);
                sep = ",";
            }
            sb.append("]");
            return Escape.packageJSON(infoType, sb);
        }
        if (info instanceof int[][]) {
            sb.append("[");
            int imax = ((int[][])info).length;
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).append(Escape.toJSON(null, ((int[][])info)[i]));
                sep = ",";
            }
            sb.append("]");
            return Escape.packageJSON(infoType, sb);
        }
        if (info instanceof float[][]) {
            sb.append("[");
            int imax = ((float[][])info).length;
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).append(Escape.toJSON(null, ((float[][])info)[i]));
                sep = ",";
            }
            sb.append("]");
            return Escape.packageJSON(infoType, sb);
        }
        if (info instanceof Vector) {
            sb.append("[ ");
            int imax = ((Vector)info).size();
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).append(Escape.toJSON(null, ((Vector)info).get(i)));
                sep = ",";
            }
            sb.append(" ]");
            return Escape.packageJSON(infoType, sb);
        }
        if (info instanceof Matrix3f) {
            sb.append("[[").append(((Matrix3f)info).m00).append(",").append(((Matrix3f)info).m01).append(",").append(((Matrix3f)info).m02).append("]").append(",[").append(((Matrix3f)info).m10).append(",").append(((Matrix3f)info).m11).append(",").append(((Matrix3f)info).m12).append("]").append(",[").append(((Matrix3f)info).m20).append(",").append(((Matrix3f)info).m21).append(",").append(((Matrix3f)info).m22).append("]]");
            return Escape.packageJSON(infoType, sb);
        }
        if (info instanceof Tuple3f) {
            sb.append("[").append(((Tuple3f)info).x).append(",").append(((Tuple3f)info).y).append(",").append(((Tuple3f)info).z).append("]");
            return Escape.packageJSON(infoType, sb);
        }
        if (info instanceof Hashtable) {
            sb.append("{ ");
            Enumeration e = ((Hashtable)info).keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                sb.append(sep).append(Escape.packageJSON(key, Escape.toJSON(null, ((Hashtable)info).get(key))));
                sep = ",";
            }
            sb.append(" }");
            return Escape.packageJSON(infoType, sb);
        }
        return Escape.packageJSON(infoType, Escape.fixString(info.toString()));
    }

    public static String toReadable(Object info) {
        return Escape.toReadable(null, info);
    }

    public static String toReadable(String infoType, Object info) {
        StringBuffer sb = new StringBuffer();
        String sep = "";
        if (info == null) {
            return "null";
        }
        if (info instanceof String) {
            return Escape.packageReadable(infoType, null, Escape.escape((String)info));
        }
        if (info instanceof String[]) {
            sb.append("array(");
            int imax = ((String[])info).length;
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).append(Escape.escape(((String[])info)[i]));
                sep = ",";
            }
            sb.append(")");
            return Escape.packageReadable(infoType, "String[" + imax + "]", sb);
        }
        if (info instanceof int[]) {
            sb.append("array(");
            int imax = ((int[])info).length;
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).append(((int[])info)[i]);
                sep = ",";
            }
            sb.append(")");
            return Escape.packageReadable(infoType, "int[" + imax + "]", sb);
        }
        if (info instanceof float[]) {
            sb.append("array(");
            int imax = ((float[])info).length;
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).append(((float[])info)[i]);
                sep = ",";
            }
            sb.append(")");
            return Escape.packageReadable(infoType, "float[" + imax + "]", sb);
        }
        if (info instanceof int[][]) {
            sb.append("[");
            int imax = ((int[][])info).length;
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).append(Escape.toReadable(null, ((int[][])info)[i]));
                sep = ",";
            }
            sb.append("]");
            return Escape.packageReadable(infoType, "int[" + imax + "][]", sb);
        }
        if (info instanceof float[][]) {
            sb.append("[\n");
            int imax = ((float[][])info).length;
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).append(Escape.toReadable(null, ((float[][])info)[i]));
                sep = ",\n";
            }
            sb.append("]");
            return Escape.packageReadable(infoType, "float[][]", sb);
        }
        if (info instanceof Vector) {
            sb.append("");
            int imax = ((Vector)info).size();
            for (int i = 0; i < imax; ++i) {
                sb.append(sep).append(Escape.toReadable(null, ((Vector)info).get(i)));
                sep = ",";
            }
            return Escape.packageReadable(infoType, "Vector[" + imax + "]", sb);
        }
        if (info instanceof Matrix3f) {
            sb.append("[[").append(((Matrix3f)info).m00).append(",").append(((Matrix3f)info).m01).append(",").append(((Matrix3f)info).m02).append("]").append(",[").append(((Matrix3f)info).m10).append(",").append(((Matrix3f)info).m11).append(",").append(((Matrix3f)info).m12).append("]").append(",[").append(((Matrix3f)info).m20).append(",").append(((Matrix3f)info).m21).append(",").append(((Matrix3f)info).m22).append("]]");
            return Escape.packageReadable(infoType, null, sb);
        }
        if (info instanceof Tuple3f) {
            sb.append(Escape.escape((Tuple3f)info));
            return Escape.packageReadable(infoType, null, sb);
        }
        if (info instanceof Hashtable) {
            Enumeration e = ((Hashtable)info).keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                sb.append(sep).append(Escape.packageReadable(key, null, Escape.toReadable(null, ((Hashtable)info).get(key))));
                sep = "";
            }
            sb.append("\n");
            return Escape.packageReadable(infoType, null, sb);
        }
        return Escape.packageReadable(infoType, null, info.toString());
    }

    public static String escapeModelFileNumber(int iv) {
        return "" + iv / 1000000 + "." + iv % 1000000;
    }

    public static Object encapsulateData(String name, Object data) {
        return "  DATA \"" + name + "\"\n" + (data instanceof float[][] ? Escape.escape((float[][])data, true) + ";\n" : data) + "    END \"" + name + "\";\n";
    }

    public static Object unescapePointOrBitset(String s) {
        Object v = s;
        if (s.charAt(0) == '{') {
            v = Escape.unescapePoint(s);
        } else if (s.indexOf("({") == 0 && s.indexOf("({") == s.lastIndexOf("({")) {
            v = Escape.unescapeBitset(s);
        } else if (s.indexOf("[{") == 0) {
            v = new Bond.BondSet(Escape.unescapeBitset(s));
        }
        return v;
    }
}

