/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.image.PixelGrabber;

class JpegInfo {
    String Comment;
    private Image imageobj;
    int imageHeight;
    int imageWidth;
    int[] BlockWidth;
    int[] BlockHeight;
    int Precision = 8;
    int NumberOfComponents = 3;
    float[][][] Components;
    int[] CompID = new int[]{1, 2, 3};
    int[] HsampFactor = new int[]{1, 1, 1};
    int[] VsampFactor = new int[]{1, 1, 1};
    int[] QtableNumber = new int[]{0, 1, 1};
    int[] DCtableNumber = new int[]{0, 1, 1};
    int[] ACtableNumber = new int[]{0, 1, 1};
    private boolean[] lastColumnIsDummy = new boolean[]{false, false, false};
    private boolean[] lastRowIsDummy = new boolean[]{false, false, false};
    int Ss = 0;
    int Se = 63;
    int Ah = 0;
    int Al = 0;
    private int[] compWidth;
    private int[] compHeight;
    private int MaxHsampFactor;
    private int MaxVsampFactor;

    public JpegInfo(Image image) {
        this.Components = new float[this.NumberOfComponents][][];
        this.compWidth = new int[this.NumberOfComponents];
        this.compHeight = new int[this.NumberOfComponents];
        this.BlockWidth = new int[this.NumberOfComponents];
        this.BlockHeight = new int[this.NumberOfComponents];
        this.imageobj = image;
        this.imageWidth = image.getWidth(null);
        this.imageHeight = image.getHeight(null);
        this.Comment = "JPEG Encoder Copyright 1998, James R. Weeks and BioElectroMech.  ";
        this.getYCCArray();
    }

    String getComment() {
        return this.Comment;
    }

    private void getYCCArray() {
        int y;
        int[] values = new int[this.imageWidth * this.imageHeight];
        PixelGrabber grabber = new PixelGrabber(this.imageobj.getSource(), 0, 0, this.imageWidth, this.imageHeight, values, 0, this.imageWidth);
        this.MaxHsampFactor = 1;
        this.MaxVsampFactor = 1;
        for (y = 0; y < this.NumberOfComponents; ++y) {
            this.MaxHsampFactor = Math.max(this.MaxHsampFactor, this.HsampFactor[y]);
            this.MaxVsampFactor = Math.max(this.MaxVsampFactor, this.VsampFactor[y]);
        }
        for (y = 0; y < this.NumberOfComponents; ++y) {
            this.compWidth[y] = (this.imageWidth % 8 != 0 ? (int)Math.ceil((double)this.imageWidth / 8.0) * 8 : this.imageWidth) / this.MaxHsampFactor * this.HsampFactor[y];
            if (this.compWidth[y] != this.imageWidth / this.MaxHsampFactor * this.HsampFactor[y]) {
                this.lastColumnIsDummy[y] = true;
            }
            this.BlockWidth[y] = (int)Math.ceil((double)this.compWidth[y] / 8.0);
            this.compHeight[y] = (this.imageHeight % 8 != 0 ? (int)Math.ceil((double)this.imageHeight / 8.0) * 8 : this.imageHeight) / this.MaxVsampFactor * this.VsampFactor[y];
            if (this.compHeight[y] != this.imageHeight / this.MaxVsampFactor * this.VsampFactor[y]) {
                this.lastRowIsDummy[y] = true;
            }
            this.BlockHeight[y] = (int)Math.ceil((double)this.compHeight[y] / 8.0);
        }
        try {
            if (!grabber.grabPixels()) {
                try {
                    throw new AWTException("Grabber returned false: " + grabber.status());
                }
                catch (Exception e) {}
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        float[][] Y = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] Cr1 = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] Cb1 = new float[this.compHeight[0]][this.compWidth[0]];
        int index = 0;
        for (y = 0; y < this.imageHeight; ++y) {
            for (int x = 0; x < this.imageWidth; ++x) {
                int r = values[index] >> 16 & 0xFF;
                int g = values[index] >> 8 & 0xFF;
                int b = values[index] & 0xFF;
                Y[y][x] = (float)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
                Cb1[y][x] = 128.0f + (float)(-0.16874 * (double)r - 0.33126 * (double)g + 0.5 * (double)b);
                Cr1[y][x] = 128.0f + (float)(0.5 * (double)r - 0.41869 * (double)g - 0.08131 * (double)b);
                ++index;
            }
        }
        this.Components[0] = Y;
        this.Components[1] = Cb1;
        this.Components[2] = Cr1;
    }
}

