/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public final class Measure {
    public static final float radiansPerDegree = (float)Math.PI / 180;

    public static float computeTorsion(Point3f p1, Point3f p2, Point3f p3, Point3f p4, boolean asDegrees) {
        float ci;
        float ijx = p1.x - p2.x;
        float ijy = p1.y - p2.y;
        float ijz = p1.z - p2.z;
        float kjx = p3.x - p2.x;
        float kjy = p3.y - p2.y;
        float kjz = p3.z - p2.z;
        float klx = p3.x - p4.x;
        float kly = p3.y - p4.y;
        float klz = p3.z - p4.z;
        float ax = ijy * kjz - ijz * kjy;
        float ay = ijz * kjx - ijx * kjz;
        float az = ijx * kjy - ijy * kjx;
        float cx = kjy * klz - kjz * kly;
        float cy = kjz * klx - kjx * klz;
        float cz = kjx * kly - kjy * klx;
        float ai2 = 1.0f / (ax * ax + ay * ay + az * az);
        float ci2 = 1.0f / (cx * cx + cy * cy + cz * cz);
        float cross = ax * cx + ay * cy + az * cz;
        float ai = (float)Math.sqrt(ai2);
        float denom = ai * (ci = (float)Math.sqrt(ci2));
        float cosang = cross * denom;
        if (cosang > 1.0f) {
            cosang = 1.0f;
        }
        if (cosang < -1.0f) {
            cosang = -1.0f;
        }
        float torsion = (float)Math.acos(cosang);
        float dot = ijx * cx + ijy * cy + ijz * cz;
        float absDot = Math.abs(dot);
        torsion = dot / absDot > 0.0f ? torsion : -torsion;
        return asDegrees ? torsion / ((float)Math.PI / 180) : torsion;
    }

    public static float computeAngle(Point3f pointA, Point3f pointB, Point3f pointC, Vector3f vectorBA, Vector3f vectorBC, boolean asDegrees) {
        vectorBA.sub(pointA, pointB);
        vectorBC.sub(pointC, pointB);
        float angle = vectorBA.angle(vectorBC);
        return asDegrees ? angle / ((float)Math.PI / 180) : angle;
    }

    public static float computeAngle(Point3f pointA, Point3f pointB, Point3f pointC, boolean asDegrees) {
        Vector3f vectorBA = new Vector3f();
        Vector3f vectorBC = new Vector3f();
        return Measure.computeAngle(pointA, pointB, pointC, vectorBA, vectorBC, asDegrees);
    }
}

