/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.BitSet;
import org.jmol.util.TextFormat;

public class Parser {
    private static final float[] decimalScale = new float[]{0.1f, 0.01f, 0.001f, 1.0E-4f, 1.0E-5f, 1.0E-6f, 1.0E-7f, 1.0E-8f};
    private static final float[] tensScale = new float[]{10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f};

    public static void parseFloatArray(String str, BitSet bs, float[] data) {
        Parser.parseFloatArray(Parser.getTokens(str), bs, data);
    }

    public static void parseFloatArray(String[] tokens, BitSet bs, float[] data) {
        int len = data.length;
        int nTokens = tokens.length;
        int n = 0;
        for (int i = 0; i < len && n < nTokens; ++i) {
            float f;
            if (bs != null && !bs.get(i)) continue;
            while (Float.isNaN(f = Parser.parseFloat(tokens[n++])) && n < nTokens) {
            }
            data[i] = f;
        }
    }

    public static float[][] parseFloatArray2d(String str) {
        str = str.replace(';', str.indexOf(10) < 0 ? (char)'\n' : ' ');
        str = TextFormat.trim(str, "\n \t");
        int[] lines = Parser.markLines(str, '\n');
        int nLines = lines.length;
        float[][] data = new float[nLines][];
        int iLine = 0;
        int pt = 0;
        while (iLine < lines.length) {
            String[] tokens = Parser.getTokens(str.substring(pt, lines[iLine]));
            data[iLine] = new float[tokens.length];
            Parser.parseFloatArray(tokens, data[iLine]);
            pt = lines[iLine++];
        }
        return data;
    }

    public static void setSelectedFloats(float f, BitSet bs, float[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (bs != null && !bs.get(i)) continue;
            data[i] = f;
        }
    }

    public static float[] extractData(String data, int field, int nBytes, int firstLine) {
        return Parser.parseFloatArrayFromMatchAndField(data, null, 0, 0, null, field, nBytes, null, firstLine);
    }

    public static float[] parseFloatArrayFromMatchAndField(String str, BitSet bs, int fieldMatch, int fieldMatchColumnCount, int[] matchData, int field, int fieldColumnCount, float[] data, int firstLine) {
        int minLen;
        int i = -1;
        boolean isMatch = matchData != null;
        int[] lines = Parser.markLines(str, str.indexOf(10) >= 0 ? (char)'\n' : ';');
        int iLine = firstLine <= 1 || firstLine >= lines.length ? 0 : firstLine - 1;
        int pt = iLine == 0 ? 0 : lines[iLine - 1];
        int nLines = lines.length;
        if (data == null) {
            data = new float[nLines - iLine];
        }
        int len = data.length;
        int n = minLen = fieldColumnCount <= 0 ? Math.max(field, fieldMatch) : Math.max(field + fieldColumnCount, fieldMatch + fieldMatchColumnCount) - 1;
        while (iLine < nLines) {
            block5: {
                float f;
                block7: {
                    int iData;
                    block6: {
                        String[] tokens;
                        String line = str.substring(pt, lines[iLine]).trim();
                        pt = lines[iLine];
                        String[] stringArray = tokens = fieldColumnCount <= 0 ? Parser.getTokens(line) : null;
                        if (fieldColumnCount > 0 ? line.length() < minLen || Float.isNaN(f = Parser.parseFloat(line.substring(field - 1, field + fieldColumnCount - 1))) : tokens.length < minLen || Float.isNaN(f = Parser.parseFloat(tokens[field - 1]))) break block5;
                        if (!isMatch) break block6;
                        iData = Parser.parseInt(tokens == null ? line.substring(fieldMatch - 1, fieldMatch + fieldMatchColumnCount - 1) : tokens[fieldMatch - 1]);
                        if (iData == Integer.MIN_VALUE || iData < 0 || iData >= len || (iData = matchData[iData]) < 0) break block5;
                        if (bs != null) {
                            bs.set(iData);
                        }
                        break block7;
                    }
                    while (++i < len && bs != null && !bs.get(i)) {
                    }
                    if (i >= len) {
                        return data;
                    }
                    iData = i;
                }
                data[iData] = f;
            }
            ++iLine;
        }
        return data;
    }

    public static void parseFloatArray(String[] tokens, float[] data) {
        Parser.parseFloatArray(tokens, data, data.length);
    }

    public static void parseFloatArray(String[] tokens, float[] data, int nData) {
        int i = nData;
        while (--i >= 0) {
            data[i] = i >= tokens.length ? Float.NaN : Parser.parseFloat(tokens[i]);
        }
    }

    public static float parseFloat(String str) {
        return Parser.parseFloat(str, new int[]{0});
    }

    public static float parseFloatStrict(String str) {
        int cch = str.length();
        if (cch == 0) {
            return Float.NaN;
        }
        return Parser.parseFloatChecked(str, cch, new int[]{0}, true);
    }

    public static int parseInt(String str) {
        return Parser.parseInt(str, new int[]{0});
    }

    public static String[] getTokens(String line) {
        return Parser.getTokens(line, 0);
    }

    public static String parseToken(String str) {
        return Parser.parseToken(str, new int[]{0});
    }

    public static String parseTrimmed(String str) {
        return Parser.parseTrimmed(str, 0, str.length());
    }

    public static String parseTrimmed(String str, int ichStart) {
        return Parser.parseTrimmed(str, ichStart, str.length());
    }

    public static String parseTrimmed(String str, int ichStart, int ichMax) {
        int cch = str.length();
        if (ichMax < cch) {
            cch = ichMax;
        }
        if (cch < ichStart) {
            return "";
        }
        return Parser.parseTrimmedChecked(str, ichStart, cch);
    }

    public static int[] markLines(String data, char eol) {
        int nLines = 0;
        int i = data.length();
        while (--i >= 0) {
            if (data.charAt(i) != eol) continue;
            ++nLines;
        }
        int[] lines = new int[nLines + 1];
        lines[nLines--] = data.length();
        int i2 = data.length();
        while (--i2 >= 0) {
            if (data.charAt(i2) != eol) continue;
            lines[nLines--] = i2 + 1;
        }
        return lines;
    }

    public static float parseFloat(String str, int[] next) {
        int cch = str.length();
        if (next[0] >= cch) {
            return Float.NaN;
        }
        return Parser.parseFloatChecked(str, cch, next, false);
    }

    public static float parseFloat(String str, int ichMax, int[] next) {
        int cch = str.length();
        if (ichMax > cch) {
            ichMax = cch;
        }
        if (next[0] >= ichMax) {
            return Float.NaN;
        }
        return Parser.parseFloatChecked(str, ichMax, next, false);
    }

    private static float parseFloatChecked(String str, int ichMax, int[] next, boolean isStrict) {
        int ich;
        boolean digitSeen = false;
        float value = 0.0f;
        if (isStrict && str.indexOf(10) != str.lastIndexOf(10)) {
            return Float.NaN;
        }
        for (ich = next[0]; ich < ichMax && Parser.isWhiteSpace(str, ich); ++ich) {
        }
        boolean negative = false;
        if (ich < ichMax && str.charAt(ich) == '-') {
            ++ich;
            negative = true;
        }
        char ch = '\u0000';
        while (ich < ichMax && (ch = str.charAt(ich)) >= '0' && ch <= '9') {
            value = value * 10.0f + (float)(ch - 48);
            ++ich;
            digitSeen = true;
        }
        boolean isDecimal = false;
        if (ch == '.') {
            isDecimal = true;
            int iscale = 0;
            while (++ich < ichMax && (ch = str.charAt(ich)) >= '0' && ch <= '9') {
                if (iscale < decimalScale.length) {
                    value += (float)(ch - 48) * decimalScale[iscale];
                }
                ++iscale;
                digitSeen = true;
            }
        }
        boolean isExponent = false;
        if (!digitSeen) {
            value = Float.NaN;
        } else if (negative) {
            value = -value;
        }
        if (ich < ichMax && (ch == 'E' || ch == 'e' || ch == 'D')) {
            isExponent = true;
            if (++ich >= ichMax) {
                return Float.NaN;
            }
            ch = str.charAt(ich);
            if (ch == '+' && ++ich >= ichMax) {
                return Float.NaN;
            }
            next[0] = ich;
            int exponent = Parser.parseIntChecked(str, ichMax, next);
            if (exponent == Integer.MIN_VALUE) {
                return Float.NaN;
            }
            if (exponent > 0) {
                value = (float)((double)value * (exponent < tensScale.length ? (double)tensScale[exponent - 1] : Math.pow(10.0, exponent)));
            } else if (exponent < 0) {
                value = (float)((double)value * (-exponent < decimalScale.length ? (double)decimalScale[-exponent - 1] : Math.pow(10.0, exponent)));
            }
        } else {
            next[0] = ich;
        }
        return !isStrict || (!isExponent || isDecimal) && Parser.checkTrailingText(str, next[0], ichMax) ? value : Float.NaN;
    }

    private static boolean checkTrailingText(String str, int ich, int ichMax) {
        char ch;
        while (ich < ichMax && ((ch = str.charAt(ich)) == ' ' || ch == '\t' || ch == '\n' || ch == ';')) {
            ++ich;
        }
        return ich == ichMax;
    }

    public static int parseInt(String str, int[] next) {
        int cch = str.length();
        if (next[0] >= cch) {
            return Integer.MIN_VALUE;
        }
        return Parser.parseIntChecked(str, cch, next);
    }

    public static int parseInt(String str, int ichMax, int[] next) {
        int cch = str.length();
        if (ichMax > cch) {
            ichMax = cch;
        }
        if (next[0] >= ichMax) {
            return Integer.MIN_VALUE;
        }
        return Parser.parseIntChecked(str, ichMax, next);
    }

    private static int parseIntChecked(String str, int ichMax, int[] next) {
        char ch;
        int ich;
        boolean digitSeen = false;
        int value = 0;
        for (ich = next[0]; ich < ichMax && Parser.isWhiteSpace(str, ich); ++ich) {
        }
        boolean negative = false;
        if (ich < ichMax && str.charAt(ich) == '-') {
            negative = true;
            ++ich;
        }
        while (ich < ichMax && (ch = str.charAt(ich)) >= '0' && ch <= '9') {
            value = value * 10 + (ch - 48);
            digitSeen = true;
            ++ich;
        }
        if (!digitSeen) {
            value = Integer.MIN_VALUE;
        } else if (negative) {
            value = -value;
        }
        next[0] = ich;
        return value;
    }

    public static String[] getTokens(String line, int ich) {
        if (line == null) {
            return null;
        }
        int cchLine = line.length();
        if (ich > cchLine) {
            return null;
        }
        int tokenCount = Parser.countTokens(line, ich);
        String[] tokens = new String[tokenCount];
        int[] next = new int[]{ich};
        for (int i = 0; i < tokenCount; ++i) {
            tokens[i] = Parser.parseTokenChecked(line, cchLine, next);
        }
        return tokens;
    }

    public static int countTokens(String line, int ich) {
        int tokenCount = 0;
        if (line != null) {
            int ichMax = line.length();
            while (true) {
                if (ich < ichMax && Parser.isWhiteSpace(line, ich)) {
                    ++ich;
                    continue;
                }
                if (ich == ichMax) break;
                ++tokenCount;
                while (++ich < ichMax && !Parser.isWhiteSpace(line, ich)) {
                }
            }
        }
        return tokenCount;
    }

    public static String parseToken(String str, int[] next) {
        int cch = str.length();
        if (next[0] >= cch) {
            return null;
        }
        return Parser.parseTokenChecked(str, cch, next);
    }

    public static String parseToken(String str, int ichMax, int[] next) {
        int cch = str.length();
        if (ichMax > cch) {
            ichMax = cch;
        }
        if (next[0] >= ichMax) {
            return null;
        }
        return Parser.parseTokenChecked(str, ichMax, next);
    }

    private static String parseTokenChecked(String str, int ichMax, int[] next) {
        int ich;
        for (ich = next[0]; ich < ichMax && Parser.isWhiteSpace(str, ich); ++ich) {
        }
        int ichNonWhite = ich;
        while (ich < ichMax && !Parser.isWhiteSpace(str, ich)) {
            ++ich;
        }
        next[0] = ich;
        if (ichNonWhite == ich) {
            return null;
        }
        return str.substring(ichNonWhite, ich);
    }

    private static String parseTrimmedChecked(String str, int ich, int ichMax) {
        int ichLast;
        while (ich < ichMax && Parser.isWhiteSpace(str, ich)) {
            ++ich;
        }
        for (ichLast = ichMax - 1; ichLast >= ich && Parser.isWhiteSpace(str, ichLast); --ichLast) {
        }
        if (ichLast < ich) {
            return "";
        }
        return str.substring(ich, ichLast + 1);
    }

    public static String concatTokens(String[] tokens, int iFirst, int iEnd) {
        String str = "";
        String sep = "";
        for (int i = iFirst; i < iEnd; ++i) {
            if (i >= tokens.length) continue;
            str = str + sep + tokens[i];
            sep = " ";
        }
        return str;
    }

    public static String getNextQuotedString(String line, int ipt0) {
        String value = line;
        int i = value.indexOf("\"", ipt0);
        if (i < 0) {
            return "";
        }
        value = value.substring(i + 1);
        i = -1;
        while (++i < value.length() && value.charAt(i) != '\"') {
            if (value.charAt(i) != '\\') continue;
            ++i;
        }
        return value.substring(0, i);
    }

    private static boolean isWhiteSpace(String str, int ich) {
        char ch = str.charAt(ich);
        return ch == ' ' || ch == '\t' || ch == '\n';
    }

    public static boolean isOneOf(String key, String semiList) {
        return key.indexOf(";") < 0 && (';' + semiList + ';').indexOf(';' + key + ';') >= 0;
    }
}

