/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.util.Eigen;

public class Quadric {
    public static void getAxesForEllipsoid(double[] coef, Vector3f[] unitVectors, float[] lengths) {
        int i;
        double[][] mat = new double[3][3];
        mat[0][0] = coef[0];
        mat[1][1] = coef[1];
        mat[2][2] = coef[2];
        double d = coef[3] / 2.0;
        mat[1][0] = d;
        mat[0][1] = d;
        double d2 = coef[4] / 2.0;
        mat[2][0] = d2;
        mat[0][2] = d2;
        double d3 = coef[5] / 2.0;
        mat[2][1] = d3;
        mat[1][2] = d3;
        Eigen eigen = new Eigen(mat);
        float[][] eigenVectors = Eigen.toFloat3x3(eigen.getEigenvectors());
        double[] eigenValues = eigen.getEigenvalues();
        for (i = 0; i < 3; ++i) {
            lengths[i] = (float)(1.0 / Math.sqrt(eigenValues[i]));
        }
        for (i = 0; i < 3; ++i) {
            unitVectors[i].set(eigenVectors[i]);
        }
    }

    public static Matrix3f setEllipsoidMatrix(Vector3f[] unitAxes, float[] lengths, Vector3f vTemp, Matrix3f mat) {
        for (int i = 0; i < 3; ++i) {
            vTemp.set(unitAxes[i]);
            vTemp.scale(lengths[i]);
            mat.setColumn(i, vTemp);
        }
        mat.invert(mat);
        return mat;
    }

    public static void getEquationForQuadricWithCenter(float x, float y, float z, Matrix3f mToElliptical, Vector3f vTemp, Matrix3f mTemp, double[] coef, Matrix4f mDeriv) {
        vTemp.set(x, y, z);
        mToElliptical.transform(vTemp);
        double f = 1.0f - vTemp.dot(vTemp);
        mTemp.transpose(mToElliptical);
        mTemp.transform(vTemp);
        mTemp.mul(mToElliptical);
        coef[0] = (double)mTemp.m00 / f;
        coef[1] = (double)mTemp.m11 / f;
        coef[2] = (double)mTemp.m22 / f;
        coef[3] = (double)(mTemp.m01 * 2.0f) / f;
        coef[4] = (double)(mTemp.m02 * 2.0f) / f;
        coef[5] = (double)(mTemp.m12 * 2.0f) / f;
        coef[6] = (double)(-2.0f * vTemp.x) / f;
        coef[7] = (double)(-2.0f * vTemp.y) / f;
        coef[8] = (double)(-2.0f * vTemp.z) / f;
        coef[9] = -1.0;
        if (mDeriv == null) {
            return;
        }
        mDeriv.setIdentity();
        mDeriv.m00 = (float)(2.0 * coef[0]);
        mDeriv.m11 = (float)(2.0 * coef[1]);
        mDeriv.m22 = (float)(2.0 * coef[2]);
        mDeriv.m01 = mDeriv.m10 = (float)coef[3];
        mDeriv.m02 = mDeriv.m20 = (float)coef[4];
        mDeriv.m12 = mDeriv.m21 = (float)coef[5];
        mDeriv.m03 = (float)coef[6];
        mDeriv.m13 = (float)coef[7];
        mDeriv.m23 = (float)coef[8];
    }

    public static boolean getQuardricZ(double x, double y, double[] coef, double[] zroot) {
        double b_2a = (coef[4] * x + coef[5] * y + coef[8]) / coef[2] / 2.0;
        double c_a = (coef[0] * x * x + coef[1] * y * y + coef[3] * x * y + coef[6] * x + coef[7] * y - 1.0) / coef[2];
        double f = b_2a * b_2a - c_a;
        if (f < 0.0) {
            return false;
        }
        f = Math.sqrt(f);
        zroot[0] = -b_2a - f;
        zroot[1] = -b_2a + f;
        return true;
    }

    public static int getOctant(Point3f pt) {
        int i = 0;
        if (pt.x < 0.0f) {
            ++i;
        }
        if (pt.y < 0.0f) {
            i += 2;
        }
        if (pt.z < 0.0f) {
            i += 4;
        }
        return i;
    }
}

